/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemProperties;

public class ConfigurationDefaults {
    private static ConfigurationDefaults configdefaults;
    private static AEMonitor class_mon;
    private HashMap def = new HashMap();
    public int def_int = 0;
    public float def_float = 0.0f;
    public int def_boolean = 0;
    public String def_String = "";
    public byte[] def_bytes = null;

    static {
        class_mon = new AEMonitor("ConfigDef");
    }

    public static ConfigurationDefaults getInstance() {
        try {
            class_mon.enter();
            if (configdefaults == null) {
                configdefaults = new ConfigurationDefaults();
            }
            ConfigurationDefaults configurationDefaults = configdefaults;
            class_mon.exit();
            return configurationDefaults;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected ConfigurationDefaults() {
        this.def.put("Override Ip", "");
        this.def.put("Enable incremental file creation", new Long(0L));
        this.def.put("TCP.Listen.Port", new Long(6881L));
        this.def.put("max active torrents", new Long(4L));
        this.def.put("max downloads", new Long(4L));
        this.def.put("Max.Peer.Connections.Per.Torrent", new Long(80L));
        this.def.put("Max.Peer.Connections.Total", new Long(400L));
        this.def.put("File Max Open", new Long(50L));
        this.def.put("Max Uploads", new Long(4L));
        this.def.put("Max Upload Speed KBs", new Long(0L));
        this.def.put("Use Resume", new Long(1L));
        this.def.put("Save Resume Interval", new Long(5L));
        this.def.put("Check Pieces on Completion", new Long(1L));
        this.def.put("Stop Ratio", new Float(0.0f));
        this.def.put("Stop Peers Ratio", new Long(0L));
        this.def.put("Disconnect Seed", new Long(1L));
        this.def.put("priorityExtensions", "");
        this.def.put("priorityExtensionsIgnoreCase", new Long(0L));
        this.def.put("Ip Filter Enabled", new Long(1L));
        this.def.put("Ip Filter Allow", new Long(0L));
        this.def.put("Ip Filter Enable Banning", new Long(1L));
        this.def.put("Allow Same IP Peers", new Long(0L));
        this.def.put("Use Super Seeding", new Long(0L));
        this.def.put("useCustomTab", new Long(1L));
        this.def.put("GUI Refresh", new Long(1000L));
        this.def.put("Graphics Update", new Long(4L));
        this.def.put("ReOrder Delay", new Long(0L));
        this.def.put("Send Version Info", new Long(1L));
        this.def.put("Show Download Basket", new Long(0L));
        this.def.put("config.style.refreshMT", new Long(0L));
        this.def.put("Open Details", new Long(0L));
        this.def.put("Use default data dir", new Long(0L));
        this.def.put("Default save path", "");
        this.def.put("GUI_SWT_bFancyTab", new Long(1L));
        this.def.put("GUI_SWT_bAlternateTablePainting", new Long(0L));
        this.def.put("update.start", new Long(1L));
        this.def.put("update.periodic", new Long(1L));
        this.def.put("update.opendialog", new Long(1L));
        this.def.put("Colors.progressBar.override", new Long(0L));
        this.def.put("Logging Enable", new Long(0L));
        this.def.put("Logging Dir", "");
        this.def.put("Logging Max Size", new Long(5L));
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        int[] logComponents = nArray;
        int i = 0;
        while (i < logComponents.length) {
            int j = 0;
            while (j <= 3) {
                this.def.put("bLog" + logComponents[i] + "-" + j, new Long(1L));
                ++j;
            }
            ++i;
        }
        this.def.put("StartStopManager_iNumPeersAsFullCopy", new Long(0L));
        this.def.put("StartStopManager_iFakeFullCopySeedStart", new Long(1L));
        this.def.put("StartStopManager_iMinPeersToBoostNoSeeds", new Long(1L));
        this.def.put("StartStopManager_iMinSpeedForActiveDL", new Long(512L));
        this.def.put("StartStopManager_iMinSpeedForActiveSeeding", new Long(512L));
        this.def.put("StartStopManager_iRankType", new Long(1L));
        this.def.put("StartStopManager_iRankTypeSeedFallback", new Long(0L));
        this.def.put("StartStopManager_bAutoReposition", new Long(0L));
        this.def.put("StartStopManager_iMinSeedingTime", new Long(180L));
        this.def.put("StartStopManager_bIgnore0Peers", new Long(1L));
        this.def.put("StartStopManager_iIgnoreSeedCount", new Long(0L));
        this.def.put("StartStopManager_bPreferLargerSwarms", new Long(1L));
        this.def.put("StartStopManager_bDebugLog", new Long(0L));
        this.def.put("StartStopManager_iFirstPriority_Type", new Long(1L));
        this.def.put("StartStopManager_iFirstPriority_ShareRatio", new Long(500L));
        this.def.put("StartStopManager_iFirstPriority_SeedingMinutes", new Long(0L));
        this.def.put("StartStopManager_iFirstPriority_DLMinutes", new Long(0L));
        this.def.put("StartStopManager_bAutoStart0Peers", new Long(0L));
        this.def.put("StartStopManager_iIgnoreRatioPeersSeedStart", new Long(0L));
        this.def.put("StartStopManager_iIgnoreShareRatioSeedStart", new Long(0L));
        this.def.put("Enable.Proxy", new Long(0L));
        this.def.put("Enable.SOCKS", new Long(0L));
        this.def.put("Proxy.Host", "");
        this.def.put("Proxy.Port", "");
        this.def.put("Proxy.Username", "");
        this.def.put("Proxy.Password", "");
        this.def.put("Proxy.Data.Enable", new Long(0L));
        this.def.put("Proxy.Data.SOCKS.version", "V4");
        this.def.put("Proxy.Data.SOCKS.inform", new Long(1L));
        this.def.put("Proxy.Data.Same", new Long(1L));
        this.def.put("Proxy.Data.Host", "");
        this.def.put("Proxy.Data.Port", "");
        this.def.put("Proxy.Data.Username", "");
        this.def.put("Proxy.Data.Password", "");
        this.def.put("Start Num Peers", new Long(-1L));
        this.def.put("Max Upload Speed", new Long(-1L));
        this.def.put("Max Clients", new Long(-1L));
        this.def.put("Server.shared.port", new Long(1L));
        this.def.put("Low Port", new Long(6881L));
        this.def.put("Already_Migrated", new Long(0L));
        this.def.put("ID", "");
        this.def.put("Play Download Finished", new Long(0L));
        this.def.put("Play Download Finished File", "");
        this.def.put("Close To Tray", new Long(1L));
        this.def.put("Minimize To Tray", new Long(0L));
        this.def.put("Watch Torrent Folder", new Long(0L));
        this.def.put("Watch Torrent Folder Interval", new Long(1L));
        this.def.put("Start Watched Torrents Stopped", new Long(0L));
        this.def.put("Watch Torrent Folder Path", "");
        this.def.put("DiskManager Write Queue Block Limit", new Long(0L));
        this.def.put("DiskManager Check Queue Piece Limit", new Long(0L));
        this.def.put("Prioritize First Piece", new Long(0L));
        this.def.put("Move Completed When Done", new Long(0L));
        this.def.put("Completed Files Directory", "");
        this.def.put("Zero New", new Long(0L));
        this.def.put("Move Only When In Default Save Dir", new Long(1L));
        this.def.put("Copy And Delete Data Rather Than Move", new Long(0L));
        this.def.put("Move Torrent When Done", new Long(1L));
        this.def.put("File.save.peers.enable", new Long(1L));
        this.def.put("Save Torrent Files", new Long(1L));
        this.def.put("General_sDefaultTorrent_Directory", String.valueOf(SystemProperties.getUserPath()) + "torrents");
        this.def.put("Old.Socket.Polling.Style", new Long(0L));
        this.def.put("Max Download Speed KBs", new Long(0L));
        this.def.put("Bind IP", "");
        this.def.put("Stats Export Peer Details", new Long(0L));
        this.def.put("Stats XSL File", "");
        this.def.put("Stats Enable", new Long(0L));
        this.def.put("Stats Period", new Long(30000L));
        this.def.put("Stats Dir", "");
        this.def.put("Stats File", "Azureus_Stats.xml");
        this.def.put("File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini");
        this.def.put("File.save.peers.max", new Long(512L));
        this.def.put("Tracker Compact Enable", new Long(1L));
        this.def.put("Tracker Key Enable Client", new Long(1L));
        this.def.put("Tracker Key Enable Server", new Long(1L));
        this.def.put("Tracker Separate Peer IDs", new Long(0L));
        this.def.put("Tracker Client Connect Timeout", new Long(120L));
        this.def.put("Tracker Client Read Timeout", new Long(60L));
        this.def.put("Tracker Public Enable", new Long(0L));
        this.def.put("Tracker Log Enable", new Long(0L));
        this.def.put("Tracker Port Enable", new Long(0L));
        this.def.put("Tracker Port", new Long(6969L));
        this.def.put("Tracker Port SSL Enable", new Long(0L));
        this.def.put("Tracker Port SSL", new Long(7000L));
        this.def.put("Tracker Port Force External", new Long(0L));
        this.def.put("Tracker IP", "");
        this.def.put("Tracker Port UDP Enable", new Long(0L));
        this.def.put("Tracker Port UDP Version", new Long(2L));
        this.def.put("Tracker Send Peer IDs", new Long(1L));
        this.def.put("Tracker Max Peers Returned", new Long(0L));
        this.def.put("Tracker Scrape Cache", new Long(5000L));
        this.def.put("Tracker Announce Cache", new Long(500L));
        this.def.put("Tracker Announce Cache Min Peers", new Long(500L));
        this.def.put("Tracker Poll Interval Min", new Long(120L));
        this.def.put("Tracker Poll Interval Max", new Long(3600L));
        this.def.put("Tracker Scrape Retry Percentage", new Long(200L));
        this.def.put("Tracker Password Enable Web", new Long(0L));
        this.def.put("Tracker Password Web HTTPS Only", new Long(0L));
        this.def.put("Tracker Password Enable Torrent", new Long(0L));
        this.def.put("Tracker Username", "");
        this.def.put("Tracker Password", null);
        this.def.put("Tracker Poll Inc By", new Long(60L));
        this.def.put("Tracker Poll Inc Per", new Long(10L));
        this.def.put("Tracker NAT Check Enable", new Long(1L));
        this.def.put("Tracker NAT Check Timeout", new Long(15L));
        this.def.put("Tracker Max Seeds Retained", new Long(0L));
        this.def.put("Tracker Max GET Time", new Long(20L));
        this.def.put("Tracker Max POST Time Multiplier", new Long(1L));
        this.def.put("Tracker Max Threads", new Long(48L));
        this.def.put("config.style.useSIUnits", new Long(0L));
        this.def.put("config.style.useUnitsRateBits", new Long(0L));
        this.def.put("Save Torrent Backup", new Long(0L));
        this.def.put("Sharing Use SSL", new Long(0L));
        this.def.put("Sharing Add Hashes", new Long(0L));
        this.def.put("Sharing Rescan Enable", new Long(0L));
        this.def.put("Sharing Rescan Period", new Long(60L));
        this.def.put("Sharing Torrent Comment", "");
        this.def.put("File.Decoder.Prompt", new Long(0L));
        this.def.put("File.Decoder.Default", "");
        this.def.put("File.Decoder.ShowLax", new Long(0L));
        this.def.put("File.Decoder.ShowAll", new Long(0L));
        this.def.put("Password enabled", new Long(0L));
        this.def.put("Password", null);
        this.def.put("Save detail views column widths", new Long(0L));
        this.def.put("config.interface.checkassoc", new Long(1L));
        this.def.put("Wizard Completed", new Long(0L));
        this.def.put("donations.donated", new Long(0L));
        this.def.put("donations.lastVersion", "");
        this.def.put("donations.nextAskTime", new Long(0L));
        this.def.put("Color Scheme.red", new Long(0L));
        this.def.put("Color Scheme.green", new Long(128L));
        this.def.put("Color Scheme.blue", new Long(255L));
        this.def.put("Show Splash", new Long(1L));
        this.def.put("window.maximized", new Long(1L));
        this.def.put("window.rectangle", "");
        this.def.put("Open Console", new Long(0L));
        this.def.put("Open Config", new Long(0L));
        this.def.put("Open Stats On Start", new Long(0L));
        this.def.put("Start Minimized", new Long(0L));
        this.def.put("Open Bar", new Long(0L));
        this.def.put("confirmationOnExit", new Long(0L));
        this.def.put("locale", Locale.getDefault().toString());
        this.def.put("Add URL Silently", new Long(0L));
        this.def.put("config.style.dropdiraction", "0");
        this.def.put("MyTorrents.SplitAt", new Long(30L));
        this.def.put("Confirm Data Delete", new Long(1L));
        this.def.put("Password Confirm", null);
        this.def.put("Auto Update", new Long(1L));
        this.def.put("Alert on close", new Long(1L));
        this.def.put("diskmanager.friendly.hashchecking", new Long(0L));
        this.def.put("Default Start Torrents Stopped", new Long(0L));
        this.def.put("Server Enable UDP", new Long(1L));
        this.def.put("diskmanager.perf.cache.enable", new Long(1L));
        this.def.put("diskmanager.perf.cache.enable.read", new Long(1L));
        this.def.put("diskmanager.perf.cache.enable.write", new Long(1L));
        this.def.put("diskmanager.perf.cache.size", new Long(4L));
        this.def.put("diskmanager.perf.cache.notsmallerthan", new Long(1024L));
        this.def.put("File.truncate.if.too.large", new Long(0L));
        this.def.put("diskmanager.perf.cache.trace", new Long(0L));
        this.def.put("Enable System Tray", new Long(1L));
        this.def.put("config.style.table.sortDefaultAscending", new Long(1L));
        this.def.put("Ignore.peer.ports", "0");
        this.def.put("Security.JAR.tools.dir", "");
        this.def.put("network.max.simultaneous.connect.attempts", new Long(8L));
        this.def.put("network.tcp.mtu.size", new Long(1500L));
        this.def.put("network.tcp.socket.SO_SNDBUF", new Long(0L));
        this.def.put("network.tcp.socket.SO_RCVBUF", new Long(0L));
        this.def.put("network.tcp.socket.IPTOS", "");
        this.def.put("confirm_torrent_removal", new Long(0L));
        this.def.put("add_torrents_silently", new Long(0L));
    }

    public String getStringParameter(String p) throws ConfigurationParameterNotFoundException {
        if (this.def.containsKey(p)) {
            Object o = this.def.get(p);
            if (o instanceof Number) {
                return ((Number)o).toString();
            }
            return (String)o;
        }
        throw new ConfigurationParameterNotFoundException(p);
    }

    public int getIntParameter(String p) throws ConfigurationParameterNotFoundException {
        if (this.def.containsKey(p)) {
            return ((Long)this.def.get(p)).intValue();
        }
        throw new ConfigurationParameterNotFoundException(p);
    }

    public float getFloatParameter(String p) throws ConfigurationParameterNotFoundException {
        if (this.def.containsKey(p)) {
            return ((Float)this.def.get(p)).floatValue();
        }
        throw new ConfigurationParameterNotFoundException(p);
    }

    public Set getAllowedParameters() {
        return this.def.keySet();
    }

    public void addParameter(String sKey, String sParameter) {
        this.def.put(sKey, sParameter);
    }

    public void addParameter(String sKey, int iParameter) {
        this.def.put(sKey, new Long(iParameter));
    }

    public void addParameter(String sKey, byte[] bParameter) {
        this.def.put(sKey, bParameter);
    }

    public void addParameter(String sKey, boolean bParameter) {
        Long lParameter = new Long(bParameter ? 1 : 0);
        this.def.put(sKey, lParameter);
    }

    public void registerExternalDefaults(Map addmap) {
        this.def.putAll(addmap);
    }

    public boolean doesParameterDefaultExist(String p) {
        return this.def.containsKey(p);
    }
}

