/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceMapper;
import org.gudy.azureus2.core3.disk.impl.PieceList;
import org.gudy.azureus2.core3.disk.impl.PieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.DMWriterAndChecker;
import org.gudy.azureus2.core3.disk.impl.piecepicker.DMPiecePicker;
import org.gudy.azureus2.core3.disk.impl.piecepicker.DMPiecePickerFactory;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class DiskManagerImpl
implements DiskManagerHelper {
    private String dm_name = "";
    private boolean used = false;
    private boolean started = false;
    private int state_set_via_method;
    private String errorMessage = "";
    private int pieceLength;
    private int lastPieceLength;
    private int nbPieces;
    private long totalLength;
    private int percentDone;
    private long allocated;
    private long remaining;
    private TOTorrent torrent;
    private DMReader reader;
    private DMWriterAndChecker writer_and_checker;
    private RDResumeHandler resume_handler;
    private DMPiecePicker piece_picker;
    private DiskManagerPieceMapper piece_mapper;
    private DiskManagerPieceImpl[] pieces;
    private PieceList[] pieceMap;
    private DiskManagerFileInfoImpl[] files;
    private DownloadManager download_manager;
    private boolean alreadyMoved = false;
    private static final int LDT_STATECHANGED = 1;
    private ListenerManager listeners = ListenerManager.createManager("DiskM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            DiskManagerListener listener = (DiskManagerListener)_listener;
            if (type == 1) {
                int[] params = (int[])value;
                listener.stateChanged(params[0], params[1]);
            }
        }
    });
    protected AEMonitor this_mon = new AEMonitor("DiskManager");

    public DiskManagerImpl(TOTorrent _torrent, DownloadManager _dmanager) {
        this.torrent = _torrent;
        this.download_manager = _dmanager;
        this.pieces = new DiskManagerPieceImpl[0];
        this.setState(1);
        this.percentDone = 0;
        if (this.torrent == null) {
            this.setState(10);
            return;
        }
        LocaleUtilDecoder locale_decoder = null;
        try {
            locale_decoder = LocaleUtil.getSingleton().getTorrentEncoding(this.torrent);
            this.dm_name = ByteFormatter.nicePrint(this.torrent.getHash(), true);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this.errorMessage = String.valueOf(TorrentUtils.exceptionToText(e)) + " (Constructor)";
            this.setState(10);
            return;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = String.valueOf(e.getMessage()) + " (Constructor)";
            this.setState(10);
            return;
        }
        this.piece_mapper = new DiskManagerPieceMapper(this);
        TOTorrentFile[] torrent_files = this.torrent.getFiles();
        if (this.torrent.isSimpleTorrent()) {
            this.piece_mapper.buildFileLookupTables(torrent_files[0], this.download_manager.getTorrentSaveFile());
        } else {
            this.piece_mapper.buildFileLookupTables(torrent_files, locale_decoder);
        }
        if (this.getState() == 10) {
            return;
        }
        this.remaining = this.totalLength = this.piece_mapper.getTotalLength();
        this.nbPieces = this.torrent.getNumberOfPieces();
        this.pieceLength = (int)this.torrent.getPieceLength();
        this.lastPieceLength = this.piece_mapper.getLastPieceLength();
        this.pieces = new DiskManagerPieceImpl[this.nbPieces];
        int i = 0;
        while (i < this.pieces.length) {
            this.pieces[i] = new DiskManagerPieceImpl(this, i);
            ++i;
        }
        this.reader = DMAccessFactory.createReader(this);
        this.writer_and_checker = DMAccessFactory.createWriterAndChecker(this);
        this.resume_handler = new RDResumeHandler(this, this.writer_and_checker);
        this.piece_picker = DMPiecePickerFactory.create(this);
    }

    public void start() {
        if (this.used) {
            Debug.out("DiskManager reuse not supported!!!!");
        }
        this.used = true;
        try {
            this.this_mon.enter();
            if (this.started) {
                this.this_mon.exit();
                return;
            }
            if (this.getState() == 10) {
                Debug.out("starting a faulty disk manager");
                this.this_mon.exit();
                return;
            }
            this.started = true;
            AEThread init = new AEThread("DiskManager:start"){

                public void runSupport() {
                    DiskManagerImpl.this.startSupport();
                    if (DiskManagerImpl.this.getState() == 10) {
                        DiskManagerImpl.this.stop();
                    }
                }
            };
            init.setPriority(1);
            init.start();
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void startSupport() {
        boolean moveWhenDone = COConfigurationManager.getBooleanParameter("Move Completed When Done", false);
        String moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        if (moveWhenDone && moveToDir.length() > 0 && this.filesExist(moveToDir)) {
            this.alreadyMoved = true;
            this.download_manager.setTorrentSaveDir(moveToDir);
        }
        this.writer_and_checker.start();
        this.reader.start();
        this.files = new DiskManagerFileInfoImpl[this.piece_mapper.getFileList().size()];
        int newFiles = this.allocateFiles();
        if (this.getState() == 10) {
            return;
        }
        this.pieceMap = this.piece_mapper.constructPieceMap();
        this.constructFilesPieces();
        this.piece_picker.start();
        this.resume_handler.start();
        if (newFiles == 0) {
            this.resume_handler.checkAllPieces(false);
        } else if (newFiles != this.files.length) {
            this.resume_handler.checkAllPieces(true);
        }
        this.setState(4);
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.writer_and_checker.stop();
        this.reader.stop();
        this.resume_handler.stop();
        this.piece_picker.stop();
        if (this.files != null) {
            int i = 0;
            while (i < this.files.length) {
                try {
                    if (this.files[i] != null) {
                        this.files[i].getCacheFile().close();
                    }
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    public boolean filesExist() {
        return this.filesExist(this.download_manager.getTorrentSaveDir());
    }

    protected boolean filesExist(String root_dir) {
        File root_dir_file;
        if (!this.torrent.isSimpleTorrent()) {
            root_dir = String.valueOf(root_dir) + File.separator + this.download_manager.getTorrentSaveFile();
        }
        if (!(root_dir_file = new File(root_dir)).exists()) {
            File current = root_dir_file;
            while (!current.exists()) {
                File parent = current.getParentFile();
                if (parent == null) break;
                if (!parent.exists()) {
                    current = parent;
                    continue;
                }
                this.errorMessage = parent.isDirectory() ? String.valueOf(current.toString()) + " not found." : String.valueOf(parent.toString()) + " is not a directory.";
                return false;
            }
            this.errorMessage = current + " not found.";
            return false;
        }
        if (!root_dir_file.isDirectory()) {
            this.errorMessage = String.valueOf(root_dir) + " is not a directory.";
            return false;
        }
        root_dir = String.valueOf(root_dir) + File.separator;
        List btFileList = this.piece_mapper.getFileList();
        int i = 0;
        while (i < btFileList.size()) {
            block17: {
                DiskManagerPieceMapper.fileInfo tempFile = (DiskManagerPieceMapper.fileInfo)btFileList.get(i);
                String tempPath = String.valueOf(root_dir) + tempFile.getPath();
                String tempName = tempFile.getName();
                long length = tempFile.getLength();
                File f = new File(tempPath, tempName);
                if (!f.exists()) {
                    this.errorMessage = String.valueOf(f.toString()) + " not found.";
                    return false;
                }
                DiskManagerFileInfoImpl file_info = tempFile.getFileInfo();
                boolean close_it = false;
                try {
                    if (file_info == null) {
                        file_info = new DiskManagerFileInfoImpl(this, f, tempFile.getTorrentFile());
                        close_it = true;
                    }
                    try {
                        long existing_length = file_info.getCacheFile().getLength();
                        if (existing_length <= length) break block17;
                        if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                            file_info.setAccessMode(2);
                            file_info.getCacheFile().setLength(length);
                            Debug.out("Existing data file length too large [" + existing_length + ">" + length + "]: " + f.getAbsolutePath() + ", truncating");
                            break block17;
                        }
                        this.errorMessage = "Existing data file length too large [" + existing_length + ">" + length + "]: " + f.getAbsolutePath();
                        if (close_it) {
                            file_info.getCacheFile().close();
                        }
                        return false;
                    }
                    finally {
                        if (close_it) {
                            file_info.getCacheFile().close();
                        }
                    }
                }
                catch (CacheFileManagerException e) {
                    this.errorMessage = String.valueOf(Debug.getNestedExceptionMessage(e)) + " (filesExist:" + f.toString() + ")";
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private int allocateFiles() {
        this.setState(2);
        this.allocated = 0L;
        int numNewFiles = 0;
        String root_dir = this.download_manager.getTorrentSaveDir();
        if (!this.torrent.isSimpleTorrent()) {
            root_dir = String.valueOf(root_dir) + File.separator + this.download_manager.getTorrentSaveFile();
        }
        root_dir = String.valueOf(root_dir) + File.separator;
        List btFileList = this.piece_mapper.getFileList();
        int i = 0;
        while (i < btFileList.size()) {
            DiskManagerFileInfoImpl fileInfo2;
            DiskManagerPieceMapper.fileInfo tempFile = (DiskManagerPieceMapper.fileInfo)btFileList.get(i);
            String tempPath = String.valueOf(root_dir) + tempFile.getPath();
            String tempName = tempFile.getName();
            long length = tempFile.getLength();
            File f = new File(tempPath, tempName);
            boolean file_exists = f.exists();
            try {
                fileInfo2 = new DiskManagerFileInfoImpl(this, f, tempFile.getTorrentFile());
            }
            catch (CacheFileManagerException e) {
                this.errorMessage = String.valueOf(Debug.getNestedExceptionMessage(e)) + " (allocateFiles:" + f.toString() + ")";
                this.setState(10);
                try {
                    tempFile.getFileInfo().getCacheFile().close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return -1;
            }
            int separator = tempName.lastIndexOf(".");
            if (separator == -1) {
                separator = 0;
            }
            fileInfo2.setExtension(tempName.substring(separator));
            String extensions = COConfigurationManager.getStringParameter("priorityExtensions", "");
            if (!extensions.equals("")) {
                boolean bIgnoreCase = COConfigurationManager.getBooleanParameter("priorityExtensionsIgnoreCase");
                StringTokenizer st = new StringTokenizer(extensions, ";");
                while (st.hasMoreTokens()) {
                    boolean bHighPriority;
                    String extension = st.nextToken();
                    if (!(extension = extension.trim()).startsWith(".")) {
                        extension = "." + extension;
                    }
                    boolean bl = bHighPriority = bIgnoreCase ? fileInfo2.getExtension().equalsIgnoreCase(extension) : fileInfo2.getExtension().equals(extension);
                    if (!bHighPriority) continue;
                    fileInfo2.setPriority(true);
                }
            }
            fileInfo2.setLength(length);
            fileInfo2.setDownloaded(0L);
            if (file_exists) {
                try {
                    long existing_length = fileInfo2.getCacheFile().getLength();
                    if (existing_length > length) {
                        if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                            fileInfo2.setAccessMode(2);
                            fileInfo2.getCacheFile().setLength(length);
                            Debug.out("Existing data file length too large [" + existing_length + ">" + length + "]: " + f.getAbsolutePath() + ", truncating");
                        } else {
                            this.errorMessage = "Existing data file length too large [" + existing_length + ">" + length + "]: " + f.getAbsolutePath();
                            this.setState(10);
                            try {
                                fileInfo2.getCacheFile().close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return -1;
                        }
                    }
                    fileInfo2.setAccessMode(1);
                }
                catch (CacheFileManagerException e) {
                    this.errorMessage = String.valueOf(Debug.getNestedExceptionMessage(e)) + " (allocateFiles existing:" + f.toString() + ")";
                    this.setState(10);
                    try {
                        fileInfo2.getCacheFile().close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return -1;
                }
                this.allocated += length;
            } else {
                block33: {
                    if (this.download_manager.isDataAlreadyAllocated()) {
                        this.errorMessage = "Data file missing: " + f.getAbsolutePath();
                        this.setState(10);
                        try {
                            fileInfo2.getCacheFile().close();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        return -1;
                    }
                    try {
                        File directory = new File(tempPath);
                        if (!directory.exists() && !directory.mkdirs()) {
                            throw new Exception("directory creation failed: " + directory);
                        }
                        f.getCanonicalPath();
                        fileInfo2.setAccessMode(2);
                        if (COConfigurationManager.getBooleanParameter("Enable incremental file creation")) {
                            fileInfo2.getCacheFile().setLength(0L);
                            break block33;
                        }
                        if (COConfigurationManager.getBooleanParameter("Zero New")) {
                            if (this.writer_and_checker.zeroFile(fileInfo2, length)) break block33;
                            this.setState(10);
                            try {
                                fileInfo2.getCacheFile().close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return -1;
                        }
                        fileInfo2.getCacheFile().setLength(length);
                        this.allocated += length;
                    }
                    catch (Exception e) {
                        this.errorMessage = String.valueOf(Debug.getNestedExceptionMessage(e)) + " (allocateFiles new:" + f.toString() + ")";
                        this.setState(10);
                        try {
                            fileInfo2.getCacheFile().close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return -1;
                    }
                }
                ++numNewFiles;
            }
            this.files[i] = fileInfo2;
            tempFile.setFileInfo(this.files[i]);
            ++i;
        }
        this.loadFilePriorities();
        this.download_manager.setDataAlreadyAllocated(true);
        return numNewFiles;
    }

    public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.reader.enqueueReadRequest(request2, listener);
    }

    public int getNumberOfPieces() {
        return this.nbPieces;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public void setPercentDone(int num) {
        this.percentDone = num;
    }

    public long getRemaining() {
        return this.remaining;
    }

    public void incrementRemaining(long num) {
        try {
            this.this_mon.enter();
            this.remaining += num;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void decrementRemaining(long num) {
        try {
            this.this_mon.enter();
            this.remaining -= num;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public long getAllocated() {
        return this.allocated;
    }

    public void setAllocated(long num) {
        this.allocated = num;
    }

    protected void setPieceDone(DiskManagerPieceImpl piece) {
        int piece_length;
        int n = piece_length = piece.getPieceNumber() == this.nbPieces - 1 ? this.lastPieceLength : this.pieceLength;
        if (piece.getDone()) {
            this.decrementRemaining(piece_length);
            this.computeFilesDone(piece.getPieceNumber());
        } else {
            this.incrementRemaining(piece_length);
        }
    }

    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    public int getPieceLength() {
        return this.pieceLength;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public int getLastPieceLength() {
        return this.lastPieceLength;
    }

    public int getState() {
        return this.state_set_via_method;
    }

    public void setState(int _state) {
        if (this.state_set_via_method != _state) {
            int[] params = new int[]{this.state_set_via_method, _state};
            this.state_set_via_method = _state;
            this.listeners.dispatch(1, params);
        }
    }

    public void computeFilesDone(int pieceNumber) {
        int i = 0;
        while (i < this.files.length) {
            DiskManagerFileInfoImpl this_file = this.files[i];
            PieceList pieceList = this.pieceMap[pieceNumber];
            int k = 0;
            while (k < pieceList.size()) {
                PieceMapEntry tempPiece = pieceList.get(k);
                if (this_file == tempPiece.getFile()) {
                    long done = this_file.getDownloaded();
                    this_file.setDownloaded(done += (long)tempPiece.getLength());
                    if (done == this_file.getLength() && this_file.getAccessMode() == 2) {
                        try {
                            this_file.setAccessMode(1);
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                ++k;
            }
            ++i;
        }
    }

    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    private void constructFilesPieces() {
        int i = 0;
        while (i < this.pieceMap.length) {
            PieceList pieceList = this.pieceMap[i];
            int j = 0;
            while (j < pieceList.size()) {
                DiskManagerFileInfoImpl fileInfo2 = pieceList.get(j).getFile();
                if (fileInfo2.getFirstPieceNumber() == -1) {
                    fileInfo2.setFirstPieceNumber(i);
                }
                fileInfo2.setNbPieces(fileInfo2.getNbPieces() + 1);
                ++j;
            }
            ++i;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setFailed(final String reason) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                LGLogger.logUnrepeatableAlert(3, DiskManagerImpl.this.errorMessage);
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop();
            }
        }.start();
    }

    public PieceList getPieceList(int piece_number) {
        return this.pieceMap[piece_number];
    }

    public byte[] getPieceHash(int piece_number) throws TOTorrentException {
        return this.torrent.getPieces()[piece_number];
    }

    public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
        return this.reader.createRequest(pieceNumber, offset, length);
    }

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequestListener listener, Object user_data) {
        this.writer_and_checker.enqueueCompleteRecheckRequest(listener, user_data);
    }

    public void enqueueCheckRequest(int pieceNumber, DiskManagerCheckRequestListener listener, Object user_data) {
        this.writer_and_checker.enqueueCheckRequest(pieceNumber, listener, user_data);
    }

    public boolean isChecking() {
        return this.writer_and_checker.isChecking();
    }

    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        return this.reader.readBlock(pieceNumber, offset, length);
    }

    public void enqueueWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data, DiskManagerWriteRequestListener listener) {
        this.writer_and_checker.writeBlock(pieceNumber, offset, data, user_data, listener);
    }

    public boolean checkBlockConsistency(int pieceNumber, int offset, DirectByteBuffer data) {
        return this.writer_and_checker.checkBlock(pieceNumber, offset, data);
    }

    public boolean checkBlockConsistency(int pieceNumber, int offset, int length) {
        return this.writer_and_checker.checkBlock(pieceNumber, offset, length);
    }

    public void dumpResumeDataToDisk(boolean savePartialPieces, boolean force_recheck) throws Exception {
        this.resume_handler.dumpResumeDataToDisk(savePartialPieces, force_recheck);
    }

    /*
     * Unable to fully structure code
     */
    public void downloadEnded() {
        block65: {
            try {
                this.this_mon.enter();
                rPath = this.download_manager.getTorrentSaveDir();
                if (!this.download_manager.isPersistent()) {
                    try {
                        resumeEnabled = COConfigurationManager.getBooleanParameter("Use Resume", true);
                        if (resumeEnabled) {
                            try {
                                this.dumpResumeDataToDisk(true, false);
                            }
                            catch (Exception e) {
                                Debug.out("dumpResumeDataToDisk fails");
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    this.this_mon.exit();
                    return;
                }
                if (this.alreadyMoved) {
                    try {
                        e = COConfigurationManager.getBooleanParameter("Use Resume", true);
                        if (e) {
                            try {
                                this.dumpResumeDataToDisk(true, false);
                            }
                            catch (Exception e) {
                                Debug.out("dumpResumeDataToDisk fails");
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    this.this_mon.exit();
                    return;
                }
                this.alreadyMoved = true;
                moveWhenDone = COConfigurationManager.getBooleanParameter("Move Completed When Done", false);
                if (!moveWhenDone) {
                    try {
                        e = COConfigurationManager.getBooleanParameter("Use Resume", true);
                        if (e) {
                            try {
                                this.dumpResumeDataToDisk(true, false);
                            }
                            catch (Exception e) {
                                Debug.out("dumpResumeDataToDisk fails");
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    this.this_mon.exit();
                    return;
                }
                moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
                if (moveToDir.length() == 0) {
                    try {
                        e = COConfigurationManager.getBooleanParameter("Use Resume", true);
                        if (e) {
                            try {
                                this.dumpResumeDataToDisk(true, false);
                            }
                            catch (Exception e) {
                                Debug.out("dumpResumeDataToDisk fails");
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    this.this_mon.exit();
                    return;
                }
                try {
                    moveOnlyInDefault = COConfigurationManager.getBooleanParameter("Move Only When In Default Save Dir");
                    if (moveOnlyInDefault && !rPath.equals(defSaveDir = COConfigurationManager.getStringParameter("Default save path"))) {
                        LGLogger.log(0, "Not moving-on-complete since data is not within default save dir");
                        try {
                            e = COConfigurationManager.getBooleanParameter("Use Resume", true);
                            if (e) {
                                try {
                                    this.dumpResumeDataToDisk(true, false);
                                }
                                catch (Exception e) {
                                    Debug.out("dumpResumeDataToDisk fails");
                                }
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        this.this_mon.exit();
                        return;
                    }
                    new_files = new File[this.files.length];
                    old_files = new File[this.files.length];
                    i = 0;
                    while (i < this.files.length) {
                        old_files[i] = old_file = this.files[i].getFile();
                        fullPath = old_file.getParent();
                        subPath = fullPath.substring(fullPath.indexOf(rPath) + rPath.length());
                        destDir = new File(String.valueOf(moveToDir) + subPath);
                        destDir.mkdirs();
                        new_files[i] = newFile = new File(destDir, old_file.getName());
                        if (newFile.exists()) {
                            msg = old_file.getName() + " already exists in MoveTo destination dir";
                            LGLogger.log(3, msg);
                            LGLogger.logUnrepeatableAlertUsingResource(3, "DiskManager.alert.movefileexists", new String[]{old_file.getName()});
                            Debug.out(msg);
                            try {
                                e = COConfigurationManager.getBooleanParameter("Use Resume", true);
                                if (e) {
                                    try {
                                        this.dumpResumeDataToDisk(true, false);
                                    }
                                    catch (Exception e) {
                                        Debug.out("dumpResumeDataToDisk fails");
                                    }
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            this.this_mon.exit();
                            return;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.files.length) {
                        block64: {
                            old_file = this.files[i].getFile();
                            new_file = new_files[i];
                            try {
                                this.files[i].moveFile(new_file);
                                this.files[i].setAccessMode(1);
                                break block64;
                            }
                            catch (CacheFileManagerException e) {
                                msg = "Failed to move " + old_file.getName() + " to destination dir";
                                LGLogger.log(3, msg);
                                LGLogger.logUnrepeatableAlertUsingResource(3, "DiskManager.alert.movefilefails", new String[]{old_file.toString(), Debug.getNestedExceptionMessage(e)});
                                Debug.out(msg);
                                j = 0;
                                ** while (j < i)
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    this.files[j].moveFile(old_files[j]);
                                    this.files[j].setAccessMode(1);
                                }
                                catch (CacheFileManagerException f) {
                                    LGLogger.logUnrepeatableAlertUsingResource(3, "DiskManager.alert.movefilerecoveryfails", new String[]{this.files[j].toString(), Debug.getNestedExceptionMessage(f)});
                                }
                                ++j;
                                continue;
                            }
lbl134:
                            // 1 sources

                            try {
                                e = COConfigurationManager.getBooleanParameter("Use Resume", true);
                                if (e) {
                                    try {
                                        this.dumpResumeDataToDisk(true, false);
                                    }
                                    catch (Exception e) {
                                        Debug.out("dumpResumeDataToDisk fails");
                                    }
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            this.this_mon.exit();
                            return;
                        }
                        ++i;
                    }
                    tFile = new File(this.download_manager.getTorrentSaveDir(), this.download_manager.getTorrentSaveFile());
                    if (tFile.isDirectory() && !moveToDir.equals(rPath)) {
                        DiskManagerImpl.deleteDataFiles(this.torrent, this.download_manager.getTorrentSaveDir(), this.download_manager.getTorrentSaveFile());
                    }
                    this.download_manager.setTorrentSaveDir(moveToDir);
                    moveTorrent = COConfigurationManager.getBooleanParameter("Move Torrent When Done", true);
                    if (!moveTorrent || (newTorrentFile = new File(moveToDir, oldFileName = (oldTorrentFile = new File(oldFullName = this.download_manager.getTorrentFileName())).getName())).equals(oldTorrentFile)) break block65;
                    if (TorrentUtils.move(oldTorrentFile, newTorrentFile)) {
                        this.download_manager.setTorrentFileName(newTorrentFile.getCanonicalPath());
                        break block65;
                    }
                    msg = "Failed to move " + oldTorrentFile.toString() + " to " + newTorrentFile.toString();
                    LGLogger.log(3, msg);
                    LGLogger.logUnrepeatableAlertUsingResource(3, "DiskManager.alert.movefilefails", new String[]{oldTorrentFile.toString(), newTorrentFile.toString()});
                    Debug.out(msg);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
            finally {
                try {
                    e = COConfigurationManager.getBooleanParameter("Use Resume", true);
                    if (e) {
                        try {
                            this.dumpResumeDataToDisk(true, false);
                        }
                        catch (Exception e) {
                            Debug.out("dumpResumeDataToDisk fails");
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                this.this_mon.exit();
            }
        }
    }

    public String getName() {
        return this.dm_name;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void addListener(DiskManagerListener l) {
        this.listeners.addListener(l);
        int[] params = new int[]{this.getState(), this.getState()};
        this.listeners.dispatch(l, 1, params);
    }

    public void removeListener(DiskManagerListener l) {
        this.listeners.removeListener(l);
    }

    public static void deleteDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        block11: {
            if (torrent == null || torrent_save_file == null) {
                return;
            }
            try {
                if (torrent.isSimpleTorrent()) {
                    new File(torrent_save_dir, torrent_save_file).delete();
                    break block11;
                }
                LocaleUtilDecoder locale_decoder = LocaleUtil.getSingleton().getTorrentEncoding(torrent);
                TOTorrentFile[] files = torrent.getFiles();
                int i = 0;
                while (i < files.length) {
                    byte[][] path_comps = files[i].getPathComponents();
                    String path_str = String.valueOf(torrent_save_dir) + File.separator + torrent_save_file + File.separator;
                    int j = 0;
                    while (j < path_comps.length) {
                        try {
                            String comp = locale_decoder.decodeString(path_comps[j]);
                            comp = FileUtil.convertOSSpecificChars(comp);
                            path_str = String.valueOf(path_str) + (j == 0 ? "" : File.separator) + comp;
                        }
                        catch (UnsupportedEncodingException e) {
                            System.out.println("file - unsupported encoding!!!!");
                        }
                        ++j;
                    }
                    File file = new File(path_str);
                    if (file.exists() && !file.isDirectory()) {
                        try {
                            file.delete();
                        }
                        catch (Exception e) {
                            Debug.out(e.toString());
                        }
                    }
                    ++i;
                }
                FileUtil.recursiveEmptyDirDelete(new File(torrent_save_dir, torrent_save_file));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void loadFilePriorities() {
        try {
            if (this.files == null) {
                return;
            }
            List file_priorities = (List)this.download_manager.getData("file_priorities");
            if (file_priorities == null) {
                return;
            }
            int i = 0;
            while (i < this.files.length) {
                DiskManagerFileInfoImpl file = this.files[i];
                if (file == null) {
                    return;
                }
                int priority = ((Long)file_priorities.get(i)).intValue();
                if (priority == 0) {
                    file.setSkipped(true);
                } else if (priority == 1) {
                    file.setPriority(true);
                }
                ++i;
            }
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
    }

    public void storeFilePriorities() {
        if (this.files == null) {
            return;
        }
        ArrayList<Long> file_priorities = new ArrayList<Long>();
        int i = 0;
        while (i < this.files.length) {
            DiskManagerFileInfoImpl file = this.files[i];
            if (file == null) {
                return;
            }
            boolean skipped = file.isSkipped();
            boolean priority = file.isPriority();
            int value = -1;
            if (skipped) {
                value = 0;
            } else if (priority) {
                value = 1;
            }
            file_priorities.add(i, new Long(value));
            ++i;
        }
        this.download_manager.setData("file_priorities", file_priorities);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    public void computePriorityIndicator() {
        this.piece_picker.computePriorityIndicator();
    }

    public int getPieceNumberToDownload(boolean[] _piecesRarest) {
        return this.piece_picker.getPiecenumberToDownload(_piecesRarest);
    }
}

