/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.PieceList;
import org.gudy.azureus2.core3.disk.impl.PieceMapEntry;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.FileUtil;

public class DiskManagerPieceMapper {
    protected DiskManagerHelper disk_manager;
    protected long total_length;
    protected int piece_count;
    protected int piece_length;
    protected int last_piece_length;
    protected ArrayList btFileList = new ArrayList();

    protected DiskManagerPieceMapper(DiskManagerHelper _disk_manager) {
        this.disk_manager = _disk_manager;
        TOTorrent torrent = this.disk_manager.getTorrent();
        this.piece_length = (int)torrent.getPieceLength();
        this.piece_count = torrent.getNumberOfPieces();
        TOTorrentFile[] files = torrent.getFiles();
        int i = 0;
        while (i < files.length) {
            this.total_length += files[i].getLength();
            ++i;
        }
        this.last_piece_length = (int)(this.total_length - (long)(this.piece_count - 1) * (long)this.piece_length);
    }

    protected void buildFileLookupTables(TOTorrentFile torrent_file, String fileName) {
        this.btFileList.add(new fileInfo(torrent_file, "", fileName, this.total_length));
    }

    protected void buildFileLookupTables(TOTorrentFile[] torrent_files, LocaleUtilDecoder locale_decoder) {
        char separator = File.separatorChar;
        int i = 0;
        while (i < torrent_files.length) {
            this.buildFileLookupTable(torrent_files[i], locale_decoder, separator);
            if (this.disk_manager.getState() == 10) {
                return;
            }
            ++i;
        }
    }

    private void buildFileLookupTable(TOTorrentFile torrent_file, LocaleUtilDecoder locale_decoder, char separator) {
        long fileLength = torrent_file.getLength();
        byte[][] path_components = torrent_file.getPathComponents();
        StringBuffer pathBuffer = new StringBuffer(0);
        try {
            int lastIndex = path_components.length - 1;
            int j = 0;
            while (j < lastIndex) {
                String comp = locale_decoder.decodeString(path_components[j]);
                comp = FileUtil.convertOSSpecificChars(comp);
                pathBuffer.append(comp);
                pathBuffer.append(separator);
                ++j;
            }
            String last_comp = locale_decoder.decodeString(path_components[lastIndex]);
            last_comp = FileUtil.convertOSSpecificChars(last_comp);
            this.btFileList.add(new fileInfo(torrent_file, pathBuffer.toString(), last_comp, fileLength));
        }
        catch (UnsupportedEncodingException e) {
            this.disk_manager.setFailed(String.valueOf(e.getMessage()) + " (buildFileLookupTable)");
        }
    }

    protected PieceList[] constructPieceMap() {
        PieceList[] pieceMap = new PieceList[this.piece_count];
        int modified_piece_length = this.piece_length;
        if (this.total_length < (long)modified_piece_length) {
            modified_piece_length = (int)this.total_length;
        }
        long fileOffset = 0L;
        int currentFile = 0;
        int i = 0;
        while (1 == this.piece_count && i < this.piece_count || i < this.piece_count - 1) {
            ArrayList<PieceMapEntry> pieceToFileList = new ArrayList<PieceMapEntry>();
            int usedSpace = 0;
            while (modified_piece_length > usedSpace) {
                fileInfo tempFile = (fileInfo)this.btFileList.get(currentFile);
                long length = tempFile.getLength();
                long availableSpace = length - fileOffset;
                PieceMapEntry tempPieceEntry = null;
                if (availableSpace < (long)(modified_piece_length - usedSpace)) {
                    tempPieceEntry = new PieceMapEntry(tempFile.getFileInfo(), fileOffset, (int)availableSpace);
                    usedSpace = (int)((long)usedSpace + availableSpace);
                    fileOffset = 0L;
                    ++currentFile;
                } else {
                    tempPieceEntry = new PieceMapEntry(tempFile.getFileInfo(), fileOffset, modified_piece_length - usedSpace);
                    fileOffset += (long)(modified_piece_length - usedSpace);
                    usedSpace += modified_piece_length - usedSpace;
                }
                pieceToFileList.add(tempPieceEntry);
            }
            pieceMap[i] = PieceList.convert(pieceToFileList);
            ++i;
        }
        if (this.piece_count > 1) {
            pieceMap[this.piece_count - 1] = PieceList.convert(this.buildLastPieceToFileList(this.btFileList, currentFile, fileOffset));
        }
        return pieceMap;
    }

    private List buildLastPieceToFileList(List file_list, int currentFile, long fileOffset) {
        ArrayList<PieceMapEntry> pieceToFileList = new ArrayList<PieceMapEntry>();
        int usedSpace = 0;
        while (this.last_piece_length > usedSpace) {
            fileInfo tempFile = (fileInfo)file_list.get(currentFile);
            long length = tempFile.getLength();
            long availableSpace = length - fileOffset;
            PieceMapEntry tempPieceEntry = null;
            if (availableSpace < (long)(this.piece_length - usedSpace)) {
                tempPieceEntry = new PieceMapEntry(tempFile.getFileInfo(), fileOffset, (int)availableSpace);
                usedSpace = (int)((long)usedSpace + availableSpace);
                fileOffset = 0L;
                ++currentFile;
            } else {
                tempPieceEntry = new PieceMapEntry(tempFile.getFileInfo(), fileOffset, this.last_piece_length - usedSpace);
                fileOffset += (long)(this.piece_length - usedSpace);
                usedSpace += this.piece_length - usedSpace;
            }
            pieceToFileList.add(tempPieceEntry);
        }
        return pieceToFileList;
    }

    protected long getTotalLength() {
        return this.total_length;
    }

    protected int getLastPieceLength() {
        return this.last_piece_length;
    }

    protected List getFileList() {
        return this.btFileList;
    }

    protected static class fileInfo {
        private DiskManagerFileInfoImpl file;
        private TOTorrentFile torrent_file;
        private String path;
        private String name;
        private long length;

        public fileInfo(TOTorrentFile _torrent_file, String _path, String _name, long _length) {
            this.torrent_file = _torrent_file;
            this.path = _path;
            this.length = _length;
            this.name = _name;
        }

        public long getLength() {
            return this.length;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public TOTorrentFile getTorrentFile() {
            return this.torrent_file;
        }

        public DiskManagerFileInfoImpl getFileInfo() {
            return this.file;
        }

        public void setFileInfo(DiskManagerFileInfoImpl _file) {
            this.file = _file;
        }
    }
}

