/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.PieceList;
import org.gudy.azureus2.core3.disk.impl.PieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.impl.DiskManagerRequestImpl;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class DMReaderImpl
implements DMReader {
    protected static final int QUEUE_REPORT_CHUNK = 32;
    protected DiskManagerHelper disk_manager;
    private boolean bOverallContinue = true;
    private List readQueue = new LinkedList();
    private AESemaphore readQueueSem = new AESemaphore("DMReader::readQ");
    private AEMonitor this_mon = new AEMonitor("DMReader");
    private int next_report_size = 32;
    private boolean started;
    private AESemaphore stop_sem = new AESemaphore("DMReader::stop");
    private DiskReadThread readThread;

    public DMReaderImpl(DiskManagerHelper _disk_manager) {
        this.disk_manager = _disk_manager;
    }

    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("DMReader: start while started");
            }
            if (!this.bOverallContinue) {
                throw new RuntimeException("DMReader: start after stopped");
            }
            this.started = true;
            this.readThread = new DiskReadThread();
            this.readThread.start();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void stop() {
        try {
            this.this_mon.enter();
            if (!this.started) {
                this.this_mon.exit();
                return;
            }
            this.started = false;
            this.bOverallContinue = false;
        }
        finally {
            this.this_mon.exit();
        }
        this.readThread.stopIt();
        this.stop_sem.reserve();
    }

    public DiskManagerReadRequest createRequest(int pieceNumber, int offset, int length) {
        return new DiskManagerRequestImpl(pieceNumber, offset, length);
    }

    public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        DiskReadRequest drr = new DiskReadRequest(request2, listener);
        try {
            this.this_mon.enter();
            if (!this.bOverallContinue) {
                throw new RuntimeException("Reader stopped");
            }
            this.readQueue.add(drr);
        }
        finally {
            this.this_mon.exit();
        }
        this.readQueueSem.release();
        int queue_size = this.readQueueSem.getValue();
        if (queue_size > this.next_report_size) {
            LGLogger.log("Disk Manager read queue size exceeds " + this.next_report_size);
            this.next_report_size += 32;
        }
    }

    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        if (!this.bOverallContinue) {
            Debug.out("DMReader:readBlock: called when stopped");
            return null;
        }
        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)6, length);
        if (buffer == null) {
            System.out.println("DiskManager::readBlock:: ByteBufferPool returned null buffer");
            return null;
        }
        long previousFilesLength = 0L;
        int currentFile = 0;
        PieceList pieceList = this.disk_manager.getPieceList(pieceNumber);
        if (pieceList.size() == 0) {
            System.out.println("no pieceList entries for " + pieceNumber);
            return buffer;
        }
        long fileOffset = pieceList.get(0).getOffset();
        while (currentFile < pieceList.size() && pieceList.getCumulativeLengthToPiece(currentFile) < offset) {
            previousFilesLength = pieceList.getCumulativeLengthToPiece(currentFile);
            ++currentFile;
            fileOffset = 0L;
        }
        fileOffset += (long)offset - previousFilesLength;
        while (buffer.hasRemaining((byte)7) && currentFile < pieceList.size()) {
            PieceMapEntry map_entry = pieceList.get(currentFile);
            int length_available = map_entry.getLength() - (int)(fileOffset - map_entry.getOffset());
            int entry_read_limit = buffer.position((byte)7) + length_available;
            entry_read_limit = Math.min(length, entry_read_limit);
            buffer.limit((byte)7, entry_read_limit);
            boolean ok = this.readFileInfoIntoBuffer(map_entry.getFile(), buffer, fileOffset);
            buffer.limit((byte)7, length);
            if (!ok) {
                buffer.returnToPool();
                return null;
            }
            ++currentFile;
            fileOffset = 0L;
        }
        buffer.position((byte)7, 0);
        return buffer;
    }

    private boolean readFileInfoIntoBuffer(DiskManagerFileInfoImpl file, DirectByteBuffer buffer, long offset) {
        try {
            file.getCacheFile().read(buffer, offset);
            return true;
        }
        catch (CacheFileManagerException e) {
            this.disk_manager.setFailed(Debug.getNestedExceptionMessage(e));
            return false;
        }
    }

    static /* synthetic */ AESemaphore access$0(DMReaderImpl dMReaderImpl) {
        return dMReaderImpl.stop_sem;
    }

    public class DiskReadThread
    extends AEThread {
        private boolean bReadContinue;

        public DiskReadThread() {
            super("Disk Reader");
            this.bReadContinue = true;
            this.setDaemon(true);
        }

        /*
         * Exception decompiling
         */
        public void runSupport() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void stopIt() {
            try {
                DMReaderImpl.this.this_mon.enter();
                this.bReadContinue = false;
            }
            finally {
                DMReaderImpl.this.this_mon.exit();
            }
            DMReaderImpl.this.readQueueSem.releaseForever();
            while (DMReaderImpl.this.readQueue.size() != 0) {
                DMReaderImpl.this.readQueue.remove(0);
            }
        }
    }

    private static class DiskReadRequest {
        private final DiskManagerReadRequest request;
        private final DiskManagerReadRequestListener listener;

        DiskReadRequest(DiskManagerReadRequest r, DiskManagerReadRequestListener l) {
            this.request = r;
            this.listener = l;
        }

        protected DiskManagerReadRequest getRequest() {
            return this.request;
        }

        protected void readCompleted(DirectByteBuffer buffer) {
            this.listener.readCompleted(this.request, buffer);
        }
    }
}

