/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;

public interface DownloadManager {
    public static final int STATE_WAITING = 0;
    public static final int STATE_INITIALIZING = 5;
    public static final int STATE_INITIALIZED = 10;
    public static final int STATE_ALLOCATING = 20;
    public static final int STATE_CHECKING = 30;
    public static final int STATE_READY = 40;
    public static final int STATE_DOWNLOADING = 50;
    public static final int STATE_FINISHING = 55;
    public static final int STATE_SEEDING = 60;
    public static final int STATE_STOPPING = 65;
    public static final int STATE_STOPPED = 70;
    public static final int STATE_QUEUED = 75;
    public static final int STATE_ERROR = 100;
    public static final int WEALTH_STOPPED = 1;
    public static final int WEALTH_NO_TRACKER = 2;
    public static final int WEALTH_NO_REMOTE = 3;
    public static final int WEALTH_OK = 4;
    public static final int WEALTH_KO = 5;

    public void initialize();

    public int getState();

    public void setState(int var1);

    public void startDownload();

    public void startDownloadInitialized(boolean var1);

    public void stopIt(int var1, boolean var2, boolean var3);

    public GlobalManager getGlobalManager();

    public DiskManager getDiskManager();

    public PEPeerManager getPeerManager();

    public void addListener(DownloadManagerListener var1);

    public void removeListener(DownloadManagerListener var1);

    public void addTrackerListener(DownloadManagerTrackerListener var1);

    public void removeTrackerListener(DownloadManagerTrackerListener var1);

    public void addPeerListener(DownloadManagerPeerListener var1);

    public void removePeerListener(DownloadManagerPeerListener var1);

    public void addPeer(PEPeer var1);

    public void removePeer(PEPeer var1);

    public void addPiece(PEPiece var1);

    public void removePiece(PEPiece var1);

    public DownloadManagerState getDownloadState();

    public TOTorrent getTorrent();

    public TRTrackerClient getTrackerClient();

    public void checkTracker();

    public TRTrackerScraperResponse getTrackerScrapeResponse();

    public void setTrackerScrapeResponse(TRTrackerScraperResponse var1);

    public String getDisplayName();

    public long getSize();

    public String getTorrentFileName();

    public void setTorrentFileName(String var1);

    public String getTorrentSaveDirAndFile();

    public String getTorrentSaveDir();

    public String getTorrentSaveFile();

    public void setTorrentSaveDir(String var1);

    public boolean isForceStart();

    public void setForceStart(boolean var1);

    public boolean isPersistent();

    public boolean isDownloadComplete();

    public String getTrackerStatus();

    public int getTrackerTime();

    public String getTorrentComment();

    public String getTorrentCreatedBy();

    public long getTorrentCreationDate();

    public int getNbPieces();

    public String getPieceLength();

    public int getNbSeeds();

    public int getNbPeers();

    public boolean filesExist();

    public String getErrorDetails();

    public void setErrorDetail(String var1);

    public int getIndex();

    public boolean isMoveableDown();

    public boolean isMoveableUp();

    public void moveDown();

    public void moveUp();

    public DownloadManagerStats getStats();

    public int getPosition();

    public void setPosition(int var1);

    public boolean getOnlySeeding();

    public void setOnlySeeding(boolean var1);

    public void restartDownload(boolean var1);

    public int getPrevState();

    public void setPrevState(int var1);

    public void downloadEnded();

    public DiskManager initializeDiskManager();

    public boolean canForceRecheck();

    public void forceRecheck();

    public int getHealthStatus();

    public void saveResumeData();

    public void saveDownload();

    public Object getData(String var1);

    public void setData(String var1, Object var2);

    public boolean isDataAlreadyAllocated();

    public void setDataAlreadyAllocated(boolean var1);

    public long getCreationTime();

    public void setCreationTime(long var1);
}

