/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.helpers.TorrentFolderWatcher;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.impl.GlobalManagerHostSupport;
import org.gudy.azureus2.core3.global.impl.GlobalManagerStatsImpl;
import org.gudy.azureus2.core3.global.impl.GlobalManagerStatsWriter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcherWithException;
import org.gudy.azureus2.core3.util.NonDaemonTask;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SystemTime;

public class GlobalManagerImpl
implements GlobalManager,
DownloadManagerListener {
    private static final int LDT_MANAGER_ADDED = 1;
    private static final int LDT_MANAGER_REMOVED = 2;
    private static final int LDT_DESTROY_INITIATED = 3;
    private static final int LDT_DESTROYED = 4;
    private ListenerManager listeners = ListenerManager.createAsyncManager("GM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            GlobalManagerListener target = (GlobalManagerListener)_listener;
            if (type == 1) {
                target.downloadManagerAdded((DownloadManager)value);
            } else if (type == 2) {
                target.downloadManagerRemoved((DownloadManager)value);
            } else if (type == 3) {
                target.destroyInitiated();
            } else if (type == 4) {
                target.destroyed();
            }
        }
    });
    private static final int LDT_MANAGER_WBR = 1;
    private ListenerManager removal_listeners = ListenerManager.createManager("GM:DLWBRMListenDispatcher", new ListenerManagerDispatcherWithException(){

        public void dispatchWithException(Object _listener, int type, Object value) throws GlobalManagerDownloadRemovalVetoException {
            GlobalManagerDownloadWillBeRemovedListener target = (GlobalManagerDownloadWillBeRemovedListener)_listener;
            target.downloadWillBeRemoved((DownloadManager)value);
        }
    });
    private List managers_cow = new ArrayList();
    private AEMonitor managers_mon = new AEMonitor("GM:Managers");
    private Map manager_map = new HashMap();
    private Checker checker;
    private GlobalManagerStatsImpl stats;
    private TRTrackerScraper trackerScraper;
    private GlobalManagerStatsWriter stats_writer;
    private GlobalManagerHostSupport host_support;
    private Map saved_download_manager_state = new HashMap();
    private TorrentFolderWatcher torrent_folder_watcher;
    private ArrayList paused_list = new ArrayList();
    private final AEMonitor paused_list_mon = new AEMonitor("GlobalManager:PL");
    private boolean isStopping;
    private boolean destroyed;
    private boolean needsSaving = false;

    public GlobalManagerImpl(AzureusCoreListener listener) {
        LGLogger.initialise();
        this.stats = new GlobalManagerStatsImpl();
        try {
            this.stats_writer = new GlobalManagerStatsWriter(this);
        }
        catch (Throwable e) {
            LGLogger.log("Stats unavailable", e);
        }
        if (listener != null) {
            listener.reportCurrentTask(String.valueOf(MessageText.getString("splash.initializeGM")) + ": " + MessageText.getString("splash.loadingTorrents"));
        }
        this.loadDownloads(listener);
        if (listener != null) {
            listener.reportCurrentTask(MessageText.getString("splash.initializeGM"));
        }
        this.trackerScraper = TRTrackerScraperFactory.getSingleton();
        this.trackerScraper.setClientResolver(new TRTrackerScraperClientResolver(){

            public TRTrackerClient getClient(byte[] torrent_hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(torrent_hash);
                if (dm != null) {
                    return dm.getTrackerClient();
                }
                return null;
            }
        });
        this.trackerScraper.addListener(new TRTrackerScraperListener(){

            public void scrapeReceived(TRTrackerScraperResponse response) {
                DownloadManager manager;
                byte[] hash = response.getHash();
                if (response.isValid() && (manager = (DownloadManager)GlobalManagerImpl.this.manager_map.get(new HashWrapper(hash))) != null) {
                    manager.setTrackerScrapeResponse(response);
                }
            }
        });
        try {
            this.host_support = new GlobalManagerHostSupport(this);
        }
        catch (Throwable e) {
            LGLogger.log("Hosting unavailable", e);
        }
        this.checker = new Checker();
        this.checker.start();
        if (this.stats_writer != null) {
            this.stats_writer.initialisationComplete();
        }
        this.torrent_folder_watcher = new TorrentFolderWatcher(this);
    }

    public DownloadManager addDownloadManager(String fileName, String savePath) {
        return this.addDownloadManager(fileName, savePath, 0, true);
    }

    public DownloadManager addDownloadManager(String fileName, String savePath, int initialState) {
        return this.addDownloadManager(fileName, savePath, initialState, true);
    }

    public DownloadManager addDownloadManager(String fileName, String savePath, int initialState, boolean persistent) {
        return this.addDownloadManager(fileName, savePath, initialState, persistent, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DownloadManager addDownloadManager(String torrent_file_name, String savePath, int initialState, boolean persistent, boolean for_seeding) {
        Map save_download_state;
        byte[] torrent_hash = null;
        if (!persistent && (save_download_state = (Map)this.saved_download_manager_state.get(torrent_file_name)) != null) {
            int saved_state;
            torrent_hash = (byte[])save_download_state.get("torrent_hash");
            if (save_download_state.containsKey("state") && (saved_state = ((Long)save_download_state.get("state")).intValue()) == 70) {
                initialState = saved_state;
            }
        }
        File torrentDir = null;
        File fDest = null;
        try {
            File cFile;
            File f = new File(torrent_file_name);
            boolean saveTorrents = persistent && COConfigurationManager.getBooleanParameter("Save Torrent Files", true);
            torrentDir = saveTorrents ? new File(COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory")) : new File(f.getParent());
            boolean moveWhenDone = COConfigurationManager.getBooleanParameter("Move Completed When Done", false);
            String completedDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
            if (moveWhenDone && completedDir.length() > 0 && (cFile = new File(completedDir, f.getName())).exists()) {
                torrentDir = new File(completedDir);
            }
            torrentDir.mkdirs();
            fDest = new File(torrentDir, f.getName().replaceAll("%20", "."));
            if (fDest.equals(f)) {
                throw new Exception("Same files");
            }
            while (true) {
                if (!fDest.exists()) {
                    fDest.createNewFile();
                    if (FileUtil.copyFile(f, fDest)) break;
                    throw new IOException("File copy failed");
                }
                fDest = new File(torrentDir, "_" + fDest.getName());
            }
            String fName = fDest.getCanonicalPath();
            DownloadManager new_manager = DownloadManagerFactory.create((GlobalManager)this, torrent_hash, fName, savePath, initialState, persistent, false, for_seeding);
            DownloadManager manager = this.addDownloadManager(new_manager, true);
            if (manager == null || manager != new_manager) {
                fDest.delete();
                File backupFile = new File(String.valueOf(fName) + ".bak");
                if (backupFile.exists()) {
                    backupFile.delete();
                }
            }
            return manager;
        }
        catch (IOException e) {
            System.out.println("DownloadManager::addDownloadManager: fails - td = " + torrentDir + ", fd = " + fDest);
            Debug.printStackTrace(e);
            DownloadManager manager = DownloadManagerFactory.create((GlobalManager)this, torrent_hash, torrent_file_name, savePath, initialState, persistent, false, for_seeding);
            return this.addDownloadManager(manager, true);
        }
        catch (Exception e) {
            DownloadManager manager = DownloadManagerFactory.create((GlobalManager)this, torrent_hash, torrent_file_name, savePath, initialState, persistent, false, for_seeding);
            return this.addDownloadManager(manager, true);
        }
    }

    protected DownloadManager addDownloadManager(DownloadManager download_manager, boolean save) {
        if (!this.isStopping) {
            try {
                boolean isCompleted;
                this.managers_mon.enter();
                int existing_index = this.managers_cow.indexOf(download_manager);
                if (existing_index != -1) {
                    DownloadManager existing;
                    DownloadManager downloadManager = existing = (DownloadManager)this.managers_cow.get(existing_index);
                    this.managers_mon.exit();
                    return downloadManager;
                }
                int minQueueingShareRatio = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_ShareRatio");
                DownloadManagerStats dm_stats = download_manager.getStats();
                String torrent_file_name = download_manager.getTorrentFileName();
                Map save_download_state = (Map)this.saved_download_manager_state.get(torrent_file_name);
                if (save_download_state != null) {
                    long ct;
                    Long creation_time;
                    Long already_allocated;
                    Long lSecondsOnlySeeding;
                    Long lSecondsDLing;
                    Category cat;
                    this.saved_download_manager_state.remove(torrent_file_name);
                    int nbUploads = ((Long)save_download_state.get("uploads")).intValue();
                    int maxDL = save_download_state.get("maxdl") == null ? 0 : ((Long)save_download_state.get("maxdl")).intValue();
                    int maxUL = save_download_state.get("maxul") == null ? 0 : ((Long)save_download_state.get("maxul")).intValue();
                    Long lDownloaded = (Long)save_download_state.get("downloaded");
                    Long lUploaded = (Long)save_download_state.get("uploaded");
                    Long lCompleted = (Long)save_download_state.get("completed");
                    Long lDiscarded = (Long)save_download_state.get("discarded");
                    Long lHashFails = (Long)save_download_state.get("hashfails");
                    dm_stats.setMaxUploads(nbUploads);
                    dm_stats.setMaxDownloadKBSpeed(maxDL);
                    dm_stats.setUploadRateLimitBytesPerSecond(maxUL);
                    if (lCompleted != null) {
                        dm_stats.setDownloadCompleted(lCompleted.intValue());
                    }
                    if (lDiscarded != null) {
                        dm_stats.saveDiscarded(lDiscarded);
                    }
                    if (lHashFails != null) {
                        dm_stats.saveHashFails(lHashFails);
                    }
                    Long lPosition = (Long)save_download_state.get("position");
                    String sCategory = null;
                    if (save_download_state.containsKey("category")) {
                        try {
                            sCategory = new String((byte[])save_download_state.get("category"), "UTF8");
                        }
                        catch (UnsupportedEncodingException e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (sCategory != null && (cat = CategoryManager.getCategory(sCategory)) != null) {
                        download_manager.getDownloadState().setCategory(cat);
                    }
                    boolean bCompleted = dm_stats.getDownloadCompleted(false) == 1000;
                    download_manager.setOnlySeeding(bCompleted);
                    if (lDownloaded != null && lUploaded != null) {
                        long lUploadedValue = lUploaded;
                        long lDownloadedValue = lDownloaded;
                        if (bCompleted && lDownloadedValue == 0L && (lDownloadedValue = download_manager.getSize()) != 0L && lUploadedValue * 1000L / lDownloadedValue < (long)minQueueingShareRatio) {
                            lUploadedValue = (download_manager.getSize() + 999L) * (long)minQueueingShareRatio / 1000L;
                        }
                        dm_stats.setSavedDownloadedUploaded(lDownloadedValue, lUploadedValue);
                    }
                    if (lPosition != null) {
                        download_manager.setPosition(lPosition.intValue());
                    }
                    if ((lSecondsDLing = (Long)save_download_state.get("secondsDownloading")) != null) {
                        dm_stats.setSecondsDownloading(lSecondsDLing);
                    }
                    if ((lSecondsOnlySeeding = (Long)save_download_state.get("secondsOnlySeeding")) != null) {
                        dm_stats.setSecondsOnlySeeding(lSecondsOnlySeeding);
                    }
                    if ((already_allocated = (Long)save_download_state.get("allocated")) != null && already_allocated.intValue() == 1) {
                        download_manager.setDataAlreadyAllocated(true);
                    }
                    if ((creation_time = (Long)save_download_state.get("creationTime")) != null && (ct = creation_time.longValue()) < SystemTime.getCurrentTime()) {
                        download_manager.setCreationTime(ct);
                    }
                    try {
                        List file_priorities = (List)save_download_state.get("file_priorities");
                        if (file_priorities != null) {
                            download_manager.setData("file_priorities", file_priorities);
                        }
                    }
                    catch (Throwable t) {
                        Debug.printStackTrace(t);
                    }
                } else if (dm_stats.getDownloadCompleted(false) == 1000) {
                    long lUploadedValue = (download_manager.getSize() + 999L) * (long)minQueueingShareRatio / 1000L;
                    dm_stats.setSavedDownloadedUploaded(download_manager.getSize(), lUploadedValue);
                }
                boolean bl = isCompleted = download_manager.getStats().getDownloadCompleted(false) == 1000;
                if (download_manager.getPosition() == -1) {
                    int endPosition = 0;
                    int i = 0;
                    while (i < this.managers_cow.size()) {
                        boolean dmIsCompleted;
                        DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
                        boolean bl2 = dmIsCompleted = dm.getStats().getDownloadCompleted(false) == 1000;
                        if (dmIsCompleted == isCompleted) {
                            ++endPosition;
                        }
                        ++i;
                    }
                    download_manager.setPosition(endPosition + 1);
                }
                download_manager.setOnlySeeding(isCompleted);
                ArrayList<DownloadManager> new_download_managers = new ArrayList<DownloadManager>(this.managers_cow);
                new_download_managers.add(download_manager);
                this.managers_cow = new_download_managers;
                TOTorrent torrent = download_manager.getTorrent();
                if (torrent != null) {
                    try {
                        this.manager_map.put(new HashWrapper(torrent.getHash()), download_manager);
                    }
                    catch (TOTorrentException e) {
                        Debug.printStackTrace(e);
                    }
                }
                this.listeners.dispatch(1, download_manager);
                download_manager.addListener(this);
                if (save_download_state != null) {
                    Long lStartStopLocked;
                    Long lForceStart = (Long)save_download_state.get("forceStart");
                    if (lForceStart == null && (lStartStopLocked = (Long)save_download_state.get("startStopLocked")) != null) {
                        lForceStart = lStartStopLocked;
                    }
                    if (lForceStart != null && lForceStart.intValue() == 1) {
                        download_manager.setForceStart(true);
                    }
                }
            }
            finally {
                this.managers_mon.exit();
            }
            if (save) {
                this.saveDownloads();
            }
            return download_manager;
        }
        LGLogger.log(0, 3, 3, "Tried to add a DownloadManager after shutdown of GlobalManager.");
        return null;
    }

    public List getDownloadManagers() {
        return this.managers_cow;
    }

    public DownloadManager getDownloadManager(TOTorrent torrent) {
        try {
            return this.getDownloadManager(torrent.getHash());
        }
        catch (TOTorrentException e) {
            return null;
        }
    }

    protected DownloadManager getDownloadManager(byte[] hash) {
        return (DownloadManager)this.manager_map.get(new HashWrapper(hash));
    }

    public void canDownloadManagerBeRemoved(DownloadManager manager) throws GlobalManagerDownloadRemovalVetoException {
        try {
            this.removal_listeners.dispatchWithException(1, manager);
        }
        catch (Throwable e) {
            throw (GlobalManagerDownloadRemovalVetoException)e;
        }
    }

    public void removeDownloadManager(DownloadManager manager) throws GlobalManagerDownloadRemovalVetoException {
        this.canDownloadManagerBeRemoved(manager);
        try {
            this.managers_mon.enter();
            ArrayList new_download_managers = new ArrayList(this.managers_cow);
            new_download_managers.remove(manager);
            this.managers_cow = new_download_managers;
            TOTorrent torrent = manager.getTorrent();
            if (torrent != null) {
                try {
                    this.manager_map.remove(new HashWrapper(torrent.getHash()));
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            this.managers_mon.exit();
        }
        this.fixUpDownloadManagerPositions();
        this.listeners.dispatch(2, manager);
        manager.removeListener(this);
        this.saveDownloads();
        DownloadManagerState dms = manager.getDownloadState();
        if (dms.getCategory() != null) {
            dms.setCategory(null);
        }
        dms.delete();
        if (manager.getTorrent() != null) {
            this.trackerScraper.remove(manager.getTorrent());
        }
    }

    public void stopAll() {
        try {
            this.managers_mon.enter();
            if (this.isStopping) {
                this.managers_mon.exit();
                return;
            }
            this.isStopping = true;
        }
        finally {
            this.managers_mon.exit();
        }
        this.informDestroyInitiated();
        if (this.host_support != null) {
            this.host_support.destroy();
        }
        this.torrent_folder_watcher.destroy();
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                public Object run() {
                    return null;
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.checker.stopIt();
        this.saveDownloads();
        this.stopAllDownloads();
        if (this.stats_writer != null) {
            this.stats_writer.destroy();
        }
        this.managers_cow = new ArrayList();
        this.manager_map.clear();
        this.informDestroyed();
    }

    public void stopAllDownloads() {
        this.stopAllDownloads(70);
    }

    public void stopAllDownloads(int stateAfterStopping) {
        Iterator iter = this.managers_cow.iterator();
        while (iter.hasNext()) {
            DownloadManager manager = (DownloadManager)iter.next();
            int state = manager.getState();
            if (state == 70 || state == 65) continue;
            manager.stopIt(stateAfterStopping, false, false);
        }
    }

    public void startAllDownloads() {
        Iterator iter = this.managers_cow.iterator();
        while (iter.hasNext()) {
            DownloadManager manager = (DownloadManager)iter.next();
            if (manager.getState() != 70) continue;
            manager.startDownloadInitialized(true);
        }
    }

    public void pauseDownloads() {
        Iterator i = this.managers_cow.iterator();
        while (i.hasNext()) {
            int state;
            DownloadManager manager = (DownloadManager)i.next();
            if (manager.getTorrent() == null || (state = manager.getState()) == 70 || state == 100 || state == 65) continue;
            try {
                manager.stopIt(70, false, false);
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.add(manager.getTorrent().getHashWrapper());
                }
                finally {
                    this.paused_list_mon.exit();
                }
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean canPauseDownloads() {
        Iterator i = this.managers_cow.iterator();
        while (i.hasNext()) {
            int state;
            DownloadManager manager = (DownloadManager)i.next();
            if (manager.getTorrent() == null || (state = manager.getState()) == 70 || state == 100 || state == 65) continue;
            return true;
        }
        return false;
    }

    public void resumeDownloads() {
        try {
            this.paused_list_mon.enter();
            int i = 0;
            while (i < this.paused_list.size()) {
                HashWrapper hash = (HashWrapper)this.paused_list.get(i);
                DownloadManager manager = this.getDownloadManager(hash.getHash());
                if (manager != null && manager.getState() == 70) {
                    manager.startDownloadInitialized(true);
                }
                ++i;
            }
            this.paused_list.clear();
        }
        finally {
            this.paused_list_mon.exit();
        }
    }

    public boolean canResumeDownloads() {
        try {
            this.paused_list_mon.enter();
            int i = 0;
            while (i < this.paused_list.size()) {
                HashWrapper hash = (HashWrapper)this.paused_list.get(i);
                DownloadManager manager = this.getDownloadManager(hash.getHash());
                if (manager != null && manager.getState() == 70) {
                    this.paused_list_mon.exit();
                    return true;
                }
                ++i;
            }
        }
        finally {
            this.paused_list_mon.exit();
        }
        return false;
    }

    private void loadDownloads(AzureusCoreListener listener) {
        try {
            int nbDownloads;
            Map map = FileUtil.readResilientConfigFile("downloads.config");
            boolean debug = Boolean.getBoolean("debug");
            Iterator<Object> iter = null;
            List downloads = (List)map.get("downloads");
            if (downloads == null) {
                iter = map.values().iterator();
                nbDownloads = map.size();
            } else {
                iter = downloads.iterator();
                nbDownloads = downloads.size();
            }
            int currentDownload = 0;
            while (iter.hasNext()) {
                ++currentDownload;
                Map mDownload = (Map)iter.next();
                try {
                    String torrent_save_file;
                    String torrent_save_dir;
                    byte[] torrent_save_dir_bytes;
                    byte[] torrent_hash = (byte[])mDownload.get("torrent_hash");
                    Long lPersistent = (Long)mDownload.get("persistent");
                    boolean persistent = lPersistent == null || lPersistent == 1L;
                    String fileName = new String((byte[])mDownload.get("torrent"), "UTF8");
                    if (listener != null && nbDownloads > 0) {
                        listener.reportPercent(100 * currentDownload / nbDownloads);
                    }
                    if (listener != null) {
                        listener.reportCurrentTask(String.valueOf(MessageText.getString("splash.loadingTorrent")) + " " + currentDownload + " " + MessageText.getString("splash.of") + " " + nbDownloads + " : " + fileName);
                    }
                    if ((torrent_save_dir_bytes = (byte[])mDownload.get("save_dir")) != null) {
                        byte[] torrent_save_file_bytes = (byte[])mDownload.get("save_file");
                        torrent_save_dir = new String(torrent_save_dir_bytes, "UTF8");
                        torrent_save_file = torrent_save_file_bytes != null ? new String(torrent_save_file_bytes, "UTF8") : null;
                    } else {
                        byte[] savePathBytes = (byte[])mDownload.get("path");
                        torrent_save_dir = new String(savePathBytes, "UTF8");
                        torrent_save_file = null;
                    }
                    int state = 0;
                    if (debug) {
                        state = 70;
                    } else if (mDownload.containsKey("state")) {
                        state = ((Long)mDownload.get("state")).intValue();
                        if (state != 70 && state != 75 && state != 0) {
                            state = 75;
                        }
                    } else {
                        int stopped = ((Long)mDownload.get("stopped")).intValue();
                        if (stopped == 1) {
                            state = 70;
                        }
                    }
                    this.saved_download_manager_state.put(fileName, mDownload);
                    if (!persistent) continue;
                    DownloadManager dm = DownloadManagerFactory.create((GlobalManager)this, torrent_hash, fileName, torrent_save_dir, torrent_save_file, state, true, true);
                    this.addDownloadManager(dm, false);
                }
                catch (UnsupportedEncodingException torrent_hash) {
                }
                catch (Throwable e) {
                    LGLogger.log("Error while loading downloads.  One download may not have been added to the list.");
                    Debug.printStackTrace(e);
                }
            }
            ArrayList pause_data = (ArrayList)map.get("pause_data");
            if (pause_data != null) {
                try {
                    this.paused_list_mon.enter();
                    int i = 0;
                    while (i < pause_data.size()) {
                        byte[] key = (byte[])pause_data.get(i);
                        this.paused_list.add(new HashWrapper(key));
                        ++i;
                    }
                }
                finally {
                    this.paused_list_mon.exit();
                }
            }
            this.fixUpDownloadManagerPositions();
            LGLogger.log("Loaded " + this.managers_cow.size() + " torrents");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private void saveDownloads() {
        try {
            this.managers_mon.enter();
            LGLogger.log("Saving Download List (" + this.managers_cow.size() + " items)");
            HashMap map = new HashMap();
            ArrayList list = new ArrayList(this.managers_cow.size());
            int i = 0;
            while (i < this.managers_cow.size()) {
                DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
                DownloadManagerStats dm_stats = dm.getStats();
                HashMap<String, Object> dmMap = new HashMap<String, Object>();
                TOTorrent torrent = dm.getTorrent();
                if (torrent != null) {
                    try {
                        dmMap.put("torrent_hash", torrent.getHash());
                    }
                    catch (TOTorrentException e) {
                        Debug.printStackTrace(e);
                    }
                }
                dmMap.put("persistent", new Long(dm.isPersistent() ? 1 : 0));
                dmMap.put("torrent", dm.getTorrentFileName());
                dmMap.put("save_dir", dm.getTorrentSaveDir());
                dmMap.put("save_file", dm.getTorrentSaveFile());
                if (dm.getTorrentSaveFile() == null) {
                    dmMap.put("path", new File(dm.getTorrentSaveDir()).getAbsolutePath());
                } else {
                    dmMap.put("path", new File(dm.getTorrentSaveDir(), dm.getTorrentSaveFile()).getAbsolutePath());
                }
                dmMap.put("uploads", new Long(dm_stats.getMaxUploads()));
                dmMap.put("maxdl", new Long(dm_stats.getMaxDownloadKBSpeed()));
                dmMap.put("maxul", new Long(dm_stats.getUploadRateLimitBytesPerSecond()));
                int state = dm.getState();
                if (dm.getOnlySeeding() && !dm.isForceStart() && state != 70) {
                    state = 75;
                } else if (state == 100) {
                    state = 70;
                } else if (state != 70 && state != 75 && state != 0) {
                    state = 0;
                }
                dmMap.put("state", new Long(state));
                dmMap.put("position", new Long(dm.getPosition()));
                dmMap.put("downloaded", new Long(dm_stats.getDownloaded()));
                dmMap.put("uploaded", new Long(dm_stats.getUploaded()));
                dmMap.put("completed", new Long(dm_stats.getDownloadCompleted(true)));
                dmMap.put("discarded", new Long(dm_stats.getDiscarded()));
                dmMap.put("hashfails", new Long(dm_stats.getHashFails()));
                dmMap.put("forceStart", new Long(dm.isForceStart() && dm.getState() != 30 ? 1 : 0));
                dmMap.put("secondsDownloading", new Long(dm_stats.getSecondsDownloading()));
                dmMap.put("secondsOnlySeeding", new Long(dm_stats.getSecondsOnlySeeding()));
                dmMap.put("creationTime", new Long(dm.getCreationTime()));
                dm.saveDownload();
                List file_priorities = (List)dm.getData("file_priorities");
                if (file_priorities != null) {
                    dmMap.put("file_priorities", file_priorities);
                }
                dmMap.put("allocated", new Long(dm.isDataAlreadyAllocated() ? 1 : 0));
                list.add(dmMap);
                ++i;
            }
            map.put("downloads", list);
            try {
                this.paused_list_mon.enter();
                if (!this.paused_list.isEmpty()) {
                    ArrayList<byte[]> pause_data = new ArrayList<byte[]>();
                    int i2 = 0;
                    while (i2 < this.paused_list.size()) {
                        HashWrapper hash = (HashWrapper)this.paused_list.get(i2);
                        pause_data.add(hash.getHash());
                        ++i2;
                    }
                    map.put("pause_data", pause_data);
                }
            }
            finally {
                this.paused_list_mon.exit();
            }
            FileUtil.writeResilientConfigFile("downloads.config", map);
        }
        finally {
            this.managers_mon.exit();
        }
    }

    public TRTrackerScraper getTrackerScraper() {
        return this.trackerScraper;
    }

    public GlobalManagerStats getStats() {
        return this.stats;
    }

    public int getIndexOf(DownloadManager manager) {
        if (this.managers_cow != null && manager != null) {
            return this.managers_cow.indexOf(manager);
        }
        return -1;
    }

    public boolean isMoveableUp(DownloadManager manager) {
        if (manager.getStats().getDownloadCompleted(false) == 1000 && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return manager.getPosition() > 1;
    }

    public boolean isMoveableDown(DownloadManager manager) {
        boolean isCompleted;
        boolean bl = isCompleted = manager.getStats().getDownloadCompleted(false) == 1000;
        if (isCompleted && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        int numInGroup = 0;
        int i = 0;
        while (i < this.managers_cow.size()) {
            DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
            if (dm.getStats().getDownloadCompleted(false) == 1000 == isCompleted) {
                ++numInGroup;
            }
            ++i;
        }
        return manager.getPosition() < numInGroup;
    }

    public void moveUp(DownloadManager manager) {
        this.moveTo(manager, manager.getPosition() - 1);
    }

    public void moveDown(DownloadManager manager) {
        this.moveTo(manager, manager.getPosition() + 1);
    }

    public void moveTop(DownloadManager[] manager) {
        try {
            this.managers_mon.enter();
            int newPosition = 1;
            int i = 0;
            while (i < manager.length) {
                this.moveTo(manager[i], newPosition++);
                ++i;
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    public void moveEnd(DownloadManager[] manager) {
        try {
            this.managers_mon.enter();
            int endPosComplete = 0;
            int endPosIncomplete = 0;
            int j = 0;
            while (j < this.managers_cow.size()) {
                DownloadManager dm = (DownloadManager)this.managers_cow.get(j);
                if (dm.getStats().getDownloadCompleted(false) == 1000) {
                    ++endPosComplete;
                } else {
                    ++endPosIncomplete;
                }
                ++j;
            }
            int i = manager.length - 1;
            while (i >= 0) {
                if (manager[i].getStats().getDownloadCompleted(false) == 1000 && endPosComplete > 0) {
                    this.moveTo(manager[i], endPosComplete--);
                } else if (endPosIncomplete > 0) {
                    this.moveTo(manager[i], endPosIncomplete--);
                }
                --i;
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    public void moveTo(DownloadManager manager, int newPosition) {
        if (newPosition < 1) {
            return;
        }
        try {
            this.managers_mon.enter();
            int curPosition = manager.getPosition();
            if (newPosition > curPosition) {
                boolean curCompleted = manager.getStats().getDownloadCompleted(false) == 1000;
                int numToMove = newPosition - curPosition;
                int i = 0;
                while (i < this.managers_cow.size()) {
                    int dmPosition;
                    boolean dmCompleted;
                    DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
                    boolean bl = dmCompleted = dm.getStats().getDownloadCompleted(false) == 1000;
                    if (dmCompleted == curCompleted && (dmPosition = dm.getPosition()) > curPosition && dmPosition <= newPosition) {
                        dm.setPosition(dmPosition - 1);
                        if (--numToMove <= 0) break;
                    }
                    ++i;
                }
                manager.setPosition(newPosition);
            } else if (newPosition < curPosition && curPosition > 1) {
                boolean curCompleted = manager.getStats().getDownloadCompleted(false) == 1000;
                int numToMove = curPosition - newPosition;
                int i = 0;
                while (i < this.managers_cow.size()) {
                    DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
                    boolean dmCompleted = dm.getStats().getDownloadCompleted(false) == 1000;
                    int dmPosition = dm.getPosition();
                    if (dmCompleted == curCompleted && dmPosition >= newPosition && dmPosition < curPosition) {
                        dm.setPosition(dmPosition + 1);
                        if (--numToMove <= 0) break;
                    }
                    ++i;
                }
                manager.setPosition(newPosition);
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    public void fixUpDownloadManagerPositions() {
        try {
            this.managers_mon.enter();
            int posComplete = 1;
            int posIncomplete = 1;
            Collections.sort(this.managers_cow, new Comparator(){

                public final int compare(Object a, Object b) {
                    return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
                }
            });
            int i = 0;
            while (i < this.managers_cow.size()) {
                DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
                if (dm.getStats().getDownloadCompleted(false) == 1000) {
                    dm.setPosition(posComplete++);
                } else {
                    dm.setPosition(posIncomplete++);
                }
                ++i;
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    protected void informDestroyed() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.listeners.dispatch(4, null);
    }

    public void informDestroyInitiated() {
        this.listeners.dispatch(3, null);
    }

    public void addListener(GlobalManagerListener listener) {
        if (this.isStopping) {
            listener.destroyed();
        } else {
            this.listeners.addListener(listener);
            try {
                this.managers_mon.enter();
                int i = 0;
                while (i < this.managers_cow.size()) {
                    listener.downloadManagerAdded((DownloadManager)this.managers_cow.get(i));
                    ++i;
                }
            }
            finally {
                this.managers_mon.exit();
            }
        }
    }

    public void removeListener(GlobalManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    public void addDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener l) {
        this.removal_listeners.addListener(l);
    }

    public void removeDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener l) {
        this.removal_listeners.removeListener(l);
    }

    public int getNextIndexForCharacter(char c, int lastSelectedIndex) {
        if (c >= '0' && c <= 'z') {
            c = Character.toLowerCase(c);
            try {
                char test;
                this.managers_mon.enter();
                if (lastSelectedIndex < 0 || lastSelectedIndex >= this.managers_cow.size()) {
                    lastSelectedIndex = -1;
                }
                int i = ++lastSelectedIndex;
                while (i < this.managers_cow.size()) {
                    test = Character.toLowerCase(((DownloadManager)this.managers_cow.get(i)).getDisplayName().charAt(0));
                    if (test == c) {
                        int n = i;
                        this.managers_mon.exit();
                        return n;
                    }
                    ++i;
                }
                i = 0;
                while (i < lastSelectedIndex) {
                    test = Character.toLowerCase(((DownloadManager)this.managers_cow.get(i)).getDisplayName().charAt(0));
                    if (test == c) {
                        int n = i;
                        this.managers_mon.exit();
                        return n;
                    }
                    ++i;
                }
            }
            finally {
                this.managers_mon.exit();
            }
        }
        return -1;
    }

    public void stateChanged(DownloadManager manager, int state) {
        this.needsSaving = true;
    }

    public void downloadComplete(DownloadManager manager) {
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public class Checker
    extends AEThread {
        boolean finished;
        int loopFactor;
        private static final int waitTime = 1000;
        private int saveResumeLoopCount;

        public Checker() {
            super("Global Status Checker");
            this.finished = false;
            this.saveResumeLoopCount = 300;
            this.loopFactor = 0;
            this.setPriority(1);
        }

        private void determineSaveResumeDataInterval() {
            int saveResumeInterval = COConfigurationManager.getIntParameter("Save Resume Interval", 5);
            if (saveResumeInterval >= 1 && saveResumeInterval <= 90) {
                this.saveResumeLoopCount = saveResumeInterval * 60000 / 1000;
            }
        }

        public void runSupport() {
            while (!this.finished) {
                try {
                    ++this.loopFactor;
                    this.determineSaveResumeDataInterval();
                    try {
                        GlobalManagerImpl.this.managers_mon.enter();
                        if (this.loopFactor % this.saveResumeLoopCount == 0 || GlobalManagerImpl.this.needsSaving) {
                            GlobalManagerImpl.this.saveDownloads();
                            GlobalManagerImpl.this.needsSaving = false;
                        }
                        int i = 0;
                        while (i < GlobalManagerImpl.this.managers_cow.size()) {
                            DownloadManager manager = (DownloadManager)GlobalManagerImpl.this.managers_cow.get(i);
                            if (this.loopFactor % this.saveResumeLoopCount == 0) {
                                manager.saveResumeData();
                            }
                            if (manager.getState() == 40 && manager.isForceStart()) {
                                manager.startDownload();
                                if (manager.getState() == 50) {
                                    manager.getStats().setSavedDiscarded();
                                    manager.getStats().setSavedHashFails();
                                }
                            }
                            ++i;
                        }
                    }
                    finally {
                        GlobalManagerImpl.this.managers_mon.exit();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }

        public void stopIt() {
            this.finished = true;
        }
    }
}

