/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gudy.azureus2.core3.internat.IntegratedResourceBundle;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;

public class MessageText {
    public static final Locale LOCALE_ENGLISH = new Locale("en", "");
    public static final Locale LOCALE_DEFAULT;
    private static Locale LOCALE_CURRENT;
    private static final String BUNDLE_NAME = "org.gudy.azureus2.internat.MessagesBundle";
    private static Map pluginLocalizationPaths;
    private static ResourceBundle RESOURCE_BUNDLE;
    private static ResourceBundle DEFAULT_BUNDLE;
    static /* synthetic */ Class class$0;

    static {
        LOCALE_CURRENT = LOCALE_DEFAULT = new Locale("", "");
        pluginLocalizationPaths = new HashMap();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.gudy.azureus2.core3.internat.MessageText");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEFAULT_BUNDLE = RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, LOCALE_DEFAULT, clazz.getClassLoader());
    }

    public static boolean keyExists(String key) {
        try {
            RESOURCE_BUNDLE.getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static String getString(String key, String sDefault) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return sDefault;
        }
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static String getStringForSentence(String sentence) {
        StringTokenizer st = new StringTokenizer(sentence, " ");
        StringBuffer result = new StringBuffer(sentence.length());
        String separator = "";
        while (st.hasMoreTokens()) {
            result.append(separator);
            separator = " ";
            String word = st.nextToken();
            int length = word.length();
            int position = word.lastIndexOf(".");
            if (position == -1 || position + 1 == length) {
                result.append(word);
                continue;
            }
            String translated = MessageText.getString(word);
            if (translated.equals("!" + word + "!")) {
                result.append(word);
                continue;
            }
            result.append(translated);
        }
        return result.toString();
    }

    public static String getString(String key, String[] params) {
        String res = MessageText.getString(key);
        int i = 0;
        while (i < params.length) {
            String from_str = "%" + (i + 1);
            String to_str = params[i];
            res = MessageText.replaceStrings(res, from_str, to_str);
            ++i;
        }
        return res;
    }

    protected static String replaceStrings(String str, String f_s, String t_s) {
        int pos = 0;
        String res = "";
        while (pos < str.length()) {
            int p1 = str.indexOf(f_s, pos);
            if (p1 == -1) {
                res = String.valueOf(res) + str.substring(pos);
                break;
            }
            res = String.valueOf(res) + str.substring(pos, p1) + t_s;
            pos = p1 + f_s.length();
        }
        return res;
    }

    public static String getDefaultLocaleString(String key) {
        try {
            return DEFAULT_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static Locale getCurrentLocale() {
        return LOCALE_DEFAULT.equals(LOCALE_CURRENT) ? LOCALE_ENGLISH : LOCALE_CURRENT;
    }

    public static boolean isCurrentLocale(Locale locale) {
        return LOCALE_ENGLISH.equals(locale) ? LOCALE_CURRENT.equals(LOCALE_DEFAULT) : LOCALE_CURRENT.equals(locale);
    }

    public static Locale[] getLocales() {
        File appDir;
        String[] appBundles;
        String bundleFolder = BUNDLE_NAME.replace('.', '/');
        final String prefix = BUNDLE_NAME.substring(BUNDLE_NAME.lastIndexOf(46) + 1);
        String extension = ".properties";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.gudy.azureus2.core3.internat.MessageText");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String urlString = clazz.getClassLoader().getResource(bundleFolder.concat(".properties")).toExternalForm();
        String[] bundles = null;
        if (urlString.startsWith("jar:file:")) {
            File jar = FileUtil.getJarFileFromURL(urlString);
            if (jar != null) {
                try {
                    JarFile jarFile = new JarFile(jar);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    ArrayList<String> list = new ArrayList<String>(250);
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        if (!jarEntry.getName().startsWith(bundleFolder) || !jarEntry.getName().endsWith(".properties") || jarEntry.getName().length() >= bundleFolder.length() + ".properties".length() + 7) continue;
                        list.add(jarEntry.getName().substring(bundleFolder.length() - prefix.length()));
                    }
                    bundles = list.toArray(new String[list.size()]);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            File bundleDirectory = new File(URI.create(urlString)).getParentFile();
            bundles = bundleDirectory.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix) && name.endsWith(".properties");
                }
            });
        }
        HashSet<String> bundleSet = new HashSet<String>();
        File localDir = new File(SystemProperties.getUserPath());
        String[] localBundles = localDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(".properties");
            }
        });
        if (localBundles != null) {
            bundleSet.addAll(Arrays.asList(localBundles));
        }
        if ((appBundles = (appDir = new File(SystemProperties.getApplicationPath())).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(".properties");
            }
        })) != null) {
            bundleSet.addAll(Arrays.asList(appBundles));
        }
        bundleSet.addAll(Arrays.asList(bundles));
        ArrayList<Locale> foundLocalesList = new ArrayList<Locale>(bundleSet.size());
        foundLocalesList.add(LOCALE_ENGLISH);
        Iterator val = bundleSet.iterator();
        boolean i = false;
        while (val.hasNext()) {
            String sBundle = (String)val.next();
            if (prefix.length() + 1 >= sBundle.length() - ".properties".length()) continue;
            String locale = sBundle.substring(prefix.length() + 1, sBundle.length() - ".properties".length());
            String[] sLocalesSplit = locale.split("_", 3);
            if (sLocalesSplit.length > 0 && sLocalesSplit[0].length() == 2) {
                if (sLocalesSplit.length == 3) {
                    foundLocalesList.add(new Locale(sLocalesSplit[0], sLocalesSplit[1], sLocalesSplit[2]));
                    continue;
                }
                if (sLocalesSplit.length == 2 && sLocalesSplit[1].length() == 2) {
                    foundLocalesList.add(new Locale(sLocalesSplit[0], sLocalesSplit[1]));
                    continue;
                }
                foundLocalesList.add(new Locale(sLocalesSplit[0]));
                continue;
            }
            if (sLocalesSplit.length != 3 || sLocalesSplit[0].length() != 0 || sLocalesSplit[2].length() <= 0) continue;
            foundLocalesList.add(new Locale(sLocalesSplit[0], sLocalesSplit[1], sLocalesSplit[2]));
        }
        Locale[] foundLocales = new Locale[foundLocalesList.size()];
        foundLocalesList.toArray(foundLocales);
        try {
            Arrays.sort(foundLocales, new Comparator(){

                public final int compare(Object a, Object b) {
                    return ((Locale)a).getDisplayName((Locale)a).compareToIgnoreCase(((Locale)b).getDisplayName((Locale)b));
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return foundLocales;
    }

    public static boolean changeLocale(Locale newLocale) {
        return MessageText.changeLocale(newLocale, false);
    }

    public static boolean changeLocale(Locale newLocale, boolean force) {
        if (!LOCALE_CURRENT.equals(newLocale) || force) {
            ResourceBundle newResourceBundle;
            block13: {
                Locale.setDefault(LOCALE_DEFAULT);
                newResourceBundle = null;
                String bundleFolder = BUNDLE_NAME.replace('.', '/');
                String prefix = BUNDLE_NAME.substring(BUNDLE_NAME.lastIndexOf(46) + 1);
                String extension = ".properties";
                try {
                    File userBundleFile = new File(SystemProperties.getUserPath());
                    File appBundleFile = new File(SystemProperties.getApplicationPath());
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.gudy.azureus2.core3.internat.MessageText");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ClassLoader cl = clazz.getClassLoader();
                    String sJar = cl.getResource(String.valueOf(bundleFolder) + ".properties").toString();
                    sJar = sJar.substring(0, sJar.length() - prefix.length() - ".properties".length());
                    URL jarURL = new URL(sJar);
                    URL[] urls = new URL[]{userBundleFile.toURL(), appBundleFile.toURL(), jarURL};
                    newResourceBundle = ResourceBundle.getBundle("MessagesBundle", newLocale, new URLClassLoader(urls));
                    if (newResourceBundle != null && (newResourceBundle.getLocale().getLanguage().equals(newLocale.getLanguage()) || newResourceBundle.getLocale().getCountry().equals(""))) break block13;
                    Locale foundLocale = newResourceBundle.getLocale();
                    System.out.println("changeLocale: " + (foundLocale.toString().equals("") ? "*Default Language*" : foundLocale.getDisplayLanguage()) + " != " + newLocale.getDisplayName() + ". Searching without country..");
                    Locale localeJustLang = new Locale(newLocale.getLanguage());
                    newResourceBundle = ResourceBundle.getBundle("MessagesBundle", localeJustLang, new URLClassLoader(urls));
                    if (newResourceBundle != null && newResourceBundle.getLocale().getLanguage().equals(localeJustLang.getLanguage())) break block13;
                    System.out.println("changeLocale: Searching for language " + newLocale.getDisplayLanguage() + " in *any* country..");
                    Locale[] locales = MessageText.getLocales();
                    int i = 0;
                    while (i < locales.length) {
                        if (locales[i].getLanguage() == newLocale.getLanguage()) {
                            newResourceBundle = ResourceBundle.getBundle("MessagesBundle", locales[i], new URLClassLoader(urls));
                            break;
                        }
                        ++i;
                    }
                }
                catch (MissingResourceException e) {
                    System.out.println("changeLocale: no resource bundle for " + newLocale);
                    Debug.printStackTrace(e);
                    return false;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
            if (newResourceBundle != null) {
                if (!newLocale.toString().equals("en") && !newResourceBundle.getLocale().equals(newLocale)) {
                    String sNewLanguage = newResourceBundle.getLocale().getDisplayName();
                    if (sNewLanguage == null || sNewLanguage.trim().equals("")) {
                        sNewLanguage = "English (default)";
                    }
                    System.out.println("changeLocale: no message properties for Locale '" + newLocale.getDisplayName() + "' (" + newLocale + "), using '" + sNewLanguage + "'");
                }
                newLocale = newResourceBundle.getLocale();
                Locale.setDefault(newLocale);
                LOCALE_CURRENT = newLocale;
                RESOURCE_BUNDLE = new IntegratedResourceBundle(newResourceBundle, pluginLocalizationPaths);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean integratePluginMessages(String localizationPath, ClassLoader classLoader) {
        boolean integratedSuccessfully = false;
        if (localizationPath != null && localizationPath.length() != 0 && !pluginLocalizationPaths.containsKey(localizationPath)) {
            pluginLocalizationPaths.put(localizationPath, classLoader);
            RESOURCE_BUNDLE = new IntegratedResourceBundle(RESOURCE_BUNDLE, pluginLocalizationPaths);
            integratedSuccessfully = true;
        }
        return integratedSuccessfully;
    }
}

