/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat.update;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.config.ConfigSectionSWT;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.GenericActionPerformer;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;

public class UpdateLanguagePlugin
implements Plugin {
    private static final int STATE_UPDATEURL = 0;
    private static final int STATE_LANGUAGEURL = 1;
    protected PluginInterface plugin_interface;
    protected PluginConfig plugin_config;
    protected LoggerChannel log;

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Localised Language Updater");
        this.log = this.plugin_interface.getLogger().getChannel("UpdateLanguage");
        this.log.log(1, "UpdateLanguage Plugin Initialisation");
        this.plugin_config = this.plugin_interface.getPluginconfig();
        try {
            this.plugin_interface.addConfigSection(new ConfigSectionUpdateLang());
        }
        catch (NoClassDefFoundError e) {
            this.log.log(2, "SWT UI Config not loaded for UpdateLanguagePlugin. " + e.getMessage() + " not found.");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (this.plugin_config.getBooleanParameter("General_bEnableLanguageUpdate")) {
            try {
                this.updateLanguage();
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public float getLocaleCurrentRevision() {
        String sCurrentRevision = "0";
        BufferedReader in = null;
        try {
            try {
                File fLanguageFile = this.getCurLocaleFile();
                in = new BufferedReader(new FileReader(fLanguageFile));
                sCurrentRevision = in.readLine();
                if (sCurrentRevision.startsWith("#")) {
                    sCurrentRevision = sCurrentRevision.substring(1);
                }
            }
            catch (FileNotFoundException fLanguageFile) {
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            return Float.valueOf(sCurrentRevision).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getBundleSuffix(String sLangID) {
        if (sLangID == "en") {
            return "";
        }
        if (!sLangID.equals("")) {
            return "_" + sLangID;
        }
        return sLangID;
    }

    private void updateLanguage() {
        String sCurrentRevision = "0";
        String sUpdateURL = this.plugin_config.getStringParameter("General_sUpdateLanguageURL");
        String sLocaleID = Locale.getDefault().toString();
        if (sLocaleID == "en") {
            sLocaleID = "";
        }
        sUpdateURL = sUpdateURL.replaceAll("%s", sLocaleID);
        String sBundleSuffix = this.getBundleSuffix(sLocaleID);
        float fCurrentRevision = this.getLocaleCurrentRevision();
        ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
        try {
            ResourceDownloader rd = rdf.create(new URL(sUpdateURL));
            this.log.log(1, "Current local revision is " + fCurrentRevision + ". Starting download using " + sUpdateURL);
            try {
                this.checkRevision(rd.download(), fCurrentRevision, sBundleSuffix);
            }
            catch (ResourceDownloaderException e) {
                this.log.log(3, "Error:" + e);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void checkRevision(InputStream is, float fCurrentRevision, String sBundleSuffix) {
        if (is == null) {
            return;
        }
        this.log.log(1, "Revision info download complete");
        String sLanguageURL = null;
        float fNewestRevision = 1.0f;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader(is));
                String sLine = in.readLine();
                try {
                    fNewestRevision = Float.valueOf(sLine).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sLanguageURL = in.readLine();
            }
            catch (FileNotFoundException sLine) {
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        if (sLanguageURL == null) {
            this.log.log(2, "Could not retrieve newest language file revision number");
            return;
        }
        if (fNewestRevision > fCurrentRevision && sLanguageURL != null) {
            this.log.log(1, "Latest revision is " + fNewestRevision);
            if (this.okToGetLatest(sBundleSuffix)) {
                try {
                    ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
                    ResourceDownloader rd = rdf.create(new URL(sLanguageURL));
                    this.log.log(1, "Downloading Rev. " + fNewestRevision + " from " + sLanguageURL);
                    this.moveInNewRevision(rd.download(), fNewestRevision);
                }
                catch (Exception e) {
                    this.log.log("DLing Lang Update", e);
                    Debug.printStackTrace(e);
                }
            }
        } else {
            this.log.log(1, "You have the latest revision (" + fNewestRevision + ")");
        }
    }

    private void moveInNewRevision(InputStream is, float fNewestRevision) {
        if (is == null) {
            return;
        }
        this.log.log(1, "Language File download complete");
        FileOutputStream os = null;
        try {
            try {
                int nbRead;
                File fOutBundle = this.getCurLocaleFile();
                os = new FileOutputStream(fOutBundle);
                byte[] buf = new byte[32768];
                String s = "#" + String.valueOf(fNewestRevision) + "\n";
                ((OutputStream)os).write(s.getBytes());
                s = "# This file will get overridden unless the line above is removed\n";
                ((OutputStream)os).write(s.getBytes());
                while ((nbRead = is.read(buf)) > 0) {
                    ((OutputStream)os).write(buf, 0, nbRead);
                }
                this.log.log(1, "Written to " + fOutBundle.getAbsolutePath());
            }
            catch (FileNotFoundException fOutBundle) {
            }
            catch (Exception e) {
                this.log.log("Writing new language File", e);
                Debug.printStackTrace(e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception exception) {}
            }
        }
        MainWindow.getWindow().getMenu().refreshLanguage();
    }

    private boolean okToGetLatest(String sBundleSuffix) {
        File fLanguageFile = this.getCurLocaleFile();
        if (!fLanguageFile.exists()) {
            return true;
        }
        boolean okToProceed = true;
        String sNewLocale = sBundleSuffix.length() > 6 ? String.valueOf(sBundleSuffix) + ".%x" : (sBundleSuffix.length() == 3 ? String.valueOf(sBundleSuffix) + "__User.%x" : (sBundleSuffix.length() == 0 ? String.valueOf(sBundleSuffix) + "___User.%x" : String.valueOf(sBundleSuffix) + "_User.%x"));
        File fRenameTo = null;
        int i = 1;
        while (i < 1000) {
            fRenameTo = FileUtil.getUserFile("MessagesBundle" + sNewLocale.replaceAll("%x", String.valueOf(i)) + ".properties");
            if (!fRenameTo.exists()) break;
            ++i;
        }
        okToProceed = fRenameTo != null && !fRenameTo.exists() ? fLanguageFile.renameTo(fRenameTo) : false;
        this.log.log(okToProceed ? 1 : 3, "Renaming old MessagesBundle" + sBundleSuffix + ".properties " + (okToProceed ? "succeeded" : "failed"));
        return okToProceed;
    }

    private File getCurLocaleFile() {
        String sBundleSuffix = this.getBundleSuffix(Locale.getDefault().toString());
        return FileUtil.getUserFile("MessagesBundle" + sBundleSuffix + ".properties");
    }

    static /* synthetic */ void access$1(UpdateLanguagePlugin updateLanguagePlugin) {
        updateLanguagePlugin.updateLanguage();
    }

    class ConfigSectionUpdateLang
    implements ConfigSectionSWT {
        ConfigSectionUpdateLang() {
        }

        public String configSectionGetParentSection() {
            return "style";
        }

        public String configSectionGetName() {
            return "language";
        }

        public void configSectionSave() {
        }

        public void configSectionDelete() {
        }

        public Composite configSectionCreate(Composite parent) {
            Composite cSection = new Composite(parent, 0);
            cSection.addControlListener((ControlListener)new Utils.LabelWrapControlListener());
            GridData gridData = new GridData(272);
            cSection.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            cSection.setLayout((Layout)layout);
            Label label = new Label(cSection, 64);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.section.language.info");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter bpEnable = new BooleanParameter(cSection, "General_bEnableLanguageUpdate", "ConfigView.section.language.enableUpdate");
            bpEnable.setLayoutData(gridData);
            bpEnable.setAdditionalActionPerformer(new GenericActionPerformer(this, null, bpEnable){
                final /* synthetic */ ConfigSectionUpdateLang this$1;
                private final /* synthetic */ BooleanParameter val$bpEnable;
                {
                    this.this$1 = configSectionUpdateLang;
                    this.val$bpEnable = booleanParameter;
                    super($anonymous0);
                }

                public void performAction() {
                    File file;
                    if (!this.val$bpEnable.isSelected() && ConfigSectionUpdateLang.access$0(this.this$1).getLocaleCurrentRevision() > 0.0f && (file = UpdateLanguagePlugin.access$0(ConfigSectionUpdateLang.access$0(this.this$1))).exists()) {
                        try {
                            file.delete();
                            MainWindow.getWindow().getMenu().refreshLanguage();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            label = new Label(cSection, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.language.UpdateURL");
            gridData = new GridData(768);
            new StringParameter(cSection, "General_sUpdateLanguageURL").setLayoutData(gridData);
            Button btnUpdateNow = new Button(cSection, 8);
            Messages.setLanguageText((Widget)btnUpdateNow, "ConfigView.section.language.UpdateNow");
            btnUpdateNow.addListener(13, new Listener(this){
                final /* synthetic */ ConfigSectionUpdateLang this$1;
                {
                    this.this$1 = configSectionUpdateLang;
                }

                public void handleEvent(Event event) {
                    ((Button)event.widget).setEnabled(false);
                    UpdateLanguagePlugin.access$1(ConfigSectionUpdateLang.access$0(this.this$1));
                }
            });
            Button btnRevert = new Button(cSection, 8);
            Messages.setLanguageText((Widget)btnRevert, "Button.revert");
            btnRevert.addListener(13, new Listener(this){
                final /* synthetic */ ConfigSectionUpdateLang this$1;
                {
                    this.this$1 = configSectionUpdateLang;
                }

                public void handleEvent(Event event) {
                    File file = UpdateLanguagePlugin.access$0(ConfigSectionUpdateLang.access$0(this.this$1));
                    if (file.exists()) {
                        try {
                            file.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ((Button)event.widget).setEnabled(file.exists());
                    MainWindow.getWindow().getMenu().refreshLanguage();
                }
            });
            btnRevert.setEnabled(UpdateLanguagePlugin.this.getCurLocaleFile().exists());
            return cSection;
        }

        static /* synthetic */ UpdateLanguagePlugin access$0(ConfigSectionUpdateLang configSectionUpdateLang) {
            return configSectionUpdateLang.UpdateLanguagePlugin.this;
        }
    }
}

