/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.util.AEMonitor;

public class PEPieceImpl
implements PEPiece {
    private DiskManagerPiece dm_piece;
    private int piece_length;
    private boolean[] downloaded;
    private boolean[] requested;
    private PEPeer[] writers;
    private List writes;
    public boolean isBeingChecked = false;
    private boolean slowPiece;
    public PEPeerManager manager;
    protected static AEMonitor class_mon = new AEMonitor("PEPiece:class");

    public PEPieceImpl(PEPeerManager _manager, DiskManagerPiece _dm_piece, boolean _slow_piece, boolean _recovered) {
        this.manager = _manager;
        this.dm_piece = _dm_piece;
        this.slowPiece = _slow_piece;
        this.piece_length = this.dm_piece.getLength();
        int nbBlocs = (this.piece_length + 16384 - 1) / 16384;
        this.downloaded = new boolean[nbBlocs];
        this.requested = new boolean[nbBlocs];
        this.writers = new PEPeer[nbBlocs];
        this.writes = new ArrayList(0);
        if (!_recovered) {
            this.dm_piece.setInitialWriteTime();
        }
    }

    public int getAvailability() {
        if (this.manager == null) {
            return 0;
        }
        return this.manager.getAvailability(this.dm_piece.getPieceNumber());
    }

    public boolean[] getRequested() {
        return this.requested;
    }

    public boolean[] getDownloaded() {
        return this.downloaded;
    }

    public void setBlockWritten(int blocNumber) {
        this.downloaded[blocNumber] = true;
    }

    public void clearRequested(int blocNumber) {
        this.requested[blocNumber] = false;
    }

    public int getAndMarkBlock() {
        int nbBlocs = this.dm_piece.getBlockCount();
        int blocNumber = -1;
        int i = 0;
        while (i < nbBlocs) {
            if (!this.requested[i] && !this.dm_piece.getWritten(i)) {
                blocNumber = i;
                this.requested[i] = true;
                i = nbBlocs;
            }
            ++i;
        }
        return blocNumber;
    }

    public void unmarkBlock(int blocNumber) {
        if (!this.downloaded[blocNumber]) {
            this.requested[blocNumber] = false;
        }
    }

    public void markBlock(int blocNumber) {
        if (!this.downloaded[blocNumber]) {
            this.requested[blocNumber] = true;
        }
    }

    public int getBlockSize(int blocNumber) {
        int length;
        if (blocNumber == this.dm_piece.getBlockCount() - 1 && (length = this.piece_length) % 16384 != 0) {
            return length % 16384;
        }
        return 16384;
    }

    public int getPieceNumber() {
        return this.dm_piece.getPieceNumber();
    }

    public int getLength() {
        return this.piece_length;
    }

    public int getNbBlocs() {
        return this.dm_piece.getBlockCount();
    }

    public void setBeingChecked() {
        this.isBeingChecked = true;
    }

    public boolean isBeingChecked() {
        return this.isBeingChecked;
    }

    public void setManager(PEPeerManager _manager) {
        this.manager = _manager;
    }

    public void setWritten(PEPeer peer, int blocNumber) {
        this.writers[blocNumber] = peer;
        this.dm_piece.setWritten(blocNumber);
    }

    public List getPieceWrites() {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        return result;
    }

    public List getPieceWrites(int blockNumber) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (write.getBlockNumber() == blockNumber) continue;
            iter.remove();
        }
        return result;
    }

    public List getPieceWrites(PEPeer peer) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (peer != null && peer.equals(write.getSender())) continue;
            iter.remove();
        }
        return result;
    }

    public void reset() {
        this.dm_piece.reset();
        int nbBlocs = this.dm_piece.getBlockCount();
        this.downloaded = new boolean[nbBlocs];
        this.requested = new boolean[nbBlocs];
        this.writers = new PEPeer[nbBlocs];
        this.isBeingChecked = false;
    }

    protected void addWrite(PEPieceWriteImpl write) {
        try {
            class_mon.enter();
            this.writes.add(write);
        }
        finally {
            class_mon.exit();
        }
    }

    public void addWrite(int blockNumber, PEPeer sender, byte[] hash, boolean correct) {
        this.addWrite(new PEPieceWriteImpl(blockNumber, sender, hash, correct));
    }

    public PEPeer[] getWriters() {
        return this.writers;
    }

    public boolean isSlowPiece() {
        return this.slowPiece;
    }

    public void setSlowPiece(boolean _slowPiece) {
        this.slowPiece = _slowPiece;
    }

    public boolean[] getWritten() {
        return this.dm_piece.getWritten();
    }

    public boolean isComplete() {
        return this.dm_piece.getCompleted();
    }

    public int getCompleted() {
        return this.dm_piece.getCompleteCount();
    }

    public boolean isWritten(int bn) {
        return this.dm_piece.getWritten(bn);
    }

    public long getLastWriteTime() {
        return this.dm_piece.getLastWriteTime();
    }

    public PEPeerManager getManager() {
        return this.manager;
    }
}

