/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacket;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;

public abstract class PRUDPPacketReply
extends PRUDPPacket {
    public PRUDPPacketReply(int _action, int _tran_id) {
        super(_action, _tran_id);
    }

    public void serialise(DataOutputStream os) throws IOException {
        os.writeInt(this.type);
        os.writeInt(this.transaction_id);
    }

    public static PRUDPPacketReply deserialiseReply(DataInputStream is) throws IOException {
        int action = is.readInt();
        int transaction_id = is.readInt();
        switch (action) {
            case 0: {
                return new PRUDPPacketReplyConnect(is, transaction_id);
            }
            case 1: {
                if (PRUDPPacket.VERSION == 1) {
                    return new PRUDPPacketReplyAnnounce(is, transaction_id);
                }
                return new PRUDPPacketReplyAnnounce2(is, transaction_id);
            }
            case 2: {
                if (PRUDPPacket.VERSION == 1) {
                    return new PRUDPPacketReplyScrape(is, transaction_id);
                }
                return new PRUDPPacketReplyScrape2(is, transaction_id);
            }
            case 3: {
                return new PRUDPPacketReplyError(is, transaction_id);
            }
        }
        throw new IOException("unsupported reply type");
    }

    public String getString() {
        return super.getString().concat(":reply[trans=").concat(String.valueOf(this.transaction_id)).concat("]");
    }
}

