/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacket;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketHandler;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketHandlerException;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReply;
import org.gudy.azureus2.core3.tracker.protocol.udp.impl.PRUDPPacketHandlerRequest;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemTime;
import sun.misc.BASE64Decoder;

public class PRUDPPacketHandlerImpl
implements PRUDPPacketHandler {
    protected int port;
    protected DatagramSocket socket;
    protected long last_timeout_check;
    protected Map requests = new HashMap();
    protected AEMonitor requests_mon = new AEMonitor("PRUDPPH:req");

    protected PRUDPPacketHandlerImpl(int _port) {
        this.port = _port;
        final AESemaphore init_sem = new AESemaphore("PRUDPPacketHandler");
        AEThread t = new AEThread("PRUDPPacketReciever:".concat(String.valueOf(this.port))){

            public void runSupport() {
                PRUDPPacketHandlerImpl.this.receiveLoop(init_sem);
            }
        };
        t.setDaemon(true);
        t.start();
        init_sem.reserve();
    }

    protected void receiveLoop(AESemaphore init_sem) {
        try {
            InetSocketAddress address;
            String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "");
            if (bind_ip.length() == 0) {
                address = new InetSocketAddress("127.0.0.1", this.port);
                this.socket = new DatagramSocket(this.port);
            } else {
                address = new InetSocketAddress(InetAddress.getByName(bind_ip), this.port);
                this.socket = new DatagramSocket(address);
            }
            this.socket.setReuseAddress(true);
            this.socket.setSoTimeout(30000);
            init_sem.release();
            LGLogger.log("PRUDPPacketReceiver: receiver established on port ".concat(String.valueOf(this.port)));
            byte[] buffer = new byte[8192];
            long successful_accepts = 0L;
            long failed_accepts = 0L;
            while (true) {
                try {
                    try {
                        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address);
                        this.socket.receive(packet);
                        ++successful_accepts;
                        this.process(packet);
                        continue;
                    }
                    catch (SocketTimeoutException packet) {
                        continue;
                    }
                    catch (Throwable e) {
                        LGLogger.log("PRUDPPacketReceiver: receive failed on port " + this.port, e);
                        if (++failed_accepts <= 100L || successful_accepts != 0L) continue;
                        LGLogger.logUnrepeatableAlertUsingResource(3, "Network.alert.acceptfail", new String[]{"" + this.port, "UDP"});
                        this.checkTimeouts();
                    }
                }
                finally {
                    this.checkTimeouts();
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            LGLogger.logUnrepeatableAlertUsingResource(3, "Tracker.alert.listenfail", new String[]{"UDP:" + this.port});
            LGLogger.log("PRUDPPacketReceiver: DatagramSocket bind failed on port ".concat(String.valueOf(this.port)), e);
        }
    }

    protected void checkTimeouts() {
        long now = SystemTime.getCurrentTime();
        if (SystemTime.isErrorLast30sec() || now - this.last_timeout_check >= 30000L) {
            this.last_timeout_check = now;
            try {
                this.requests_mon.enter();
                Iterator it = this.requests.values().iterator();
                while (it.hasNext()) {
                    PRUDPPacketHandlerRequest request2 = (PRUDPPacketHandlerRequest)it.next();
                    if (now - request2.getCreateTime() < 30000L) continue;
                    LGLogger.log(3, "PRUDPPacketHandler: request timeout");
                    request2.setException(new PRUDPPacketHandlerException("timed out"));
                }
            }
            finally {
                this.requests_mon.exit();
            }
        }
    }

    protected void process(DatagramPacket packet) throws IOException {
        byte[] packet_data = packet.getData();
        PRUDPPacketReply reply = PRUDPPacketReply.deserialiseReply(new DataInputStream(new ByteArrayInputStream(packet_data, 0, packet.getLength())));
        LGLogger.log("PRUDPPacketHandler: reply packet received: ".concat(((PRUDPPacket)reply).getString()));
        try {
            this.requests_mon.enter();
            PRUDPPacketHandlerRequest request2 = (PRUDPPacketHandlerRequest)this.requests.get(new Integer(reply.getTransactionId()));
            if (request2 == null) {
                LGLogger.log(3, "PRUDPPacketReceiver: unmatched reply received, discarding:".concat(((PRUDPPacket)reply).getString()));
            } else {
                request2.setReply(reply);
            }
        }
        finally {
            this.requests_mon.exit();
        }
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(baos);
            request_packet.serialise(os);
            byte[] buffer = baos.toByteArray();
            if (auth != null) {
                SHA1Hasher hasher = new SHA1Hasher();
                String user_name = auth.getUserName();
                String password = new String(auth.getPassword());
                byte[] sha1_password = user_name.equals("<internal>") ? new BASE64Decoder().decodeBuffer(password) : hasher.calculateHash(password.getBytes());
                byte[] user_bytes = new byte[8];
                Arrays.fill(user_bytes, (byte)0);
                int i = 0;
                while (i < user_bytes.length && i < user_name.length()) {
                    user_bytes[i] = (byte)user_name.charAt(i);
                    ++i;
                }
                hasher = new SHA1Hasher();
                hasher.update(buffer);
                hasher.update(user_bytes);
                hasher.update(sha1_password);
                byte[] overall_hash = hasher.getDigest();
                baos.write(user_bytes);
                baos.write(overall_hash, 0, 8);
                buffer = baos.toByteArray();
            }
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, destination_address);
            PRUDPPacketHandlerRequest request2 = new PRUDPPacketHandlerRequest();
            try {
                this.requests_mon.enter();
                this.requests.put(new Integer(request_packet.getTransactionId()), request2);
            }
            finally {
                this.requests_mon.exit();
            }
            LGLogger.log("PRUDPPacketHandler: request packet sent: ".concat(request_packet.getString()));
            try {
                this.socket.send(packet);
                PRUDPPacket pRUDPPacket = request2.getReply();
                try {
                    this.requests_mon.enter();
                    this.requests.remove(new Integer(request_packet.getTransactionId()));
                }
                finally {
                    this.requests_mon.exit();
                }
            }
            catch (Throwable throwable) {
                try {
                    this.requests_mon.enter();
                    this.requests.remove(new Integer(request_packet.getTransactionId()));
                }
                finally {
                    this.requests_mon.exit();
                }
                throw throwable;
            }
        }
        catch (PRUDPPacketHandlerException e) {
            throw e;
        }
        catch (Throwable e) {
            LGLogger.log("PRUDPPacketHandler: sendAndReceive failed", e);
            throw new PRUDPPacketHandlerException("PRUDPPacketHandler:sendAndReceive failed", e);
        }
    }
}

