/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.ThreadPoolTask;

public abstract class TRTrackerServerProcessor
extends ThreadPoolTask {
    protected TRTrackerServerImpl server;

    protected TRTrackerServerTorrentImpl processTrackerRequest(TRTrackerServerImpl _server, Map[] root_out, TRTrackerServerPeerImpl[] peer_out, int request_type, byte[] hash, HashWrapper peer_id, boolean no_peer_id, boolean compact, String key, String event, int port, String client_ip_address, long downloaded, long uploaded, long left, int num_want) throws Exception {
        this.server = _server;
        client_ip_address = TRTrackerUtils.adjustHostFromHosting(client_ip_address);
        boolean loopback = client_ip_address.equals(TRTrackerUtils.getTrackerIP());
        TRTrackerServerTorrentImpl torrent = null;
        if (request_type != 3) {
            if (hash == null) {
                throw new Exception("Hash missing from request ");
            }
            torrent = this.server.getTorrent(hash);
            if (torrent == null) {
                if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable", false)) {
                    throw new Exception("Torrent unauthorised ");
                }
                try {
                    this.server.permit(hash, false);
                    torrent = this.server.getTorrent(hash);
                }
                catch (Throwable e) {
                    throw new Exception("Torrent unauthorised ");
                }
            }
            if (request_type == 1) {
                if (peer_id == null) {
                    throw new Exception("peer_id missing from request");
                }
                long interval = this.server.getAnnounceRetryInterval(torrent);
                TRTrackerServerPeerImpl peer = torrent.peerContact(event, peer_id, port, client_ip_address, loopback, key, uploaded, downloaded, left, interval);
                boolean stopped = event != null && event.equalsIgnoreCase("stopped");
                root_out[0] = torrent.exportAnnounceToMap(peer, left > 0L, stopped ? 0 : num_want, interval, no_peer_id, compact);
                peer_out[0] = peer;
            } else {
                HashMap<String, ByteEncodedKeyHashMap> root;
                ByteEncodedKeyHashMap files = new ByteEncodedKeyHashMap();
                boolean local_scrape = client_ip_address.equals("127.0.0.1");
                Map hash_entry = torrent.exportScrapeToMap(!local_scrape);
                byte[] torrent_hash = torrent.getHash().getHash();
                String str_hash = new String(torrent_hash, "ISO-8859-1");
                files.put(str_hash, hash_entry);
                root_out[0] = root = new HashMap<String, ByteEncodedKeyHashMap>();
                this.addScrapeInterval(torrent, root);
                root.put("files", files);
            }
        } else {
            HashMap<String, ByteEncodedKeyHashMap> root;
            ByteEncodedKeyHashMap files = new ByteEncodedKeyHashMap();
            TRTrackerServerTorrentImpl[] torrents = this.server.getTorrents();
            int i = 0;
            while (i < torrents.length) {
                TRTrackerServerTorrentImpl this_torrent = torrents[i];
                byte[] torrent_hash = this_torrent.getHash().getHash();
                String str_hash = new String(torrent_hash, "ISO-8859-1");
                Map hash_entry = this_torrent.exportScrapeToMap(true);
                files.put(str_hash, hash_entry);
                ++i;
            }
            root_out[0] = root = new HashMap<String, ByteEncodedKeyHashMap>();
            this.addScrapeInterval(null, root);
            root.put("files", files);
        }
        return torrent;
    }

    protected void addScrapeInterval(TRTrackerServerTorrentImpl torrent, Map root) {
        long interval = this.server.getScrapeRetryInterval(torrent);
        if (interval > 0L) {
            HashMap<String, Long> flags = new HashMap<String, Long>();
            flags.put("min_request_interval", new Long(interval));
            root.put("flags", flags);
        }
    }
}

