/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerProcessorUDP;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ThreadPool;

public class TRTrackerServerUDP
extends TRTrackerServerImpl {
    protected static final int THREAD_POOL_SIZE = 10;
    protected ThreadPool thread_pool;
    protected int port;

    public TRTrackerServerUDP(String _name, int _port) {
        super(_name);
        this.port = _port;
        this.thread_pool = new ThreadPool("TrackerServer:UDP:" + this.port, 10);
        try {
            DatagramSocket socket;
            InetSocketAddress address;
            String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "");
            if (bind_ip.length() == 0) {
                address = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), this.port);
                socket = new DatagramSocket(this.port);
            } else {
                address = new InetSocketAddress(InetAddress.getByName(bind_ip), this.port);
                socket = new DatagramSocket(address);
            }
            socket.setReuseAddress(true);
            final DatagramSocket f_socket = socket;
            final InetSocketAddress f_address = address;
            AEThread recv_thread = new AEThread("TRTrackerServerUDP:recv.loop"){

                public void runSupport() {
                    TRTrackerServerUDP.this.recvLoop(f_socket, f_address);
                }
            };
            recv_thread.setDaemon(true);
            recv_thread.start();
            LGLogger.log("TRTrackerServerUDP: recv established on port " + this.port);
        }
        catch (Throwable e) {
            LGLogger.log("TRTrackerServerUDP: DatagramSocket bind failed on port " + this.port, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void recvLoop(DatagramSocket socket, InetSocketAddress address) {
        long successfull_accepts = 0L;
        long failed_accepts = 0L;
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[8192];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length, address);
                    socket.receive(packet);
                    ++successfull_accepts;
                    String ip = packet.getAddress().getHostAddress();
                    if (this.ip_filter.isInRange(ip, "Tracker")) continue;
                    this.thread_pool.run(new TRTrackerServerProcessorUDP(this, socket, packet));
                }
            }
            catch (Throwable e) {
                LGLogger.log("TRTrackerServer: receive failed on port " + this.port, e);
                if (++failed_accepts <= 100L || successfull_accepts != 0L) continue;
                LGLogger.logUnrepeatableAlertUsingResource(3, "Network.alert.acceptfail", new String[]{"" + this.port, "UDP"});
                return;
            }
            break;
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return COConfigurationManager.getStringParameter("Tracker IP", "");
    }

    public boolean isSSL() {
        return false;
    }

    public void addRequestListener(TRTrackerServerRequestListener l) {
    }

    public void removeRequestListener(TRTrackerServerRequestListener l) {
    }
}

