/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequest;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequestListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.ThreadPool;

public class ConcurrentHasher {
    protected static ConcurrentHasher singleton = new ConcurrentHasher();
    protected int processor_num;
    protected List requests = new LinkedList();
    protected List hashers = new ArrayList();
    protected AESemaphore request_sem = new AESemaphore("ConcHashReqQ");
    protected AESemaphore scheduler_sem = new AESemaphore("ConcHashSched");
    protected AEMonitor requests_mon = new AEMonitor("ConcurrentHasher:R");
    private static boolean friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");

    static {
        COConfigurationManager.addParameterListener("diskmanager.friendly.hashchecking", new ParameterListener(){

            public void parameterChanged(String str) {
                friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");
            }
        });
    }

    public static ConcurrentHasher getSingleton() {
        return singleton;
    }

    public static boolean concurrentHashingAvailable() {
        return ConcurrentHasher.getSingleton().processor_num > 1;
    }

    protected ConcurrentHasher() {
        this.processor_num = Runtime.getRuntime().availableProcessors();
        if (this.processor_num <= 0) {
            this.processor_num = 1;
        }
        int i = 0;
        while (i < this.processor_num + 1) {
            this.scheduler_sem.release();
            ++i;
        }
        final ThreadPool pool = new ThreadPool("ConcurrentHasher", 64);
        AEThread scheduler = new AEThread("CuncurrentHasher:scheduler"){

            public void runSupport() {
                while (true) {
                    SHA1Hasher hasher;
                    ConcurrentHasherRequest req;
                    ConcurrentHasher.this.request_sem.reserve();
                    try {
                        ConcurrentHasher.this.requests_mon.enter();
                        req = (ConcurrentHasherRequest)ConcurrentHasher.this.requests.remove(0);
                        hasher = ConcurrentHasher.this.hashers.size() == 0 ? new SHA1Hasher() : (SHA1Hasher)ConcurrentHasher.this.hashers.remove(ConcurrentHasher.this.hashers.size() - 1);
                    }
                    finally {
                        ConcurrentHasher.this.requests_mon.exit();
                    }
                    pool.run(new AERunnable(this, hasher, req){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ SHA1Hasher val$hasher;
                        private final /* synthetic */ ConcurrentHasherRequest val$req;
                        {
                            this.this$1 = var1_1;
                            this.val$hasher = sHA1Hasher;
                            this.val$req = concurrentHasherRequest;
                        }

                        public void runSupport() {
                            try {
                                this.val$req.run(this.val$hasher);
                            }
                            finally {
                                try {
                                    2.access$0(this.this$1).requests_mon.enter();
                                    2.access$0(this.this$1).hashers.add(this.val$hasher);
                                }
                                finally {
                                    2.access$0(this.this$1).requests_mon.exit();
                                }
                                if (ConcurrentHasher.access$1()) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                                2.access$0(this.this$1).scheduler_sem.release();
                            }
                        }
                    });
                }
            }

            static /* synthetic */ ConcurrentHasher access$0(2 var0) {
                return var0.ConcurrentHasher.this;
            }
        };
        scheduler.setDaemon(true);
        scheduler.start();
    }

    public ConcurrentHasherRequest addRequest(ByteBuffer buffer) {
        return this.addRequest(buffer, null);
    }

    public ConcurrentHasherRequest addRequest(ByteBuffer buffer, ConcurrentHasherRequestListener listener) {
        ConcurrentHasherRequest req = new ConcurrentHasherRequest(this, buffer, listener);
        this.scheduler_sem.reserve();
        try {
            this.requests_mon.enter();
            this.requests.add(req);
        }
        finally {
            this.requests_mon.exit();
        }
        this.request_sem.release();
        return req;
    }

    public static void main(String[] args) {
    }

    static /* synthetic */ boolean access$1() {
        return friendly_hashing;
    }
}

