/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.SHA1;

public final class SHA1Hasher {
    private final SHA1 sha1 = new SHA1();

    public byte[] calculateHash(byte[] bytes) {
        ByteBuffer buff = ByteBuffer.wrap(bytes);
        return this.calculateHash(buff);
    }

    public byte[] calculateHash(ByteBuffer buffer) {
        this.sha1.reset();
        return this.sha1.digest(buffer);
    }

    public void update(byte[] data) {
        this.update(ByteBuffer.wrap(data));
    }

    public void update(byte[] data, int pos, int len) {
        this.update(ByteBuffer.wrap(data, pos, len));
    }

    public void update(ByteBuffer buffer) {
        this.sha1.update(buffer);
    }

    public byte[] getDigest() {
        return this.sha1.digest();
    }

    public void reset() {
        this.sha1.reset();
    }

    public void saveHashState() {
        this.sha1.saveState();
    }

    public void restoreHashState() {
        this.sha1.restoreState();
    }
}

