/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreListener;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.pluginsimpl.PluginUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.PluginManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;
import org.gudy.azureus2.update.UpdaterUpdateChecker;

public class PluginInitializer
implements GlobalManagerListener {
    private String[][] builtin_plugins = new String[][]{{"Start/Stop Rules", "com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin", "<internal>", ""}, {"Torrent Removal Rules", "com.aelitis.azureus.plugins.removerules.DownloadRemoveRulesPlugin", "<internal>", ""}, {"Share Hoster", "com.aelitis.azureus.plugins.sharing.hoster.ShareHosterPlugin", "<internal>", "ShareHoster"}, {"Default Tracker Web", "org.gudy.azureus2.ui.tracker.TrackerDefaultWeb", "<internal>", "TrackerDefault"}, {"Plugin Update Checker", "org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin", "<internal>", "PluginUpdate"}, {"Core Update Checker", "org.gudy.azureus2.update.CoreUpdateChecker", "<internal>", "CoreUpdater"}, {"Core Patch Checker", "org.gudy.azureus2.update.CorePatchChecker", "<internal>", "CorePatcher"}, {"Platform Checker", "org.gudy.azureus2.platform.win32.PlatformManagerUpdateChecker", "azplatform2", "azplatform2"}, {"UPnP", "com.aelitis.azureus.plugins.upnp.UPnPPlugin", "<internal>", "UPnP"}};
    private static String[][] default_version_details = new String[][]{{"org.gudy.azureus2.ui.webplugin.remoteui.servlet.RemoteUIServlet", "webui", "Swing Web Interface", "1.2.3"}, {"org.ludo.plugins.azureus.AzureusIpFilterExporter", "safepeer", "SafePeer", "1.2.4"}, {"org.gudy.azureus2.countrylocator.Plugin", "CountryLocator", "Country Locator", "1.0"}, {"org.gudy.azureus2.ui.webplugin.remoteui.xml.server.XMLHTTPServerPlugin", "xml_http_if", "XML over HTTP", "1.0"}, {"org.cneclipse.bdcc.BDCCPlugin", "bdcc", "BitTorrent IRC Bot", "2.1"}, {"org.cneclipse.multiport.MultiPortPlugin", "multi-ports", "Mutli-Port Trackers", "1.0"}, {"i18nPlugin.i18nPlugin", "i18nAZ", "i18nAZ", "1.0"}, {"info.baeker.markus.plugins.azureus.RSSImport", "RSSImport", "RSS Importer", "1.0"}};
    private static PluginInitializer singleton;
    private static AEMonitor class_mon;
    private static List registration_queue;
    private AzureusCoreListener listener;
    private AzureusCore azureus_core;
    private PluginInterfaceImpl default_plugin;
    private PluginManager plugin_manager;
    private List plugins = new ArrayList();
    private List plugin_interfaces = new ArrayList();
    private boolean initialisation_complete;

    static {
        class_mon = new AEMonitor("PluginInitializer");
        registration_queue = new ArrayList();
    }

    public static PluginInitializer getSingleton(AzureusCore azureus_core, AzureusCoreListener listener) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new PluginInitializer(azureus_core, listener);
                int i = 0;
                while (i < registration_queue.size()) {
                    try {
                        Object entry2 = registration_queue.get(i);
                        if (entry2 instanceof Class) {
                            Class cla = (Class)entry2;
                            singleton.initializePluginFromClass(cla, "<internal>", cla.getName());
                        } else {
                            Object[] x = (Object[])entry2;
                            Plugin plugin = (Plugin)x[0];
                            singleton.initializePluginFromInstance(plugin, (String)x[1], plugin.getClass().getName());
                        }
                    }
                    catch (PluginException pluginException) {
                        // empty catch block
                    }
                    ++i;
                }
                registration_queue.clear();
            }
            PluginInitializer pluginInitializer = singleton;
            class_mon.exit();
            return pluginInitializer;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected static void queueRegistration(Class _class) {
        try {
            class_mon.enter();
            if (singleton == null) {
                registration_queue.add(_class);
            } else {
                try {
                    singleton.initializePluginFromClass(_class, "<internal>", _class.getName());
                }
                catch (PluginException e) {}
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected static void queueRegistration(Plugin plugin, String id) {
        try {
            class_mon.enter();
            if (singleton == null) {
                registration_queue.add(new Object[]{plugin, id});
            } else {
                try {
                    singleton.initializePluginFromInstance(plugin, id, plugin.getClass().getName());
                }
                catch (PluginException e) {}
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected PluginInitializer(AzureusCore _azureus_core, AzureusCoreListener _listener) {
        this.azureus_core = _azureus_core;
        this.azureus_core.getGlobalManager().addListener(this);
        this.listener = _listener;
        UpdateManagerImpl.getSingleton(this.azureus_core);
        this.plugin_manager = PluginManagerImpl.getSingleton(this);
        UpdaterUpdateChecker.checkPlugin();
    }

    public void initializePlugins(AzureusCore core) {
        PluginManagerImpl.setStartDetails(core);
        File user_dir = FileUtil.getUserFile("plugins");
        File app_dir = FileUtil.getApplicationFile("plugins");
        int user_plugins = 0;
        int app_plugins = 0;
        if (user_dir.exists() && user_dir.isDirectory()) {
            user_plugins = user_dir.listFiles().length;
        }
        if (app_dir.exists() && app_dir.isDirectory()) {
            app_plugins = app_dir.listFiles().length;
        }
        this.initializePluginsFromDir(user_dir, 0, user_plugins + app_plugins);
        if (!user_dir.equals(app_dir)) {
            this.initializePluginsFromDir(app_dir, user_plugins, user_plugins + app_plugins);
        }
        LGLogger.checkRedirection();
        LGLogger.log("Initializing built-in plugins");
        PluginManagerDefaults def = PluginManager.getDefaults();
        int i = 0;
        while (i < this.builtin_plugins.length) {
            if (def.isDefaultPluginEnabled(this.builtin_plugins[i][0])) {
                String id = this.builtin_plugins[i][2];
                String key = this.builtin_plugins[i][3];
                try {
                    Class<?> cla = this.getClass().getClassLoader().loadClass(this.builtin_plugins[i][1]);
                    this.initializePluginFromClass(cla, id, key);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    LGLogger.logUnrepeatableAlert("Initialisation of built in plugin '" + key + "' fails", e);
                }
            } else {
                LGLogger.log("Built-in plugin '" + this.builtin_plugins[i][0] + "' is disabled");
            }
            ++i;
        }
    }

    private void initializePluginsFromDir(File pluginDirectory, int plugin_offset, int plugin_total) {
        LGLogger.log("Plugin Directory is " + pluginDirectory);
        if (!pluginDirectory.exists()) {
            pluginDirectory.mkdirs();
        }
        if (pluginDirectory.isDirectory()) {
            File[] pluginsDirectory = pluginDirectory.listFiles();
            int i = 0;
            while (i < pluginsDirectory.length) {
                if (pluginsDirectory[i].getName().equals("CVS")) {
                    LGLogger.log("Skipping plugin " + pluginsDirectory[i].getName());
                } else {
                    LGLogger.log("Initializing plugin " + pluginsDirectory[i].getName());
                    if (this.listener != null) {
                        this.listener.reportCurrentTask(String.valueOf(MessageText.getString("splash.plugin")) + pluginsDirectory[i].getName());
                    }
                    try {
                        this.initializePluginFromDir(pluginsDirectory[i]);
                    }
                    catch (PluginException pluginException) {
                        // empty catch block
                    }
                    if (this.listener != null) {
                        this.listener.reportPercent(100 * (i + plugin_offset) / plugin_total);
                    }
                }
                ++i;
            }
        }
    }

    private void initializePluginFromDir(File directory) throws PluginException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!directory.isDirectory()) {
            return;
        }
        String pluginName = directory.getName();
        File[] pluginContents = directory.listFiles();
        if (pluginContents.length <= 0) {
            return;
        }
        String[] plugin_version = new String[1];
        String[] plugin_id = new String[1];
        pluginContents = this.getHighestJarVersions(pluginContents, plugin_version, plugin_id);
        int i = 0;
        while (i < pluginContents.length) {
            String name;
            File jar_file = pluginContents[i];
            if (pluginContents.length > 1 && (name = jar_file.getName()).startsWith("i18nPlugin_")) {
                LGLogger.log("renaming '" + name + "' to conform with versioning system");
                jar_file.renameTo(new File(jar_file.getParent(), "i18nAZ_0.1.jar  "));
            } else {
                classLoader = this.addFileToClassPath(classLoader, jar_file);
            }
            ++i;
        }
        String plugin_class_string = null;
        try {
            int p1;
            String plugin_name_string;
            Properties props;
            PluginException last_load_failure;
            block40: {
                last_load_failure = null;
                props = new Properties();
                File properties_file = new File(String.valueOf(directory.toString()) + File.separator + "plugin.properties");
                try {
                    if (properties_file.exists()) {
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(properties_file);
                            props.load(fis);
                            break block40;
                        }
                        finally {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                    }
                    if (classLoader instanceof URLClassLoader) {
                        URLClassLoader current = (URLClassLoader)classLoader;
                        URL url = current.findResource("plugin.properties");
                        if (url != null) {
                            props.load(url.openStream());
                            break block40;
                        }
                        throw new Exception("failed to load plugin.properties from jars");
                    }
                    throw new Exception("failed to load plugin.properties from dir or jars");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    String msg = "Can't read 'plugin.properties' for plugin '" + pluginName + "': file may be missing";
                    LGLogger.logUnrepeatableAlert(3, msg);
                    System.out.println(msg);
                    throw new PluginException(msg, e);
                }
            }
            plugin_class_string = (String)props.get("plugin.class");
            if (plugin_class_string == null) {
                plugin_class_string = (String)props.get("plugin.classes");
            }
            if ((plugin_name_string = (String)props.get("plugin.name")) == null) {
                plugin_name_string = (String)props.get("plugin.names");
            }
            int pos1 = 0;
            int pos2 = 0;
            do {
                String plugin_class;
                if ((p1 = plugin_class_string.indexOf(";", pos1)) == -1) {
                    plugin_class = plugin_class_string.substring(pos1).trim();
                } else {
                    plugin_class = plugin_class_string.substring(pos1, p1).trim();
                    pos1 = p1 + 1;
                }
                PluginInterfaceImpl existing_pi = this.getPluginFromClass(plugin_class);
                if (existing_pi != null) {
                    File this_parent = directory.getParentFile();
                    File existing_parent = null;
                    if (existing_pi.getInitializerKey() instanceof File) {
                        existing_parent = ((File)existing_pi.getInitializerKey()).getParentFile();
                    }
                    if (this_parent.equals(FileUtil.getApplicationFile("plugins")) && existing_parent != null && existing_parent.equals(FileUtil.getUserFile("plugins"))) continue;
                    LGLogger.logUnrepeatableAlert(1, "plugin class '" + plugin_class + "' is already loaded");
                    continue;
                }
                String plugin_name = null;
                if (plugin_name_string != null) {
                    int p2 = plugin_name_string.indexOf(";", pos2);
                    if (p2 == -1) {
                        plugin_name = plugin_name_string.substring(pos2).trim();
                    } else {
                        plugin_name = plugin_name_string.substring(pos2, p2).trim();
                        pos2 = p2 + 1;
                    }
                }
                Properties new_props = (Properties)props.clone();
                int j = 0;
                while (j < default_version_details.length) {
                    if (plugin_class.equals(default_version_details[j][0])) {
                        if (new_props.get("plugin.id") == null) {
                            new_props.put("plugin.id", default_version_details[j][1]);
                        }
                        if (plugin_name == null) {
                            plugin_name = default_version_details[j][2];
                        }
                        if (new_props.get("plugin.version") == null) {
                            if (plugin_version[0] != null) {
                                new_props.put("plugin.version", plugin_version[0]);
                            } else {
                                new_props.put("plugin.version", default_version_details[j][3]);
                            }
                        }
                    }
                    ++j;
                }
                new_props.put("plugin.class", plugin_class);
                if (plugin_name != null) {
                    new_props.put("plugin.name", plugin_name);
                }
                Plugin plugin = null;
                Throwable load_failure = null;
                try {
                    Class<?> c = classLoader.loadClass(plugin_class);
                    plugin = (Plugin)c.newInstance();
                }
                catch (Throwable e) {
                    load_failure = e;
                    plugin = new loadFailedPlugin();
                }
                MessageText.integratePluginMessages((String)props.get("plugin.langfile"), classLoader);
                PluginInterfaceImpl plugin_interface = new PluginInterfaceImpl(plugin, this, directory, classLoader, directory.getName(), new_props, directory.getAbsolutePath(), plugin_id[0] == null ? directory.getName() : plugin_id[0], plugin_version[0]);
                try {
                    plugin.initialize(plugin_interface);
                }
                catch (Throwable e) {
                    load_failure = e;
                }
                plugin_interface.setOperational(load_failure == null);
                this.plugins.add(plugin);
                this.plugin_interfaces.add(plugin_interface);
                if (load_failure == null) continue;
                Debug.printStackTrace(load_failure);
                String msg = "Error loading plugin '" + pluginName + "' / '" + plugin_class_string + "'";
                LGLogger.logUnrepeatableAlert(msg, load_failure);
                System.out.println(String.valueOf(msg) + " : " + load_failure);
                last_load_failure = new PluginException(msg, load_failure);
            } while (p1 != -1);
            if (last_load_failure != null) {
                throw last_load_failure;
            }
        }
        catch (Throwable e) {
            if (e instanceof PluginException) {
                throw (PluginException)e;
            }
            Debug.printStackTrace(e);
            String msg = "Error loading plugin '" + pluginName + "' / '" + plugin_class_string + "'";
            LGLogger.logUnrepeatableAlert(msg, e);
            System.out.println(String.valueOf(msg) + " : " + e);
            throw new PluginException(msg, e);
        }
    }

    private ClassLoader addFileToClassPath(ClassLoader classLoader, File f) {
        if (f.exists() && !f.isDirectory() && f.getName().endsWith(".jar")) {
            try {
                if (classLoader instanceof URLClassLoader) {
                    URL[] old = ((URLClassLoader)classLoader).getURLs();
                    URL[] new_urls = new URL[old.length + 1];
                    System.arraycopy(old, 0, new_urls, 0, old.length);
                    new_urls[new_urls.length - 1] = f.toURL();
                    classLoader = new URLClassLoader(new_urls, classLoader == this.getClass().getClassLoader() ? classLoader : classLoader.getParent());
                } else {
                    classLoader = new URLClassLoader(new URL[]{f.toURL()}, classLoader);
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        return classLoader;
    }

    protected void initializePluginFromClass(Class plugin_class, String plugin_id, String plugin_config_key) throws PluginException {
        if (this.getPluginFromClass(plugin_class) != null) {
            LGLogger.logUnrepeatableAlert(1, "plugin class '" + plugin_class.getName() + "' is already loaded");
            return;
        }
        if (this.listener != null) {
            String plugin_name = plugin_class.getName();
            int pos = plugin_name.lastIndexOf(".");
            if (pos != -1) {
                plugin_name = plugin_name.substring(pos + 1);
            }
            this.listener.reportCurrentTask(String.valueOf(MessageText.getString("splash.plugin")) + plugin_name);
        }
        try {
            Plugin plugin = (Plugin)plugin_class.newInstance();
            PluginInterfaceImpl plugin_interface = new PluginInterfaceImpl(plugin, this, plugin_class, plugin_class.getClassLoader(), plugin_config_key, new Properties(), "", plugin_id, null);
            plugin.initialize(plugin_interface);
            this.plugins.add(plugin);
            this.plugin_interfaces.add(plugin_interface);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            String msg = "Error loading internal plugin '" + plugin_class.getName() + "'";
            LGLogger.logUnrepeatableAlert(msg, e);
            System.out.println(String.valueOf(msg) + " : " + e);
            throw new PluginException(msg, e);
        }
    }

    protected void initializePluginFromInstance(Plugin plugin, String plugin_id, String plugin_config_key) throws PluginException {
        try {
            PluginInterfaceImpl plugin_interface = new PluginInterfaceImpl(plugin, this, plugin.getClass(), plugin.getClass().getClassLoader(), plugin_config_key, new Properties(), "", plugin_id, null);
            plugin.initialize(plugin_interface);
            this.plugins.add(plugin);
            this.plugin_interfaces.add(plugin_interface);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            String msg = "Error loading internal plugin '" + plugin.getClass().getName() + "'";
            LGLogger.logUnrepeatableAlert(msg, e);
            System.out.println(String.valueOf(msg) + " : " + e);
            throw new PluginException(msg, e);
        }
    }

    protected void unloadPlugin(PluginInterfaceImpl pi) {
        this.plugins.remove(pi.getPlugin());
        this.plugin_interfaces.remove(pi);
    }

    protected void reloadPlugin(PluginInterfaceImpl pi) throws PluginException {
        this.unloadPlugin(pi);
        Object key = pi.getInitializerKey();
        String config_key = pi.getPluginConfigKey();
        if (key instanceof File) {
            this.initializePluginFromDir((File)key);
        } else {
            this.initializePluginFromClass((Class)key, pi.getPluginID(), config_key);
        }
    }

    protected AzureusCore getAzureusCore() {
        return this.azureus_core;
    }

    protected GlobalManager getGlobalManager() {
        return this.azureus_core.getGlobalManager();
    }

    public static PluginInterface getDefaultInterface() {
        return singleton.getDefaultInterfaceSupport();
    }

    protected PluginInterface getDefaultInterfaceSupport() {
        if (this.default_plugin == null) {
            this.default_plugin = new PluginInterfaceImpl(null, this, this.getClass(), this.getClass().getClassLoader(), "default", new Properties(), null, "<internal>", null);
        }
        return this.default_plugin;
    }

    public void downloadManagerAdded(DownloadManager dm) {
    }

    public void downloadManagerRemoved(DownloadManager dm) {
    }

    public void destroyInitiated() {
        int i = 0;
        while (i < this.plugin_interfaces.size()) {
            ((PluginInterfaceImpl)this.plugin_interfaces.get(i)).closedownInitiated();
            ++i;
        }
        if (this.default_plugin != null) {
            this.default_plugin.closedownInitiated();
        }
    }

    public void destroyed() {
        int i = 0;
        while (i < this.plugin_interfaces.size()) {
            ((PluginInterfaceImpl)this.plugin_interfaces.get(i)).closedownComplete();
            ++i;
        }
        if (this.default_plugin != null) {
            this.default_plugin.closedownComplete();
        }
    }

    protected void fireEventSupport(final int type) {
        PluginEvent ev = new PluginEvent(){

            public int getType() {
                return type;
            }
        };
        int i = 0;
        while (i < this.plugin_interfaces.size()) {
            ((PluginInterfaceImpl)this.plugin_interfaces.get(i)).fireEvent(ev);
            ++i;
        }
    }

    public static void fireEvent(int type) {
        singleton.fireEventSupport(type);
    }

    protected void initialisationCompleteSupport() {
        this.initialisation_complete = true;
        int i = 0;
        while (i < this.plugin_interfaces.size()) {
            ((PluginInterfaceImpl)this.plugin_interfaces.get(i)).initialisationComplete();
            ++i;
        }
        if (this.default_plugin != null) {
            this.default_plugin.initialisationComplete();
        }
    }

    protected boolean isInitialisationComplete() {
        return this.initialisation_complete;
    }

    public static void initialisationComplete() {
        singleton.initialisationCompleteSupport();
    }

    public static List getPluginInterfaces() {
        return singleton.getPluginInterfacesSupport();
    }

    protected List getPluginInterfacesSupport() {
        return this.plugin_interfaces;
    }

    protected PluginInterface[] getPlugins() {
        List pis = this.getPluginInterfacesSupport();
        PluginInterface[] res = new PluginInterface[pis.size()];
        pis.toArray(res);
        return res;
    }

    protected PluginManager getPluginManager() {
        return this.plugin_manager;
    }

    protected PluginInterfaceImpl getPluginFromClass(Class cla) {
        return this.getPluginFromClass(cla.getName());
    }

    protected PluginInterfaceImpl getPluginFromClass(String class_name) {
        int i = 0;
        while (i < this.plugin_interfaces.size()) {
            PluginInterfaceImpl pi = (PluginInterfaceImpl)this.plugin_interfaces.get(i);
            if (pi.getPlugin().getClass().getName().equals(class_name)) {
                return pi;
            }
            ++i;
        }
        return null;
    }

    protected File[] getHighestJarVersions(File[] files, String[] version_out, String[] id_out) {
        ArrayList<File> res = new ArrayList<File>();
        HashMap<String, String> version_map = new HashMap<String, String>();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            String name = f.getName().toLowerCase();
            if (name.endsWith(".jar")) {
                int cvs_pos = name.lastIndexOf("_cvs");
                int sep_pos = cvs_pos <= 0 ? name.lastIndexOf("_") : name.lastIndexOf("_", cvs_pos - 1);
                if (sep_pos == -1 || sep_pos == name.length() - 1 || !Character.isDigit(name.charAt(sep_pos + 1))) {
                    res.add(f);
                } else {
                    String prefix = name.substring(0, sep_pos);
                    String version = name.substring(sep_pos + 1, cvs_pos <= 0 ? name.length() - 4 : cvs_pos);
                    String prev_version = (String)version_map.get(prefix);
                    if (prev_version == null) {
                        version_map.put(prefix, version);
                    } else if (PluginUtils.comparePluginVersions(prev_version, version) < 0) {
                        version_map.put(prefix, version);
                    }
                }
            }
            ++i;
        }
        if (version_map.size() > 0) {
            res.clear();
        }
        Iterator it = version_map.keySet().iterator();
        block1: while (it.hasNext()) {
            String prefix = (String)it.next();
            String version = (String)version_map.get(prefix);
            String target = String.valueOf(prefix) + "_" + version;
            version_out[0] = version;
            id_out[0] = prefix;
            int i2 = 0;
            while (i2 < files.length) {
                File f = files[i2];
                String lc_name = f.getName().toLowerCase();
                if (lc_name.equals(String.valueOf(target) + ".jar") || lc_name.equals(String.valueOf(target) + "_cvs.jar")) {
                    res.add(f);
                    continue block1;
                }
                ++i2;
            }
        }
        File[] res_array = new File[res.size()];
        res.toArray(res_array);
        return res_array;
    }

    protected class loadFailedPlugin
    implements UnloadablePlugin {
        protected loadFailedPlugin() {
        }

        public void initialize(PluginInterface pluginInterface) throws PluginException {
        }

        public void unload() {
        }
    }
}

