/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateEvent;
import org.gudy.azureus2.core3.download.DownloadManagerStateListener;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyEvent;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadAnnounceResultImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadScrapeResultImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;

public class DownloadImpl
implements Download,
DownloadManagerListener,
DownloadManagerTrackerListener,
DownloadManagerPeerListener,
DownloadManagerStateListener {
    protected DownloadManager download_manager;
    protected DownloadStatsImpl download_stats;
    protected int latest_state = 7;
    protected boolean latest_forcedStart;
    protected DownloadAnnounceResultImpl last_announce_result = new DownloadAnnounceResultImpl(this, null);
    protected DownloadScrapeResultImpl last_scrape_result = new DownloadScrapeResultImpl(this, null);
    protected List listeners = new ArrayList();
    protected AEMonitor listeners_mon = new AEMonitor("Download:L");
    protected List property_listeners = new ArrayList();
    protected List tracker_listeners = new ArrayList();
    protected AEMonitor tracker_listeners_mon = new AEMonitor("Download:TL");
    protected List removal_listeners = new ArrayList();
    protected AEMonitor removal_listeners_mon = new AEMonitor("Download:RL");
    protected List peer_listeners = new ArrayList();
    protected AEMonitor peer_listeners_mon = new AEMonitor("Download:PL");

    protected DownloadImpl(DownloadManager _dm) {
        this.download_manager = _dm;
        this.download_stats = new DownloadStatsImpl(this.download_manager);
        this.download_manager.addListener(this);
        this.latest_forcedStart = this.download_manager.isForceStart();
    }

    protected DownloadManager getDownload() {
        return this.download_manager;
    }

    public int getState() {
        return this.latest_state;
    }

    protected int convertState(int dm_state) {
        int our_state;
        switch (dm_state) {
            case 0: {
                our_state = 1;
                break;
            }
            case 5: 
            case 10: 
            case 20: 
            case 30: {
                our_state = 2;
                break;
            }
            case 40: {
                our_state = 3;
                break;
            }
            case 50: 
            case 55: {
                our_state = 4;
                break;
            }
            case 60: {
                our_state = 5;
                break;
            }
            case 65: {
                our_state = 6;
                break;
            }
            case 70: {
                our_state = 7;
                break;
            }
            case 75: {
                our_state = 9;
                break;
            }
            case 100: {
                our_state = 8;
                break;
            }
            default: {
                our_state = 8;
            }
        }
        return our_state;
    }

    public String getErrorStateDetails() {
        return this.download_manager.getErrorDetails();
    }

    public int getIndex() {
        return this.download_manager.getIndex();
    }

    public Torrent getTorrent() {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent == null) {
            return null;
        }
        return new TorrentImpl(torrent);
    }

    public void initialize() throws DownloadException {
        if (this.download_manager.getState() != 0) {
            throw new DownloadException("Download::initialize: download not waiting");
        }
        this.download_manager.initialize();
    }

    public void start() throws DownloadException {
        if (this.download_manager.getState() != 40) {
            throw new DownloadException("Download::start: download not ready");
        }
        this.download_manager.startDownload();
        this.download_manager.getStats().setSavedDiscarded();
        this.download_manager.getStats().setSavedHashFails();
    }

    public void restart() throws DownloadException {
        if (this.download_manager.getState() != 70 && this.download_manager.getState() != 75) {
            throw new DownloadException("Download::restart: download already running");
        }
        this.download_manager.setState(0);
    }

    public void stop() throws DownloadException {
        if (this.download_manager.getState() == 70) {
            throw new DownloadException("Download::stop: download already stopped");
        }
        this.download_manager.stopIt(70, false, false);
    }

    public void stopAndQueue() throws DownloadException {
        if (this.download_manager.getState() == 75) {
            throw new DownloadException("Download::stopAndQueue: download already queued");
        }
        this.download_manager.stopIt(75, false, false);
    }

    public boolean isStartStopLocked() {
        return this.download_manager.getState() == 70;
    }

    public boolean isForceStart() {
        return this.download_manager.isForceStart();
    }

    public void setForceStart(boolean forceStart) {
        this.download_manager.setForceStart(forceStart);
    }

    public int getPosition() {
        return this.download_manager.getPosition();
    }

    public long getCreationTime() {
        return this.download_manager.getCreationTime();
    }

    public void setPosition(int newPosition) {
        this.download_manager.setPosition(newPosition);
    }

    public void moveUp() {
        this.download_manager.moveUp();
    }

    public void moveDown() {
        this.download_manager.moveDown();
    }

    public String getName() {
        return this.download_manager.getDisplayName();
    }

    public String getTorrentFileName() {
        return this.download_manager.getTorrentFileName();
    }

    public String getCategoryName() {
        Category category = this.download_manager.getDownloadState().getCategory();
        if (category == null) {
            category = CategoryManager.getCategory(2);
        }
        if (category == null) {
            return null;
        }
        return category.getName();
    }

    public String getAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            return this.download_manager.getDownloadState().getAttribute(name);
        }
        return null;
    }

    public void setAttribute(TorrentAttribute attribute, String value) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            this.download_manager.getDownloadState().setAttribute(name, value);
        }
    }

    protected String convertAttribute(TorrentAttribute attribute) {
        if (attribute.getName() == "Category") {
            return "category";
        }
        Debug.out("Can't convert attribute '" + attribute.getName() + "'");
        return null;
    }

    protected TorrentAttribute convertAttribute(String name) {
        if (name.equals("category")) {
            return TorrentManagerImpl.getSingleton().getAttribute("Category");
        }
        return null;
    }

    public void setCategory(String sName) {
        Category category = CategoryManager.getCategory(sName);
        if (category == null) {
            category = CategoryManager.createCategory(sName);
        }
        this.download_manager.getDownloadState().setCategory(category);
    }

    public boolean isPersistent() {
        return this.download_manager.isPersistent();
    }

    public void remove() throws DownloadException, DownloadRemovalVetoException {
        int dl_state = this.download_manager.getState();
        if (dl_state == 70 || dl_state == 100 || dl_state == 75) {
            GlobalManager globalManager = this.download_manager.getGlobalManager();
            try {
                globalManager.removeDownloadManager(this.download_manager);
            }
            catch (GlobalManagerDownloadRemovalVetoException e) {
                throw new DownloadRemovalVetoException(e.getMessage());
            }
        } else {
            throw new DownloadRemovalVetoException(MessageText.getString("plugin.download.remove.veto.notstopped"));
        }
    }

    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        int dl_state = this.download_manager.getState();
        if (dl_state == 70 || dl_state == 100 || dl_state == 75) {
            GlobalManager globalManager = this.download_manager.getGlobalManager();
            try {
                globalManager.canDownloadManagerBeRemoved(this.download_manager);
            }
            catch (GlobalManagerDownloadRemovalVetoException e) {
                throw new DownloadRemovalVetoException(e.getMessage());
            }
        } else {
            throw new DownloadRemovalVetoException(MessageText.getString("plugin.download.remove.veto.notstopped"));
        }
        return true;
    }

    public DownloadStats getStats() {
        return this.download_stats;
    }

    public boolean isComplete() {
        int state = this.getState();
        return state == 5 || this.download_manager.isDownloadComplete();
    }

    protected void isRemovable() throws DownloadRemovalVetoException {
        int i = 0;
        while (i < this.removal_listeners.size()) {
            try {
                ((DownloadWillBeRemovedListener)this.removal_listeners.get(i)).downloadWillBeRemoved(this);
            }
            catch (DownloadRemovalVetoException e) {
                throw e;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void destroy() {
        this.download_manager.removeListener(this);
    }

    public void stateChanged(DownloadManager manager, int state) {
        int prev_state = this.latest_state;
        this.latest_state = this.convertState(state);
        boolean curr_forcedStart = this.isForceStart();
        if (prev_state != this.latest_state || this.latest_forcedStart != curr_forcedStart) {
            this.latest_forcedStart = curr_forcedStart;
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((DownloadListener)this.listeners.get(i)).stateChanged(this, prev_state, this.latest_state);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    public void downloadComplete(DownloadManager manager) {
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((DownloadListener)this.listeners.get(i)).positionChanged(this, oldPosition, newPosition);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public void addListener(DownloadListener l) {
        try {
            this.listeners_mon.enter();
            ArrayList<DownloadListener> new_listeners = new ArrayList<DownloadListener>(this.listeners);
            new_listeners.add(l);
            this.listeners = new_listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void removeListener(DownloadListener l) {
        try {
            this.listeners_mon.enter();
            ArrayList new_listeners = new ArrayList(this.listeners);
            new_listeners.remove(l);
            this.listeners = new_listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public DownloadAnnounceResult getLastAnnounceResult() {
        return this.last_announce_result;
    }

    public DownloadScrapeResult getLastScrapeResult() {
        TRTrackerScraperResponse response = this.download_manager.getTrackerScrapeResponse();
        this.last_scrape_result.setContent(response);
        return this.last_scrape_result;
    }

    public void scrapeResult(TRTrackerScraperResponse response) {
        this.last_scrape_result.setContent(response);
        int i = 0;
        while (i < this.tracker_listeners.size()) {
            try {
                ((DownloadTrackerListener)this.tracker_listeners.get(i)).scrapeResult(this.last_scrape_result);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public void announceResult(TRTrackerResponse response) {
        this.last_announce_result.setContent(response);
        List tracker_listeners_ref = this.tracker_listeners;
        int i = 0;
        while (i < tracker_listeners_ref.size()) {
            try {
                ((DownloadTrackerListener)tracker_listeners_ref.get(i)).announceResult(this.last_announce_result);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public void stateChanged(DownloadManagerState state, DownloadManagerStateEvent event) {
        String name;
        if (event.getType() == 1 && (name = (String)event.getData()).equals("category")) {
            List property_listeners_ref = this.property_listeners;
            final TorrentAttribute attr = this.convertAttribute(name);
            if (attr != null) {
                int i = 0;
                while (i < property_listeners_ref.size()) {
                    try {
                        ((DownloadPropertyListener)property_listeners_ref.get(i)).propertyChanged(this, new DownloadPropertyEvent(){

                            public int getType() {
                                return 1;
                            }

                            public Object getData() {
                                return attr;
                            }
                        });
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
            }
        }
    }

    public void addPropertyListener(DownloadPropertyListener l) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList<DownloadPropertyListener> new_property_listeners = new ArrayList<DownloadPropertyListener>(this.property_listeners);
            new_property_listeners.add(l);
            this.property_listeners = new_property_listeners;
            if (this.property_listeners.size() == 1) {
                this.download_manager.getDownloadState().addListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
    }

    public void removePropertyListener(DownloadPropertyListener l) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList new_property_listeners = new ArrayList(this.property_listeners);
            new_property_listeners.remove(l);
            this.property_listeners = new_property_listeners;
            if (this.property_listeners.size() == 0) {
                this.download_manager.getDownloadState().removeListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
    }

    public void torrentChanged() {
        TRTrackerClient client = this.download_manager.getTrackerClient();
        if (client != null) {
            client.resetTrackerUrl(true);
        }
    }

    public void addTrackerListener(DownloadTrackerListener l) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList<DownloadTrackerListener> new_tracker_listeners = new ArrayList<DownloadTrackerListener>(this.tracker_listeners);
            new_tracker_listeners.add(l);
            this.tracker_listeners = new_tracker_listeners;
            if (this.tracker_listeners.size() == 1) {
                this.download_manager.addTrackerListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
        l.announceResult(this.last_announce_result);
        l.scrapeResult(this.last_scrape_result);
    }

    public void removeTrackerListener(DownloadTrackerListener l) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList new_tracker_listeners = new ArrayList(this.tracker_listeners);
            new_tracker_listeners.remove(l);
            this.tracker_listeners = new_tracker_listeners;
            if (this.tracker_listeners.size() == 0) {
                this.download_manager.removeTrackerListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
    }

    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        try {
            this.removal_listeners_mon.enter();
            ArrayList<DownloadWillBeRemovedListener> new_removal_listeners = new ArrayList<DownloadWillBeRemovedListener>(this.removal_listeners);
            new_removal_listeners.add(l);
            this.removal_listeners = new_removal_listeners;
        }
        finally {
            this.removal_listeners_mon.exit();
        }
    }

    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        try {
            this.removal_listeners_mon.enter();
            ArrayList new_removal_listeners = new ArrayList(this.removal_listeners);
            new_removal_listeners.remove(l);
            this.removal_listeners = new_removal_listeners;
        }
        finally {
            this.removal_listeners_mon.exit();
        }
    }

    public void addPeerListener(DownloadPeerListener l) {
        try {
            this.peer_listeners_mon.enter();
            ArrayList<DownloadPeerListener> new_peer_listeners = new ArrayList<DownloadPeerListener>(this.peer_listeners);
            new_peer_listeners.add(l);
            this.peer_listeners = new_peer_listeners;
            if (this.peer_listeners.size() == 1) {
                this.download_manager.addPeerListener(this);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void removePeerListener(DownloadPeerListener l) {
        try {
            this.peer_listeners_mon.enter();
            ArrayList new_peer_listeners = new ArrayList(this.peer_listeners);
            new_peer_listeners.remove(l);
            this.peer_listeners = new_peer_listeners;
            if (this.peer_listeners.size() == 0) {
                this.download_manager.removePeerListener(this);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void peerManagerAdded(PEPeerManager manager) {
        if (this.peer_listeners.size() > 0) {
            PeerManagerImpl pm = PeerManagerImpl.getPeerManager(manager);
            int i = 0;
            while (i < this.peer_listeners.size()) {
                ((DownloadPeerListener)this.peer_listeners.get(i)).peerManagerAdded(this, pm);
                ++i;
            }
        }
    }

    public void peerManagerRemoved(PEPeerManager manager) {
        if (this.peer_listeners.size() > 0) {
            PeerManagerImpl pm = PeerManagerImpl.getPeerManager(manager);
            int i = 0;
            while (i < this.peer_listeners.size()) {
                ((DownloadPeerListener)this.peer_listeners.get(i)).peerManagerRemoved(this, pm);
                ++i;
            }
        }
    }

    public PeerManager getPeerManager() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return null;
        }
        return PeerManagerImpl.getPeerManager(pm);
    }

    public void peerAdded(PEPeer peer) {
    }

    public void peerRemoved(PEPeer peer) {
    }

    public void pieceAdded(PEPiece piece) {
    }

    public void pieceRemoved(PEPiece piece) {
    }

    public void setMaximumDownloadKBPerSecond(int kb) {
        this.download_manager.getStats().setMaxDownloadKBSpeed(kb < 0 ? 0 : kb);
    }

    public int getMaximumDownloadKBPerSecond() {
        return this.download_manager.getStats().getMaxDownloadKBSpeed();
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.download_manager.getStats().getUploadRateLimitBytesPerSecond();
    }

    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.download_manager.getStats().setUploadRateLimitBytesPerSecond(max_rate_bps);
    }

    public String getSavePath() {
        return this.download_manager.getTorrentSaveDirAndFile();
    }

    public void requestTrackerAnnounce() {
        this.download_manager.checkTracker();
    }

    public byte[] getDownloadPeerId() {
        return this.download_manager.getTrackerClient().getPeerId();
    }

    public int getPriority() {
        return 0;
    }

    public boolean isPriorityLocked() {
        return false;
    }

    public void setPriority(int priority) {
    }
}

