/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;

public class UpdateInstallerImpl
implements UpdateInstaller {
    protected static final String UPDATE_DIR = "updates";
    protected static final String ACTIONS = "install.act";
    protected static AEMonitor class_mon = new AEMonitor("UpdateInstaller:class");
    protected File install_dir;

    protected static void checkForFailedInstalls() {
        try {
            File update_dir = new File(String.valueOf(UpdateInstallerImpl.getUserDirSupport()) + File.separator + UPDATE_DIR);
            File[] dirs = update_dir.listFiles();
            if (dirs != null) {
                boolean found_failure = false;
                int i = 0;
                while (i < dirs.length) {
                    File dir = dirs[i];
                    if (dir.isDirectory()) {
                        found_failure = true;
                        FileUtil.recursiveDelete(dir);
                    }
                    ++i;
                }
                if (found_failure) {
                    LGLogger.logUnrepeatableAlert(3, "Installation of at least one component failed - see 'update.log' for details");
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected UpdateInstallerImpl() throws UpdateException {
        try {
            class_mon.enter();
            String update_dir = String.valueOf(this.getUserDir()) + File.separator + UPDATE_DIR;
            int i = 1;
            while (i < 1024) {
                File try_dir = new File(String.valueOf(update_dir) + File.separator + "inst_" + i);
                if (!try_dir.exists()) {
                    if (!try_dir.mkdirs()) {
                        throw new UpdateException("Failed to create a temporary installation dir");
                    }
                    this.install_dir = try_dir;
                    break;
                }
                ++i;
            }
            if (this.install_dir == null) {
                throw new UpdateException("Failed to find a temporary installation dir");
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public void addResource(String resource_name, InputStream is) throws UpdateException {
        this.addResource(resource_name, is, true);
    }

    public void addResource(String resource_name, InputStream is, boolean closeInputStream) throws UpdateException {
        try {
            File target_file = new File(this.install_dir, resource_name);
            FileUtil.copyFile(is, (OutputStream)new FileOutputStream(target_file), closeInputStream);
        }
        catch (Throwable e) {
            throw new UpdateException("UpdateInstaller: resource addition fails", e);
        }
    }

    public String getInstallDir() {
        String str = SystemProperties.getApplicationPath();
        if (str.endsWith(File.separator)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public String getUserDir() {
        return UpdateInstallerImpl.getUserDirSupport();
    }

    protected static String getUserDirSupport() {
        String str = SystemProperties.getUserPath();
        if (str.endsWith(File.separator)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public void addMoveAction(String from_file_or_resource, String to_file) throws UpdateException {
        if (from_file_or_resource.indexOf(File.separator) == -1) {
            from_file_or_resource = String.valueOf(this.install_dir.toString()) + File.separator + from_file_or_resource;
        }
        this.appendAction("move," + from_file_or_resource + "," + to_file);
    }

    public void addChangeRightsAction(String rights, String to_file) throws UpdateException {
        this.appendAction("chmod," + rights + "," + to_file);
    }

    public void addRemoveAction(String file) throws UpdateException {
        this.appendAction("remove," + file);
    }

    protected void appendAction(String data) throws UpdateException {
        PrintWriter pw = null;
        try {
            try {
                pw = new PrintWriter(new FileWriter(String.valueOf(this.install_dir.toString()) + File.separator + ACTIONS, true));
                pw.println(data);
            }
            catch (Throwable e) {
                throw new UpdateException("Failed to write actions file", e);
            }
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Throwable e) {
                    throw new UpdateException("Failed to write actions file", e);
                }
            }
        }
    }
}

