/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class UTTimerImpl
implements UTTimer {
    protected Timer timer;
    protected boolean destroyed;

    protected UTTimerImpl(PluginInterface pi, String name) {
        this.timer = new Timer("Plugin " + pi.getPluginID() + ":" + name);
    }

    public UTTimerEvent addPeriodicEvent(long periodic_millis, final UTTimerEventPerformer performer) {
        if (this.destroyed) {
            throw new RuntimeException("Timer has been destroyed");
        }
        final timerEvent res = new timerEvent();
        TimerEventPeriodic ev = this.timer.addPeriodicEvent(periodic_millis, new TimerEventPerformer(){

            public void perform(TimerEvent ev) {
                res.perform(performer);
            }
        });
        res.setEvent(ev);
        return res;
    }

    public void destroy() {
        this.destroyed = true;
        this.timer.destroy();
    }

    protected class timerEvent
    implements UTTimerEvent {
        protected TimerEventPeriodic ev;

        protected timerEvent() {
        }

        protected void setEvent(TimerEventPeriodic _ev) {
            this.ev = _ev;
        }

        protected void perform(UTTimerEventPerformer p) {
            p.perform(this);
        }

        public void cancel() {
            this.ev.cancel();
        }
    }
}

