/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.torrent;

import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;

public class RPTorrentDownloader
extends RPObject
implements TorrentDownloader {
    protected transient TorrentDownloader delegate;

    public static RPTorrentDownloader create(TorrentDownloader _delegate) {
        RPTorrentDownloader res = (RPTorrentDownloader)RPObject._lookupLocal(_delegate);
        if (res == null) {
            res = new RPTorrentDownloader(_delegate);
        }
        return res;
    }

    protected RPTorrentDownloader(TorrentDownloader _delegate) {
        super(_delegate);
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (TorrentDownloader)_delegate;
    }

    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        if (method.equals("download")) {
            try {
                Torrent to = this.delegate.download();
                RPTorrent res = RPTorrent.create(to);
                return new RPReply(res);
            }
            catch (TorrentException e) {
                return new RPReply(e);
            }
        }
        if (method.equals("download[String]")) {
            try {
                Torrent to = this.delegate.download((String)request2.getParams()[0]);
                RPTorrent res = RPTorrent.create(to);
                return new RPReply(res);
            }
            catch (TorrentException e) {
                return new RPReply(e);
            }
        }
        throw new RPException("Unknown method: " + method);
    }

    public Torrent download() throws TorrentException {
        try {
            RPTorrent resp = (RPTorrent)this._dispatcher.dispatch(new RPRequest(this, "download", null)).getResponse();
            resp._setRemote(this._dispatcher);
            return resp;
        }
        catch (RPException e) {
            if (e.getCause() instanceof TorrentException) {
                throw (TorrentException)e.getCause();
            }
            throw e;
        }
    }

    public Torrent download(String encoding) throws TorrentException {
        try {
            RPTorrent resp = (RPTorrent)this._dispatcher.dispatch(new RPRequest(this, "download[String]", new Object[]{encoding})).getResponse();
            resp._setRemote(this._dispatcher);
            return resp;
        }
        catch (RPException e) {
            if (e.getCause() instanceof TorrentException) {
                throw (TorrentException)e.getCause();
            }
            throw e;
        }
    }
}

