/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.torrent;

import java.io.File;
import java.net.URL;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.torrent.TorrentManagerListener;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrentDownloader;

public class RPTorrentManager
extends RPObject
implements TorrentManager {
    protected transient TorrentManager delegate;

    public static RPTorrentManager create(TorrentManager _delegate) {
        RPTorrentManager res = (RPTorrentManager)RPObject._lookupLocal(_delegate);
        if (res == null) {
            res = new RPTorrentManager(_delegate);
        }
        return res;
    }

    protected RPTorrentManager(TorrentManager _delegate) {
        super(_delegate);
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (TorrentManager)_delegate;
    }

    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        Object[] params = request2.getParams();
        if (method.equals("getURLDownloader[URL]")) {
            try {
                TorrentDownloader dl = this.delegate.getURLDownloader((URL)params[0]);
                RPTorrentDownloader res = RPTorrentDownloader.create(dl);
                return new RPReply(res);
            }
            catch (TorrentException e) {
                return new RPReply(e);
            }
        }
        if (method.equals("getURLDownloader[URL,String,String]")) {
            try {
                TorrentDownloader dl = this.delegate.getURLDownloader((URL)params[0], (String)params[1], (String)params[2]);
                RPTorrentDownloader res = RPTorrentDownloader.create(dl);
                return new RPReply(res);
            }
            catch (TorrentException e) {
                return new RPReply(e);
            }
        }
        if (method.equals("createFromBEncodedData[byte[]]")) {
            try {
                return new RPReply(RPTorrent.create(this.delegate.createFromBEncodedData((byte[])params[0])));
            }
            catch (TorrentException e) {
                return new RPReply(e);
            }
        }
        throw new RPException("Unknown method: " + method);
    }

    public TorrentDownloader getURLDownloader(URL url) throws TorrentException {
        try {
            RPTorrentDownloader resp = (RPTorrentDownloader)this._dispatcher.dispatch(new RPRequest(this, "getURLDownloader[URL]", new Object[]{url})).getResponse();
            resp._setRemote(this._dispatcher);
            return resp;
        }
        catch (RPException e) {
            if (e.getCause() instanceof TorrentException) {
                throw (TorrentException)e.getCause();
            }
            throw e;
        }
    }

    public TorrentDownloader getURLDownloader(URL url, String user_name, String password) throws TorrentException {
        try {
            RPTorrentDownloader resp = (RPTorrentDownloader)this._dispatcher.dispatch(new RPRequest(this, "getURLDownloader[URL,String,String]", new Object[]{url, user_name, password})).getResponse();
            resp._setRemote(this._dispatcher);
            return resp;
        }
        catch (RPException e) {
            if (e.getCause() instanceof TorrentException) {
                throw (TorrentException)e.getCause();
            }
            throw e;
        }
    }

    public Torrent createFromBEncodedFile(File file) throws TorrentException {
        this.notSupported();
        return null;
    }

    public Torrent createFromBEncodedData(byte[] data) throws TorrentException {
        try {
            RPTorrent res = (RPTorrent)this._dispatcher.dispatch(new RPRequest(this, "createFromBEncodedData[byte[]]", new Object[]{data})).getResponse();
            res._setRemote(this._dispatcher);
            return res;
        }
        catch (RPException e) {
            if (e.getCause() instanceof TorrentException) {
                throw (TorrentException)e.getCause();
            }
            throw e;
        }
    }

    public Torrent createFromDataFile(File data, URL announce_url) throws TorrentException {
        this.notSupported();
        return null;
    }

    public Torrent createFromDataFile(File data, URL announce_url, boolean include_other_hashes) throws TorrentException {
        this.notSupported();
        return null;
    }

    public TorrentAttribute[] getDefinedAttributes() {
        this.notSupported();
        return null;
    }

    public TorrentAttribute getAttribute(String name) {
        this.notSupported();
        return null;
    }

    public void addListener(TorrentManagerListener l) {
        this.notSupported();
    }

    public void removeListener(TorrentManagerListener l) {
        this.notSupported();
    }
}

