/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.IAdditionalActionPerformer;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;

public class BooleanParameter
extends Parameter {
    String name;
    Button checkBox;
    List performers = new ArrayList();

    public BooleanParameter(Composite composite, String name) {
        this(composite, name, COConfigurationManager.getBooleanParameter(name), null, null);
    }

    public BooleanParameter(Composite composite, String name, String textKey) {
        this(composite, name, COConfigurationManager.getBooleanParameter(name), textKey, null);
    }

    public BooleanParameter(Composite composite, String name, boolean defaultValue, String textKey) {
        this(composite, name, defaultValue, textKey, null);
    }

    public BooleanParameter(Composite composite, String name, boolean defaultValue) {
        this(composite, name, defaultValue, null, null);
    }

    public BooleanParameter(Composite composite, final String name, boolean defaultValue, String textKey, IAdditionalActionPerformer actionPerformer) {
        if (actionPerformer != null) {
            this.performers.add(actionPerformer);
        }
        boolean value = COConfigurationManager.getBooleanParameter(name, defaultValue);
        this.checkBox = new Button(composite, 32);
        if (textKey != null) {
            Messages.setLanguageText((Widget)this.checkBox, textKey);
        }
        this.checkBox.setSelection(value);
        this.checkBox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int i;
                boolean selected = BooleanParameter.this.checkBox.getSelection();
                COConfigurationManager.setParameter(name, selected);
                if (BooleanParameter.this.performers.size() > 0) {
                    i = 0;
                    while (i < BooleanParameter.this.performers.size()) {
                        IAdditionalActionPerformer performer = (IAdditionalActionPerformer)BooleanParameter.this.performers.get(i);
                        performer.setSelected(selected);
                        performer.performAction();
                        ++i;
                    }
                }
                if (BooleanParameter.this.change_listeners != null) {
                    i = 0;
                    while (i < BooleanParameter.this.change_listeners.size()) {
                        ((ParameterChangeListener)BooleanParameter.this.change_listeners.get(i)).parameterChanged(BooleanParameter.this, false);
                        ++i;
                    }
                }
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        this.checkBox.setLayoutData(layoutData);
    }

    public void setAdditionalActionPerformer(IAdditionalActionPerformer actionPerformer) {
        this.performers.add(actionPerformer);
        boolean selected = this.checkBox.getSelection();
        actionPerformer.setSelected(selected);
        actionPerformer.performAction();
    }

    public Control getControl() {
        return this.checkBox;
    }

    public boolean isSelected() {
        return this.checkBox.getSelection();
    }
}

