/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import java.util.Locale;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.donations.DonationWindow2;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import org.gudy.azureus2.ui.swt.help.AboutWindow;
import org.gudy.azureus2.ui.swt.help.HealthHelpWindow;
import org.gudy.azureus2.ui.swt.importtorrent.wizard.ImportTorrentWizard;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.pluginsuninstaller.UnInstallPluginWizard;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;

public class MainMenu {
    private Display display;
    private MainWindow mainWindow;
    private Menu menuBar;
    private MenuItem menu_tools;
    private Menu toolsMenu;
    private MenuItem menu_plugin;
    private Menu pluginMenu;

    public MainMenu(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.display = SWTThread.getInstance().getDisplay();
    }

    public void buildMenu(Locale[] locales) {
        try {
            this.menuBar = new Menu((Decorations)this.mainWindow.getShell(), 2);
            this.mainWindow.getShell().setMenuBar(this.menuBar);
            MenuItem fileItem = new MenuItem(this.menuBar, 64);
            Messages.setLanguageText((Widget)fileItem, "MainWindow.menu.file");
            Menu fileMenu = new Menu((Decorations)this.mainWindow.getShell(), 4);
            fileItem.setMenu(fileMenu);
            MenuItem file_new = new MenuItem(fileMenu, 64);
            Messages.setLanguageText((Widget)file_new, "MainWindow.menu.file.open");
            MenuItem file_share = new MenuItem(fileMenu, 64);
            Messages.setLanguageText((Widget)file_share, "MainWindow.menu.file.share");
            MenuItem file_create = new MenuItem(fileMenu, 0);
            Messages.setLanguageText((Widget)file_create, "MainWindow.menu.file.create");
            new MenuItem(fileMenu, 2);
            MenuItem file_export = new MenuItem(fileMenu, 0);
            Messages.setLanguageText((Widget)file_export, "MainWindow.menu.file.export");
            MenuItem file_import = new MenuItem(fileMenu, 0);
            Messages.setLanguageText((Widget)file_import, "MainWindow.menu.file.import");
            new MenuItem(fileMenu, 2);
            MenuItem file_restart = new MenuItem(fileMenu, 0);
            Messages.setLanguageText((Widget)file_restart, "MainWindow.menu.file.restart");
            file_restart.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MainWindow.getWindow().dispose(true, false);
                }
            });
            if (!Constants.isOSX) {
                MenuItem file_exit = new MenuItem(fileMenu, 0);
                Messages.setLanguageText((Widget)file_exit, "MainWindow.menu.file.exit");
                file_exit.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        MainMenu.this.mainWindow.dispose(false, false);
                    }
                });
            }
            Menu newMenu = new Menu((Decorations)this.mainWindow.getShell(), 4);
            file_new.setMenu(newMenu);
            MenuItem file_new_torrent = new MenuItem(newMenu, 0);
            Messages.setLanguageText((Widget)file_new_torrent, "MainWindow.menu.file.open.torrent");
            file_new_torrent.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TorrentOpener.openTorrent();
                }
            });
            MenuItem file_new_torrent_no_default = new MenuItem(newMenu, 0);
            Messages.setLanguageText((Widget)file_new_torrent_no_default, "MainWindow.menu.file.open.torrentnodefault");
            file_new_torrent_no_default.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TorrentOpener.openTorrentNoDefaultSave(false);
                }
            });
            MenuItem file_new_torrent_for_seeding = new MenuItem(newMenu, 0);
            Messages.setLanguageText((Widget)file_new_torrent_for_seeding, "MainWindow.menu.file.open.torrentforseeding");
            file_new_torrent_for_seeding.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TorrentOpener.openTorrentNoDefaultSave(true);
                }
            });
            MenuItem file_new_url = new MenuItem(newMenu, 0);
            Messages.setLanguageText((Widget)file_new_url, "MainWindow.menu.file.open.url");
            file_new_url.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TorrentOpener.openUrl(MainMenu.this.mainWindow.getAzureusCore());
                }
            });
            MenuItem file_new_folder = new MenuItem(newMenu, 0);
            Messages.setLanguageText((Widget)file_new_folder, "MainWindow.menu.file.folder");
            file_new_folder.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TorrentOpener.openDirectory();
                }
            });
            Menu shareMenu = new Menu((Decorations)this.mainWindow.getShell(), 4);
            file_share.setMenu(shareMenu);
            MenuItem file_share_file = new MenuItem(shareMenu, 0);
            Messages.setLanguageText((Widget)file_share_file, "MainWindow.menu.file.share.file");
            file_share_file.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ShareUtils.shareFile(MainMenu.this.mainWindow.getAzureusCore(), MainMenu.this.mainWindow.getShell());
                }
            });
            MenuItem file_share_dir = new MenuItem(shareMenu, 0);
            Messages.setLanguageText((Widget)file_share_dir, "MainWindow.menu.file.share.dir");
            file_share_dir.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ShareUtils.shareDir(MainMenu.this.mainWindow.getAzureusCore(), MainMenu.this.mainWindow.getShell());
                }
            });
            MenuItem file_share_dircontents = new MenuItem(shareMenu, 0);
            Messages.setLanguageText((Widget)file_share_dircontents, "MainWindow.menu.file.share.dircontents");
            file_share_dircontents.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ShareUtils.shareDirContents(MainMenu.this.mainWindow.getAzureusCore(), MainMenu.this.mainWindow.getShell(), false);
                }
            });
            MenuItem file_share_dircontents_rec = new MenuItem(shareMenu, 0);
            Messages.setLanguageText((Widget)file_share_dircontents_rec, "MainWindow.menu.file.share.dircontentsrecursive");
            file_share_dircontents_rec.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ShareUtils.shareDirContents(MainMenu.this.mainWindow.getAzureusCore(), MainMenu.this.mainWindow.getShell(), true);
                }
            });
            file_create.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new NewTorrentWizard(MainMenu.this.mainWindow.getAzureusCore(), MainMenu.this.display);
                }
            });
            file_export.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new ExportTorrentWizard(MainMenu.this.mainWindow.getAzureusCore(), MainMenu.this.display);
                }
            });
            file_import.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new ImportTorrentWizard(MainMenu.this.mainWindow.getAzureusCore(), MainMenu.this.display);
                }
            });
            MenuItem downloadItem = new MenuItem(this.menuBar, 64);
            Messages.setLanguageText((Widget)downloadItem, "MainWindow.menu.transfers");
            Menu downloadMenu = new Menu((Decorations)this.mainWindow.getShell(), 4);
            downloadItem.setMenu(downloadMenu);
            MenuItem itemStartAll = new MenuItem(downloadMenu, 0);
            Messages.setLanguageText((Widget)itemStartAll, "MainWindow.menu.transfers.startalltransfers");
            MenuItem itemStopAll = new MenuItem(downloadMenu, 0);
            Messages.setLanguageText((Widget)itemStopAll, "MainWindow.menu.transfers.stopalltransfers");
            final MenuItem itemPause = new MenuItem(downloadMenu, 0);
            Messages.setLanguageText((Widget)itemPause, "MainWindow.menu.transfers.pausetransfers");
            final MenuItem itemResume = new MenuItem(downloadMenu, 0);
            Messages.setLanguageText((Widget)itemResume, "MainWindow.menu.transfers.resumetransfers");
            itemStartAll.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    MainMenu.this.mainWindow.getGlobalManager().startAllDownloads();
                }
            });
            itemStopAll.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    MainMenu.this.mainWindow.getGlobalManager().stopAllDownloads();
                }
            });
            itemPause.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    MainMenu.this.mainWindow.getGlobalManager().pauseDownloads();
                }
            });
            itemResume.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    MainMenu.this.mainWindow.getGlobalManager().resumeDownloads();
                }
            });
            downloadMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent menu) {
                    itemPause.setEnabled(MainMenu.this.mainWindow.getGlobalManager().canPauseDownloads());
                    itemResume.setEnabled(MainMenu.this.mainWindow.getGlobalManager().canResumeDownloads());
                }

                public void menuHidden(MenuEvent menu) {
                }
            });
            MenuItem viewItem = new MenuItem(this.menuBar, 64);
            Messages.setLanguageText((Widget)viewItem, "MainWindow.menu.view");
            Menu viewMenu = new Menu((Decorations)this.mainWindow.getShell(), 4);
            viewItem.setMenu(viewMenu);
            MenuItem view_torrents = new MenuItem(viewMenu, 0);
            Messages.setLanguageText((Widget)view_torrents, "MainWindow.menu.view.mytorrents");
            view_torrents.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    MainMenu.this.mainWindow.showMyTorrents();
                }
            });
            MenuItem view_tracker = new MenuItem(viewMenu, 0);
            Messages.setLanguageText((Widget)view_tracker, "MainWindow.menu.view.mytracker");
            view_tracker.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    MainMenu.this.mainWindow.showMyTracker();
                }
            });
            MenuItem view_shares = new MenuItem(viewMenu, 0);
            Messages.setLanguageText((Widget)view_shares, "MainWindow.menu.view.myshares");
            view_shares.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    MainMenu.this.mainWindow.showMyShares();
                }
            });
            new MenuItem(viewMenu, 2);
            MenuItem view_closeDetails = new MenuItem(viewMenu, 0);
            Messages.setLanguageText((Widget)view_closeDetails, "MainWindow.menu.closealldetails");
            view_closeDetails.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Tab.closeAllDetails();
                }
            });
            this.addCloseDownloadBarsToMenu(viewMenu);
            this.menu_tools = new MenuItem(this.menuBar, 64);
            Messages.setLanguageText((Widget)this.menu_tools, "MainWindow.menu.tools");
            this.toolsMenu = new Menu((Decorations)this.mainWindow.getShell(), 4);
            this.menu_tools.setMenu(this.toolsMenu);
            MenuItem view_console = new MenuItem(this.toolsMenu, 0);
            Messages.setLanguageText((Widget)view_console, "MainWindow.menu.view.console");
            view_console.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    MainMenu.this.mainWindow.showConsole();
                }
            });
            MenuItem view_stats = new MenuItem(this.toolsMenu, 0);
            Messages.setLanguageText((Widget)view_stats, "MainWindow.menu.view.stats");
            view_stats.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    MainMenu.this.mainWindow.showStats();
                }
            });
            new MenuItem(this.toolsMenu, 2);
            MenuItem file_configure = new MenuItem(this.toolsMenu, 0);
            Messages.setLanguageText((Widget)file_configure, "MainWindow.menu.file.configure");
            file_configure.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new ConfigureWizard(MainMenu.this.mainWindow.getAzureusCore(), MainMenu.this.display);
                }
            });
            if (!Constants.isOSX) {
                MenuItem view_config = new MenuItem(this.toolsMenu, 0);
                Messages.setLanguageText((Widget)view_config, "MainWindow.menu.view.configuration");
                view_config.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        MainMenu.this.mainWindow.showConfig();
                    }
                });
            }
            this.menu_plugin = new MenuItem(this.menuBar, 64);
            Messages.setLanguageText((Widget)this.menu_plugin, "MainWindow.menu.view.plugins");
            this.pluginMenu = new Menu((Decorations)this.mainWindow.getShell(), 4);
            this.menu_plugin.setEnabled(false);
            this.menu_plugin.setMenu(this.pluginMenu);
            new MenuItem(this.pluginMenu, 2);
            MenuItem plugins_install_wizard = new MenuItem(this.pluginMenu, 0);
            Messages.setLanguageText((Widget)plugins_install_wizard, "MainWindow.menu.plugins.installPlugins");
            plugins_install_wizard.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new InstallPluginWizard(MainMenu.this.mainWindow.getAzureusCore(), MainMenu.this.display);
                }
            });
            MenuItem plugins_uninstall_wizard = new MenuItem(this.pluginMenu, 0);
            Messages.setLanguageText((Widget)plugins_uninstall_wizard, "MainWindow.menu.plugins.uninstallPlugins");
            plugins_uninstall_wizard.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new UnInstallPluginWizard(MainMenu.this.mainWindow.getAzureusCore(), MainMenu.this.display);
                }
            });
            MenuItem helpItem = new MenuItem(this.menuBar, 64);
            Messages.setLanguageText((Widget)helpItem, "MainWindow.menu.help");
            Menu helpMenu = new Menu((Decorations)this.mainWindow.getShell(), 4);
            helpItem.setMenu(helpMenu);
            MenuItem help_about = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_about, "MainWindow.menu.help.about");
            help_about.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    AboutWindow.show(MainMenu.this.display);
                }
            });
            if (!SystemProperties.isJavaWebStartInstance()) {
                MenuItem help_checkupdate = new MenuItem(helpMenu, 0);
                Messages.setLanguageText((Widget)help_checkupdate, "MainWindow.menu.help.checkupdate");
                help_checkupdate.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        UpdateMonitor.getSingleton(MainMenu.this.mainWindow.getAzureusCore()).performCheck();
                    }
                });
            }
            new MenuItem(helpMenu, 2);
            MenuItem help_health = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_health, "MyTorrentsView.menu.health");
            help_health.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    HealthHelpWindow.show(MainMenu.this.display);
                }
            });
            MenuItem help_faq = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_faq, "MainWindow.menu.help.faq");
            help_faq.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    String faqString = "http://azureus.aelitis.com/wiki/";
                    Program.launch((String)faqString);
                }
            });
            new MenuItem(helpMenu, 2);
            MenuItem help_new = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_new, "MainWindow.menu.help.whatsnew");
            help_new.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Program.launch((String)"http://azureus.sourceforge.net/changelog.php?version=2.2.0.2");
                }
            });
            MenuItem help_plugin = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_plugin, "MainWindow.menu.help.plugins");
            help_plugin.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    String pluginString = "http://azureus.sourceforge.net/plugin_list.php";
                    Program.launch((String)pluginString);
                }
            });
            new MenuItem(helpMenu, 2);
            MenuItem help_donate = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_donate, "MainWindow.menu.help.donate");
            help_donate.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new DonationWindow2(MainMenu.this.display).show();
                }
            });
        }
        catch (Exception e) {
            LGLogger.log(3, "Error while creating menu items");
            Debug.printStackTrace(e);
        }
    }

    public void addCloseDownloadBarsToMenu(Menu menu) {
        MenuItem view_closeAll = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)view_closeAll, "MainWindow.menu.closealldownloadbars");
        view_closeAll.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainMenu.this.mainWindow.closeDownloadBars();
            }
        });
    }

    public void updateMenuText(Object menu) {
        MenuItem item;
        if (menu == null) {
            return;
        }
        if (menu instanceof Menu) {
            MenuItem[] menus = ((Menu)menu).getItems();
            int i = 0;
            while (i < menus.length) {
                this.updateMenuText(menus[i]);
                ++i;
            }
        } else if (menu instanceof MenuItem && (item = (MenuItem)menu).getData() != null && item.getData() instanceof String) {
            item.setText(MessageText.getString((String)item.getData()));
            this.updateMenuText(item.getMenu());
        }
    }

    public void refreshLanguage() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                MainMenu.this.updateMenuText(MainMenu.this.menuBar);
                MainMenu.this.mainWindow.setSelectedLanguageItem();
            }
        });
    }

    public void addPluginView(final PluginView view) {
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                String name = view.getPluginViewName();
                MenuItem[] items = MainMenu.this.pluginMenu.getItems();
                int insert_at = items.length;
                int i = 0;
                while (i < items.length) {
                    if (items[i].getStyle() == 2 || name.compareTo(items[i].getText()) < 0) {
                        insert_at = i;
                        break;
                    }
                    ++i;
                }
                MenuItem item = new MenuItem(MainMenu.this.pluginMenu, 0, insert_at);
                item.setText(name);
                item.addListener(13, new Listener(this, view){
                    final /* synthetic */ 39 this$1;
                    private final /* synthetic */ PluginView val$view;
                    {
                        this.this$1 = var1_1;
                        this.val$view = pluginView;
                    }

                    public void handleEvent(Event e) {
                        MainMenu.access$0(39.access$0(this.this$1)).openPluginView(this.val$view);
                    }
                });
                MainMenu.this.menu_plugin.setEnabled(true);
            }

            static /* synthetic */ MainMenu access$0(39 var0) {
                return var0.MainMenu.this;
            }
        });
    }
}

