/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderAdapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateCheckerListener;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.ui.swt.BlockedIpsWindow;
import org.gudy.azureus2.ui.swt.IconBar;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.MinimizedWindow;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.TrayWindow;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.donations.DonationWindow2;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.GUIUpdater;
import org.gudy.azureus2.ui.swt.mainwindow.Initializer;
import org.gudy.azureus2.ui.swt.mainwindow.MainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.sharing.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateWindow;
import org.gudy.azureus2.ui.swt.views.ConfigView;
import org.gudy.azureus2.ui.swt.views.ConsoleView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;
import org.gudy.azureus2.ui.swt.wizard.WizardListener;
import org.gudy.azureus2.ui.systray.SystemTraySWT;

public class MainWindow
extends AERunnable
implements GlobalManagerListener,
DownloadManagerListener,
ParameterListener,
IconBarEnabler,
AzureusCoreListener {
    private static MainWindow window;
    private Initializer initializer;
    private GUIUpdater updater;
    private AzureusCore azureus_core;
    GlobalManager globalManager;
    public static boolean isAlreadyDead;
    public static boolean isDisposeFromListener;
    private Display display;
    private Shell mainWindow;
    private MainMenu mainMenu;
    private IconBar iconBar;
    private boolean useCustomTab;
    private Composite folder;
    private UpdateWindow updateWindow;
    private Composite statusArea;
    StackLayout layoutStatusAera;
    private CLabel statusText;
    private String statusTextKey = "";
    private Composite statusUpdate;
    private Label statusUpdateLabel;
    private ProgressBar statusUpdateProgressBar;
    CLabel ipBlocked;
    CLabel statusDown;
    CLabel statusUp;
    private TrayWindow tray;
    SystemTraySWT systemTraySWT;
    private HashMap downloadViews;
    private AEMonitor downloadViews_mon = new AEMonitor("MainWindow:dlviews");
    HashMap downloadBars;
    AEMonitor downloadBars_mon = new AEMonitor("MainWindow:dlbars");
    private Tab mytorrents;
    private Tab my_tracker_tab;
    private Tab my_shares_tab;
    private Tab stats_tab;
    private Tab console;
    private Tab config;
    private ArrayList update_stack = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("MainWindow");
    Map pluginTabs = new HashMap();

    static {
        isAlreadyDead = false;
        isDisposeFromListener = false;
    }

    public MainWindow(AzureusCore _azureus_core, Initializer _initializer) {
        try {
            LGLogger.log("MainWindow start");
            this.azureus_core = _azureus_core;
            this.globalManager = this.azureus_core.getGlobalManager();
            this.initializer = _initializer;
            this.display = SWTThread.getInstance().getDisplay();
            window = this;
            this.initializer.addListener(this);
            this.display.syncExec((Runnable)this);
        }
        catch (AzureusCoreException e) {
            Debug.printStackTrace(e);
        }
    }

    public void runSupport() {
        try {
            this.useCustomTab = COConfigurationManager.getBooleanParameter("useCustomTab");
            COConfigurationManager.addParameterListener("config.style.useSIUnits", this);
            this.mytorrents = null;
            this.my_tracker_tab = null;
            this.console = null;
            this.config = null;
            this.downloadViews = new HashMap();
            this.downloadBars = new HashMap();
            this.mainWindow = new Shell(this.display, 3280);
            this.mainWindow.setText("Azureus");
            if (!Constants.isOSX) {
                this.mainWindow.setImages(new Image[]{ImageRepository.getImage("azureus"), ImageRepository.getImage("azureus32"), ImageRepository.getImage("azureus64"), ImageRepository.getImage("azureus128")});
            }
            TorrentOpener.init(this.mainWindow, this.globalManager);
            this.mainMenu = new MainMenu(this);
            this.mainMenu.buildMenu(MessageText.getLocales());
            this.createDropTarget((Control)this.mainWindow);
            FormLayout mainLayout = new FormLayout();
            mainLayout.marginHeight = 0;
            mainLayout.marginWidth = 0;
            try {
                mainLayout.spacing = 0;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            this.mainWindow.setLayout((Layout)mainLayout);
            Label separator = new Label((Composite)this.mainWindow, 258);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            separator.setLayoutData((Object)formData);
            this.iconBar = new IconBar((Composite)this.mainWindow);
            this.iconBar.setCurrentEnabler(this);
            formData = new FormData();
            formData.top = new FormAttachment((Control)separator);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.iconBar.setLayoutData(formData);
            separator = new Label((Composite)this.mainWindow, 258);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.iconBar.getCoolBar());
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            separator.setLayoutData((Object)formData);
            this.folder = !this.useCustomTab ? new TabFolder((Composite)this.mainWindow, 512) : new CTabFolder((Composite)this.mainWindow, 0x800040);
            Tab.setFolder(this.folder);
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                        MainWindow.this.display.asyncExec((Runnable)new AERunnable(this, event){
                            final /* synthetic */ 7 this$1;
                            private final /* synthetic */ SelectionEvent val$event;
                            {
                                this.this$1 = var1_1;
                                this.val$event = selectionEvent;
                            }

                            public void runSupport() {
                                CTabItem item;
                                if (MainWindow.access$7(7.access$0(this.this$1)) && (item = (CTabItem)this.val$event.item) != null && !item.isDisposed() && !MainWindow.access$8(7.access$0(this.this$1)).isDisposed()) {
                                    try {
                                        ((CTabFolder)MainWindow.access$8(7.access$0(this.this$1))).setSelection(item);
                                        Control control = item.getControl();
                                        if (control != null) {
                                            control.setVisible(true);
                                            control.setFocus();
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                                MainWindow.access$9(7.access$0(this.this$1)).setCurrentEnabler(7.access$0(this.this$1));
                            }
                        });
                    }
                }

                static /* synthetic */ MainWindow access$0(7 var0) {
                    return var0.MainWindow.this;
                }
            };
            if (!this.useCustomTab) {
                Tab.addTabKeyListenerToComposite(this.folder);
                ((TabFolder)this.folder).addSelectionListener((SelectionListener)selectionAdapter);
            } else {
                try {
                    ((CTabFolder)this.folder).MIN_TAB_WIDTH = 75;
                }
                catch (Exception e) {
                    LGLogger.log(3, "Can't set MIN_TAB_WIDTH");
                    Debug.printStackTrace(e);
                }
                ((CTabFolder)this.folder).addCTabFolderListener((CTabFolderListener)new CTabFolderAdapter(){

                    public void itemClosed(CTabFolderEvent event) {
                        Tab.closed((Item)((CTabItem)event.item));
                        event.doit = true;
                        ((CTabItem)event.item).dispose();
                    }
                });
                ((CTabFolder)this.folder).addSelectionListener((SelectionListener)selectionAdapter);
                try {
                    ((CTabFolder)this.folder).setSelectionBackground(new Color[]{this.display.getSystemColor(25), this.display.getSystemColor(25), this.folder.getBackground()}, new int[]{10, 90}, true);
                }
                catch (NoSuchMethodError e) {
                    ((CTabFolder)this.folder).setSelectionBackground(new Color[]{this.display.getSystemColor(25)}, new int[0]);
                }
                ((CTabFolder)this.folder).setSelectionForeground(this.display.getSystemColor(24));
                try {
                    ((CTabFolder)this.folder).setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
            Composite statusBar = new Composite((Composite)this.mainWindow, 4);
            formData = new FormData();
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            statusBar.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment((Control)separator);
            formData.bottom = new FormAttachment((Control)statusBar);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.folder.setLayoutData((Object)formData);
            GridLayout layout_status = new GridLayout();
            layout_status.numColumns = 4;
            layout_status.horizontalSpacing = 1;
            layout_status.verticalSpacing = 0;
            layout_status.marginHeight = 0;
            layout_status.marginWidth = 0;
            statusBar.setLayout((Layout)layout_status);
            GridData gridData = new GridData(768);
            this.statusArea = new Composite(statusBar, 0);
            this.statusArea.setLayoutData((Object)gridData);
            this.layoutStatusAera = new StackLayout();
            this.statusArea.setLayout((Layout)this.layoutStatusAera);
            this.statusText = new CLabel(this.statusArea, 4);
            int height = this.statusText.computeSize((int)150, (int)-1).y;
            Listener listener = new Listener(){

                public void handleEvent(Event e) {
                    if (MainWindow.this.updateWindow != null) {
                        MainWindow.this.updateWindow.show();
                    }
                }
            };
            this.statusText.addListener(4, listener);
            this.statusText.addListener(8, listener);
            this.statusUpdate = new Composite(this.statusArea, 0);
            this.statusUpdate.setSize(-1, height);
            FormLayout layoutStatusUpdate = new FormLayout();
            layoutStatusUpdate.marginHeight = 0;
            layoutStatusUpdate.marginWidth = 0;
            try {
                layoutStatusUpdate.spacing = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            this.statusUpdate.setLayout((Layout)layoutStatusUpdate);
            this.statusUpdateLabel = new Label(this.statusUpdate, 0);
            Messages.setLanguageText((Widget)this.statusUpdateLabel, "MainWindow.statusText.checking");
            Messages.setLanguageText((Widget)this.statusUpdateLabel, "MainWindow.status.update.tooltip");
            this.statusUpdateLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    MainWindow.this.showUpdateProgressWindow();
                }
            });
            this.statusUpdateProgressBar = new ProgressBar(this.statusUpdate, 256);
            Messages.setLanguageText((Widget)this.statusUpdateProgressBar, "MainWindow.status.update.tooltip");
            this.statusUpdateProgressBar.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    MainWindow.this.showUpdateProgressWindow();
                }
            });
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            int ctrlHeight = this.statusUpdateLabel.computeSize((int)100, (int)-1).y;
            int top = (height - ctrlHeight) / 2;
            formData.top = new FormAttachment(0, top);
            formData.width = 150;
            formData.height = height;
            this.statusUpdateLabel.setLayoutData((Object)formData);
            formData = new FormData();
            formData.left = new FormAttachment((Control)this.statusUpdateLabel);
            formData.right = new FormAttachment(100, 0);
            ctrlHeight = this.statusUpdateProgressBar.computeSize((int)100, (int)-1).y;
            top = (height - ctrlHeight) / 2;
            formData.top = new FormAttachment(0, top);
            formData.height = height;
            this.statusUpdateProgressBar.setLayoutData((Object)formData);
            this.layoutStatusAera.topControl = this.statusText;
            gridData = new GridData();
            gridData.widthHint = Constants.isLinux ? 255 : 225;
            this.ipBlocked = new CLabel(statusBar, 4);
            this.ipBlocked.setText("{} IPs:");
            this.ipBlocked.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)this.ipBlocked, "MainWindow.IPs.tooltip");
            this.ipBlocked.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    BlockedIpsWindow.showBlockedIps(MainWindow.this.azureus_core, MainWindow.this.mainWindow);
                }
            });
            gridData = new GridData();
            gridData.widthHint = Constants.isOSX ? 150 : (Constants.isLinux ? 140 : 130);
            this.statusDown = new CLabel(statusBar, 4);
            this.statusDown.setText("n/a");
            this.statusDown.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)this.statusDown, "MainWindow.status.updowndetails.tooltip");
            Listener lStats = new Listener(){

                public void handleEvent(Event e) {
                    MainWindow.this.showStats();
                }
            };
            gridData = new GridData();
            gridData.widthHint = Constants.isOSX ? 150 : (Constants.isLinux ? 140 : 130);
            this.statusUp = new CLabel(statusBar, 4);
            this.statusUp.setText("n/a");
            this.statusUp.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)this.statusUp, "MainWindow.status.updowndetails.tooltip");
            this.statusDown.addListener(8, lStats);
            this.statusUp.addListener(8, lStats);
            final Menu menuUpSpeed = new Menu((Decorations)this.mainWindow, 8);
            menuUpSpeed.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    MenuItem[] items = menuUpSpeed.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    int upLimit = COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0);
                    MenuItem item = new MenuItem(menuUpSpeed, 16);
                    item.setText(MessageText.getString("ConfigView.unlimited"));
                    item.addListener(13, new Listener(this){
                        final /* synthetic */ 15 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void handleEvent(Event e) {
                            COConfigurationManager.setParameter("Max Upload Speed KBs", 0);
                            COConfigurationManager.save();
                        }
                    });
                    if (upLimit == 0) {
                        item.setSelection(true);
                    }
                    Listener speedChangeListener = new Listener(this){
                        final /* synthetic */ 15 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void handleEvent(Event e) {
                            int iSpeed = ((Long)((MenuItem)e.widget).getData("speed")).intValue();
                            COConfigurationManager.setParameter("Max Upload Speed KBs", iSpeed);
                            COConfigurationManager.save();
                        }
                    };
                    int iRel = 0;
                    int i2 = 0;
                    while (i2 < 12) {
                        int[] iAboveBelow = iRel == 0 ? new int[]{upLimit} : new int[]{upLimit - iRel, upLimit + iRel};
                        int j = 0;
                        while (j < iAboveBelow.length) {
                            if (iAboveBelow[j] >= 5) {
                                item = new MenuItem(menuUpSpeed, 16, j == 0 ? 1 : menuUpSpeed.getItemCount());
                                item.setText(String.valueOf(iAboveBelow[j]) + " KB/s");
                                item.setData("speed", (Object)new Long(iAboveBelow[j]));
                                item.addListener(13, speedChangeListener);
                                if (upLimit == iAboveBelow[j]) {
                                    item.setSelection(true);
                                }
                            }
                            ++j;
                        }
                        iRel += iRel >= 10 ? 10 : (iRel >= 6 ? 2 : 1);
                        ++i2;
                    }
                }
            });
            this.statusUp.setMenu(menuUpSpeed);
            final Menu menuDownSpeed = new Menu((Decorations)this.mainWindow, 8);
            menuDownSpeed.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    MenuItem[] items = menuDownSpeed.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    int downLimit = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0);
                    MenuItem item = new MenuItem(menuDownSpeed, 16);
                    item.setText(MessageText.getString("ConfigView.unlimited"));
                    item.addListener(13, new Listener(this){
                        final /* synthetic */ 18 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void handleEvent(Event e) {
                            COConfigurationManager.setParameter("Max Download Speed KBs", 0);
                            COConfigurationManager.save();
                        }
                    });
                    if (downLimit == 0) {
                        item.setSelection(true);
                    }
                    Listener speedChangeListener = new Listener(this){
                        final /* synthetic */ 18 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void handleEvent(Event e) {
                            int iSpeed = ((Long)((MenuItem)e.widget).getData("speed")).intValue();
                            COConfigurationManager.setParameter("Max Download Speed KBs", iSpeed);
                            COConfigurationManager.save();
                        }
                    };
                    int iRel = 0;
                    int i2 = 0;
                    while (i2 < 12) {
                        int[] iAboveBelow = iRel == 0 ? new int[]{downLimit} : new int[]{downLimit - iRel, downLimit + iRel};
                        int j = 0;
                        while (j < iAboveBelow.length) {
                            if (iAboveBelow[j] >= 5) {
                                item = new MenuItem(menuDownSpeed, 16, j == 0 ? 1 : menuDownSpeed.getItemCount());
                                item.setText(String.valueOf(iAboveBelow[j]) + " KB/s");
                                item.setData("speed", (Object)new Long(iAboveBelow[j]));
                                item.addListener(13, speedChangeListener);
                                if (downLimit == iAboveBelow[j]) {
                                    item.setSelection(true);
                                }
                            }
                            ++j;
                        }
                        iRel += iRel >= 10 ? 10 : (iRel >= 6 ? 2 : 1);
                        ++i2;
                    }
                }
            });
            this.statusDown.setMenu(menuDownSpeed);
            LGLogger.log("Initializing GUI complete");
            this.globalManager.addListener(this);
            boolean isMaximized = COConfigurationManager.getBooleanParameter("window.maximized", this.mainWindow.getMaximized());
            this.mainWindow.setMaximized(isMaximized);
            String windowRectangle = COConfigurationManager.getStringParameter("window.rectangle", null);
            if (windowRectangle != null) {
                int i = 0;
                int[] values = new int[4];
                StringTokenizer st = new StringTokenizer(windowRectangle, ",");
                try {
                    while (st.hasMoreTokens() && i < 4) {
                        values[i++] = Integer.valueOf(st.nextToken());
                        if (values[i - 1] >= 0) continue;
                        values[i - 1] = 0;
                    }
                    if (i == 4) {
                        this.mainWindow.setBounds(values[0], values[1], values[2], values[3]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mainWindow.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    if (!isAlreadyDead) {
                        isDisposeFromListener = true;
                        if (MainWindow.this.mainWindow != null) {
                            MainWindow.this.mainWindow.removeDisposeListener((DisposeListener)this);
                            MainWindow.this.dispose(false, false);
                        }
                        isAlreadyDead = true;
                    }
                }
            });
            this.mainWindow.layout();
            this.mainWindow.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent event) {
                    if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray", true)) {
                        MainWindow.this.minimizeToTray(event);
                    } else {
                        event.doit = MainWindow.this.dispose(false, false);
                    }
                }

                public void shellIconified(ShellEvent event) {
                    if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Minimize To Tray", false)) {
                        MainWindow.this.minimizeToTray(event);
                    }
                }
            });
            this.mainWindow.addListener(20, new Listener(){

                public void handleEvent(Event e) {
                    if (Constants.isOSX && COConfigurationManager.getBooleanParameter("Password enabled", false)) {
                        e.doit = false;
                        MainWindow.this.mainWindow.setVisible(false);
                        PasswordWindow.showPasswordWindow(MainWindow.this.display);
                    }
                }
            });
        }
        catch (Throwable e) {
            System.out.println("Initialize Error");
            Debug.printStackTrace(e);
        }
    }

    private void openMainWindow() {
        new ProgressWindow();
        this.addUpdateListener();
        if (this.azureus_core.getTrackerHost().getTorrents().length > 0) {
            this.showMyTracker();
        }
        this.showMyTorrents();
        if (COConfigurationManager.getBooleanParameter("Open Console", false)) {
            this.showConsole();
        }
        if (COConfigurationManager.getBooleanParameter("Open Config", false)) {
            this.showConfig();
        }
        if (COConfigurationManager.getBooleanParameter("Open Stats On Start", false)) {
            this.showStats();
        }
        this.mainWindow.open();
        this.mainWindow.forceActive();
        this.updater = new GUIUpdater(this.azureus_core, this);
        this.updater.start();
        if (COConfigurationManager.getBooleanParameter("Enable System Tray")) {
            try {
                this.systemTraySWT = new SystemTraySWT(this);
            }
            catch (Throwable e) {
                LGLogger.log(3, "Upgrade to SWT3.0M8 or later for system tray support.");
            }
            if (COConfigurationManager.getBooleanParameter("Start Minimized", false)) {
                this.minimizeToTray(null);
            } else if (COConfigurationManager.getBooleanParameter("Password enabled", false)) {
                this.minimizeToTray(null);
                PasswordWindow.showPasswordWindow(this.display);
            }
        }
        this.azureus_core.getPluginManager().firePluginEvent(1);
        if (!COConfigurationManager.getBooleanParameter("Wizard Completed", false)) {
            ConfigureWizard wizard = new ConfigureWizard(this.getAzureusCore(), this.display);
            wizard.addListener(new WizardListener(){

                public void closed() {
                    MainWindow.this.azureus_core.getPluginManager().firePluginEvent(2);
                }
            });
        } else {
            this.azureus_core.getPluginManager().firePluginEvent(2);
        }
        if (COConfigurationManager.getBooleanParameter("Show Download Basket", false)) {
            if (this.tray == null) {
                this.tray = new TrayWindow(this);
            }
            this.tray.setVisible(true);
        }
        COConfigurationManager.addParameterListener("Show Download Basket", this);
        COConfigurationManager.addParameterListener("GUI_SWT_bFancyTab", this);
        Tab.addTabKeyListenerToComposite(this.folder);
        DonationWindow2.checkForDonationPopup();
    }

    public void showMyTracker() {
        if (this.my_tracker_tab == null) {
            this.my_tracker_tab = new Tab(new MyTrackerView(this.azureus_core));
        } else {
            this.my_tracker_tab.setFocus();
            this.refreshIconBar();
        }
    }

    public void showMyShares() {
        if (this.my_shares_tab == null) {
            this.my_shares_tab = new Tab(new MySharesView(this.azureus_core));
        } else {
            this.my_shares_tab.setFocus();
            this.refreshIconBar();
        }
    }

    public void showMyTorrents() {
        if (this.mytorrents == null) {
            this.mytorrents = new Tab(new MyTorrentsSuperView(this.azureus_core));
        } else {
            this.mytorrents.setFocus();
        }
        this.refreshIconBar();
    }

    private void minimizeToTray(ShellEvent event) {
        if (event != null) {
            event.doit = false;
        }
        if (Constants.isOSX) {
            this.mainWindow.setMinimized(true);
        } else {
            this.mainWindow.setVisible(false);
        }
        if (this.tray != null) {
            this.tray.setVisible(true);
        }
        try {
            this.downloadBars_mon.enter();
            Iterator iter = this.downloadBars.values().iterator();
            while (iter.hasNext()) {
                MinimizedWindow mw = (MinimizedWindow)iter.next();
                mw.setVisible(true);
            }
        }
        finally {
            this.downloadBars_mon.exit();
        }
    }

    public void setStatusText(String keyedSentence) {
        this.statusTextKey = keyedSentence == null ? "" : keyedSentence;
        this.updateStatusText();
    }

    private void updateStatusText() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        final String text = this.updateWindow != null ? String.valueOf(this.statusTextKey) + " MainWindow.updateavail" : this.statusTextKey;
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (MainWindow.this.statusText != null && !MainWindow.this.statusText.isDisposed()) {
                    MainWindow.this.statusText.setText(MessageText.getStringForSentence(text));
                }
            }
        });
    }

    private void updateComponents() {
        if (this.statusText != null) {
            this.statusText.update();
        }
        if (this.folder != null) {
            if (this.useCustomTab) {
                ((CTabFolder)this.folder).update();
            } else {
                ((TabFolder)this.folder).update();
            }
        }
    }

    public void closeDownloadBars() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                try {
                    MainWindow.this.downloadBars_mon.enter();
                    Iterator iter = MainWindow.this.downloadBars.keySet().iterator();
                    while (iter.hasNext()) {
                        DownloadManager dm = (DownloadManager)iter.next();
                        MinimizedWindow mw = (MinimizedWindow)MainWindow.this.downloadBars.get(dm);
                        mw.close();
                        iter.remove();
                    }
                }
                finally {
                    MainWindow.this.downloadBars_mon.exit();
                }
            }
        });
    }

    private void createDropTarget(Control control) {
        DropTarget dropTarget = new DropTarget(control, 23);
        dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                if (URLTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    event.detail = 4;
                }
            }

            public void drop(DropTargetEvent event) {
                TorrentOpener.openDroppedTorrents(MainWindow.this.azureus_core, event);
            }
        });
    }

    public void destroyed() {
    }

    public void destroyInitiated() {
    }

    public void downloadManagerAdded(DownloadManager created) {
        DonationWindow2.checkForDonationPopup();
        created.addListener(this);
    }

    public void openManagerView(DownloadManager downloadManager) {
        try {
            this.downloadViews_mon.enter();
            if (this.downloadViews.containsKey(downloadManager)) {
                Tab tab = (Tab)this.downloadViews.get(downloadManager);
                tab.setFocus();
                this.refreshIconBar();
            } else {
                Tab tab = new Tab(new ManagerView(this.azureus_core, downloadManager));
                this.downloadViews.put(downloadManager, tab);
            }
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    public void removeManagerView(DownloadManager downloadManager) {
        try {
            this.downloadViews_mon.enter();
            this.downloadViews.remove(downloadManager);
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    public void downloadManagerRemoved(DownloadManager removed) {
        try {
            this.downloadViews_mon.enter();
            if (this.downloadViews.containsKey(removed)) {
                final Tab tab = (Tab)this.downloadViews.get(removed);
                if (this.display == null || this.display.isDisposed()) {
                    this.downloadViews_mon.exit();
                    return;
                }
                this.display.asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        tab.dispose();
                    }
                });
            }
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public Shell getShell() {
        return this.mainWindow;
    }

    public void setVisible(boolean visible) {
        this.mainWindow.setVisible(visible);
        if (visible) {
            if (this.tray != null) {
                this.tray.setVisible(false);
            }
            this.mainWindow.forceActive();
            this.mainWindow.setMinimized(false);
        }
    }

    public boolean isVisible() {
        return this.mainWindow.isVisible();
    }

    public boolean dispose(boolean for_restart, boolean close_already_in_progress) {
        if (COConfigurationManager.getBooleanParameter("confirmationOnExit", false) && !this.getExitConfirmation(for_restart)) {
            return false;
        }
        if (this.systemTraySWT != null) {
            this.systemTraySWT.dispose();
        }
        Tab.closeAllTabs();
        isAlreadyDead = true;
        if (this.updater != null) {
            this.updater.stopIt();
        }
        COConfigurationManager.setParameter("window.maximized", this.mainWindow.getMaximized());
        if (this.mainWindow.getMaximized()) {
            this.mainWindow.setMaximized(false);
        }
        Rectangle windowRectangle = this.mainWindow.getBounds();
        COConfigurationManager.setParameter("window.rectangle", String.valueOf(windowRectangle.x) + "," + windowRectangle.y + "," + windowRectangle.width + "," + windowRectangle.height);
        COConfigurationManager.save();
        this.initializer.stopIt(for_restart, close_already_in_progress);
        if (!this.mainWindow.isDisposed() && !isDisposeFromListener) {
            this.mainWindow.dispose();
        }
        COConfigurationManager.removeParameterListener("config.style.useSIUnits", this);
        COConfigurationManager.removeParameterListener("Show Download Basket", this);
        COConfigurationManager.removeParameterListener("GUI_SWT_bFancyTab", this);
        if (SystemProperties.isJavaWebStartInstance()) {
            AEThread close = new AEThread("JWS Force Terminate"){

                public void runSupport() {
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    SESecurityManager.exitVM(1);
                }
            };
            close.setDaemon(true);
            close.start();
        }
        return true;
    }

    private boolean getExitConfirmation(boolean for_restart) {
        MessageBox mb = new MessageBox(this.mainWindow, 200);
        mb.setText(MessageText.getString(for_restart ? "MainWindow.dialog.restartconfirmation.title" : "MainWindow.dialog.exitconfirmation.title"));
        mb.setMessage(MessageText.getString(for_restart ? "MainWindow.dialog.restartconfirmation.text" : "MainWindow.dialog.exitconfirmation.text"));
        return mb.open() == 64;
    }

    public GlobalManager getGlobalManager() {
        return this.globalManager;
    }

    public Tab getConsole() {
        return this.console;
    }

    public Tab getMytorrents() {
        return this.mytorrents;
    }

    public Tab getMyTracker() {
        return this.my_tracker_tab;
    }

    public void setConsole(Tab tab) {
        this.console = tab;
    }

    public void setMytorrents(Tab tab) {
        this.mytorrents = tab;
    }

    public void setMyTracker(Tab tab) {
        this.my_tracker_tab = tab;
    }

    public void setMyShares(Tab tab) {
        this.my_shares_tab = tab;
    }

    public static MainWindow getWindow() {
        return window;
    }

    public HashMap getDownloadBars() {
        return this.downloadBars;
    }

    public Tab getConfig() {
        return this.config;
    }

    public void setConfig(Tab tab) {
        this.config = tab;
    }

    public Tab getStats() {
        return this.stats_tab;
    }

    public void setStats(Tab tab) {
        this.stats_tab = tab;
    }

    public TrayWindow getTray() {
        return this.tray;
    }

    public boolean isUseCustomTab() {
        return this.useCustomTab;
    }

    public void openPluginView(PluginView view) {
        Tab tab = (Tab)this.pluginTabs.get(view.getPluginViewName());
        if (tab != null) {
            tab.setFocus();
        } else {
            tab = new Tab(view);
            this.pluginTabs.put(view.getPluginViewName(), tab);
        }
    }

    public void removeActivePluginView(PluginView view) {
        this.pluginTabs.remove(view.getPluginViewName());
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Show Download Basket")) {
            if (COConfigurationManager.getBooleanParameter("Show Download Basket")) {
                if (this.tray == null) {
                    this.tray = new TrayWindow(this);
                    this.tray.setVisible(true);
                }
            } else if (this.tray != null) {
                this.tray.setVisible(false);
                this.tray = null;
            }
        }
        if (parameterName.equals("GUI_SWT_bFancyTab") && this.folder instanceof CTabFolder && this.folder != null && !this.folder.isDisposed()) {
            try {
                ((CTabFolder)this.folder).setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (parameterName.equals("config.style.useSIUnits")) {
            this.updateComponents();
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("open")) {
            return true;
        }
        if (itemKey.equals("open_no_default")) {
            return true;
        }
        if (itemKey.equals("open_url")) {
            return true;
        }
        if (itemKey.equals("open_folder")) {
            return true;
        }
        if (itemKey.equals("new")) {
            return true;
        }
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            return currentView.isEnabled(itemKey);
        }
        return false;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("open")) {
            TorrentOpener.openTorrent();
            return;
        }
        if (itemKey.equals("open_no_default")) {
            TorrentOpener.openTorrentNoDefaultSave(false);
            return;
        }
        if (itemKey.equals("open_for_seeding")) {
            TorrentOpener.openTorrentNoDefaultSave(true);
            return;
        }
        if (itemKey.equals("open_url")) {
            TorrentOpener.openUrl(this.azureus_core);
            return;
        }
        if (itemKey.equals("open_folder")) {
            TorrentOpener.openDirectory();
            return;
        }
        if (itemKey.equals("new")) {
            new NewTorrentWizard(this.getAzureusCore(), this.display);
            return;
        }
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            currentView.itemActivated(itemKey);
        }
    }

    IView getCurrentView() {
        try {
            if (!this.useCustomTab) {
                TabItem[] selection = ((TabFolder)this.folder).getSelection();
                if (selection.length > 0) {
                    return Tab.getView((Item)selection[0]);
                }
                return null;
            }
            return Tab.getView((Item)((CTabFolder)this.folder).getSelection());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void refreshIconBar() {
        this.iconBar.setCurrentEnabler(this);
    }

    public void showConfig() {
        if (this.config == null) {
            this.config = new Tab(new ConfigView(this.azureus_core));
        } else {
            this.config.setFocus();
        }
    }

    public void showConsole() {
        if (this.console == null) {
            this.console = new Tab(new ConsoleView());
        } else {
            this.console.setFocus();
        }
    }

    public void showStats() {
        if (this.stats_tab == null) {
            this.stats_tab = new Tab(new StatsView(this.globalManager));
        } else {
            this.stats_tab.setFocus();
        }
    }

    public void setSelectedLanguageItem() {
        try {
            this.this_mon.enter();
            Messages.updateLanguageForControl((Widget)this.mainWindow.getShell());
            if (this.systemTraySWT != null) {
                Messages.updateLanguageForControl((Widget)this.systemTraySWT.getMenu());
            }
            if (this.statusText != null) {
                this.statusText.update();
            }
            if (this.folder != null) {
                if (this.useCustomTab) {
                    ((CTabFolder)this.folder).update();
                } else {
                    ((TabFolder)this.folder).update();
                }
            }
            if (this.tray != null) {
                this.tray.updateLanguage();
            }
            Tab.updateLanguage();
            this.setStatusText(this.statusTextKey);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public MainMenu getMenu() {
        return this.mainMenu;
    }

    public void reportCurrentTask(String task) {
    }

    public void reportPercent(int percent) {
        if (percent > 100) {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    MainWindow.this.openMainWindow();
                }
            });
        }
    }

    public void setUpdateNeeded(UpdateWindow updateWindow) {
        this.updateWindow = updateWindow;
        if (updateWindow != null) {
            this.statusText.setCursor(Cursors.handCursor);
            this.statusText.setForeground(Colors.colorWarning);
            this.updateStatusText();
        } else {
            this.statusText.setCursor(null);
            this.statusText.setForeground(null);
            this.updateStatusText();
        }
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    public void downloadComplete(DownloadManager manager) {
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public void stateChanged(final DownloadManager manager, int state) {
        if (!(state != 50 && state != 60 || this.display == null || this.display.isDisposed())) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (COConfigurationManager.getBooleanParameter("Open Details", false)) {
                        MainWindow.this.openManagerView(manager);
                    }
                    if (COConfigurationManager.getBooleanParameter("Open Bar", false)) {
                        try {
                            MainWindow.this.downloadBars_mon.enter();
                            if (MainWindow.this.downloadBars.get(manager) == null) {
                                MinimizedWindow mw = new MinimizedWindow(manager, MainWindow.this.mainWindow);
                                MainWindow.this.downloadBars.put(manager, mw);
                            }
                        }
                        finally {
                            MainWindow.this.downloadBars_mon.exit();
                        }
                    }
                }
            });
        }
    }

    public AzureusCore getAzureusCore() {
        return this.azureus_core;
    }

    private void addUpdateListener() {
        this.azureus_core.getPluginManager().getDefaultPluginInterface().getUpdateManager().addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance instance) {
                new updateStatusChanger(instance);
            }
        });
    }

    protected void showUpdateProgressWindow() {
        try {
            this.this_mon.enter();
            UpdateCheckInstance[] instances = new UpdateCheckInstance[this.update_stack.size()];
            int i = 0;
            while (i < instances.length) {
                instances[i] = ((updateStatusChanger)this.update_stack.get(i)).getInstance();
                ++i;
            }
            UpdateProgressWindow.show(instances, this.getShell());
        }
        finally {
            this.this_mon.exit();
        }
    }

    static /* synthetic */ ProgressBar access$2(MainWindow mainWindow) {
        return mainWindow.statusUpdateProgressBar;
    }

    static /* synthetic */ Composite access$3(MainWindow mainWindow) {
        return mainWindow.statusArea;
    }

    static /* synthetic */ Label access$4(MainWindow mainWindow) {
        return mainWindow.statusUpdateLabel;
    }

    static /* synthetic */ Composite access$5(MainWindow mainWindow) {
        return mainWindow.statusUpdate;
    }

    static /* synthetic */ boolean access$7(MainWindow mainWindow) {
        return mainWindow.useCustomTab;
    }

    static /* synthetic */ Composite access$8(MainWindow mainWindow) {
        return mainWindow.folder;
    }

    static /* synthetic */ IconBar access$9(MainWindow mainWindow) {
        return mainWindow.iconBar;
    }

    protected class updateStatusChanger {
        UpdateCheckInstance instance;
        int check_num = 0;
        boolean active;

        protected updateStatusChanger(UpdateCheckInstance _instance) {
            this.instance = _instance;
            try {
                MainWindow.this.this_mon.enter();
                MainWindow.this.update_stack.add(this);
                this.instance.addListener(new UpdateCheckInstanceListener(this){
                    final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = updateStatusChanger2;
                    }

                    public void cancelled(UpdateCheckInstance instance) {
                        updateStatusChanger.access$0(this.this$1);
                    }

                    public void complete(UpdateCheckInstance instance) {
                        updateStatusChanger.access$0(this.this$1);
                    }
                });
                UpdateChecker[] checkers = this.instance.getCheckers();
                UpdateCheckerListener listener = new UpdateCheckerListener(this){
                    final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = updateStatusChanger2;
                    }

                    public void cancelled(UpdateChecker checker) {
                    }

                    public void completed(UpdateChecker checker) {
                        updateStatusChanger.access$1(this.this$1);
                    }

                    public void failed(UpdateChecker checker) {
                        updateStatusChanger.access$1(this.this$1);
                    }
                };
                int i = 0;
                while (i < checkers.length) {
                    checkers[i].addListener(listener);
                    ++i;
                }
                this.activate();
            }
            finally {
                MainWindow.this.this_mon.exit();
            }
        }

        protected UpdateCheckInstance getInstance() {
            return this.instance;
        }

        private void activate() {
            try {
                MainWindow.this.this_mon.enter();
                this.active = true;
                this.switchStatusToUpdate();
                this.setNbChecks(this.instance.getCheckers().length);
            }
            finally {
                MainWindow.this.this_mon.exit();
            }
        }

        private void deactivate() {
            try {
                MainWindow.this.this_mon.enter();
                this.active = false;
                int i = 0;
                while (i < MainWindow.this.update_stack.size()) {
                    if (MainWindow.this.update_stack.get(i) == this) {
                        MainWindow.this.update_stack.remove(i);
                        break;
                    }
                    ++i;
                }
                if (MainWindow.this.update_stack.size() == 0) {
                    this.switchStatusToText();
                } else {
                    ((updateStatusChanger)MainWindow.this.update_stack.get(MainWindow.this.update_stack.size() - 1)).activate();
                }
            }
            finally {
                MainWindow.this.this_mon.exit();
            }
        }

        private void setNbChecks(int nbChecks) {
            if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                MainWindow.this.display.asyncExec((Runnable)new AERunnable(this, nbChecks){
                    final /* synthetic */ updateStatusChanger this$1;
                    private final /* synthetic */ int val$nbChecks;
                    {
                        this.this$1 = updateStatusChanger2;
                        this.val$nbChecks = n;
                    }

                    public void runSupport() {
                        if (MainWindow.access$2(updateStatusChanger.access$2(this.this$1)) == null || MainWindow.access$2(updateStatusChanger.access$2(this.this$1)).isDisposed()) {
                            return;
                        }
                        MainWindow.access$2(updateStatusChanger.access$2(this.this$1)).setMinimum(0);
                        MainWindow.access$2(updateStatusChanger.access$2(this.this$1)).setMaximum(this.val$nbChecks);
                        MainWindow.access$2(updateStatusChanger.access$2(this.this$1)).setSelection(this.this$1.check_num);
                    }
                });
            }
        }

        private void setNextCheck() {
            if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                MainWindow.this.display.asyncExec((Runnable)new AERunnable(this){
                    final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = updateStatusChanger2;
                    }

                    public void runSupport() {
                        if (MainWindow.access$2(updateStatusChanger.access$2(this.this$1)) == null || MainWindow.access$2(updateStatusChanger.access$2(this.this$1)).isDisposed()) {
                            return;
                        }
                        ++this.this$1.check_num;
                        if (this.this$1.active) {
                            MainWindow.access$2(updateStatusChanger.access$2(this.this$1)).setSelection(this.this$1.check_num);
                        }
                    }
                });
            }
        }

        private void switchStatusToUpdate() {
            if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                MainWindow.this.display.asyncExec((Runnable)new AERunnable(this){
                    final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = updateStatusChanger2;
                    }

                    public void runSupport() {
                        if (MainWindow.access$3(updateStatusChanger.access$2(this.this$1)) == null || MainWindow.access$3(updateStatusChanger.access$2(this.this$1)).isDisposed()) {
                            return;
                        }
                        String name = this.this$1.instance.getName();
                        if (MessageText.keyExists(name)) {
                            name = MessageText.getString(name);
                        }
                        MainWindow.access$4(updateStatusChanger.access$2(this.this$1)).setText(name);
                        updateStatusChanger.access$2((updateStatusChanger)this.this$1).layoutStatusAera.topControl = MainWindow.access$5(updateStatusChanger.access$2(this.this$1));
                        MainWindow.access$3(updateStatusChanger.access$2(this.this$1)).layout();
                    }
                });
            }
        }

        private void switchStatusToText() {
            if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                MainWindow.this.display.asyncExec((Runnable)new AERunnable(this){
                    final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = updateStatusChanger2;
                    }

                    public void runSupport() {
                        if (MainWindow.access$3(updateStatusChanger.access$2(this.this$1)) == null || MainWindow.access$3(updateStatusChanger.access$2(this.this$1)).isDisposed()) {
                            return;
                        }
                        updateStatusChanger.access$2((updateStatusChanger)this.this$1).layoutStatusAera.topControl = MainWindow.access$6(updateStatusChanger.access$2(this.this$1));
                        MainWindow.access$3(updateStatusChanger.access$2(this.this$1)).layout();
                    }
                });
            }
        }

        static /* synthetic */ void access$0(updateStatusChanger updateStatusChanger2) {
            updateStatusChanger2.deactivate();
        }

        static /* synthetic */ void access$1(updateStatusChanger updateStatusChanger2) {
            updateStatusChanger2.setNextCheck();
        }

        static /* synthetic */ MainWindow access$2(updateStatusChanger updateStatusChanger2) {
            return updateStatusChanger2.MainWindow.this;
        }
    }
}

