/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.update;

import com.aelitis.azureus.core.AzureusCore;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class UpdateWindow
extends AERunnable
implements ResourceDownloaderListener {
    private AzureusCore azureus_core;
    private UpdateCheckInstance check_instance;
    private int check_type;
    Display display;
    Shell updateWindow;
    Table table;
    StyledText stDescription;
    ProgressBar progress;
    Label status;
    Button btnOk;
    Listener lOk;
    Button btnCancel;
    Listener lCancel;
    boolean askingForShow;
    boolean restartRequired;
    private long totalDownloadSize;
    private List downloaders;
    private Iterator iterDownloaders;
    private static final int COL_NAME = 0;
    private static final int COL_VERSION = 1;
    private static final int COL_SIZE = 2;
    private Map downloadersToData;

    public UpdateWindow(AzureusCore _azureus_core, UpdateCheckInstance _check_instance) {
        this.azureus_core = _azureus_core;
        this.check_instance = _check_instance;
        this.check_type = this.check_instance.getType();
        this.display = SWTThread.getInstance().getDisplay();
        this.updateWindow = null;
        this.askingForShow = false;
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)this);
        }
    }

    public void runSupport() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.updateWindow = new Shell(this.display, 2160);
        this.updateWindow.addListener(21, new Listener(){

            public void handleEvent(Event e) {
                e.doit = false;
            }
        });
        if (!Constants.isOSX) {
            this.updateWindow.setImage(ImageRepository.getImage("azureus"));
        }
        String res_prefix = "swt.";
        res_prefix = this.check_type == 1 ? String.valueOf(res_prefix) + "install.window" : (this.check_type == 3 ? String.valueOf(res_prefix) + "uninstall.window" : String.valueOf(res_prefix) + "update.window");
        Messages.setLanguageText((Widget)this.updateWindow, String.valueOf(res_prefix) + ".title");
        FormLayout layout = new FormLayout();
        try {
            layout.spacing = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.updateWindow.setLayout((Layout)layout);
        Label lHeaderText = new Label((Composite)this.updateWindow, 64);
        Messages.setLanguageText((Widget)lHeaderText, String.valueOf(res_prefix) + ".header");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        lHeaderText.setLayoutData((Object)formData);
        SashForm sash = new SashForm((Composite)this.updateWindow, 512);
        this.table = new Table((Composite)sash, 67620);
        String[] names = new String[]{"name", "version", "size"};
        int[] sizes = new int[]{220, 80, 80};
        int i = 0;
        while (i < names.length) {
            TableColumn column = new TableColumn(this.table, 16384);
            Messages.setLanguageText((Widget)column, "swt.update.window.columns." + names[i]);
            column.setWidth(sizes[i]);
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UpdateWindow.this.rowSelected();
            }
        });
        this.stDescription = new StyledText((Composite)sash, 2824);
        this.stDescription.setWordWrap(true);
        this.progress = new ProgressBar((Composite)this.updateWindow, 0);
        this.progress.setMinimum(0);
        this.progress.setMaximum(100);
        this.progress.setSelection(0);
        this.status = new Label((Composite)this.updateWindow, 0);
        this.btnOk = new Button((Composite)this.updateWindow, 8);
        Messages.setLanguageText((Widget)this.btnOk, String.valueOf(res_prefix) + ".ok");
        this.updateWindow.setDefaultButton(this.btnOk);
        this.lOk = new Listener(){

            public void handleEvent(Event e) {
                UpdateWindow.this.update();
            }
        };
        this.btnOk.addListener(13, this.lOk);
        this.btnOk.setEnabled(false);
        this.btnCancel = new Button((Composite)this.updateWindow, 8);
        Messages.setLanguageText((Widget)this.btnCancel, "swt.update.window.cancel");
        this.lCancel = new Listener(){

            public void handleEvent(Event e) {
                UpdateWindow.this.dispose();
                UpdateWindow.this.check_instance.cancel();
            }
        };
        this.btnCancel.addListener(13, this.lCancel);
        this.updateWindow.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    UpdateWindow.this.dispose();
                    UpdateWindow.this.check_instance.cancel();
                }
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)lHeaderText);
        formData.bottom = new FormAttachment((Control)this.progress);
        sash.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)this.status);
        this.progress.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)this.btnCancel);
        this.status.setLayoutData((Object)formData);
        formData = new FormData();
        formData.width = 100;
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.btnCancel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.width = 100;
        formData.right = new FormAttachment((Control)this.btnCancel);
        formData.bottom = new FormAttachment(100, 0);
        this.btnOk.setLayoutData((Object)formData);
        this.updateWindow.setSize(400, 400);
    }

    protected void rowSelected() {
        this.checkMandatory();
        this.checkRestartNeeded();
        TableItem[] items = this.table.getSelection();
        if (items.length == 0) {
            return;
        }
        Update update = (Update)items[0].getData();
        String[] descriptions = update.getDescription();
        this.stDescription.setText("");
        int i = 0;
        while (i < descriptions.length) {
            this.stDescription.append(String.valueOf(descriptions[i]) + "\n");
            ++i;
        }
    }

    public void dispose() {
        this.updateWindow.dispose();
        MainWindow.getWindow().setUpdateNeeded(null);
    }

    public void addUpdate(final Update update) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (UpdateWindow.this.table == null || UpdateWindow.this.table.isDisposed()) {
                    return;
                }
                TableItem item = new TableItem(UpdateWindow.this.table, 0);
                item.setData((Object)update);
                item.setText(0, update.getName());
                item.setText(1, update.getNewVersion());
                ResourceDownloader[] rds = update.getDownloaders();
                long totalLength = 0L;
                int i = 0;
                while (i < rds.length) {
                    try {
                        totalLength += rds[i].getSize();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                item.setText(2, DisplayFormatters.formatByteCountToBase10KBEtc(totalLength));
                item.setChecked(true);
                if (UpdateWindow.this.table.getItemCount() == 1) {
                    UpdateWindow.this.table.select(0);
                    UpdateWindow.this.rowSelected();
                }
                UpdateWindow.this.checkRestartNeeded();
                if (COConfigurationManager.getBooleanParameter("update.opendialog") || UpdateWindow.this.check_instance.getType() != 2) {
                    UpdateWindow.this.show();
                } else {
                    MainWindow.getWindow().setUpdateNeeded(UpdateWindow.this);
                }
            }
        });
    }

    protected void updateAdditionComplete() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (UpdateWindow.this.btnOk == null || UpdateWindow.this.btnOk.isDisposed()) {
                    return;
                }
                UpdateWindow.this.btnOk.setEnabled(true);
            }
        });
    }

    public void show() {
        if (this.updateWindow == null || this.updateWindow.isDisposed()) {
            return;
        }
        this.updateWindow.open();
        this.updateWindow.forceActive();
    }

    private void checkMandatory() {
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            Update update = (Update)items[i].getData();
            if (update.isMandatory()) {
                items[i].setChecked(true);
            }
            ++i;
        }
    }

    private void checkRestartNeeded() {
        this.restartRequired = false;
        boolean restartMaybeRequired = false;
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                Update update = (Update)items[i].getData();
                int required = update.getRestartRequired();
                if (required == 3) {
                    restartMaybeRequired = true;
                } else if (required == 2) {
                    this.restartRequired = true;
                }
            }
            ++i;
        }
        if (this.restartRequired) {
            this.status.setText(MessageText.getString("swt.update.window.status.restartNeeded"));
        } else if (restartMaybeRequired) {
            this.status.setText(MessageText.getString("swt.update.window.status.restartMaybeNeeded"));
        } else {
            this.status.setText("");
        }
    }

    private void update() {
        this.btnOk.setEnabled(false);
        Messages.setLanguageText((Widget)this.btnCancel, "swt.update.window.cancel");
        this.table.setEnabled(false);
        this.stDescription.setText("");
        TableItem[] items = this.table.getItems();
        this.totalDownloadSize = 0L;
        this.downloaders = new ArrayList();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                Update update = (Update)items[i].getData();
                ResourceDownloader[] rds = update.getDownloaders();
                int j = 0;
                while (j < rds.length) {
                    this.downloaders.add(rds[j]);
                    try {
                        this.totalDownloadSize += rds[j].getSize();
                    }
                    catch (Exception e) {
                        this.stDescription.append(String.valueOf(MessageText.getString("swt.update.window.no_size")) + rds[j].getName() + "\n");
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.downloadersToData = new HashMap();
        this.iterDownloaders = this.downloaders.iterator();
        this.nextUpdate();
    }

    private void nextUpdate() {
        if (this.iterDownloaders.hasNext()) {
            ResourceDownloader downloader = (ResourceDownloader)this.iterDownloaders.next();
            downloader.addListener(this);
            downloader.asyncDownload();
        } else {
            this.switchToRestart();
        }
    }

    private void switchToRestart() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                UpdateWindow.this.checkRestartNeeded();
                UpdateWindow.this.progress.setSelection(100);
                UpdateWindow.this.status.setText(MessageText.getString("swt.update.window.status.done"));
                UpdateWindow.this.btnOk.removeListener(13, UpdateWindow.this.lOk);
                UpdateWindow.this.btnOk.setEnabled(true);
                UpdateWindow.this.btnOk.addListener(13, new Listener(this){
                    final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void handleEvent(Event e) {
                        UpdateWindow.access$3(8.access$0(this.this$1), true);
                    }
                });
                if (UpdateWindow.this.restartRequired) {
                    ((FormData)UpdateWindow.this.btnOk.getLayoutData()).width = 150;
                    ((FormData)UpdateWindow.this.btnCancel.getLayoutData()).width = 150;
                    UpdateWindow.this.updateWindow.layout();
                    Messages.setLanguageText((Widget)UpdateWindow.this.btnOk, "swt.update.window.restart");
                    UpdateWindow.this.btnCancel.removeListener(13, UpdateWindow.this.lCancel);
                    Messages.setLanguageText((Widget)UpdateWindow.this.btnCancel, "swt.update.window.restartLater");
                    UpdateWindow.this.btnCancel.addListener(13, new Listener(this){
                        final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void handleEvent(Event e) {
                            UpdateWindow.access$3(8.access$0(this.this$1), false);
                        }
                    });
                } else {
                    Messages.setLanguageText((Widget)UpdateWindow.this.btnOk, "swt.update.window.close");
                    UpdateWindow.this.btnCancel.setEnabled(false);
                }
            }

            static /* synthetic */ UpdateWindow access$0(8 var0) {
                return var0.UpdateWindow.this;
            }
        });
    }

    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
        this.setProgressSelection(percentage);
    }

    private void setProgressSelection(final int percent) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (UpdateWindow.this.progress != null && !UpdateWindow.this.progress.isDisposed()) {
                    UpdateWindow.this.progress.setSelection(percent);
                }
            }
        });
    }

    public boolean completed(ResourceDownloader downloader, InputStream data) {
        this.downloadersToData.put(downloader, data);
        downloader.removeListener(this);
        this.setProgressSelection(0);
        this.nextUpdate();
        return true;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        downloader.removeListener(this);
        this.setStatusText(MessageText.getString("swt.update.window.status.failed"));
        String msg = String.valueOf(downloader.getName()) + " : " + e;
        if (e.getCause() != null) {
            msg = String.valueOf(msg) + " [" + e.getCause() + "]";
        }
        this.appendDetails(msg);
    }

    public void reportActivity(ResourceDownloader downloader, String activity) {
        this.setStatusText(activity.trim());
        this.appendDetails(activity);
    }

    private void setStatusText(final String text) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (UpdateWindow.this.status != null && !UpdateWindow.this.status.isDisposed()) {
                    UpdateWindow.this.status.setText(text);
                }
            }
        });
    }

    private void appendDetails(final String text) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (UpdateWindow.this.stDescription != null && !UpdateWindow.this.stDescription.isDisposed()) {
                    UpdateWindow.this.stDescription.append(String.valueOf(text) + "\n");
                }
            }
        });
    }

    private void finishUpdate(boolean restartNow) {
        MainWindow.getWindow().setUpdateNeeded(null);
        if (this.restartRequired && restartNow) {
            if (!MainWindow.getWindow().dispose(true, false)) {
                this.updateWindow.dispose();
            }
        } else {
            this.updateWindow.dispose();
        }
    }

    protected boolean isDisposed() {
        return this.display == null || this.display.isDisposed() || this.updateWindow == null || this.updateWindow.isDisposed();
    }

    static /* synthetic */ void access$3(UpdateWindow updateWindow, boolean bl) {
        updateWindow.finishUpdate(bl);
    }
}

