/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.updater2;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.ui.swt.updater2.SWTVersionGetter;

public class SWTUpdateChecker
implements UpdatableComponent {
    public static void initialize() {
        PluginInitializer.getDefaultInterface().getUpdateManager().registerUpdatableComponent(new SWTUpdateChecker(), true);
    }

    public void checkForUpdate(final UpdateChecker checker) {
        block10: {
            try {
                try {
                    SWTVersionGetter versionGetter = new SWTVersionGetter(checker);
                    if (!versionGetter.needsUpdate() || System.getProperty("azureus.skipSWTcheck") != null) break block10;
                    String[] mirrors = versionGetter.getMirrors();
                    ResourceDownloader swtDownloader = null;
                    ResourceDownloaderFactory factory = ResourceDownloaderFactoryImpl.getSingleton();
                    ArrayList<ResourceDownloader> downloaders = new ArrayList<ResourceDownloader>();
                    int i = 0;
                    while (i < mirrors.length) {
                        try {
                            downloaders.add(factory.getSuffixBasedDownloader(factory.create(new URL(mirrors[i]))));
                        }
                        catch (MalformedURLException e) {
                            LGLogger.log("Cannot use URL " + mirrors[i] + " (not valid)");
                        }
                        ++i;
                    }
                    ResourceDownloader[] resourceDownloaders = downloaders.toArray(new ResourceDownloader[downloaders.size()]);
                    swtDownloader = factory.getRandomDownloader(resourceDownloaders);
                    swtDownloader.addListener(new ResourceDownloaderAdapter(){

                        public boolean completed(ResourceDownloader downloader, InputStream data) {
                            return SWTUpdateChecker.this.processData(checker, data);
                        }
                    });
                    try {
                        swtDownloader.getSize();
                    }
                    catch (ResourceDownloaderException e) {
                        Debug.printStackTrace(e);
                    }
                    checker.addUpdate("SWT Library for " + versionGetter.getPlatform(), new String[]{"SWT is the graphical library used by Azureus"}, "" + versionGetter.getLatestVersion(), swtDownloader, 2);
                }
                catch (Throwable e) {
                    LGLogger.logUnrepeatableAlert("SWT Version check failed", e);
                    checker.failed();
                }
            }
            finally {
                checker.completed();
            }
        }
    }

    private boolean processData(UpdateChecker checker, InputStream data) {
        try {
            UpdateInstaller installer = checker.createInstaller();
            ZipInputStream zip = new ZipInputStream(data);
            ZipEntry entry2 = null;
            while ((entry2 = zip.getNextEntry()) != null) {
                String name = entry2.getName();
                if (name.equals("swt.jar")) {
                    installer.addResource(name, zip, false);
                    if (Constants.isOSX) {
                        installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + "/Azureus.app/Contents/Resources/Java/" + name);
                        continue;
                    }
                    installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + File.separator + name);
                    continue;
                }
                if (name.equals("swt-pi.jar")) {
                    installer.addResource(name, zip, false);
                    if (Constants.isOSX) {
                        installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + "/Azureus.app/Contents/Resources/Java/" + name);
                        continue;
                    }
                    installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + File.separator + name);
                    continue;
                }
                if (name.endsWith(".jnilib") && Constants.isOSX) {
                    installer.addResource(name, zip, false);
                    installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + "/Azureus.app/Contents/Resources/Java/dll/" + name);
                    continue;
                }
                if (name.equals("java_swt")) {
                    installer.addResource(name, zip, false);
                    installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + "/Azureus.app/Contents/MacOS/" + name);
                    installer.addChangeRightsAction("755", String.valueOf(installer.getInstallDir()) + "/Azureus.app/Contents/MacOS/" + name);
                    continue;
                }
                if (name.startsWith("swt-win32-") && name.endsWith(".dll")) {
                    installer.addResource(name, zip, false);
                    installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + "\\" + name);
                    continue;
                }
                if (!Constants.isLinux) continue;
                if (name.endsWith(".jar")) {
                    installer.addResource(name, zip, false);
                    installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + "/" + name);
                    continue;
                }
                if (!name.endsWith(".so")) continue;
                installer.addResource(name, zip, false);
                installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + "/" + name);
            }
            zip.close();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public String getName() {
        return "SWT library";
    }

    public int getMaximumCheckTime() {
        return 30;
    }
}

