/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableContextMenuItemImpl;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.table.ITableStructureModificationListener;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.impl.TableRowImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.SortableTable;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnEditorWindow;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.table.utils.TableContextMenuManager;
import org.gudy.azureus2.ui.swt.views.table.utils.TableSorter;
import org.gudy.azureus2.ui.swt.views.table.utils.TableStructureEventDispatcher;

public class TableView
extends AbstractIView
implements SortableTable,
ParameterListener,
ITableStructureModificationListener {
    protected String sTableID;
    protected String sPropertiesPrefix;
    protected String sDefaultSortOn;
    protected boolean bSkipFirstColumn;
    protected int iCellHeight = 0;
    protected Point ptIconSize = null;
    private TableColumnCore[] basicItems;
    private TableColumnCore[] tableColumns;
    private Composite panel;
    private Table table;
    private int iTableStyle;
    private Menu menu;
    private Menu menuThisColumn;
    private Map objectToSortableItem;
    private AEMonitor objectToSortableItem_mon = new AEMonitor("TableView:OTSI");
    protected TableSorter sorter;
    private boolean bSortScheduled = false;
    private int iMouseX = -1;
    private int loopFactor;
    private int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    private int checkColumnWidthsEvery = Constants.isOSX && SWT.getVersion() < 3054 ? 10000 / COConfigurationManager.getIntParameter("GUI Refresh") : 0;

    public TableView(String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn, int _iTableStyle) {
        this.sTableID = _sTableID;
        this.basicItems = _basicItems;
        this.sPropertiesPrefix = _sPropertiesPrefix;
        this.sDefaultSortOn = _sDefaultSortOn;
        this.iTableStyle = _iTableStyle;
        this.objectToSortableItem = new HashMap();
    }

    public TableView(String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn) {
        this(_sTableID, _sPropertiesPrefix, _basicItems, _sDefaultSortOn, 65540);
    }

    private void initializeColumnDefs() {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        int i = 0;
        while (i < this.basicItems.length) {
            tcManager.addColumn(this.basicItems[i]);
            ++i;
        }
        tcManager.ensureIntegrety(this.sTableID);
        this.tableColumns = tcManager.getAllTableColumnCoreAsArray(this.sTableID);
    }

    public void initialize(Composite composite) {
        this.panel = this.createMainPanel(composite);
        this.menu = this.createMenu();
        this.fillMenu(this.menu);
        this.table = this.createTable();
        this.initializeTable(this.table);
        COConfigurationManager.addParameterListener("Graphics Update", this);
        Colors.getInstance().addColorsChangedListener(this);
        TableStructureEventDispatcher.getInstance(this.sTableID).addListener(this);
    }

    public Composite createMainPanel(Composite composite) {
        this.panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.panel.setLayout((Layout)layout);
        return this.panel;
    }

    public Table createTable() {
        this.table = new Table(this.panel, this.iTableStyle);
        this.table.setLayoutData((Object)new GridData(1808));
        return this.table;
    }

    public Composite createLegendComposite(Color[] colors, String[] keys) {
        if (colors.length != keys.length) {
            return null;
        }
        Composite legend = new Composite(this.panel, 0);
        legend.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        int numColumns = colors.length * 2;
        if (numColumns > 10) {
            numColumns = 10;
        }
        layout.numColumns = numColumns;
        legend.setLayout((Layout)layout);
        int i = 0;
        while (i < colors.length) {
            Label lblColor = new Label(legend, 2048);
            lblColor.setBackground(colors[i]);
            GridData data = new GridData();
            data.widthHint = 20;
            data.heightHint = 10;
            lblColor.setLayoutData((Object)data);
            Label lblDesc = new Label(legend, 0);
            Messages.setLanguageText((Widget)lblDesc, keys[i]);
            data = new GridData();
            data.widthHint = 150;
            lblDesc.setLayoutData((Object)data);
            ++i;
        }
        return legend;
    }

    public void initializeTable(final Table table) {
        int position;
        this.initializeColumnDefs();
        table.setLinesVisible(false);
        table.setMenu(this.menu);
        table.setData("Name", (Object)this.sTableID);
        table.setData("TableView", (Object)this);
        this.sorter = new TableSorter(this, this.sTableID, this.sDefaultSortOn, COConfigurationManager.getBooleanParameter("config.style.table.sortDefaultAscending"));
        ControlAdapter resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TableColumn column = (TableColumn)e.widget;
                if (column == null || column.isDisposed()) {
                    return;
                }
                TableColumnCore tc = (TableColumnCore)column.getData("TableColumnCore");
                if (tc != null) {
                    tc.setWidth(column.getWidth());
                }
                int columnNumber = table.indexOf(column);
                TableView.this.locationChanged(columnNumber);
            }
        };
        if (this.bSkipFirstColumn) {
            TableColumn tc = new TableColumn(table, 0);
            tc.setWidth(0);
            tc.setResizable(false);
        }
        int i = 0;
        while (i < this.tableColumns.length) {
            position = this.tableColumns[i].getPosition();
            if (position != -1) {
                new TableColumn(table, 0);
            }
            ++i;
        }
        i = 0;
        while (i < this.tableColumns.length) {
            position = this.tableColumns[i].getPosition();
            if (position != -1) {
                String sName = this.tableColumns[i].getName();
                int adjusted_position = position + (this.bSkipFirstColumn ? 1 : 0);
                if (adjusted_position >= table.getColumnCount()) {
                    Debug.out("Incorrect table column setup, skipping column '" + sName + "'");
                } else {
                    TableColumn column = table.getColumn(adjusted_position);
                    Messages.setLanguageText((Widget)column, this.tableColumns[i].getTitleLanguageKey());
                    column.setAlignment(this.tableColumns[i].getSWTAlign());
                    column.setWidth(this.tableColumns[i].getWidth());
                    column.setData("TableColumnCore", (Object)this.tableColumns[i]);
                    column.setData("configName", (Object)("Table." + this.sTableID + "." + sName));
                    column.setData("Name", (Object)sName);
                    column.addControlListener((ControlListener)resizeListener);
                    column.addListener(13, (Listener)new ColumnListener(this.tableColumns[i]));
                }
            }
            ++i;
        }
        table.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (event.width == 0 || event.height == 0) {
                    return;
                }
                TableView.this.doPaint(event.gc);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableView.this.iMouseX = e.x;
                try {
                    Point pMousePosition;
                    if (table.getItemCount() <= 0) {
                        return;
                    }
                    Rectangle rTableArea = table.getClientArea();
                    if (rTableArea.contains(pMousePosition = new Point(e.x, e.y))) {
                        TableItem ti = table.getItem(table.getItemCount() - 1);
                        Rectangle cellBounds = ti.getBounds(table.getColumnCount() - 1);
                        if (cellBounds.width <= 0 || cellBounds.height <= 0) {
                            return;
                        }
                        if (e.x > cellBounds.x + cellBounds.width || e.y > cellBounds.y + cellBounds.height) {
                            table.deselectAll();
                        }
                    }
                }
                catch (Exception ex) {
                    System.out.println("MouseDownError");
                    Debug.printStackTrace(ex);
                }
            }
        });
        table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TableView.this.iMouseX = e.x;
            }
        });
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = event.widget instanceof Control ? ((Control)event.widget).getShell() : (Shell)event.widget;
                switch (event.type) {
                    case 3: 
                    case 8: {
                        Event e = new Event();
                        TableItem ti = (TableItem)shell.getData("_TABLEITEM");
                        if (!ti.isDisposed()) {
                            e.item = ti;
                            table.setSelection(table.indexOf(ti));
                            table.notifyListeners(event.type == 3 ? 13 : 14, e);
                        }
                        if (table != null && !table.isDisposed()) {
                            table.setFocus();
                        }
                    }
                    case 5: 
                    case 7: {
                        TableCellCore cell = (TableCellCore)shell.getData("TableCellCore");
                        cell.invokeToolTipListeners(1);
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell shell = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.shell == null) break;
                        this.shell.dispose();
                        this.shell = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        Rectangle displayRect;
                        TableItem item;
                        if (this.shell != null && !this.shell.isDisposed()) {
                            this.shell.dispose();
                        }
                        if ((item = table.getItem(new Point(event.x, event.y))) == null) {
                            return;
                        }
                        TableRowCore row = (TableRowCore)item.getData("TableRow");
                        if (row == null) {
                            return;
                        }
                        int iColumn = TableView.this.getColumnNo(event.x);
                        if (iColumn < 0) {
                            return;
                        }
                        TableColumn tcColumn = table.getColumn(iColumn);
                        String sCellName = (String)tcColumn.getData("Name");
                        if (sCellName == null) {
                            return;
                        }
                        TableCellCore cell = row.getTableCellCore(sCellName);
                        if (cell == null) {
                            return;
                        }
                        cell.invokeToolTipListeners(0);
                        Object oToolTip = cell.getToolTip();
                        if (oToolTip == null || !(oToolTip instanceof String)) {
                            return;
                        }
                        String sToolTip = (String)oToolTip;
                        Display d = table.getDisplay();
                        if (d == null) {
                            return;
                        }
                        this.shell = new Shell(table.getShell(), 16384);
                        FillLayout f = new FillLayout();
                        try {
                            f.marginWidth = 3;
                            f.marginHeight = 1;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        this.shell.setLayout((Layout)f);
                        this.shell.setBackground(d.getSystemColor(29));
                        this.label = new Label((Composite)this.shell, 64);
                        this.label.setForeground(d.getSystemColor(28));
                        this.label.setBackground(d.getSystemColor(29));
                        this.shell.setData("_TABLEITEM", (Object)item);
                        this.shell.setData("TableCellCore", (Object)cell);
                        this.label.setText(sToolTip);
                        this.label.addListener(5, labelListener);
                        this.label.addListener(3, labelListener);
                        this.label.addListener(7, labelListener);
                        this.shell.addListener(5, labelListener);
                        this.shell.addListener(3, labelListener);
                        this.shell.addListener(7, labelListener);
                        this.shell.addListener(8, labelListener);
                        Point size = this.label.computeSize(-1, -1);
                        if (size.x > 600) {
                            size = this.label.computeSize(600, -1, true);
                        }
                        size.x += this.shell.getBorderWidth() * 2;
                        size.y += this.shell.getBorderWidth() * 2;
                        try {
                            size.x += this.shell.getBorderWidth() * 2 + f.marginWidth * 2;
                            size.y += this.shell.getBorderWidth() * 2 + f.marginHeight * 2;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        Point pt = table.toDisplay(event.x - 1, event.y - size.y + 2);
                        try {
                            displayRect = this.shell.getMonitor().getClientArea();
                        }
                        catch (NoSuchMethodError e) {
                            displayRect = this.shell.getDisplay().getClientArea();
                        }
                        if (pt.x + size.x > displayRect.x + displayRect.width) {
                            pt.x = displayRect.x + displayRect.width - size.x;
                        }
                        this.shell.setBounds(pt.x, pt.y < 0 ? 0 : pt.y, size.x, size.y);
                        this.shell.setVisible(true);
                    }
                }
            }
        };
        table.addListener(12, tableListener);
        table.addListener(1, tableListener);
        table.addListener(5, tableListener);
        table.addListener(32, tableListener);
        table.setHeaderVisible(true);
    }

    public Menu createMenu() {
        return new Menu((Decorations)this.panel.getShell(), 8);
    }

    public void fillMenu(Menu menu) {
        this.menuThisColumn = new Menu((Decorations)this.panel.getShell(), 4);
        MenuItem itemThisColumn = new MenuItem(menu, 64);
        itemThisColumn.setMenu(this.menuThisColumn);
        MenuItem itemChangeTable = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemChangeTable, "MyTorrentsView.menu.editTableColumns");
        itemChangeTable.setImage(ImageRepository.getImage("columns"));
        menu.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                TableView.this.addThisColumnSubMenu(TableView.this.getColumnNo(TableView.this.iMouseX));
            }
        });
        itemChangeTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                new TableColumnEditorWindow(TableView.this.table.getDisplay(), TableView.this.tableColumns, TableStructureEventDispatcher.getInstance(TableView.this.sTableID));
            }
        });
        TableContextMenuItem[] items = TableContextMenuManager.getInstance().getAllAsArray(this.sTableID);
        if (items.length > 0) {
            new MenuItem(menu, 2);
            int i = 0;
            while (i < items.length) {
                final TableContextMenuItemImpl contextMenuItem = (TableContextMenuItemImpl)items[i];
                MenuItem menuItem = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)menuItem, contextMenuItem.getResourceKey());
                menuItem.addListener(13, (Listener)new SelectedTableRowsListener(){

                    public void run(TableRowCore row) {
                        contextMenuItem.invokeListeners(row);
                    }
                });
                ++i;
            }
        }
    }

    private void addThisColumnSubMenu(int iColumn) {
        MenuItem[] oldItems = this.menuThisColumn.getItems();
        int i = 0;
        while (i < oldItems.length) {
            oldItems[i].dispose();
            ++i;
        }
        MenuItem item = this.menuThisColumn.getParentItem();
        if (iColumn == -1) {
            item.setEnabled(false);
            item.setText(MessageText.getString("GenericText.column"));
            return;
        }
        item.setEnabled(true);
        this.menu.setData("ColumnNo", (Object)new Long(iColumn));
        TableColumn tcColumn = this.table.getColumn(iColumn);
        item.setText("'" + tcColumn.getText() + "' " + MessageText.getString("GenericText.column"));
        String sColumnName = (String)tcColumn.getData("Name");
        if (sColumnName != null) {
            this.addThisColumnSubMenu(sColumnName, this.menuThisColumn);
        }
        if (this.menuThisColumn.getItemCount() > 0) {
            new MenuItem(this.menuThisColumn, 2);
        }
        item = new MenuItem(this.menuThisColumn, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.sort");
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int iColumn = ((Long)TableView.this.menu.getData("ColumnNo")).intValue();
                TableView.this.table.getColumn(iColumn).notifyListeners(13, new Event());
            }
        });
        item = new MenuItem(this.menuThisColumn, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.remove");
        item.setEnabled(false);
        item = new MenuItem(this.menuThisColumn, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.toClipboard");
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                String sToClipboard = "";
                int iColumn = ((Long)TableView.this.menu.getData("ColumnNo")).intValue();
                TableItem[] tis = TableView.this.table.getSelection();
                int i = 0;
                while (i < tis.length) {
                    if (i != 0) {
                        sToClipboard = String.valueOf(sToClipboard) + "\n";
                    }
                    sToClipboard = String.valueOf(sToClipboard) + tis[i].getText(iColumn);
                    ++i;
                }
                new Clipboard(TableView.this.panel.getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
        TableColumnCore tc = (TableColumnCore)tcColumn.getData("TableColumnCore");
        TableContextMenuItem[] items = tc.getContextMenuItems();
        if (items.length > 0) {
            new MenuItem(this.menuThisColumn, 2);
            int i2 = 0;
            while (i2 < items.length) {
                final TableContextMenuItemImpl contextMenuItem = (TableContextMenuItemImpl)items[i2];
                MenuItem menuItem = new MenuItem(this.menuThisColumn, 8);
                Messages.setLanguageText((Widget)menuItem, contextMenuItem.getResourceKey());
                menuItem.addListener(13, (Listener)new SelectedTableRowsListener(){

                    public void run(TableRowCore row) {
                        contextMenuItem.invokeListeners(row);
                    }
                });
                ++i2;
            }
        }
    }

    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
    }

    public Composite getComposite() {
        return this.panel;
    }

    public void refresh() {
        try {
            this.this_mon.enter();
            if (this.getComposite() == null || this.getComposite().isDisposed()) {
                this.this_mon.exit();
                return;
            }
            if (this.checkColumnWidthsEvery != 0 && this.loopFactor % this.checkColumnWidthsEvery == 0) {
                TableColumn[] tableColumnsSWT = this.table.getColumns();
                int i = 0;
                while (i < tableColumnsSWT.length) {
                    TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                    if (tc != null && tc.getWidth() != tableColumnsSWT[i].getWidth()) {
                        tc.setWidth(tableColumnsSWT[i].getWidth());
                        int columnNumber = this.table.indexOf(tableColumnsSWT[i]);
                        this.locationChanged(columnNumber);
                    }
                    ++i;
                }
            }
            if (this.bSortScheduled) {
                this.bSortScheduled = false;
                this.sorter.sortColumn();
            } else {
                this.sorter.reOrder(false);
            }
            final int topIndex = this.table.getTopIndex();
            final int bottomIndex = topIndex + this.table.getClientArea().height / this.table.getItemHeight();
            this.runForAllRows(new GroupTableRowRunner(){

                public void run(TableRowCore row) {
                    int index = row.getIndex();
                    if (index >= topIndex && index <= bottomIndex) {
                        row.refresh(TableView.this.loopFactor % TableView.this.graphicsUpdate == 0);
                    } else {
                        TableCellCore cell = row.getTableCellCore(TableView.this.sorter.getLastField());
                        if (cell != null) {
                            cell.refresh();
                        }
                    }
                }
            });
            Utils.alternateTableBackground(this.table);
            ++this.loopFactor;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void locationChanged(final int iStartColumn) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.runForAllRows(new GroupTableRowRunner(){

            public void run(TableRowCore row) {
                row.locationChanged(iStartColumn);
            }
        });
    }

    private void doPaint(final GC gc) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.runForAllRows(new GroupTableRowRunner(){

            public void run(TableRowCore row) {
                row.doPaint(gc);
            }
        });
    }

    public void delete() {
        TableStructureEventDispatcher.getInstance(this.sTableID).removeListener(this);
        int i = 0;
        while (i < this.tableColumns.length) {
            this.tableColumns[i].saveSettings();
            ++i;
        }
        this.removeAllTableRows();
        if (this.table != null && !this.table.isDisposed()) {
            this.table.dispose();
        }
        COConfigurationManager.removeParameterListener("ReOrder Delay", this.sorter);
        COConfigurationManager.removeParameterListener("Graphics Update", this);
        Colors.getInstance().removeColorsChangedListener(this);
    }

    public String getData() {
        return String.valueOf(this.sPropertiesPrefix) + ".title.short";
    }

    public String getFullTitle() {
        return MessageText.getString(String.valueOf(this.sPropertiesPrefix) + ".title.full");
    }

    public void addDataSource(final Object dataSource) {
        try {
            this.this_mon.enter();
            try {
                if (this.objectToSortableItem.containsKey(dataSource) || this.panel.isDisposed() || this.table.isDisposed()) {
                    this.this_mon.exit();
                    return;
                }
                try {
                    this.objectToSortableItem_mon.enter();
                    this.objectToSortableItem.put(dataSource, null);
                }
                finally {
                    this.objectToSortableItem_mon.exit();
                }
                final Display display = this.panel.getDisplay();
                display.asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        TableRowImpl row = new TableRowImpl(TableView.this, dataSource, TableView.this.bSkipFirstColumn);
                        if (TableView.this.ptIconSize != null) {
                            Image image = new Image((Device)display, TableView.this.ptIconSize.x, TableView.this.ptIconSize.y);
                            row.setImage(0, image);
                            row.setImage(0, null);
                            image.dispose();
                        } else if (TableView.this.iCellHeight > 0) {
                            row.setHeight(TableView.this.iCellHeight);
                        }
                        if (TableView.this.objectToSortableItem.containsKey(dataSource)) {
                            try {
                                TableView.this.objectToSortableItem_mon.enter();
                                TableView.this.objectToSortableItem.put(dataSource, row);
                            }
                            finally {
                                TableView.this.objectToSortableItem_mon.exit();
                            }
                            TableCellCore cell = row.getTableCellCore(TableView.this.sorter.getLastField());
                            if (cell != null) {
                                cell.refresh();
                            }
                        } else {
                            row.delete();
                        }
                        TableView.this.bSortScheduled = true;
                    }
                });
            }
            catch (Exception e) {
                System.out.println("Error adding row to " + this.sTableID + " table");
                Debug.printStackTrace(e);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeDataSource(Object dataSource) {
        TableRowCore item;
        try {
            this.objectToSortableItem_mon.enter();
            item = (TableRowCore)this.objectToSortableItem.remove(dataSource);
        }
        finally {
            this.objectToSortableItem_mon.exit();
        }
        if (item == null) {
            return;
        }
        item.delete();
    }

    public void removeAllTableRows() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.removeAll();
        }
        this.runForAllRows(new GroupTableRowRunner(){

            public void run(TableRowCore row) {
                row.delete();
            }
        });
        this.objectToSortableItem.clear();
    }

    public Table getTable() {
        return this.table;
    }

    public String getTableID() {
        return this.sTableID;
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Graphics Update")) {
            this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
            return;
        }
        if (parameterName.startsWith("Color")) {
            this.tableInvalidate();
        }
    }

    public void tableStructureChanged() {
        this.removeAllTableRows();
        if (this.table != null && !this.table.isDisposed()) {
            this.table.dispose();
        }
        this.menu.dispose();
        this.menu = this.createMenu();
        this.fillMenu(this.menu);
        this.table = this.createTable();
        this.initializeTable(this.table);
        this.panel.layout();
    }

    public void columnSizeChanged(TableColumnCore tableColumn) {
        int newWidth = tableColumn.getWidth();
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        TableColumn column = null;
        TableColumn[] tableColumnsSWT = this.table.getColumns();
        int i = 0;
        while (i < tableColumnsSWT.length) {
            if (tableColumnsSWT[i].getData("TableColumnCore") == tableColumn) {
                column = tableColumnsSWT[i];
                break;
            }
            ++i;
        }
        if (column == null || column.isDisposed() || column.getWidth() == newWidth) {
            return;
        }
        column.setWidth(newWidth);
    }

    public void columnInvalidate(TableColumnCore tableColumn) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new GroupTableRowRunner(){

            public void run(TableRowCore row) {
                TableCellCore cell = row.getTableCellCore(sColumnName);
                if (cell != null) {
                    cell.setValid(false);
                }
            }
        });
    }

    public void tableInvalidate() {
        this.runForAllRows(new GroupTableRowRunner(){

            public void run(TableRowCore row) {
                row.setValid(false);
                row.refresh(true);
            }
        });
    }

    public List getColumnCoreCells(String sColumnName) {
        ArrayList<TableCellCore> l = new ArrayList<TableCellCore>();
        if (this.table != null && !this.table.isDisposed()) {
            TableItem[] tis = this.table.getItems();
            int i = 0;
            while (i < tis.length) {
                TableCellCore cell;
                TableRowCore row = (TableRowCore)tis[i].getData("TableRow");
                if (row != null && (cell = row.getTableCellCore(sColumnName)) != null) {
                    l.add(cell);
                }
                ++i;
            }
        }
        return l;
    }

    public List getRowsOrdered() {
        ArrayList<TableRowCore> l = new ArrayList<TableRowCore>();
        if (this.table != null && !this.table.isDisposed()) {
            TableItem[] tis = this.table.getItems();
            int i = 0;
            while (i < tis.length) {
                TableRowCore row = (TableRowCore)tis[i].getData("TableRow");
                if (row != null) {
                    l.add(row);
                }
                ++i;
            }
        }
        return l;
    }

    public TableRowCore[] getRowsUnordered() {
        return this.objectToSortableItem.values().toArray(new TableRowCore[0]);
    }

    public TableColumnCore[] getAllTableColumnCore() {
        return this.tableColumns;
    }

    public TableColumnCore getTableColumnCore(String sColumnName) {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        return tcManager.getTableColumnCore(this.sTableID, sColumnName);
    }

    public List getSelectedDataSourcesList() {
        ArrayList<Object> l = new ArrayList<Object>();
        if (this.table != null && !this.table.isDisposed()) {
            TableItem[] tis = this.table.getSelection();
            int i = 0;
            while (i < tis.length) {
                TableRowCore row = (TableRowCore)tis[i].getData("TableRow");
                if (row != null && row.getDataSource(true) != null) {
                    l.add(row.getDataSource(true));
                }
                ++i;
            }
        }
        return l;
    }

    public Object[] getSelectedDataSources(Object[] a) {
        return this.getSelectedDataSourcesList().toArray(a);
    }

    public Object[] getSelectedDataSources() {
        return this.getSelectedDataSourcesList().toArray();
    }

    public TableRowCore[] getSelectedRows() {
        return this.getSelectedRowsList().toArray(new TableRowCore[0]);
    }

    public List getSelectedRowsList() {
        ArrayList<TableRowCore> l = new ArrayList<TableRowCore>();
        if (this.table != null && !this.table.isDisposed()) {
            TableItem[] tis = this.table.getSelection();
            int i = 0;
            while (i < tis.length) {
                TableRowCore row = (TableRowCore)tis[i].getData("TableRow");
                if (row != null && row.getDataSource(true) != null) {
                    l.add(row);
                }
                ++i;
            }
        }
        return l;
    }

    public Object getFirstSelectedDataSource() {
        if (this.table == null || this.table.isDisposed() || this.table.getSelectionCount() == 0) {
            return null;
        }
        TableRowCore row = (TableRowCore)this.table.getSelection()[0].getData("TableRow");
        if (row == null) {
            return null;
        }
        return row.getDataSource(true);
    }

    public void runForSelectedRows(GroupTableRowRunner runner) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        TableItem[] tis = this.table.getSelection();
        int i = 0;
        while (i < tis.length) {
            TableRowCore row = (TableRowCore)tis[i].getData("TableRow");
            if (row != null) {
                runner.run(row);
            }
            ++i;
        }
    }

    public void runForAllRows(GroupTableRowRunner runner) {
        TableRowCore[] rows = this.objectToSortableItem.values().toArray(new TableRowCore[0]);
        int i = 0;
        while (i < rows.length) {
            if (rows[i] != null) {
                runner.run(rows[i]);
            }
            ++i;
        }
    }

    public void clipboardSelected() {
        String sToClipboard = "";
        int j = 0;
        while (j < this.getTable().getColumnCount()) {
            if (j != 0) {
                sToClipboard = String.valueOf(sToClipboard) + "\t";
            }
            sToClipboard = String.valueOf(sToClipboard) + this.getTable().getColumn(j).getText();
            ++j;
        }
        TableItem[] tis = this.getTable().getSelection();
        int i = 0;
        while (i < tis.length) {
            sToClipboard = String.valueOf(sToClipboard) + "\n";
            int j2 = 0;
            while (j2 < this.getTable().getColumnCount()) {
                if (j2 != 0) {
                    sToClipboard = String.valueOf(sToClipboard) + "\t";
                }
                sToClipboard = String.valueOf(sToClipboard) + tis[i].getText(j2);
                ++j2;
            }
            ++i;
        }
        new Clipboard(this.getComposite().getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
    }

    private int getColumnNo(int iMouseX) {
        int iColumn = -1;
        if (this.table.getItemCount() > 0) {
            TableItem ti = this.table.getItem(this.table.getTopIndex());
            int i = this.bSkipFirstColumn ? 1 : 0;
            while (i < this.table.getColumnCount()) {
                Rectangle cellBounds = ti.getBounds(i);
                if (iMouseX >= cellBounds.x && iMouseX < cellBounds.x + cellBounds.width && cellBounds.width > 0) {
                    iColumn = i;
                    break;
                }
                ++i;
            }
        }
        return iColumn;
    }

    public abstract class GroupTableRowRunner {
        public abstract void run(TableRowCore var1);
    }

    public abstract class SelectedTableRowsListener
    extends GroupTableRowRunner
    implements Listener {
        protected Event event;

        public void handleEvent(Event e) {
            this.event = e;
            TableView.this.runForSelectedRows(this);
        }

        public abstract void run(TableRowCore var1);
    }

    private class ColumnListener
    implements Listener {
        private TableColumnCore tableColumn;

        public ColumnListener(TableColumnCore tc) {
            this.tableColumn = tc;
        }

        public void handleEvent(Event e) {
            TableView.this.sorter.sortColumnReverse(this.tableColumn);
        }
    }
}

