/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;

public class TableContextMenuManager {
    private static TableContextMenuManager instance;
    private static AEMonitor class_mon;
    private Map items;
    private AEMonitor items_mon = new AEMonitor("TableContextMenuManager:items");

    static {
        class_mon = new AEMonitor("TableContextMenuManager");
    }

    private TableContextMenuManager() {
        this.items = new HashMap();
    }

    public static TableContextMenuManager getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TableContextMenuManager();
            }
            TableContextMenuManager tableContextMenuManager = instance;
            class_mon.exit();
            return tableContextMenuManager;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public void addContextMenuItem(TableContextMenuItem item) {
        try {
            String name = item.getResourceKey();
            String sTableID = item.getTableID();
            try {
                this.items_mon.enter();
                LinkedHashMap<String, TableContextMenuItem> mTypes = (LinkedHashMap<String, TableContextMenuItem>)this.items.get(sTableID);
                if (mTypes == null) {
                    mTypes = new LinkedHashMap<String, TableContextMenuItem>();
                    this.items.put(sTableID, mTypes);
                }
                mTypes.put(name, item);
            }
            finally {
                this.items_mon.exit();
            }
        }
        catch (Exception e) {
            System.out.println("Error while adding Context Table Menu Item");
            Debug.printStackTrace(e);
        }
    }

    public TableContextMenuItem[] getAllAsArray(String sTableID) {
        Map mTypes = (Map)this.items.get(sTableID);
        if (mTypes != null) {
            ArrayList l = new ArrayList();
            l.addAll(mTypes.values());
            mTypes = (Map)this.items.get(null);
            if (mTypes != null) {
                l.addAll(mTypes.values());
            }
            return l.toArray(new TableContextMenuItem[0]);
        }
        return new TableContextMenuItem[0];
    }
}

