/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.pluginsimpl.local.ui.SWT.SWTManagerImpl;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class CompletionItem
extends CoreTableColumn
implements TableCellAddedListener {
    private static final int borderWidth = 1;

    public CompletionItem() {
        super("completion", "MyTorrents");
        this.initializeAsGraphic(-1, 250);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(2);
        new Cell(cell);
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellDisposeListener {
        int lastPercentDone = 0;

        public Cell(TableCell cell) {
            cell.setFillCell(true);
            cell.addRefreshListener(this);
            cell.addDisposeListener(this);
        }

        public void dispose(TableCell cell) {
            Image img = ((TableCellCore)cell).getGraphicSWT();
            if (img != null && !img.isDisposed()) {
                img.dispose();
            }
            cell.setGraphic(null);
        }

        public void refresh(TableCell cell) {
            GC gcImage;
            Rectangle imageBounds;
            boolean bImageSizeChanged;
            int percentDone = this.getPercentDone(cell);
            if (!cell.setSortValue(percentDone) && cell.isValid() && this.lastPercentDone == percentDone) {
                return;
            }
            int newWidth = cell.getWidth();
            if (newWidth <= 0) {
                return;
            }
            int newHeight = cell.getHeight();
            int x1 = newWidth - 1 - 1;
            int y1 = newHeight - 1 - 1;
            if (x1 < 10 || y1 < 3) {
                return;
            }
            this.lastPercentDone = percentDone;
            Image image = ((TableCellCore)cell).getGraphicSWT();
            if (image == null) {
                bImageSizeChanged = true;
            } else {
                imageBounds = image.getBounds();
                boolean bl = bImageSizeChanged = imageBounds.width != newWidth || imageBounds.height != newHeight;
            }
            if (bImageSizeChanged) {
                image = new Image((Device)SWTManagerImpl.getSingleton().getDisplay(), newWidth, newHeight);
                imageBounds = image.getBounds();
                gcImage = new GC((Drawable)image);
                gcImage.setForeground(Colors.grey);
                gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
            } else {
                gcImage = new GC((Drawable)image);
            }
            int limit = x1 * percentDone / 1000;
            gcImage.setBackground(Colors.blues[9]);
            gcImage.fillRectangle(1, 1, limit, y1);
            if (limit < x1) {
                gcImage.setBackground(Colors.blues[0]);
                gcImage.fillRectangle(limit + 1, 1, x1 - limit, y1);
            }
            gcImage.dispose();
            ((TableCellCore)cell).setGraphic(image);
        }

        public int getPercentDone(TableCell cell) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return 0;
            }
            return dm.getStats().getDownloadCompleted(true);
        }
    }
}

