/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class DownSpeedLimitItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public DownSpeedLimitItem(String sTableID) {
        super("maxdownspeed", 2, -1, 35, sTableID);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = dm == null ? 0 : dm.getStats().getMaxDownloadKBSpeed() * 1024;
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        if (value == -1L) {
            cell.setText(MessageText.getString("MyTorrents.items.UpSpeedLimit.disabled"));
        } else if (value == 0L) {
            cell.setText(MessageText.getString("MyTorrents.items.UpSpeedLimit.unlimited"));
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(value));
        }
    }
}

