/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class NameItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public NameItem(String sTableID) {
        super("name", -2, 250, sTableID);
    }

    public void refresh(TableCell cell) {
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        if (cell.setText(name)) {
            TOTorrent torrent;
            boolean folder_icon = false;
            if (dm != null && (torrent = dm.getTorrent()) != null && !torrent.isSimpleTorrent()) {
                folder_icon = true;
            }
            if (folder_icon) {
                Image icon = ImageRepository.getFolderImage();
                ((TableCellCore)cell).setImage(icon);
            } else {
                int sep = name.lastIndexOf(46);
                if (sep < 0) {
                    sep = 0;
                }
                name = name.substring(sep);
                Program program = Program.findProgram((String)name);
                Image icon = ImageRepository.getIconFromProgram(program);
                ((TableCellCore)cell).setImage(icon);
            }
        }
    }
}

