/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class TrackerNameItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public TrackerNameItem(String sTableID) {
        super("trackername", -1, 120, sTableID);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String name = "";
        if (dm != null && dm.getTorrent() != null) {
            String[] parts = dm.getTorrent().getAnnounceURL().getHost().split("\\.");
            int used = 0;
            int i = parts.length - 1;
            while (i >= 0) {
                if (used > 4) break;
                String chunk = parts[i];
                if (used >= 2 && chunk.length() >= 11) break;
                name = used == 0 ? chunk : String.valueOf(chunk) + "." + name;
                ++used;
                --i;
            }
        }
        cell.setText(name);
    }
}

