/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class StateItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public StateItem() {
        super("state", -2, 65, "Peers");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        PEPeerTransport peer = (PEPeerTransport)cell.getDataSource();
        String state_text = "";
        if (peer != null) {
            int state = peer.getConnectionState();
            if (!cell.setSortValue(state) && cell.isValid()) {
                return;
            }
            switch (state) {
                case 0: {
                    state_text = MessageText.getString("PeersView.state.pending");
                    break;
                }
                case 1: {
                    state_text = MessageText.getString("PeersView.state.connecting");
                    break;
                }
                case 2: {
                    state_text = MessageText.getString("PeersView.state.handshake");
                    break;
                }
                case 3: {
                    state_text = MessageText.getString("PeersView.state.bitfield");
                    break;
                }
                case 4: {
                    state_text = MessageText.getString("PeersView.state.established");
                }
            }
        }
        cell.setText(state_text);
    }
}

