/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.webplugin;

import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestAccessController;
import org.gudy.azureus2.ui.webplugin.WebPlugin;

public class WebPluginAccessController
implements RPRequestAccessController {
    protected boolean view_mode;

    public WebPluginAccessController(PluginInterface pi) {
        String mode_str = pi.getPluginconfig().getPluginStringParameter("Mode", ((WebPlugin)pi.getPlugin()).CONFIG_MODE_DEFAULT);
        this.view_mode = !mode_str.equalsIgnoreCase("full");
    }

    public void checkUploadAllowed() {
        if (this.view_mode) {
            throw new RPException("Access Denied");
        }
    }

    public void checkAccess(String name, RPRequest request2) {
        String method = request2.getMethod();
        if (this.view_mode) {
            boolean ok = false;
            if (name.equals("PluginInterface")) {
                ok = method.equals("getPluginconfig") || method.equals("getDownloadManager") || method.equals("getIPFilter");
            } else if (name.equals("DownloadManager")) {
                ok = method.equals("getDownloads");
            } else if (name.equals("PluginConfig")) {
                if (method.startsWith("getPlugin") || method.equals("save")) {
                    ok = true;
                } else if (method.equals("setPluginParameter[String,int]")) {
                    String param = (String)request2.getParams()[0];
                    ok = param.equals("MDConfigModel:refresh_period");
                }
            }
            if (!ok) {
                throw new RPException("Access Denied");
            }
        }
    }
}

