/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.update.CorePatchLevel;
import org.gudy.azureus2.update.UpdateJarPatcher;

public class CorePatchChecker
implements Plugin,
UpdatableComponent,
UpdateCheckInstanceListener {
    public static final boolean TESTING = false;
    protected PluginInterface plugin_interface;
    static /* synthetic */ Class class$0;

    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Core Patcher");
        if (!Constants.isCVSVersion()) {
            this.plugin_interface.getUpdateManager().registerUpdatableComponent(this, false);
        }
    }

    public String getName() {
        return "Core Patch Checker";
    }

    public int getMaximumCheckTime() {
        return 0;
    }

    public void checkForUpdate(UpdateChecker checker) {
        try {
            UpdateCheckInstance inst = checker.getCheckInstance();
            inst.addListener(this);
            checker.addUpdate("Core Patch Checker", new String[0], "", new ResourceDownloader[0], 3);
        }
        finally {
            checker.completed();
        }
    }

    public void cancelled(UpdateCheckInstance instance) {
    }

    public void complete(final UpdateCheckInstance instance) {
        Update[] updates = instance.getUpdates();
        PluginManager pluginManager = this.plugin_interface.getPluginManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.gudy.azureus2.update.UpdaterUpdateChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        final PluginInterface updater_plugin = pluginManager.getPluginInterfaceByClass(clazz);
        int i = 0;
        while (i < updates.length) {
            Update update = updates[i];
            Object user_object = update.getUserObject();
            if (user_object != null && user_object == updater_plugin) {
                LGLogger.log("Core Patcher: updater update found");
                update.setRestartRequired(3);
                update.addListener(new UpdateListener(){

                    public void complete(Update update) {
                        LGLogger.log("Core Patcher: updater update complete");
                        CorePatchChecker.this.patch(instance, update, updater_plugin);
                    }
                });
            }
            ++i;
        }
    }

    protected void patch(UpdateCheckInstance instance, Update updater_update, PluginInterface updater_plugin) {
        try {
            ResourceDownloader rd_log = updater_update.getDownloaders()[0];
            File[] files = new File(updater_plugin.getPluginDirectoryName()).listFiles();
            if (files == null) {
                LGLogger.log("Core Patcher: no files in plugin dir!!!");
                return;
            }
            String patch_prefix = "Azureus2_" + Constants.getBaseVersion() + "_P";
            int highest_p = -1;
            File highest_p_file = null;
            int i = 0;
            while (i < files.length) {
                String name = files[i].getName();
                if (name.startsWith(patch_prefix) && name.endsWith(".pat")) {
                    LGLogger.log("Core Patcher: found patch file '" + name + "'");
                    try {
                        int this_p = Integer.parseInt(name.substring(patch_prefix.length(), name.indexOf(".pat")));
                        if (this_p > highest_p) {
                            highest_p = this_p;
                            highest_p_file = files[i];
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                ++i;
            }
            if (CorePatchLevel.getCurrentPatchLevel() >= highest_p) {
                LGLogger.log("Core Patcher: no applicable patch found (highest = " + highest_p + ")");
            } else {
                rd_log.reportActivity("Applying patch '" + highest_p_file.getName() + "'");
                LGLogger.log("Core Patcher: applying patch '" + highest_p_file.toString() + "'");
                UpdateInstaller installer = instance.createInstaller();
                File tmp = AETemporaryFileHandler.createTempFile("AZU", null);
                FileOutputStream os = new FileOutputStream(tmp);
                String az2_jar = Constants.isOSX ? String.valueOf(installer.getInstallDir()) + "/Azureus.app/Contents/Resources/Java/" : String.valueOf(installer.getInstallDir()) + File.separator;
                az2_jar = String.valueOf(az2_jar) + "Azureus2.jar";
                FileInputStream is = new FileInputStream(az2_jar);
                FileInputStream pis = new FileInputStream(highest_p_file);
                new UpdateJarPatcher(is, pis, os);
                ((InputStream)is).close();
                ((InputStream)pis).close();
                ((OutputStream)os).close();
                String resource_name = "Azureus2_P" + highest_p + ".jar";
                installer.addResource(resource_name, new FileInputStream(tmp));
                tmp.delete();
                installer.addMoveAction(resource_name, az2_jar);
                LGLogger.logUnrepeatableAlert(0, "Patch " + highest_p_file.getName() + " ready to be applied");
                String done_file = highest_p_file.toString();
                done_file = String.valueOf(done_file.substring(0, done_file.length() - 1)) + "x";
                highest_p_file.renameTo(new File(done_file));
                updater_update.setRestartRequired(2);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            LGLogger.logUnrepeatableAlert("Core Patcher failed", e);
        }
    }
}

