/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;

    ScrollBar() {
    }

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public boolean getEnabled() {
        this.checkWidget();
        int barHandle = (this.style & 0x100) != 0 ? OS.GTK_SCROLLED_WINDOW_HSCROLLBAR((int)this.parent.scrolledHandle) : OS.GTK_SCROLLED_WINDOW_VSCROLLBAR((int)this.parent.scrolledHandle);
        if (barHandle != 0) {
            return OS.GTK_WIDGET_SENSITIVE((int)barHandle);
        }
        return true;
    }

    public int getIncrement() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        return (int)adjustment.step_increment;
    }

    public int getMaximum() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        return (int)adjustment.upper;
    }

    public int getMinimum() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        return (int)adjustment.lower;
    }

    public int getPageIncrement() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        return (int)adjustment.page_increment;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        return (int)adjustment.value;
    }

    public Point getSize() {
        this.checkWidget();
        int barHandle = 0;
        int scrolledHandle = this.parent.scrolledHandle;
        barHandle = (this.style & 0x100) != 0 ? OS.GTK_SCROLLED_WINDOW_HSCROLLBAR((int)scrolledHandle) : OS.GTK_SCROLLED_WINDOW_VSCROLLBAR((int)scrolledHandle);
        if (barHandle == 0) {
            return new Point(0, 0);
        }
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)barHandle, (GtkRequisition)requisition);
        return new Point(requisition.width, requisition.height);
    }

    public int getThumb() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        return (int)adjustment.page_size;
    }

    public boolean getVisible() {
        this.checkWidget();
        int scrolledHandle = this.parent.scrolledHandle;
        int[] hsp = new int[1];
        int[] vsp = new int[1];
        OS.gtk_scrolled_window_get_policy((int)scrolledHandle, (int[])hsp, (int[])vsp);
        if ((this.style & 0x100) != 0) {
            return hsp[0] != 2;
        }
        return vsp[0] != 2;
    }

    int gtk_value_changed(int adjustment) {
        this.postEvent(13);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect((int)this.handle, (byte[])OS.value_changed, (int)this.display.windowProc2, (int)45);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.getParent().getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.getParent().isVisible();
    }

    void releaseChild() {
        super.releaseChild();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int barHandle = (this.style & 0x100) != 0 ? OS.GTK_SCROLLED_WINDOW_HSCROLLBAR((int)this.parent.scrolledHandle) : OS.GTK_SCROLLED_WINDOW_VSCROLLBAR((int)this.parent.scrolledHandle);
        if (barHandle != 0) {
            OS.gtk_widget_set_sensitive((int)barHandle, (boolean)enabled);
        }
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        adjustment.step_increment = value;
        OS.memmove((int)this.handle, (GtkAdjustment)adjustment);
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
        OS.gtk_adjustment_changed((int)this.handle);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        int minimum = (int)adjustment.lower;
        if (value <= minimum) {
            return;
        }
        adjustment.upper = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, value - minimum);
        adjustment.value = Math.min((int)adjustment.value, (int)((double)value - adjustment.page_size));
        OS.memmove((int)this.handle, (GtkAdjustment)adjustment);
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
        OS.gtk_adjustment_changed((int)this.handle);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        int maximum = (int)adjustment.upper;
        if (value >= maximum) {
            return;
        }
        adjustment.lower = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, maximum - value);
        adjustment.value = Math.max((int)adjustment.value, value);
        OS.memmove((int)this.handle, (GtkAdjustment)adjustment);
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
        OS.gtk_adjustment_changed((int)this.handle);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        adjustment.page_increment = value;
        OS.memmove((int)this.handle, (GtkAdjustment)adjustment);
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
        OS.gtk_adjustment_changed((int)this.handle);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
    }

    public void setSelection(int value) {
        this.checkWidget();
        value = Math.min(value, this.getMaximum() - this.getThumb());
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
        OS.gtk_adjustment_set_value((int)this.handle, (double)value);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        value = Math.min(value, (int)(adjustment.upper - adjustment.lower));
        adjustment.page_size = value;
        adjustment.value = Math.min((int)adjustment.value, (int)(adjustment.upper - (double)value));
        OS.memmove((int)this.handle, (GtkAdjustment)adjustment);
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
        OS.gtk_adjustment_changed((int)this.handle);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)this.handle);
        adjustment.lower = minimum;
        adjustment.upper = maximum;
        adjustment.step_increment = increment;
        adjustment.page_increment = pageIncrement;
        adjustment.page_size = thumb;
        adjustment.value = Math.min(Math.max(selection, minimum), maximum - thumb);
        OS.memmove((int)this.handle, (GtkAdjustment)adjustment);
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
        OS.gtk_adjustment_changed((int)this.handle);
        OS.gtk_adjustment_value_changed((int)this.handle);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)45);
    }

    public void setVisible(boolean visible) {
        int policy;
        this.checkWidget();
        int scrolledHandle = this.parent.scrolledHandle;
        int[] hsp = new int[1];
        int[] vsp = new int[1];
        OS.gtk_scrolled_window_get_policy((int)scrolledHandle, (int[])hsp, (int[])vsp);
        int n = policy = visible ? 0 : 2;
        if ((this.style & 0x100) != 0) {
            if (hsp[0] == policy) {
                return;
            }
            hsp[0] = policy;
        } else {
            if (vsp[0] == policy) {
                return;
            }
            vsp[0] = policy;
        }
        OS.gtk_scrolled_window_set_policy((int)scrolledHandle, (int)hsp[0], (int)vsp[0]);
        int parentHandle = this.parent.scrolledHandle;
        OS.gtk_container_resize_children((int)parentHandle);
        this.parent.sendEvent(11);
        this.sendEvent(visible ? 22 : 23);
    }
}

