/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel;

import gov.llnl.babel.symbols.RegexMatch;
import gov.llnl.babel.symbols.SymbolID;
import java.util.LinkedList;
import java.util.List;

public class BabelConfiguration {
    private static final String BASE_CLASS = "sidl.BaseClass";
    private static final String BASE_CLASSINFO = "sidl.ClassInfo";
    private static final String BASE_CLASSINFOI = "sidl.ClassInfoI";
    private static final String BASE_EXCEPTION = "sidl.BaseException";
    private static final String BASE_INTERFACE = "sidl.BaseInterface";
    private static final String MAKEFILE_NAME = "babel.make";
    private static final int MAXIMUM_ARRAY = 7;
    private static final String SIDL_EXCEPTION = "sidl.SIDLException";
    public static final String FUND_EXCEPTION = "sidl.BaseInterface";
    public static final String PRE_EXCEPTION = "sidl.PreconditionViolation";
    public static final String POST_EXCEPTION = "sidl.PostconditionViolation";
    public static final String INV_EXCEPTION = "sidl.InvariantViolation";
    public static final String NO_CHECKING = "0";
    public static final String MIN_CHECKING_STATS = "1";
    public static final String FULL_CHECKING_STATS = "2";
    private String d_generate_assertions = "2";
    private boolean d_generate_client = false;
    private boolean d_generate_interceptors = false;
    private boolean d_generate_server = false;
    private boolean d_generate_stdlib = false;
    private boolean d_generate_text = false;
    private boolean d_package_subdirs = false;
    private boolean d_language_subdir = false;
    private boolean d_glue_subdirs = false;
    private boolean d_checkNullIOR = false;
    private boolean d_parser_check = false;
    private boolean d_suppress_timestamps = false;
    private boolean d_comment_local_only = false;
    private boolean d_short_file_names = false;
    private String d_target_language = "";
    private String d_output_directory = ".";
    private String d_vpath_directory = null;
    private StringBuffer d_repository_path = new StringBuffer("");
    private List d_excluded_symbols = new LinkedList();
    private boolean d_exclude_external = false;
    private List d_included_symbols = new LinkedList();
    private String d_make_prefix = "";
    private String d_makefile = "babel.make";
    private boolean d_sidl_file_input = false;
    public static final int sidl_bool_array = 1;
    public static final int sidl_char_array = 2;
    public static final int sidl_dcomplex_array = 3;
    public static final int sidl_double_array = 4;
    public static final int sidl_fcomplex_array = 5;
    public static final int sidl_float_array = 6;
    public static final int sidl_int_array = 7;
    public static final int sidl_long_array = 8;
    public static final int sidl_opaque_array = 9;
    public static final int sidl_string_array = 10;
    public static final int sidl_interface_array = 11;
    private static BabelConfiguration s_my_instance = null;

    protected BabelConfiguration() {
    }

    public static BabelConfiguration getInstance() {
        if (s_my_instance == null) {
            s_my_instance = new BabelConfiguration();
        }
        return s_my_instance;
    }

    public static String arrayType(int type) {
        switch (type) {
            case 1: {
                return "bool";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "dcomplex";
            }
            case 4: {
                return "double";
            }
            case 5: {
                return "fcomplex";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "int";
            }
            case 8: {
                return "long";
            }
            case 9: {
                return "opaque";
            }
            case 10: {
                return "string";
            }
            case 11: {
                return "BaseInterface";
            }
        }
        return "BaseInterface";
    }

    public static String getBaseInterface() {
        return "sidl.BaseInterface";
    }

    public static String getBaseClass() {
        return BASE_CLASS;
    }

    public static String getClassInfo() {
        return BASE_CLASSINFO;
    }

    public static String getClassInfoI() {
        return BASE_CLASSINFOI;
    }

    public static String getBaseExceptionInterface() {
        return BASE_EXCEPTION;
    }

    public static String getBaseExceptionClass() {
        return SIDL_EXCEPTION;
    }

    public static String getBaseExceptionType() {
        return "sidl.BaseInterface";
    }

    public String getMakefileName() {
        return this.d_makefile;
    }

    public static int getMaximumArray() {
        return 7;
    }

    public static boolean isSIDLBaseClass(SymbolID id) {
        String n;
        boolean is_sidl = false;
        if (id != null && (n = id.getFullName()) != null && (n.equals("sidl") || n.startsWith("sidl."))) {
            is_sidl = true;
        }
        return is_sidl;
    }

    public void setGenerateAssertions(String lvl) {
        this.d_generate_assertions = lvl;
    }

    public String getAssertionLevel() {
        return this.d_generate_assertions;
    }

    public boolean generateAssertions() {
        return this.d_generate_assertions != NO_CHECKING;
    }

    public void setGenerateClient(boolean generate) {
        this.d_generate_client = generate;
    }

    public boolean generateClient() {
        return this.d_generate_client;
    }

    public void setGenerateInterceptors(boolean generate) {
        this.d_generate_interceptors = generate;
    }

    public boolean generateInterceptors() {
        return this.d_generate_interceptors;
    }

    public void setGenerateServer(boolean generate) {
        this.d_generate_server = generate;
    }

    public boolean generateServer() {
        return this.d_generate_server;
    }

    public void setGenerateText(boolean generate) {
        this.d_generate_text = generate;
    }

    public boolean generateText() {
        return this.d_generate_text;
    }

    public void setGenerateStdlib(boolean generate) {
        this.d_generate_stdlib = generate;
    }

    public boolean generateStdlib() {
        return this.d_generate_stdlib;
    }

    public void setParseCheckOnly(boolean parse) {
        this.d_parser_check = parse;
    }

    public boolean parseCheckOnly() {
        return this.d_parser_check;
    }

    public void setCommentLocalOnly(boolean localOnly) {
        this.d_comment_local_only = localOnly;
    }

    public boolean getCommentLocalOnly() {
        return this.d_comment_local_only;
    }

    public void setShortFileNames(boolean shortFileNames) {
        this.d_short_file_names = shortFileNames;
    }

    public boolean getShortFileNames() {
        return this.d_short_file_names;
    }

    public void setSuppressTimestamps(boolean suppress) {
        this.d_suppress_timestamps = suppress;
    }

    public boolean suppressTimestamps() {
        return this.d_suppress_timestamps;
    }

    public void setMakePackageSubdirs(boolean make_subdirs) {
        this.d_package_subdirs = make_subdirs;
    }

    public boolean makePackageSubdirs() {
        return this.d_package_subdirs;
    }

    public void setMakeGlueSubdirs(boolean make_glue_subdirs) {
        this.d_glue_subdirs = make_glue_subdirs;
    }

    public boolean makeGlueSubdirs() {
        return this.d_glue_subdirs;
    }

    public void setCxxCheckNullIOR(boolean checkNullIOR) {
        this.d_checkNullIOR = checkNullIOR;
    }

    public boolean makeCxxCheckNullIOR() {
        return this.d_checkNullIOR;
    }

    public void setMakeLanguageSubdir(boolean make_language_subdir) {
        this.d_language_subdir = make_language_subdir;
    }

    public boolean makeLanguageSubdir() {
        return this.d_language_subdir;
    }

    public void setOutputDirectory(String dir) {
        this.d_output_directory = dir;
    }

    public String getOutputDirectory() {
        return this.d_output_directory;
    }

    public void setVPathDirectory(String dir) {
        this.d_vpath_directory = dir;
    }

    public String getVPathDirectory() {
        return this.d_vpath_directory;
    }

    public void setTargetLanguage(String lang) {
        this.d_target_language = lang;
    }

    public String getTargetLanguage() {
        return this.d_target_language;
    }

    public void addToRepositoryPath(String new_path) {
        if (this.d_repository_path != null) {
            if (this.d_repository_path.length() == 0) {
                this.d_repository_path.insert(0, new_path);
            } else {
                this.d_repository_path.insert(0, new_path + ";");
            }
        } else {
            this.d_repository_path = new StringBuffer(new_path);
        }
    }

    public String getRepositoryPath() {
        return this.d_repository_path.toString();
    }

    public void addExcluded(RegexMatch rm) {
        this.d_excluded_symbols.add(rm);
    }

    public List getExcludedList() {
        return this.d_excluded_symbols;
    }

    public void addIncluded(String str) {
        this.d_included_symbols.add(str);
    }

    public List getIncludedList() {
        return this.d_included_symbols;
    }

    public void setExcludeExternal(boolean val) {
        this.d_exclude_external = val;
    }

    public boolean excludeExternal() {
        return this.d_exclude_external;
    }

    public String getMakePrefix() {
        return this.d_make_prefix;
    }

    public void setMakePrefix(String prefix) {
        this.d_make_prefix = prefix != null ? prefix : "";
        this.d_makefile = this.d_make_prefix + MAKEFILE_NAME;
    }

    public boolean getSIDLFileInput() {
        return this.d_sidl_file_input;
    }

    public void setSIDLFileInput(boolean sf) {
        this.d_sidl_file_input = sf;
    }
}

