/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.fortran.StubSource;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class StubDoc {
    private LanguageWriterForFortran d_lw;

    public StubDoc(LanguageWriterForFortran writer) {
        this.d_lw = writer;
    }

    private void extendAndGenerate(Method m, SymbolID id) throws CodeGenerationException {
        List extendedArgs = StubSource.extendArgs(id, m, false);
        this.d_lw.writeComment(m, false);
        this.d_lw.print("subroutine " + Fortran.getMethodStubName(id, m) + "(");
        Iterator i = extendedArgs.iterator();
        while (i.hasNext()) {
            this.d_lw.print(((Argument)i.next()).getFormalName());
            if (!i.hasNext()) continue;
            this.d_lw.print(", ");
        }
        this.d_lw.println(")");
        this.d_lw.println("implicit none");
        i = Fortran.reorderArguments(extendedArgs).iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            this.d_lw.writeCommentLine(a.getArgumentString());
            this.d_lw.print(Fortran.getReturnString(a.getType()) + " " + a.getFormalName());
            if (a.getType().isRarray()) {
                this.d_lw.println(Fortran.arrayIndices(a.getType().getArrayIndices()));
                continue;
            }
            this.d_lw.println();
        }
        this.d_lw.println("end");
    }

    private Method create(SymbolID id) {
        Method m = new Method();
        m.setMethodName("_create");
        m.setDefinitionModifier(3);
        String[] s = new String[]{"Create an instance of class " + id.getFullName()};
        m.setComment(new Comment(s));
        m.setReturnType(new Type(id));
        return m;
    }

    private Collection extendMethods(Extendable ext) throws CodeGenerationException {
        Collection allMethods = ext.getMethods(true);
        SymbolID id = ext.getSymbolID();
        ArrayList<Method> extendedMethods = new ArrayList<Method>(allMethods.size() + 3);
        if (!ext.isAbstract()) {
            extendedMethods.add(this.create(id));
        }
        extendedMethods.add(Fortran.createCast(id));
        extendedMethods.add(Fortran.createCastTwo(id));
        extendedMethods.addAll(allMethods);
        return extendedMethods;
    }

    public void generateCode(Extendable ext) throws CodeGenerationException {
        Collection methods = this.extendMethods(ext);
        SymbolID id = ext.getSymbolID();
        this.d_lw.writeBanner(ext, Fortran.getImplFile(id), false, "Client-side documentation text for " + id.getFullName());
        this.d_lw.println("THIS FILE IS DOCUMENTATION - DO NOT COMPILE IT!");
        this.d_lw.println();
        this.d_lw.writeComment(ext, false);
        this.d_lw.println();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            this.d_lw.println();
            this.d_lw.println();
            this.extendAndGenerate((Method)i.next(), id);
        }
    }

    public static void generateCode(Symbol sym, LanguageWriterForFortran writer) throws CodeGenerationException {
        if (sym instanceof Extendable) {
            StubDoc doc = new StubDoc(writer);
            doc.generateCode((Extendable)sym);
        }
    }
}

