/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.writers;

import gov.llnl.babel.backend.CodeConstants;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LineCountingFilterWriter;
import java.io.PrintWriter;

public class LanguageWriterForCxx
extends LanguageWriterForC
implements CodeConstants {
    public LanguageWriterForCxx(PrintWriter writer) {
        super(writer);
        this.defineBlockComment("", "// ");
        this.enableLineBreak(80, null, null);
    }

    public LanguageWriterForCxx(PrintWriter writer, LineCountingFilterWriter lcfw) {
        super(writer, lcfw);
        this.defineBlockComment("", "// ");
        this.enableLineBreak(80, null, null);
    }

    public void beginBlockComment(boolean is_doc) {
        if (is_doc) {
            this.println("/**");
            this.defineBlockComment("", " * ");
        } else {
            this.println("// ");
        }
        this.enableBlockComment();
    }

    public void endBlockComment(boolean is_doc) {
        this.disableBlockComment();
        if (is_doc) {
            this.println(" */");
            this.defineBlockComment("", "// ");
        } else {
            this.println("// ");
        }
    }

    public void writeCommentLine(String comment) {
        if (comment != null) {
            this.println("// " + comment);
        }
    }

    public void beginBoldComment() {
        this.println();
        this.println("//////////////////////////////////////////////////");
        this.beginBlockComment(false);
    }

    public void endBoldComment() {
        this.endBlockComment(false);
        this.println();
    }

    public String getIncludeGuard(String file) {
        if (file.endsWith(".hh")) {
            int index = file.length();
            return "included_" + file.substring(0, index -= 3) + "_hh";
        }
        return super.getIncludeGuard(file);
    }
}

