/*
 * File:          gov_cca_AbstractFramework_IOR.h
 * Symbol:        gov.cca.AbstractFramework-v0.6.3
 * Symbol Type:   interface
 * Babel Version: 0.10.2
 * Description:   Intermediate Object Representation for gov.cca.AbstractFramework
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#ifndef included_gov_cca_AbstractFramework_IOR_h
#define included_gov_cca_AbstractFramework_IOR_h

#ifndef included_sidl_header_h
#include "sidl_header.h"
#endif
#ifndef included_sidl_io_Serializer_h
#include "sidl_io_Serializer.h"
#endif
#ifndef included_sidl_io_Deserializer_h
#include "sidl_io_Deserializer.h"
#endif
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Symbol "gov.cca.AbstractFramework" (version 0.6.3)
 * 
 *  This is an interface presented by a CCA-compliant framework to access its 
 *  application framing capabilities. Most of the manipulation of the 
 *  underlying framework is expected to be be done with the 
 *  gov.cca.BuilderService Port. This class exists as a sort of bootstrap 
 *  to get a Services object necessary to retrieve Port's, including 
 *  BuilderService, from the underlying framework. How the interface and 
 *  the underlying framework is created is entirely unspecified and is up 
 *  to the devices of the programmer and the framework provider.
 * 
 *  <p>Example</p>
 *  <p>
 *  Here it is assumed that an instance of AbstractFramework
 *  is created in the main() from some hypothetical implementation.
 *  The idea is to allow a complete swap of framework choice by 
 *  changing out the specified implementation class of a framework.
 *  </p>
 * 
 *  <code><pre>
 *  // java
 *  main() {
 *    cca.reference.Framework fwkimpl = new cca.reference.Framework();
 *    // change fwkimpl above to use different cca implementations when
 *    // AbstractFramework becomes part of the standard.
 *    gov.cca.AbstractFramework fwk = (gov.cca.AbstractFramework)fwkimpl;
 *    gov.cca.Services svc = 
 * 	   fwk.getServices("instance0","AppDriver",null);
 *    // From here on, access all services, components, etc
 *    // through svc.
 *    ...
 *    // when done
 *    fwk.releaseServices(svc);
 *    fwk.shutdownFramework();
 *  }
 * 
 *  // c++
 *  int functionName() {
 *    ::gov::sandia::ccafe::Framework fwkimpl;
 *    ::gov::cca::AbstractFrameworkPtr fwk;
 * 
 *    fwk = fwkimpl.getStandardFramework();
 *    ::gov::cca::Services_Interface * svc = 0;
 *    svc = fwk->getServices("instance0","AppDriver",0);
 *    // From here on, access all services, components, etc
 *    // through svc.
 *    ...
 *    // when done
 *    fwk->releaseServices(svc);
 *    svc = 0;
 *    fwk->shutdownFramework();
 * 
 *    // at scope exit, all memory is automatically cleaned up.
 *  }
 *  </pre></code>
 */

struct gov_cca_AbstractFramework__array;
struct gov_cca_AbstractFramework__object;

/*
 * Forward references for external classes and interfaces.
 */

struct gov_cca_CCAException__array;
struct gov_cca_CCAException__object;
struct gov_cca_Services__array;
struct gov_cca_Services__object;
struct gov_cca_TypeMap__array;
struct gov_cca_TypeMap__object;
struct sidl_BaseException__array;
struct sidl_BaseException__object;
struct sidl_BaseInterface__array;
struct sidl_BaseInterface__object;
struct sidl_ClassInfo__array;
struct sidl_ClassInfo__object;

/*
 * Declare the method entry point vector.
 */

struct gov_cca_AbstractFramework__epv {
  /* Implicit builtin methods */
  void* (*f__cast)(
    /* in */ void* self,
    /* in */ const char* name);
  void (*f__delete)(
    /* in */ void* self);
  void (*f__exec)(
    /* in */ void* self,
    /* in */ const char* methodName,
    /* in */ struct sidl_io_Deserializer__object* inArgs,
    /* in */ struct sidl_io_Serializer__object* outArgs);
  /* Methods introduced in sidl.BaseInterface-v0.9.1 */
  void (*f_addRef)(
    /* in */ void* self);
  void (*f_deleteRef)(
    /* in */ void* self);
  sidl_bool (*f_isSame)(
    /* in */ void* self,
    /* in */ struct sidl_BaseInterface__object* iobj);
  struct sidl_BaseInterface__object* (*f_queryInt)(
    /* in */ void* self,
    /* in */ const char* name);
  sidl_bool (*f_isType)(
    /* in */ void* self,
    /* in */ const char* name);
  struct sidl_ClassInfo__object* (*f_getClassInfo)(
    /* in */ void* self);
  /* Methods introduced in gov.cca.AbstractFramework-v0.6.3 */
  struct gov_cca_TypeMap__object* (*f_createTypeMap)(
    /* in */ void* self,
    /* out */ struct sidl_BaseInterface__object* *_ex);
  struct gov_cca_Services__object* (*f_getServices)(
    /* in */ void* self,
    /* in */ const char* selfInstanceName,
    /* in */ const char* selfClassName,
    /* in */ struct gov_cca_TypeMap__object* selfProperties,
    /* out */ struct sidl_BaseInterface__object* *_ex);
  void (*f_releaseServices)(
    /* in */ void* self,
    /* in */ struct gov_cca_Services__object* svc,
    /* out */ struct sidl_BaseInterface__object* *_ex);
  void (*f_shutdownFramework)(
    /* in */ void* self,
    /* out */ struct sidl_BaseInterface__object* *_ex);
  struct gov_cca_AbstractFramework__object* (*f_createEmptyFramework)(
    /* in */ void* self,
    /* out */ struct sidl_BaseInterface__object* *_ex);
};

/*
 * Define the interface object structure.
 */

struct gov_cca_AbstractFramework__object {
  struct gov_cca_AbstractFramework__epv* d_epv;
  void*                                  d_object;
};

#ifdef __cplusplus
}
#endif
#endif
