/*
 * File:          ArrayTest_ArrayOps_Impl.c
 * Symbol:        ArrayTest.ArrayOps-v1.3
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for ArrayTest.ArrayOps
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "ArrayTest.ArrayOps" (version 1.3)
 */

#include "ArrayTest_ArrayOps_Impl.h"

#line 24 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
/* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._includes) */
#include "ArrayTest_ArrayOps_IOR.h"
#include "ArrayTest_ArrayOps.h"
#include "sidl_BaseInterface.h"
#include "sidlArray.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

static int32_t intFunc(const int dimen, const int32_t ind[])
{
  int32_t result = 1;
  int i;
  for(i = 0;i < dimen; ++i){
    result *= (ind[i] + (i + 1));
  }
  return result;
}

/** The arrays are passed in by reference here, this function increased
 *  the indicies, until it goes over the end of the array, it then returns
 *   false.
 */

static int
next(const int dimen, int32_t ind[],
     const int32_t lower[], const int32_t upper[])
{
  int i = 0;
  while ((i < dimen) && (++(ind[i]) > upper[i])) {
    ind[i] = lower[i];
    ++i;
  }
  return i < dimen;
}
/** This function creates a test C array according to the specs.
 *  One odd thing is it tests all 3 ways of setting an arrays element  
 *  It selects amoung these choices randomly.  (C Macro, array indicies,
 *  and explicit indicies. ) 
 */
static struct sidl_int__array *
makeIntTestMatrix(int dimen)
{
  struct sidl_int__array *result = NULL;
  static const int32_t lower[] = {0, 0, 0, 0, 0, 0, 0};
  static const int32_t upper[] = {3, 3, 2, 2, 2, 2, 2};
  int32_t ind[] = {0, 0, 0, 0, 0, 0, 0};
  int32_t value;
  result  = sidl_int__array_createCol(dimen, lower, upper);
  do {  
    value = intFunc(dimen, ind);
    switch(rand() % 3) {
    case 0:
      switch(dimen) {
      case 3:
        sidlArrayElem3(result, ind[0], ind[1], ind[2]) = value;
	break;
      case 4:
        sidlArrayElem4(result, ind[0], ind[1], ind[2], ind[3]) = value;
	break;
      case 5:
	sidlArrayElem5(result, ind[0], ind[1], ind[2], ind[3], ind[4]) = value;
	break;
      case 6:
	sidlArrayElem6(result, ind[0], ind[1], ind[2], ind[3], ind[4],
		       ind[5]) = value;
	break;
      case 7:
	sidlArrayElem7(result, ind[0], ind[1], ind[2], ind[3], ind[4],
		       ind[5], ind[6]) = value;
	break;
      }
      break;
    case 1:
      sidl_int__array_set(result, ind, value);
      break;
    case 2:
      switch(dimen) {
      case 3:
        sidl_int__array_set3(result, ind[0], ind[1], ind[2], value);
	break;
      case 4:
        sidl_int__array_set4(result, ind[0], ind[1], ind[2], ind[3], value);
	break;
      case 5:
	sidl_int__array_set5(result, ind[0], ind[1], ind[2], ind[3], 
			     ind[4], value);
	break;
      case 6:
	sidl_int__array_set6(result, ind[0], ind[1], ind[2], ind[3], 
			     ind[4], ind[5], value);
	break;
      case 7:
	sidl_int__array_set7(result, ind[0], ind[1], ind[2], ind[3], 
			     ind[4], ind[5], ind[6], value);
	break;
      }
      break;
    }
  } while (next(dimen, ind, lower, upper));
  return result;
}

double powTwo(int64_t i) {
  double result = 1;
  if (i >= 0) {
    while (i--) {
      result *= 2;
    }
  }
  else if (i < 0) {
    while (i++) {
      result *= 0.5;
    }
  }
  return result;
}

float fpowTwo(int64_t i) {
  register float result = 0.0F;
  static volatile float forcestore;                               
 
  result = 1.0F;
  if (i >= 0) {
    while (i--) {
      result *= 2.0F;
    }
  }
  else if (i < 0) {
    while (i++) {
      result *= 0.5F;
    }
  }
  forcestore = result;
  return forcestore;
}

static int isPrime(const int64_t num) {
  register int64_t i;
  for(i = 3L; i*i <= num; ++i) {
    if (!(num % i)) return 0;
  }
  return 1;
}

int64_t
nextPrime(int64_t prev) {
  if (prev <= 1L) {
    return 2L;
  }
  else if (prev == 2L) {
    return 3L;
  }
  else {
    do {
      prev += 2L;
    } while (!isPrime(prev));
    return prev;
  }
}

static const char s_TestText[] = "\
I'd rather write programs to write programs than write programs.";

static const char *s_TestWords[] = {
  "I'd",
  "rather",
  "write",
  "programs",
  "to",
  "write",
  "programs",
  "than",
  "write",
  "programs.",
  NULL
};

const char *nextChar(const char *str) {
  if (!*(++str)) {
    str = s_TestText;
  }
  return str;
}

const char * const* nextWord(const char *const*word) {
  if (!*(++word)){
    word = s_TestWords;
  }
  return word;
}

static int
nextElem(const int32_t dimen,
         int32_t ind[],
         const int32_t lower[],
         const int32_t upper[])
{
  int i = 0;
  while ((i < dimen) && (++(ind[i]) > upper[i])) {
    ind[i] = lower[i];
    ++i;
  }
  return i < dimen;
}

static int32_t
arrayValue(const int dimen, const int32_t ind[])
{
  int32_t result = 1;
  int i;
  for(i = 0; i < dimen; ++i){
    result *= (ind[i] + (i + 1));
  }
  return result;
}

static int
hasElements(const int dimen, const int32_t lower[], const int32_t upper[])
{
  int i;
  for (i = 0; i < dimen; ++i){
    if (lower[i] > upper[i]) return 0;
  }
  return 1;
}

static struct sidl__array *
createArrayByType(const int32_t type,
                  const int32_t dimen,
                  const int32_t lower[],
                  const int32_t upper[])
{
  switch(type){
  case sidl_bool_array:
    return (struct sidl__array *)
      sidl_bool__array_createRow(dimen, lower, upper);
  case sidl_char_array:
    return (struct sidl__array *)
      sidl_char__array_createRow(dimen, lower, upper);
  case sidl_dcomplex_array:
    return (struct sidl__array *)
      sidl_dcomplex__array_createRow(dimen, lower, upper);
  case sidl_double_array:
    return (struct sidl__array *)
      sidl_double__array_createRow(dimen, lower, upper);
  case sidl_fcomplex_array:
    return (struct sidl__array *)
      sidl_fcomplex__array_createRow(dimen, lower, upper);
  case sidl_float_array:
    return (struct sidl__array *)
      sidl_float__array_createRow(dimen, lower, upper);
  case sidl_int_array:
    return (struct sidl__array *)
      sidl_int__array_createRow(dimen, lower, upper);
  case sidl_long_array:
    return (struct sidl__array *)
      sidl_long__array_createRow(dimen, lower, upper);
  case sidl_opaque_array:
    return (struct sidl__array *)
      sidl_opaque__array_createRow(dimen, lower, upper);
  case sidl_string_array:
    return (struct sidl__array *)
      sidl_string__array_createRow(dimen, lower, upper);
  case sidl_interface_array:
    return (struct sidl__array *)
      sidl_BaseInterface__array_createRow(dimen, lower, upper);
  default:
    return NULL;
  }
}

static void
copyArrayByType(const struct sidl__array *src,
                struct sidl__array *dest)
{
  switch(sidl__array_type(src)){
  case sidl_bool_array:
    sidl_bool__array_copy((const struct sidl_bool__array *)src,
                          (struct sidl_bool__array *)dest);
    break;
  case sidl_char_array:
    sidl_char__array_copy((const struct sidl_char__array *)src,
                          (struct sidl_char__array *)dest);
    break;
  case sidl_dcomplex_array:
    sidl_dcomplex__array_copy((const struct sidl_dcomplex__array *)src, 
                              (struct sidl_dcomplex__array *)dest);
    break;
  case sidl_double_array:
    sidl_double__array_copy((const struct sidl_double__array *)src, 
                            (struct sidl_double__array *)dest);
    break;
  case sidl_fcomplex_array:
    sidl_fcomplex__array_copy((const struct sidl_fcomplex__array *)src,
                              (struct sidl_fcomplex__array *)dest);
    break;
  case sidl_float_array:
    sidl_float__array_copy((const struct sidl_float__array *)src, 
                           (struct sidl_float__array *)dest);
    break;
  case sidl_int_array:
    sidl_int__array_copy((const struct sidl_int__array *)src,
                         (struct sidl_int__array *)dest);
    break;
  case sidl_long_array:
    sidl_long__array_copy((const struct sidl_long__array *)src, 
                          (struct sidl_long__array *)dest);
    break;
  case sidl_opaque_array:
    sidl_opaque__array_copy((const struct sidl_opaque__array *)src,
                            (struct sidl_opaque__array *)dest);
    break;
  case sidl_string_array:
    sidl_string__array_copy((const struct sidl_string__array *)src,
                            (struct sidl_string__array *)dest);
    break;
  case sidl_interface_array:
    sidl_BaseInterface__array_copy
      ((const struct sidl_BaseInterface__array *)src,
       (struct sidl_BaseInterface__array *)dest);
    break;
  }
}

void matrixMultiply(
  /*in*/ int32_t* a, /*in*/ int32_t* b, /*inout*/ int32_t* res,
    /*in*/ int32_t n, /*in*/ int32_t m, /*in*/ int32_t o)
{
  int32_t i,j,k;

  for(i=0;i<n;++i){
    for(k=0;k<o;++k){
      int32_t temp = 0;
      for(j=0;j<m;++j) {
	temp += (RarrayElem2(a,i,j,n) * RarrayElem2(b,j,k,m));
      }
      RarrayElem2(res,i,k,n) = temp;
    }
  }  
}



/* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._includes) */
#line 370 "ArrayTest_ArrayOps_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps__load"

void
impl_ArrayTest_ArrayOps__load(
  void)
{
#line 381 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._load) */
#line 387 "ArrayTest_ArrayOps_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps__ctor"

void
impl_ArrayTest_ArrayOps__ctor(
  /* in */ ArrayTest_ArrayOps self)
{
#line 396 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._ctor) */
  /* nothing needed */
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._ctor) */
#line 404 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps__dtor"

void
impl_ArrayTest_ArrayOps__dtor(
  /* in */ ArrayTest_ArrayOps self)
{
#line 412 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._dtor) */
  /* nothing needed */
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._dtor) */
#line 422 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Return <code>true</code> iff the even elements are true and
 * the odd elements are false.
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkBool"

sidl_bool
impl_ArrayTest_ArrayOps_checkBool(
  /* in */ struct sidl_bool__array* a)
{
#line 429 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkBool) */
  if (a && (1 == sidl_bool__array_dimen(a)) && (1 == sidlArrayDim(a)) &&
      (sidlLower(a,0) == sidl_bool__array_lower(a,0)) &&
      (sidlUpper(a,0) == sidl_bool__array_upper(a,0))) {
    int32_t i, ind[1];
    for(i = sidlLower(a,0); i <= sidlUpper(a,0);  ++i) {
      ind[0] = i;
      if ((sidlArrayElem1(a,i) != sidl_bool__array_get1(a, i)) ||
          (sidlArrayElem1(a,i) != sidl_bool__array_get(a, ind)) ||
          (sidlArrayElem1(a,i) != ((i & 0x1) ? FALSE : TRUE))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkBool) */
#line 455 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkChar[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkChar"

sidl_bool
impl_ArrayTest_ArrayOps_checkChar(
  /* in */ struct sidl_char__array* a)
{
#line 459 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkChar) */
  if (a && (1 == sidl_char__array_dimen(a)) && (1 == sidlArrayDim(a)) &&
      (sidlLower(a,0) == sidl_char__array_lower(a,0)) &&
      (sidlUpper(a,0) == sidl_char__array_upper(a,0))) {
    int32_t i, ind[1];
    const char *testStr = s_TestText;
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); 
        ++i, testStr = nextChar(testStr)) {
      ind[0] = i;
      if ((sidlArrayElem1(a,i) != sidl_char__array_get1(a, i)) ||
          (sidlArrayElem1(a,i) != sidl_char__array_get(a, ind)) ||
          (sidlArrayElem1(a,i) != *testStr)) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkChar) */
#line 489 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkInt[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkInt"

sidl_bool
impl_ArrayTest_ArrayOps_checkInt(
  /* in */ struct sidl_int__array* a)
{
#line 491 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkInt) */
  if (a && (1 == sidl_int__array_dimen(a)) && (1 == sidlArrayDim(a)) &&
      (sidlLower(a,0) == sidl_int__array_lower(a,0)) &&
      (sidlUpper(a,0) == sidl_int__array_upper(a,0))) {
    int32_t i, ind[1];
    int64_t lprime = nextPrime(0L);
    int32_t prime;
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); 
        ++i, lprime = nextPrime(lprime)) {
      prime = (int32_t)lprime;
      ind[0] = i;
      if ((sidlArrayElem1(a,i) != sidl_int__array_get1(a, i)) ||
          (sidlArrayElem1(a,i) != sidl_int__array_get(a, ind)) ||
          (sidlArrayElem1(a,i) != prime)) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkInt) */
#line 525 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkLong[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkLong"

sidl_bool
impl_ArrayTest_ArrayOps_checkLong(
  /* in */ struct sidl_long__array* a)
{
#line 525 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkLong) */
  if (a && (1 == sidl_long__array_dimen(a)) && (1 == sidlArrayDim(a)) &&
      (sidlLower(a,0) == sidl_long__array_lower(a,0)) &&
      (sidlUpper(a,0) == sidl_long__array_upper(a,0))) {
    int32_t i, ind[1];
    int64_t prime = nextPrime(0L);
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); 
        ++i, prime = nextPrime(prime)) {
      ind[0] = i;
      if ((sidlArrayElem1(a,i) != sidl_long__array_get1(a, i)) ||
          (sidlArrayElem1(a,i) != sidl_long__array_get(a, ind)) ||
          (sidlArrayElem1(a,i) != prime)) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkLong) */
#line 559 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkString[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkString"

sidl_bool
impl_ArrayTest_ArrayOps_checkString(
  /* in */ struct sidl_string__array* a)
{
#line 557 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkString) */
  if (a && (1 == sidl_string__array_dimen(a))) {
    int32_t i, ind[1];
    const char * const *testWord = s_TestWords;
    for(i = sidl_string__array_lower(a,0); 
        i <= sidl_string__array_upper(a,0); 
        ++i, testWord = nextWord(testWord)) {
      char *s1, *s2;
      ind[0] = i;
      s1 = sidl_string__array_get1(a, i);
      s2 = sidl_string__array_get(a, ind);
      if (!(s1 && s2 && !strcmp(s1, s2) && !strcmp(s1, *testWord))) {
        free(s1);
        free(s2);
        return FALSE;
      }
      free(s1);
      free(s2);
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkString) */
#line 597 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkDouble[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkDouble"

sidl_bool
impl_ArrayTest_ArrayOps_checkDouble(
  /* in */ struct sidl_double__array* a)
{
#line 593 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDouble) */
  if (a && (1 == sidl_double__array_dimen(a)) && (1 == sidlArrayDim(a)) &&
      (sidlLower(a,0) == sidl_double__array_lower(a,0)) &&
      (sidlUpper(a,0) == sidl_double__array_upper(a,0))) {
    int32_t i, ind[1];
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); ++i) {
      ind[0] = i;
      if ((sidlArrayElem1(a,i) != sidl_double__array_get1(a, i)) ||
          (sidlArrayElem1(a,i) != sidl_double__array_get(a, ind)) ||
          (sidlArrayElem1(a,i) != powTwo(-i))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDouble) */
#line 629 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkFloat[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkFloat"

sidl_bool
impl_ArrayTest_ArrayOps_checkFloat(
  /* in */ struct sidl_float__array* a)
{
#line 623 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFloat) */
  if (a && (1 == sidl_float__array_dimen(a)) && (1 == sidlArrayDim(a)) &&
      (sidlLower(a,0) == sidl_float__array_lower(a,0)) &&
      (sidlUpper(a,0) == sidl_float__array_upper(a,0))) {
    int32_t i, ind[1];
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); ++i) {
      ind[0] = i;
      if ((sidlArrayElem1(a,i) != sidl_float__array_get1(a, i)) ||
          (sidlArrayElem1(a,i) != sidl_float__array_get(a, ind)) ||
          (sidlArrayElem1(a,i) != fpowTwo(-i))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFloat) */
#line 661 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkFcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkFcomplex"

sidl_bool
impl_ArrayTest_ArrayOps_checkFcomplex(
  /* in */ struct sidl_fcomplex__array* a)
{
#line 653 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFcomplex) */
  if (a && (1 == sidl_fcomplex__array_dimen(a)) && (1 == sidlArrayDim(a)) &&
      (sidlLower(a,0) == sidl_fcomplex__array_lower(a,0)) &&
      (sidlUpper(a,0) == sidl_fcomplex__array_upper(a,0))) {
    int32_t i, ind[1];
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); ++i) {
      struct sidl_fcomplex r1 = sidl_fcomplex__array_get1(a, i);
      struct sidl_fcomplex r2;
      ind[0] = i;
      r2 = sidl_fcomplex__array_get(a, ind);
      if (memcmp(&r1, &sidlArrayElem1(a,i), 
                 sizeof(struct sidl_fcomplex)) ||
          memcmp(&r1, &r2, sizeof(struct sidl_fcomplex)) ||
          (sidlArrayElem1(a,i).real != fpowTwo(i)) ||
          (sidlArrayElem1(a,i).imaginary != fpowTwo(-i))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFcomplex) */
#line 698 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkDcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkDcomplex"

sidl_bool
impl_ArrayTest_ArrayOps_checkDcomplex(
  /* in */ struct sidl_dcomplex__array* a)
{
#line 688 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDcomplex) */
  if (a && (1 == sidl_dcomplex__array_dimen(a)) && (1 == sidlArrayDim(a)) &&
      (sidlLower(a,0) == sidl_dcomplex__array_lower(a,0)) &&
      (sidlUpper(a,0) == sidl_dcomplex__array_upper(a,0))) {
    int32_t i, ind[1];
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); ++i) {
      struct sidl_dcomplex r1 = sidl_dcomplex__array_get1(a, i);
      struct sidl_dcomplex r2;
      ind[0] = i;
      r2 = sidl_dcomplex__array_get(a, ind);
      if (memcmp(&r1, &sidlArrayElem1(a,i),
                 sizeof(struct sidl_dcomplex)) ||
          memcmp(&r1, &r2, sizeof(struct sidl_dcomplex)) ||
          (sidlArrayElem1(a,i).real != powTwo(i)) ||
          (sidlArrayElem1(a,i).imaginary != powTwo(-i))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDcomplex) */
#line 735 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  check2Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check2Int"

sidl_bool
impl_ArrayTest_ArrayOps_check2Int(
  /* in */ struct sidl_int__array* a)
{
#line 723 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Int) */
  if (a && (2 == sidl_int__array_dimen(a)) && (2 == sidlArrayDim(a))) {
    int32_t i, j, ind[2];
    for(i = 0; i < 2; ++i){
      if ((sidlLower(a,i) != sidl_int__array_lower(a,i)) ||
          (sidlUpper(a,i) != sidl_int__array_upper(a,i))) {
	return FALSE;
      }
    }
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); ++i){
      ind[0] = i;
      for(j = sidlLower(a,1); j <= sidlUpper(a,1); ++j) {
        ind[1] = j;	
        if ((sidlArrayElem2(a, i, j) != 
             sidl_int__array_get2(a, i, j)) ||
            (sidlArrayElem2(a, i, j) !=
             sidl_int__array_get(a, ind)) ||
            (sidlArrayElem2(a, i, j) != (int)powTwo(abs(i-j)))) {
	  return FALSE;
        }
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Int) */
#line 776 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  check2Double[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check2Double"

sidl_bool
impl_ArrayTest_ArrayOps_check2Double(
  /* in */ struct sidl_double__array* a)
{
#line 762 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Double) */
  if (a && (2 == sidl_double__array_dimen(a)) && (2 == sidlArrayDim(a))) {
    int32_t i, j, ind[2];
    for(i = 0; i < 2; ++i){
      if ((sidlLower(a,i) != sidl_double__array_lower(a,i)) ||
          (sidlUpper(a,i) != sidl_double__array_upper(a,i))) {
        return FALSE;
      }
    }
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); ++i){
      for(j = sidlLower(a,1); j <= sidlUpper(a,1); ++j) {
        ind[0] = i;
        ind[1] = j;
        if ((sidlArrayElem2(a, i, j) != 
             sidl_double__array_get2(a, i, j)) ||
            (sidlArrayElem2(a, i, j) !=
             sidl_double__array_get(a, ind)) ||
            (sidlArrayElem2(a, i, j) != powTwo(i-j))) {
          return FALSE;
        }
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Double) */
#line 817 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  check2Float[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check2Float"

sidl_bool
impl_ArrayTest_ArrayOps_check2Float(
  /* in */ struct sidl_float__array* a)
{
#line 801 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Float) */
  if (a && (2 == sidl_float__array_dimen(a)) && (2 == sidlArrayDim(a))) {
    int32_t i, j, ind[2];
    for(i = 0; i < 2; ++i){
      if ((sidlLower(a,i) != sidl_float__array_lower(a,i)) ||
          (sidlUpper(a,i) != sidl_float__array_upper(a,i))) {
        return FALSE;
      }
    }
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); ++i){
      for(j = sidlLower(a,1); j <= sidlUpper(a,1); ++j) {
        ind[0] = i;
        ind[1] = j;
        if ((sidlArrayElem2(a, i, j) != 
             sidl_float__array_get2(a, i, j)) ||
            (sidlArrayElem2(a, i, j) !=
             sidl_float__array_get(a, ind)) ||
            (sidlArrayElem2(a, i, j) != fpowTwo(i-j))) {
          return FALSE;
        }
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Float) */
#line 858 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  check2Fcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check2Fcomplex"

sidl_bool
impl_ArrayTest_ArrayOps_check2Fcomplex(
  /* in */ struct sidl_fcomplex__array* a)
{
#line 840 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Fcomplex) */
  if (a && (2 == sidl_fcomplex__array_dimen(a)) && (2 == sidlArrayDim(a))) {
    int32_t i, j, ind[2];
    for(i = 0; i < 2; ++i){
      if ((sidlLower(a,i) != sidl_fcomplex__array_lower(a,i)) ||
          (sidlUpper(a,i) != sidl_fcomplex__array_upper(a,i))) {
        return FALSE;
      }
    }
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); ++i){
      for(j = sidlLower(a,1); j <= sidlUpper(a,1); ++j) {
        struct sidl_fcomplex r1 = sidl_fcomplex__array_get2(a, i, j);
        struct sidl_fcomplex r2;
        ind[0] = i;
        ind[1] = j;
        r2 = sidl_fcomplex__array_get(a, ind);
        if (memcmp(&r1, &sidlArrayElem2(a, i, j),
                   sizeof(struct sidl_fcomplex)) ||
            memcmp(&r1, &r2, sizeof(struct sidl_fcomplex)) ||
            (sidlArrayElem2(a, i, j).real != fpowTwo(i)) ||
            (sidlArrayElem2(a, i, j).imaginary != fpowTwo(-j))) {
          return FALSE;
        }
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Fcomplex) */
#line 902 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  check2Dcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check2Dcomplex"

sidl_bool
impl_ArrayTest_ArrayOps_check2Dcomplex(
  /* in */ struct sidl_dcomplex__array* a)
{
#line 882 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Dcomplex) */
  if (a && (2 == sidl_dcomplex__array_dimen(a)) && (2 == sidlArrayDim(a))) {
    int32_t i, j, ind[2];
    for(i = 0; i < 2; ++i){
      if ((sidlLower(a,i) != sidl_dcomplex__array_lower(a,i)) ||
          (sidlUpper(a,i) != sidl_dcomplex__array_upper(a,i))) {
        return FALSE;
      }
    }
    for(i = sidlLower(a,0); i <= sidlUpper(a,0); ++i){
      for(j = sidlLower(a,1); j <= sidlUpper(a,1); ++j) {
        struct sidl_dcomplex r1 = sidl_dcomplex__array_get2(a, i, j);
        struct sidl_dcomplex r2;
        ind[0] = i;
        ind[1] = j;
        r2 = sidl_dcomplex__array_get(a, ind);
        if (memcmp(&r1, &sidlArrayElem2(a, i, j),
                   sizeof(struct sidl_dcomplex)) ||
            memcmp(&r1, &r2, sizeof(struct sidl_dcomplex)) ||
            (sidlArrayElem2(a, i, j).real != powTwo(i)) ||
            (sidlArrayElem2(a, i, j).imaginary != powTwo(-j))) {
          return FALSE;
        }
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Dcomplex) */
#line 946 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  check3Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check3Int"

sidl_bool
impl_ArrayTest_ArrayOps_check3Int(
  /* in */ struct sidl_int__array* a)
{
#line 924 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check3Int) */
  
  int result = FALSE;
  if (a && sidl_int__array_dimen(a) == 3) {
    result = TRUE;
    if (hasElements(3, a->d_metadata.d_lower, a->d_metadata.d_upper)) {
      int32_t ind[3], value;
      memcpy(ind, a->d_metadata.d_lower, sizeof(int32_t)*3);
      do {
        value = arrayValue(3, ind);
        switch(rand() % 3) {
        case 0:
          if (sidlArrayElem3(a, ind[0], ind[1], ind[2]) != value) {
	    result = FALSE;
	  }
          break;
        case 1:
          if (sidl_int__array_get3(a, ind[0], ind[1], ind[2]) != value) {
            result = FALSE;
	  }
          break;
        case 2:
          if (sidl_int__array_get(a, ind) != value) {
            result = FALSE;
	  }
          break;
        }
      } while (result && nextElem(3, ind, a->d_metadata.d_lower,
                                  a->d_metadata.d_upper));
    }
  }
  
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check3Int) */
#line 995 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  check4Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check4Int"

sidl_bool
impl_ArrayTest_ArrayOps_check4Int(
  /* in */ struct sidl_int__array* a)
{
#line 971 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check4Int) */
  int result = FALSE;
  if (a && sidl_int__array_dimen(a) == 4) {
    result = TRUE;
    if (hasElements(4, a->d_metadata.d_lower, a->d_metadata.d_upper)) {
      int32_t ind[4], value;
      memcpy(ind, a->d_metadata.d_lower, sizeof(int32_t)*4);
      do {
	
        value = arrayValue(4, ind);
	switch(rand() % 3) {
        case 0:
          if (sidlArrayElem4(a, ind[0], ind[1], ind[2], ind[3]) != value)
            result = FALSE;
          break;
        case 1:
          if (sidl_int__array_get4(a, ind[0], ind[1], ind[2], ind[3])
              != value)
            result = FALSE;
          break;
        case 2:
          if (sidl_int__array_get(a, ind) != value) 
            result = FALSE;
          break;
        }
	
      } while (result && nextElem(4, ind, a->d_metadata.d_lower,
                                  a->d_metadata.d_upper));
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check4Int) */
#line 1042 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  check5Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check5Int"

sidl_bool
impl_ArrayTest_ArrayOps_check5Int(
  /* in */ struct sidl_int__array* a)
{
#line 1016 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check5Int) */
  int result = FALSE;
  if (a && sidl_int__array_dimen(a) == 5) {
    result = TRUE;
    if (hasElements(5, a->d_metadata.d_lower, a->d_metadata.d_upper)) {
      int32_t ind[5], value;
      memcpy(ind, a->d_metadata.d_lower, sizeof(int32_t)*5);
      do {
        value = arrayValue(5, ind);
        switch(rand() % 3) {
        case 0:
          if (sidlArrayElem5(a, ind[0], ind[1], ind[2], ind[3], ind[4]) != value)
            result = FALSE;
          break;
        case 1:
          if (sidl_int__array_get5(a, ind[0], ind[1], ind[2], ind[3], ind[4])
              != value)
            result = FALSE;
          break;
        case 2:
          if (sidl_int__array_get(a, ind) != value) 
            result = FALSE;
          break;
        }
      } while (result && nextElem(5, ind, a->d_metadata.d_lower, 
                                  a->d_metadata.d_upper));
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check5Int) */
#line 1087 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  check6Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check6Int"

sidl_bool
impl_ArrayTest_ArrayOps_check6Int(
  /* in */ struct sidl_int__array* a)
{
#line 1059 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check6Int) */
  int result = FALSE;
  if (a && sidl_int__array_dimen(a) == 6) {
    result = TRUE;
    if (hasElements(6, a->d_metadata.d_lower, a->d_metadata.d_upper)) {
      int32_t ind[6], value;
      memcpy(ind, a->d_metadata.d_lower, sizeof(int32_t)*6);
      do {
        value = arrayValue(6, ind);
        switch(rand() % 3) {
        case 0:
          if (sidlArrayElem6(a, ind[0], ind[1], ind[2], ind[3], ind[4], ind[5]) 
	      != value)
            result = FALSE;
          break;
        case 1:
          if (sidl_int__array_get6(a, ind[0], ind[1], ind[2], ind[3], 
				   ind[4], ind[5]) != value)
            result = FALSE;
          break;
        case 2:
          if (sidl_int__array_get(a, ind) != value) 
            result = FALSE;
          break;
        }
      } while (result && nextElem(6, ind, a->d_metadata.d_lower,
                                  a->d_metadata.d_upper));
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check6Int) */
#line 1133 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  check7Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check7Int"

sidl_bool
impl_ArrayTest_ArrayOps_check7Int(
  /* in */ struct sidl_int__array* a)
{
#line 1103 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check7Int) */
  int result = FALSE;
  if (a && sidl_int__array_dimen(a) == 7) {
    result = TRUE;
    if (hasElements(7, a->d_metadata.d_lower, a->d_metadata.d_upper)) {
      int32_t ind[7], value;
      memcpy(ind, a->d_metadata.d_lower, sizeof(int32_t)*7);
      do {
        value = arrayValue(7, ind);
        switch(rand() % 3) {
        case 0:
          if (sidlArrayElem7(a, ind[0], ind[1], ind[2], ind[3], 
			     ind[4], ind[5], ind[6]) != value)
            result = FALSE;
          break;
        case 1:
          if (sidl_int__array_get7(a, ind[0], ind[1], ind[2], ind[3], 
				   ind[4], ind[5], ind[6]) != value)
            result = FALSE;
          break;
        case 2:
          if (sidl_int__array_get(a, ind) != value) 
            result = FALSE;
          break;
        }
      } while (result && nextElem(7, ind, a->d_metadata.d_lower, 
                                  a->d_metadata.d_upper));
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check7Int) */
#line 1179 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkObject[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkObject"

int32_t
impl_ArrayTest_ArrayOps_checkObject(
  /* in */ struct ArrayTest_ArrayOps__array* a)
{
#line 1147 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkObject) */
  if (a && ArrayTest_ArrayOps__array_dimen(a) == 1) {
    const int32_t upper = ArrayTest_ArrayOps__array_upper(a, 0);
    int32_t i, count=0;
    for(i = ArrayTest_ArrayOps__array_lower(a, 0); i <= upper; ++i) {
      ArrayTest_ArrayOps obj = ArrayTest_ArrayOps__array_get1(a, i);
      if (ArrayTest_ArrayOps__cast(obj) != NULL) {
        ++count;
        ArrayTest_ArrayOps_deleteRef(obj);
      }
    }
    return count;
  }
  return 0;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkObject) */
#line 1209 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  reverseBool[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseBool"

sidl_bool
impl_ArrayTest_ArrayOps_reverseBool(
  /* inout */ struct sidl_bool__array** a,
  /* in */ sidl_bool newArray)
{
#line 1176 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseBool) */
  sidl_bool result = FALSE;
  if (*a && sidl_bool__array_dimen(*a) == 1) {
    const int32_t upper = sidl_bool__array_upper(*a,0);
    const int32_t lower = sidl_bool__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkBool(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct sidl_bool__array
        *copy = sidl_bool__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        sidl_bool__array_set1(copy, upper - i,
                              sidl_bool__array_get1(*a,lower + i));
      }
      sidl_bool__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        sidl_bool tmp = sidl_bool__array_get1(*a, lower + i);
        sidl_bool__array_set1(*a, lower + i,
                              sidl_bool__array_get1(*a, upper - i));
        sidl_bool__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseBool) */
#line 1257 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  reverseChar[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseChar"

sidl_bool
impl_ArrayTest_ArrayOps_reverseChar(
  /* inout */ struct sidl_char__array** a,
  /* in */ sidl_bool newArray)
{
#line 1222 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseChar) */
  sidl_bool result = FALSE;
  if (*a && sidl_char__array_dimen(*a) == 1) {
    const int32_t upper = sidl_char__array_upper(*a,0);
    const int32_t lower = sidl_char__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkChar(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct sidl_char__array
        *copy = sidl_char__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        sidl_char__array_set1(copy, upper - i,
                              sidl_char__array_get1(*a,lower + i));
      }
      sidl_char__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        char tmp = sidl_char__array_get1(*a, lower + i);
        sidl_char__array_set1(*a, lower + i,
                              sidl_char__array_get1(*a, upper - i));
        sidl_char__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseChar) */
#line 1305 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  reverseInt[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseInt"

sidl_bool
impl_ArrayTest_ArrayOps_reverseInt(
  /* inout */ struct sidl_int__array** a,
  /* in */ sidl_bool newArray)
{
#line 1268 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseInt) */
  sidl_bool result = FALSE;
  if (*a && sidl_int__array_dimen(*a) == 1) {
    const int32_t upper = sidl_int__array_upper(*a,0);
    const int32_t lower = sidl_int__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkInt(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct sidl_int__array
        *copy = sidl_int__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        sidl_int__array_set1(copy, upper - i,
                             sidl_int__array_get1(*a,lower + i));
      }
      sidl_int__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        int32_t tmp = sidl_int__array_get1(*a, lower + i);
        sidl_int__array_set1(*a, lower + i,
                             sidl_int__array_get1(*a, upper - i));
        sidl_int__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseInt) */
#line 1353 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  reverseLong[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseLong"

sidl_bool
impl_ArrayTest_ArrayOps_reverseLong(
  /* inout */ struct sidl_long__array** a,
  /* in */ sidl_bool newArray)
{
#line 1314 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseLong) */
  sidl_bool result = FALSE;
  if (*a && sidl_long__array_dimen(*a) == 1) {
    const int32_t upper = sidl_long__array_upper(*a,0);
    const int32_t lower = sidl_long__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkLong(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct sidl_long__array
        *copy = sidl_long__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        sidl_long__array_set1(copy, upper - i,
                              sidl_long__array_get1(*a,lower + i));
      }
      sidl_long__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        int64_t tmp = sidl_long__array_get1(*a, lower + i);
        sidl_long__array_set1(*a, lower + i,
                              sidl_long__array_get1(*a, upper - i));
        sidl_long__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseLong) */
#line 1401 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  reverseString[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseString"

sidl_bool
impl_ArrayTest_ArrayOps_reverseString(
  /* inout */ struct sidl_string__array** a,
  /* in */ sidl_bool newArray)
{
#line 1360 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseString) */
  sidl_bool result = FALSE;
  if (*a && sidl_string__array_dimen(*a) == 1) {
    const int32_t upper = sidl_string__array_upper(*a,0);
    const int32_t lower = sidl_string__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkString(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct sidl_string__array
        *copy = sidl_string__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        char *tmp = sidl_string__array_get1(*a,lower + i);
        sidl_string__array_set1(copy, upper - i, tmp);
        free(tmp);
      }
      sidl_string__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        char *tmp1 = sidl_string__array_get1(*a, lower + i);
        char *tmp2 = sidl_string__array_get1(*a, upper - i);
        sidl_string__array_set1(*a, lower + i, tmp2);
        sidl_string__array_set1(*a, upper - i, tmp1);
        free(tmp2);
        free(tmp1);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseString) */
#line 1452 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  reverseDouble[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseDouble"

sidl_bool
impl_ArrayTest_ArrayOps_reverseDouble(
  /* inout */ struct sidl_double__array** a,
  /* in */ sidl_bool newArray)
{
#line 1409 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDouble) */
  sidl_bool result = FALSE;
  if (*a && sidl_double__array_dimen(*a) == 1) {
    const int32_t upper = sidl_double__array_upper(*a,0);
    const int32_t lower = sidl_double__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkDouble(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct sidl_double__array
        *copy = sidl_double__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        sidl_double__array_set1(copy, upper - i,
                                sidl_double__array_get1(*a,lower + i));
      }
      sidl_double__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        double tmp = sidl_double__array_get1(*a, lower + i);
        sidl_double__array_set1(*a, lower + i,
                                sidl_double__array_get1(*a, upper - i));
        sidl_double__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDouble) */
#line 1500 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  reverseFloat[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseFloat"

sidl_bool
impl_ArrayTest_ArrayOps_reverseFloat(
  /* inout */ struct sidl_float__array** a,
  /* in */ sidl_bool newArray)
{
#line 1455 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFloat) */
  sidl_bool result = FALSE;
  if (*a && sidl_float__array_dimen(*a) == 1) {
    const int32_t upper = sidl_float__array_upper(*a,0);
    const int32_t lower = sidl_float__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkFloat(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct sidl_float__array
        *copy = sidl_float__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        sidl_float__array_set1(copy, upper - i,
                               sidl_float__array_get1(*a,lower + i));
      }
      sidl_float__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        float tmp = sidl_float__array_get1(*a, lower + i);
        sidl_float__array_set1(*a, lower + i,
                               sidl_float__array_get1(*a, upper - i));
        sidl_float__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFloat) */
#line 1548 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  reverseFcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseFcomplex"

sidl_bool
impl_ArrayTest_ArrayOps_reverseFcomplex(
  /* inout */ struct sidl_fcomplex__array** a,
  /* in */ sidl_bool newArray)
{
#line 1501 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFcomplex) */
  sidl_bool result = FALSE;
  if (*a && sidl_fcomplex__array_dimen(*a) == 1) {
    const int32_t upper = sidl_fcomplex__array_upper(*a,0);
    const int32_t lower = sidl_fcomplex__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkFcomplex(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct sidl_fcomplex__array
        *copy = sidl_fcomplex__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        sidl_fcomplex__array_set1(copy, upper - i,
                                  sidl_fcomplex__array_get1(*a,lower + i));
      }
      sidl_fcomplex__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        struct sidl_fcomplex 
          tmp = sidl_fcomplex__array_get1(*a, lower + i);
        sidl_fcomplex__array_set1(*a, lower + i,
                                  sidl_fcomplex__array_get1(*a, upper - i));
        sidl_fcomplex__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFcomplex) */
#line 1597 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  reverseDcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseDcomplex"

sidl_bool
impl_ArrayTest_ArrayOps_reverseDcomplex(
  /* inout */ struct sidl_dcomplex__array** a,
  /* in */ sidl_bool newArray)
{
#line 1548 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDcomplex) */
  sidl_bool result = FALSE;
  if (*a && sidl_dcomplex__array_dimen(*a) == 1) {
    const int32_t upper = sidl_dcomplex__array_upper(*a,0);
    const int32_t lower = sidl_dcomplex__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkDcomplex(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct sidl_dcomplex__array
        *copy = sidl_dcomplex__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        sidl_dcomplex__array_set1(copy, upper - i,
                                  sidl_dcomplex__array_get1(*a,lower + i));
      }
      sidl_dcomplex__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        struct sidl_dcomplex 
          tmp = sidl_dcomplex__array_get1(*a, lower + i);
        sidl_dcomplex__array_set1(*a, lower + i,
                                  sidl_dcomplex__array_get1(*a, upper - i));
        sidl_dcomplex__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDcomplex) */
#line 1646 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  createBool[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createBool"

struct sidl_bool__array*
impl_ArrayTest_ArrayOps_createBool(
  /* in */ int32_t len)
{
#line 1594 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createBool) */
  struct sidl_bool__array* result;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = sidl_bool__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      sidlArrayElem1(result, i) = ((i & 0x1) ? FALSE : TRUE);
      break;
    case 1:
      sidl_bool__array_set1(result, i, ((i & 0x1) ? FALSE : TRUE));
      break;
    case 2:
      sidl_bool__array_set(result, lower, ((i & 0x1) ? FALSE : TRUE));
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createBool) */
#line 1684 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  createChar[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createChar"

struct sidl_char__array*
impl_ArrayTest_ArrayOps_createChar(
  /* in */ int32_t len)
{
#line 1630 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createChar) */
  struct sidl_char__array* result;
  const char *testStr = s_TestText;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = sidl_char__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i, testStr = nextChar(testStr)) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      sidlArrayElem1(result, i) = *testStr;
      break;
    case 1:
      sidl_char__array_set1(result, i, *testStr);
      break;
    case 2:
      sidl_char__array_set(result, lower, *testStr);
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createChar) */
#line 1723 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  createInt[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createInt"

struct sidl_int__array*
impl_ArrayTest_ArrayOps_createInt(
  /* in */ int32_t len)
{
#line 1667 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createInt) */
  struct sidl_int__array* result;
  int64_t lprime = nextPrime(0L);
  int32_t lower[1], upper[1], i, prime;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = sidl_int__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i, lprime = nextPrime(lprime)) {
    prime = (int32_t)lprime;
    lower[0] = i;
    switch(rand() % 3) {
    case 0:      sidlArrayElem1(result, i) = prime;
      break;
    case 1:
      sidl_int__array_set1(result, i, prime);
      break;
    case 2:
      sidl_int__array_set(result, lower, prime);
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createInt) */
#line 1762 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  createLong[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createLong"

struct sidl_long__array*
impl_ArrayTest_ArrayOps_createLong(
  /* in */ int32_t len)
{
#line 1704 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createLong) */
  struct sidl_long__array* result;
  int32_t lower[1], upper[1], i;
  int64_t prime = nextPrime(0L);
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = sidl_long__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i, prime = nextPrime(prime)) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      sidlArrayElem1(result, i) = prime;
      break;
    case 1:
      sidl_long__array_set1(result, i, prime);
      break;
    case 2:
      sidl_long__array_set(result, lower, prime);
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createLong) */
#line 1801 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  createString[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createString"

struct sidl_string__array*
impl_ArrayTest_ArrayOps_createString(
  /* in */ int32_t len)
{
#line 1741 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createString) */
  struct sidl_string__array* result;
  const char * const *testWord = s_TestWords;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = sidl_string__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i, testWord = nextWord(testWord)) {
    lower[0] = i;
    switch(rand() % 2) {
    case 0:
      sidl_string__array_set1(result, i, *testWord);
      break;
    case 1:
      sidl_string__array_set(result, lower, *testWord);
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createString) */
#line 1837 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  createDouble[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createDouble"

struct sidl_double__array*
impl_ArrayTest_ArrayOps_createDouble(
  /* in */ int32_t len)
{
#line 1775 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDouble) */
  struct sidl_double__array* result;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = sidl_double__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      sidlArrayElem1(result, i) = powTwo(-i);
      break;
    case 1:
      sidl_double__array_set1(result, i, powTwo(-i));
      break;
    case 2:
      sidl_double__array_set(result, lower, powTwo(-i));
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDouble) */
#line 1875 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  createFloat[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createFloat"

struct sidl_float__array*
impl_ArrayTest_ArrayOps_createFloat(
  /* in */ int32_t len)
{
#line 1811 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFloat) */
  struct sidl_float__array* result;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = sidl_float__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      sidlArrayElem1(result, i) = fpowTwo(-i);
      break;
    case 1:
      sidl_float__array_set1(result, i, fpowTwo(-i));
      break;
    case 2:
      sidl_float__array_set(result, lower, fpowTwo(-i));
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFloat) */
#line 1913 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  createFcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createFcomplex"

struct sidl_fcomplex__array*
impl_ArrayTest_ArrayOps_createFcomplex(
  /* in */ int32_t len)
{
#line 1847 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFcomplex) */
  struct sidl_fcomplex__array* result;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = sidl_fcomplex__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      sidlArrayElem1(result, i).real = fpowTwo(i);
      sidlArrayElem1(result, i).imaginary = fpowTwo(-i);
      break;
    case 1:
      {
        struct sidl_fcomplex tmp;
        tmp.real = fpowTwo(i);
        tmp.imaginary = fpowTwo(-i);
        sidl_fcomplex__array_set1(result, i, tmp);
      }
      break;
    case 2:
      {
        struct sidl_fcomplex tmp;
        tmp.real = fpowTwo(i);
        tmp.imaginary = fpowTwo(-i);
        sidl_fcomplex__array_set(result, lower, tmp);
      }
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFcomplex) */
#line 1962 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  createDcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createDcomplex"

struct sidl_dcomplex__array*
impl_ArrayTest_ArrayOps_createDcomplex(
  /* in */ int32_t len)
{
#line 1894 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDcomplex) */
  struct sidl_dcomplex__array* result;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = sidl_dcomplex__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      sidlArrayElem1(result, i).real = powTwo(i);
      sidlArrayElem1(result, i).imaginary = powTwo(-i);
      break;
    case 1:
      {
        struct sidl_dcomplex tmp;
        tmp.real = powTwo(i);
        tmp.imaginary = powTwo(-i);
        sidl_dcomplex__array_set1(result, i, tmp);
      }
      break;
    case 2:
      {
        struct sidl_dcomplex tmp;
        tmp.real = powTwo(i);
        tmp.imaginary = powTwo(-i);
        sidl_dcomplex__array_set(result, lower, tmp);
      }
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDcomplex) */
#line 2011 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  createObject[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createObject"

struct ArrayTest_ArrayOps__array*
impl_ArrayTest_ArrayOps_createObject(
  /* in */ int32_t len)
{
#line 1941 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createObject) */
  struct ArrayTest_ArrayOps__array *a = NULL;
  if (len >= 0) {
    int32_t lower = 0, upper = len - 1;
    a = ArrayTest_ArrayOps__array_createRow(1, &lower, &upper);
    while (len--) {
      ArrayTest_ArrayOps obj = ArrayTest_ArrayOps__create();
      ArrayTest_ArrayOps__array_set1(a, len, obj);
      ArrayTest_ArrayOps_deleteRef(obj);
    }
  }
  return a;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createObject) */
#line 2039 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  create2Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create2Int"

struct sidl_int__array*
impl_ArrayTest_ArrayOps_create2Int(
  /* in */ int32_t d1,
  /* in */ int32_t d2)
{
#line 1968 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Int) */
  struct sidl_int__array* result;
  int32_t lower[2], upper[2], i, j;
  if ((d1 < 0) || (d2 < 0)) return NULL;
  lower[0] = 0;
  upper[0] = d1 - 1;
  lower[1] = 0;
  upper[1] = d2 - 1;
  result = sidl_int__array_createRow(2, lower, upper);
  for(i = 0; i < d1; ++i) {
    lower[0] = i;
    for(j = 0; j < d2; ++j) {
      lower[1] = j;
      switch(rand() % 3) {
      case 0:
        sidlArrayElem2(result, i, j) = powTwo(abs(i-j));
        break;
      case 1:
        sidl_int__array_set2(result, i, j, powTwo(abs(i-j)));
        break;
      case 2:
        sidl_int__array_set(result, lower, powTwo(abs(i-j)));
        break;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Int) */
#line 2083 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  create2Double[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create2Double"

struct sidl_double__array*
impl_ArrayTest_ArrayOps_create2Double(
  /* in */ int32_t d1,
  /* in */ int32_t d2)
{
#line 2010 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Double) */
  struct sidl_double__array* result;
  int32_t lower[2], upper[2], i, j;
  if ((d1 < 0) || (d2 < 0)) return NULL;
  lower[0] = 0;
  upper[0] = d1 - 1;
  lower[1] = 0;
  upper[1] = d2 - 1;
  result = sidl_double__array_createRow(2, lower, upper);
  for(i = 0; i < d1; ++i) {
    lower[0] = i;
    for(j = 0; j < d2; ++j) {
      lower[1] = j;
      switch(rand() % 3) {
      case 0:
        sidlArrayElem2(result, i, j) = powTwo(i-j);
        break;
      case 1:
        sidl_double__array_set2(result, i, j, powTwo(i-j));
        break;
      case 2:
        sidl_double__array_set(result, lower, powTwo(i-j));
        break;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Double) */
#line 2127 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  create2Float[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create2Float"

struct sidl_float__array*
impl_ArrayTest_ArrayOps_create2Float(
  /* in */ int32_t d1,
  /* in */ int32_t d2)
{
#line 2052 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Float) */
  struct sidl_float__array* result;
  int32_t lower[2], upper[2], i, j;
  if ((d1 < 0) || (d2 < 0)) return NULL;
  lower[0] = 0;
  upper[0] = d1 - 1;
  lower[1] = 0;
  upper[1] = d2 - 1;
  result = sidl_float__array_createRow(2, lower, upper);
  for(i = 0; i < d1; ++i) {
    lower[0] = i;
    for(j = 0; j < d2; ++j) {
      lower[1] = j;
      switch(rand() % 3) {
      case 0:
        sidlArrayElem2(result, i, j) = powTwo(i-j);
        break;
      case 1:
        sidl_float__array_set2(result, i, j, powTwo(i-j));
        break;
      case 2:
        sidl_float__array_set(result, lower, powTwo(i-j));
        break;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Float) */
#line 2171 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  create2Dcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create2Dcomplex"

struct sidl_dcomplex__array*
impl_ArrayTest_ArrayOps_create2Dcomplex(
  /* in */ int32_t d1,
  /* in */ int32_t d2)
{
#line 2094 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Dcomplex) */
  struct sidl_dcomplex__array* result;
  int32_t lower[2], upper[2], i, j;
  if ((d1 < 0) || (d2 < 0)) return NULL;
  lower[0] = 0;
  upper[0] = d1 - 1;
  lower[1] = 0;
  upper[1] = d2 - 1;
  result = sidl_dcomplex__array_createRow(2, lower, upper);
  for(i = 0; i < d1; ++i) {
    lower[0] = i;
    for(j = 0; j < d2; ++j) {
      struct sidl_dcomplex tmp;
      tmp.real = powTwo(i);
      tmp.imaginary = powTwo(-j);
      lower[1] = j;
      switch(rand() % 3) {
      case 0:
        sidlArrayElem2(result, i, j) = tmp;
        break;
      case 1:
        sidl_dcomplex__array_set2(result, i, j, tmp);
        break;
      case 2:
        sidl_dcomplex__array_set(result, lower, tmp);
        break;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Dcomplex) */
#line 2218 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  create2Fcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create2Fcomplex"

struct sidl_fcomplex__array*
impl_ArrayTest_ArrayOps_create2Fcomplex(
  /* in */ int32_t d1,
  /* in */ int32_t d2)
{
#line 2139 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Fcomplex) */
  struct sidl_fcomplex__array* result;
  int32_t lower[2], upper[2], i, j;
  if ((d1 < 0) || (d2 < 0)) return NULL;
  lower[0] = 0;
  upper[0] = d1 - 1;
  lower[1] = 0;
  upper[1] = d2 - 1;
  result = sidl_fcomplex__array_createRow(2, lower, upper);
  for(i = 0; i < d1; ++i) {
    lower[0] = i;
    for(j = 0; j < d2; ++j) {
      struct sidl_fcomplex tmp;
      tmp.real = fpowTwo(i);
      tmp.imaginary = fpowTwo(-j);
      lower[1] = j;
      switch(rand() % 3) {
      case 0:
        sidlArrayElem2(result, i, j) = tmp;
        break;
      case 1:
        sidl_fcomplex__array_set2(result, i, j, tmp);
        break;
      case 2:
        sidl_fcomplex__array_set(result, lower, tmp);
        break;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Fcomplex) */
#line 2265 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  create3Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create3Int"

struct sidl_int__array*
impl_ArrayTest_ArrayOps_create3Int(
  void)
{
#line 2183 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create3Int) */
  return makeIntTestMatrix(3);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create3Int) */
#line 2283 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  create4Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create4Int"

struct sidl_int__array*
impl_ArrayTest_ArrayOps_create4Int(
  void)
{
#line 2199 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create4Int) */
  return makeIntTestMatrix(4);;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create4Int) */
#line 2301 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  create5Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create5Int"

struct sidl_int__array*
impl_ArrayTest_ArrayOps_create5Int(
  void)
{
#line 2215 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create5Int) */
  return makeIntTestMatrix(5);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create5Int) */
#line 2319 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  create6Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create6Int"

struct sidl_int__array*
impl_ArrayTest_ArrayOps_create6Int(
  void)
{
#line 2231 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create6Int) */
  return makeIntTestMatrix(6);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create6Int) */
#line 2337 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  create7Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create7Int"

struct sidl_int__array*
impl_ArrayTest_ArrayOps_create7Int(
  void)
{
#line 2247 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create7Int) */
  return makeIntTestMatrix(7);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create7Int) */
#line 2355 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeBool[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeBool"

void
impl_ArrayTest_ArrayOps_makeBool(
  /* in */ int32_t len,
  /* out */ struct sidl_bool__array** a)
{
#line 2264 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeBool) */
  *a =  impl_ArrayTest_ArrayOps_createBool(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeBool) */
#line 2374 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeChar[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeChar"

void
impl_ArrayTest_ArrayOps_makeChar(
  /* in */ int32_t len,
  /* out */ struct sidl_char__array** a)
{
#line 2281 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeChar) */
  *a = impl_ArrayTest_ArrayOps_createChar(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeChar) */
#line 2393 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInt[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInt"

void
impl_ArrayTest_ArrayOps_makeInt(
  /* in */ int32_t len,
  /* out */ struct sidl_int__array** a)
{
#line 2298 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInt) */
  *a = impl_ArrayTest_ArrayOps_createInt(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInt) */
#line 2412 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeLong[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeLong"

void
impl_ArrayTest_ArrayOps_makeLong(
  /* in */ int32_t len,
  /* out */ struct sidl_long__array** a)
{
#line 2315 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeLong) */
  *a = impl_ArrayTest_ArrayOps_createLong(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeLong) */
#line 2431 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeString[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeString"

void
impl_ArrayTest_ArrayOps_makeString(
  /* in */ int32_t len,
  /* out */ struct sidl_string__array** a)
{
#line 2332 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeString) */
  *a = impl_ArrayTest_ArrayOps_createString(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeString) */
#line 2450 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeDouble[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeDouble"

void
impl_ArrayTest_ArrayOps_makeDouble(
  /* in */ int32_t len,
  /* out */ struct sidl_double__array** a)
{
#line 2349 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDouble) */
  *a = impl_ArrayTest_ArrayOps_createDouble(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDouble) */
#line 2469 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeFloat[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeFloat"

void
impl_ArrayTest_ArrayOps_makeFloat(
  /* in */ int32_t len,
  /* out */ struct sidl_float__array** a)
{
#line 2366 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFloat) */
  *a = impl_ArrayTest_ArrayOps_createFloat(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFloat) */
#line 2488 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeFcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeFcomplex"

void
impl_ArrayTest_ArrayOps_makeFcomplex(
  /* in */ int32_t len,
  /* out */ struct sidl_fcomplex__array** a)
{
#line 2383 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFcomplex) */
  *a = impl_ArrayTest_ArrayOps_createFcomplex(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFcomplex) */
#line 2507 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeDcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeDcomplex"

void
impl_ArrayTest_ArrayOps_makeDcomplex(
  /* in */ int32_t len,
  /* out */ struct sidl_dcomplex__array** a)
{
#line 2400 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDcomplex) */
  *a = impl_ArrayTest_ArrayOps_createDcomplex(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDcomplex) */
#line 2526 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOutBool[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutBool"

void
impl_ArrayTest_ArrayOps_makeInOutBool(
  /* inout */ struct sidl_bool__array** a,
  /* in */ int32_t len)
{
#line 2417 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutBool) */
  if (*a) sidl_bool__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createBool(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutBool) */
#line 2546 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOutChar[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutChar"

void
impl_ArrayTest_ArrayOps_makeInOutChar(
  /* inout */ struct sidl_char__array** a,
  /* in */ int32_t len)
{
#line 2435 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutChar) */
  if (*a) sidl_char__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createChar(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutChar) */
#line 2566 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOutInt[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutInt"

void
impl_ArrayTest_ArrayOps_makeInOutInt(
  /* inout */ struct sidl_int__array** a,
  /* in */ int32_t len)
{
#line 2453 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutInt) */
  if (*a) sidl_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createInt(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutInt) */
#line 2586 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOutLong[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutLong"

void
impl_ArrayTest_ArrayOps_makeInOutLong(
  /* inout */ struct sidl_long__array** a,
  /* in */ int32_t len)
{
#line 2471 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutLong) */
  if (*a) sidl_long__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createLong(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutLong) */
#line 2606 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOutString[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutString"

void
impl_ArrayTest_ArrayOps_makeInOutString(
  /* inout */ struct sidl_string__array** a,
  /* in */ int32_t len)
{
#line 2489 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutString) */
  if (*a) sidl_string__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createString(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutString) */
#line 2626 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOutDouble[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutDouble"

void
impl_ArrayTest_ArrayOps_makeInOutDouble(
  /* inout */ struct sidl_double__array** a,
  /* in */ int32_t len)
{
#line 2507 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDouble) */
  if (*a) sidl_double__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createDouble(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDouble) */
#line 2646 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOutFloat[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutFloat"

void
impl_ArrayTest_ArrayOps_makeInOutFloat(
  /* inout */ struct sidl_float__array** a,
  /* in */ int32_t len)
{
#line 2525 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFloat) */
  if (*a) sidl_float__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createFloat(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFloat) */
#line 2666 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOutDcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutDcomplex"

void
impl_ArrayTest_ArrayOps_makeInOutDcomplex(
  /* inout */ struct sidl_dcomplex__array** a,
  /* in */ int32_t len)
{
#line 2543 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDcomplex) */
  if (*a) sidl_dcomplex__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createDcomplex(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDcomplex) */
#line 2686 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOutFcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutFcomplex"

void
impl_ArrayTest_ArrayOps_makeInOutFcomplex(
  /* inout */ struct sidl_fcomplex__array** a,
  /* in */ int32_t len)
{
#line 2561 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFcomplex) */
  if (*a) sidl_fcomplex__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createFcomplex(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFcomplex) */
#line 2706 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOut2Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut2Int"

void
impl_ArrayTest_ArrayOps_makeInOut2Int(
  /* inout */ struct sidl_int__array** a,
  /* in */ int32_t d1,
  /* in */ int32_t d2)
{
#line 2580 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Int) */
  if (*a) sidl_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create2Int(d1, d2);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Int) */
#line 2727 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOut2Double[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut2Double"

void
impl_ArrayTest_ArrayOps_makeInOut2Double(
  /* inout */ struct sidl_double__array** a,
  /* in */ int32_t d1,
  /* in */ int32_t d2)
{
#line 2599 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Double) */
  if (*a) sidl_double__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create2Double(d1, d2);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Double) */
#line 2748 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOut2Float[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut2Float"

void
impl_ArrayTest_ArrayOps_makeInOut2Float(
  /* inout */ struct sidl_float__array** a,
  /* in */ int32_t d1,
  /* in */ int32_t d2)
{
#line 2618 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Float) */
  if (*a) sidl_float__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create2Float(d1, d2);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Float) */
#line 2769 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOut2Dcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut2Dcomplex"

void
impl_ArrayTest_ArrayOps_makeInOut2Dcomplex(
  /* inout */ struct sidl_dcomplex__array** a,
  /* in */ int32_t d1,
  /* in */ int32_t d2)
{
#line 2637 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Dcomplex) */
  if (*a) sidl_dcomplex__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create2Dcomplex(d1, d2);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Dcomplex) */
#line 2790 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOut2Fcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut2Fcomplex"

void
impl_ArrayTest_ArrayOps_makeInOut2Fcomplex(
  /* inout */ struct sidl_fcomplex__array** a,
  /* in */ int32_t d1,
  /* in */ int32_t d2)
{
#line 2656 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Fcomplex) */
  if (*a) sidl_fcomplex__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create2Fcomplex(d1, d2);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Fcomplex) */
#line 2811 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOut3Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut3Int"

void
impl_ArrayTest_ArrayOps_makeInOut3Int(
  /* inout */ struct sidl_int__array** a)
{
#line 2673 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut3Int) */
  if (*a) sidl_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create3Int();
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut3Int) */
#line 2830 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOut4Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut4Int"

void
impl_ArrayTest_ArrayOps_makeInOut4Int(
  /* inout */ struct sidl_int__array** a)
{
#line 2690 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut4Int) */
  if (*a) sidl_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create4Int();
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut4Int) */
#line 2849 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOut5Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut5Int"

void
impl_ArrayTest_ArrayOps_makeInOut5Int(
  /* inout */ struct sidl_int__array** a)
{
#line 2707 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut5Int) */
  if (*a) sidl_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create5Int();
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut5Int) */
#line 2868 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOut6Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut6Int"

void
impl_ArrayTest_ArrayOps_makeInOut6Int(
  /* inout */ struct sidl_int__array** a)
{
#line 2724 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut6Int) */
  if (*a) sidl_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create6Int();
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut6Int) */
#line 2887 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  makeInOut7Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut7Int"

void
impl_ArrayTest_ArrayOps_makeInOut7Int(
  /* inout */ struct sidl_int__array** a)
{
#line 2741 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut7Int) */
  if (*a) sidl_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create7Int();
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut7Int) */
#line 2906 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Return as out parameters the type and dimension of the 
 * array passed in. If a is NULL, dimen == type == 0 on exit.
 * The contents of the array have the default values for a 
 * newly created array.
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkGeneric"

void
impl_ArrayTest_ArrayOps_checkGeneric(
  /* in */ struct sidl__array* a,
  /* out */ int32_t* dmn,
  /* out */ int32_t* tp)
{
#line 2763 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkGeneric) */
  if (a) {
    *dmn = sidlArrayDim(a);
    *tp = sidl__array_type(a);
  }
  else {
    *dmn = 0;
    *tp = 0;
  }
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkGeneric) */
#line 2936 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Create an array of the type and dimension specified and
 * return it. A type of 0 causes a NULL array to be returned.
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createGeneric"

struct sidl__array*
impl_ArrayTest_ArrayOps_createGeneric(
  /* in */ int32_t dmn,
  /* in */ int32_t tp)
{
#line 2788 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createGeneric) */
  static const int32_t lower[] = {0, 0, 0, 0, 0, 0, 0};
  static const int32_t upper[] = {2, 2, 2, 2, 2, 2, 2};
  return createArrayByType(tp, dmn, lower, upper);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createGeneric) */
#line 2958 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Testing passing generic arrays using every possible mode.
 * The returned array is a copy of inArg, so if inArg != NULL,
 * the return value should != NULL. outArg is also a copy of
 * inArg.
 * If inOutArg is NULL on entry, a 2-D array of int that should
 * pass check2Int is returned.
 * If inOutArg is not NULL on entry and its dimension is even,
 * it is returned unchanged; otherwise, NULL is returned.
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_passGeneric"

struct sidl__array*
impl_ArrayTest_ArrayOps_passGeneric(
  /* in */ struct sidl__array* inArg,
  /* inout */ struct sidl__array** inOutArg,
  /* out */ struct sidl__array** outArg)
{
#line 2815 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.passGeneric) */
  int32_t lower[7], upper[7], i;
  struct sidl__array *result = NULL;
  if (inArg) {
    const int32_t dimen = sidlArrayDim(inArg);
    for(i = 0; i <  dimen; ++i) { 
      lower[i] = sidlLower(inArg, i);
      upper[i] = sidlUpper(inArg, i);
    }
    result = createArrayByType(sidl__array_type(inArg), dimen, lower, upper);
    *outArg = createArrayByType(sidl__array_type(inArg), dimen, lower, upper);
    copyArrayByType(inArg, result);
    copyArrayByType(inArg, *outArg);
  }

  if (*inOutArg) {
    if (sidlArrayDim(*inOutArg) & 1) {
      sidl__array_deleteRef(*inOutArg);
      *inOutArg = NULL;
    }
  }
  else {
    *inOutArg = (struct sidl__array *)ArrayTest_ArrayOps_create2Int(3, 3);
  }

  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.passGeneric) */
#line 3009 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  initRarray1Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_initRarray1Int"

void
impl_ArrayTest_ArrayOps_initRarray1Int(
  /* inout */ int32_t* a,
  /* in */ int32_t n)
{
#line 2856 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.initRarray1Int) */
  int64_t lprime = nextPrime(0L);
  int32_t i, prime;
  if (n < 0) return;
  for(i = 0; i < n; ++i, lprime = nextPrime(lprime)) {
    prime = (int32_t)lprime;
    switch(rand() % 2) {
    case 0:      
      a[i] = prime;
      break;
    case 1:
      RarrayElem1(a,i) = prime;
      break;
    }
  }
  return;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.initRarray1Int) */
#line 3042 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  initRarray3Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_initRarray3Int"

void
impl_ArrayTest_ArrayOps_initRarray3Int(
  /* inout */ int32_t* a,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o)
{
#line 2889 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.initRarray3Int) */
  int32_t lower[] = {0, 0, 0};
  int32_t upper[3];
  int32_t ind[] = {0, 0, 0};
  int32_t dimen = 3;
  upper[0] = n-1;
  upper[1] = m-1;
  upper[2] = o-1;
  do {  
    RarrayElem3(a,ind[0], ind[1], ind[2], n, m)  = intFunc(dimen, ind);
  } while (next(dimen, ind, lower, upper));
  return;


  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.initRarray3Int) */
#line 3075 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  initRarray7Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_initRarray7Int"

void
impl_ArrayTest_ArrayOps_initRarray7Int(
  /* inout */ int32_t* a,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o,
  /* in */ int32_t p,
  /* in */ int32_t q,
  /* in */ int32_t r,
  /* in */ int32_t s)
{
#line 2924 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.initRarray7Int) */
  int32_t lower[] = {0, 0, 0, 0, 0, 0, 0};
  int32_t upper[7];
  int32_t ind[] = {0, 0, 0, 0, 0, 0, 0};
  int32_t dimen = 7;
  upper[0] = n-1;
  upper[1] = m-1;
  upper[2] = o-1;
  upper[3] = p-1;
  upper[4] = q-1;
  upper[5] = r-1;
  upper[6] = s-1;
  do {  
    RarrayElem7(a,ind[0], ind[1], ind[2], ind[3], ind[4], ind[5], ind[6],
		n, m, o, p, q, r)  = intFunc(dimen, ind);
  } while (next(dimen, ind, lower, upper));
  return;

  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.initRarray7Int) */
#line 3116 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  initRarray1Double[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_initRarray1Double"

void
impl_ArrayTest_ArrayOps_initRarray1Double(
  /* inout */ double* a,
  /* in */ int32_t n)
{
#line 2957 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.initRarray1Double) */
  int32_t lower[1], upper[1], i;
  if (n < 0) return;
  lower[0] = 0;
  upper[0] = n - 1;
  for(i = 0; i < n; ++i) {
    switch(rand() % 2) {
    case 0:
      RarrayElem1(a, i) = powTwo(-i);
      break;
    case 1:
      a[i] = powTwo(-i);
      break;
    }
  }
  return;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.initRarray1Double) */
#line 3149 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  initRarray1Dcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_initRarray1Dcomplex"

void
impl_ArrayTest_ArrayOps_initRarray1Dcomplex(
  /* inout */ struct sidl_dcomplex* a,
  /* in */ int32_t n)
{
#line 2988 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.initRarray1Dcomplex) */
  int32_t lower[1], upper[1], i;
  if (n < 0) return;
  lower[0] = 0;
  upper[0] = n - 1;
  for(i = 0; i < n; ++i) {
    switch(rand() % 2) {
    case 0:
      RarrayElem1(a, i).real = powTwo(i);
      RarrayElem1(a, i).imaginary = powTwo(-i);
      break;
    case 1:
      {
	a[i].real = powTwo(i);
	a[i].imaginary = powTwo(-i);
      }
      break;

    }
  }
  return;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.initRarray1Dcomplex) */
#line 3187 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkRarray1Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkRarray1Int"

sidl_bool
impl_ArrayTest_ArrayOps_checkRarray1Int(
  /* in */ int32_t* a,
  /* in */ int32_t n)
{
#line 3024 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkRarray1Int) */
  if (a) {
    int32_t i;
    int64_t lprime = nextPrime(0L);
    int32_t prime;
    for(i = 0; i < n; ++i, lprime = nextPrime(lprime)) {
      prime = (int32_t)lprime;
      if (a[i] != RarrayElem1(a,i) ||
          a[i] != prime) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkRarray1Int) */
#line 3219 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkRarray3Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkRarray3Int"

sidl_bool
impl_ArrayTest_ArrayOps_checkRarray3Int(
  /* in */ int32_t* a,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o)
{
#line 3056 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkRarray3Int) */
  int result = FALSE;
  int32_t lower[3] = {0,0,0};
  int32_t upper[3];
  upper[0] = n-1;
  upper[1] = m-1;
  upper[2] = o-1;
  if (a) {

    int32_t ind[3] = {0, 0, 0};
    int32_t value = 0;
    result = TRUE;
    do {
      value = arrayValue(3, ind);
      if (RarrayElem3(a, ind[0], ind[1], ind[2], n, m) != value) {
	result = FALSE;
      }
    } while (result && nextElem(3, ind, lower, upper));
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkRarray3Int) */
#line 3258 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkRarray7Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkRarray7Int"

sidl_bool
impl_ArrayTest_ArrayOps_checkRarray7Int(
  /* in */ int32_t* a,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o,
  /* in */ int32_t p,
  /* in */ int32_t q,
  /* in */ int32_t r,
  /* in */ int32_t s)
{
#line 3097 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkRarray7Int) */
  int result = FALSE;
  int32_t lower[7] = {0,0,0,0,0,0,0};
  int32_t upper[7];
  upper[0] = n-1;
  upper[1] = m-1;
  upper[2] = o-1;
  upper[3] = p-1;
  upper[4] = q-1;
  upper[5] = r-1;
  upper[6] = s-1;
  if (a) {
    result = TRUE;
    int32_t ind[7] = {0, 0, 0, 0, 0, 0, 0};
    int32_t value = 0;
    do {
      value = arrayValue(7, ind);
      if (RarrayElem7(a, ind[0], ind[1], ind[2], ind[3], ind[4], ind[5], ind[6],
		      n, m, o, p, q, r) != value) {
	result = FALSE;
      }
    } while (result && nextElem(7, ind, lower, upper));
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkRarray7Int) */
#line 3305 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkRarray1Double[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkRarray1Double"

sidl_bool
impl_ArrayTest_ArrayOps_checkRarray1Double(
  /* in */ double* a,
  /* in */ int32_t n)
{
#line 3136 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkRarray1Double) */
  if (a) {
    int32_t i, ind[1];
    for(i = 0; i < n; ++i) {
      ind[0] = i;
      if (RarrayElem1(a,i) != a[i] || a[i] != powTwo(-i)) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;

  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkRarray1Double) */
#line 3335 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkRarray1Dcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkRarray1Dcomplex"

sidl_bool
impl_ArrayTest_ArrayOps_checkRarray1Dcomplex(
  /* in */ struct sidl_dcomplex* a,
  /* in */ int32_t n)
{
#line 3164 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkRarray1Dcomplex) */
  if (a) {
    int32_t i;
    for(i = 0; i < n; ++i) {
      if ((RarrayElem1(a,i).real != powTwo(i)) ||
          (RarrayElem1(a,i).imaginary != powTwo(-i)) ||
	  (a[i].real != powTwo(i)) ||
	  (a[i].imaginary != powTwo(-i))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;

  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkRarray1Dcomplex) */
#line 3367 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  matrixMultiply[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_matrixMultiply"

void
impl_ArrayTest_ArrayOps_matrixMultiply(
  /* in */ int32_t* a,
  /* in */ int32_t* b,
  /* inout */ int32_t* res,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o)
{
#line 3198 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.matrixMultiply) */
  if(a && b && res) {
    matrixMultiply(a,b,res,n,m,o);
  }
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.matrixMultiply) */
#line 3392 "ArrayTest_ArrayOps_Impl.c"
}

/*
 * Method:  checkMatrixMultiply[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkMatrixMultiply"

sidl_bool
impl_ArrayTest_ArrayOps_checkMatrixMultiply(
  /* in */ int32_t* a,
  /* in */ int32_t* b,
  /* in */ int32_t* res,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o)
{
#line 3221 "../../../../babel/regression/arrays/libC/ArrayTest_ArrayOps_Impl.c"
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkMatrixMultiply) */
  int32_t test[n*o];
  int32_t i,j;
  if(a && b && res) {
    matrixMultiply(a,b,test,n,m,o);
    for(i=0;i<n;++i) {
      for(j=0;j<o;++j) {
	if(RarrayElem2(test,i,j,n) != RarrayElem2(res,i,j,n))
	  return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;

  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkMatrixMultiply) */
#line 3428 "ArrayTest_ArrayOps_Impl.c"
}
