// excepttest.cc

#include <string>
using namespace std;
#include "ExceptionTest.hh"
using namespace ExceptionTest;
#include "synch.hh"


#define MYPASS( AAA ) \
  tracker.writeComment(AAA); \
  tracker.endPart(part_no, synch::ResultType_PASS);

#define MYFAIL( AAA ) \
  tracker.writeComment(AAA); \
  tracker.endPart(part_no, synch::ResultType_FAIL);

int main() { 
  int part_no = 0;
  synch::RegOut tracker = synch::RegOut::_create();
  Fib fib = Fib::_create();

  tracker.setExpectations(4);
  try { 
    tracker.startPart(++part_no);
    fib.getFib(10,25,200,0);
    MYPASS( "no exception thrown (none expected)" );
  } catch (...) { 
    MYFAIL("unexpected exception thrown");
  }

  try { 
    tracker.startPart(++part_no);
    fib.getFib(-1,10,10,0);    
    MYFAIL( "no exception thrown (NegativeValueException expected)" );
  } catch ( NegativeValueException ex ) { 
    MYPASS( "NegativeValueException thrown (as expected)" );
  } catch ( ... ) { 
    MYFAIL( "unexpected exception thrown" );
  }
 
  try { 
    tracker.startPart(++part_no);
    fib.getFib(10,1,1000,0);
    MYFAIL( "no exception thrown (TooDeepException expected)" );    
  } catch ( TooDeepException ex ) { 
    MYFAIL( "TooDeepException thrown (and unexpectedly caught!)");
  } catch ( FibException ex ) { // catch declared types
    TooDeepException ex2 = ex;  // downcast
    if ( !ex2 ) { 
      MYFAIL( "FibException caught, but cannot cast to TooDeepException" );
    } else { 
      MYPASS( "FibException caught, and correctly cast to TooDeepException" );
    }
  } catch( ... ) { 
    MYFAIL( "unexpected exception thrown" );
  }

  try { 
    tracker.startPart(++part_no);
    fib.getFib(10,1000,1,0);
    MYFAIL( "no exception thrown (TooBigException expected)" );    
  } catch ( TooBigException ex ) { 
    MYFAIL( "TooBigException thrown (and unexpectedly caught!)");
  } catch ( FibException ex ) { // catch declared types
    TooBigException ex2 = ex;  // downcast
    if ( !ex2 ) { 
      MYFAIL( "FibException caught, but cannot cast to TooBigException" );
    } else { 
      MYPASS( "FibException caught, and correctly cast to TooBigException" );
    }  
  } catch( ... ) { 
    MYFAIL( "unexpected exception thrown" );
  }

  tracker.close();
  return 0;
}
