C     
C File:        inherittest.f
C Copyright:   (c) 2001 The Regents of the University of California
C Revision:    $Revision: 4434 $
C Date:        $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
C Description: Regression test to test FORTRAN calls to BABEL
C
      subroutine castcheck(partno, sourcename,
     $     destname, pointer)
      implicit none
      integer*4 partno
      character *(*) sourcename, destname
      character*(1024) buffer
      integer*8 pointer, tracker
      partno = partno + 1
      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_startPart_f(tracker, partno)
      buffer = 'Casting ' // sourcename // ' to ' //
     $     destname
      call synch_RegOut_writeComment_f(tracker, buffer)
      if (pointer .ne. 0) then
         call synch_RegOut_endPart_f(tracker, partno, 0)
      else
         call synch_RegOut_endPart_f(tracker, partno, 1)
      endif
      call synch_RegOut_deleteRef_f(tracker)
      end
      

      subroutine reporttest(partno, methodname,
     $     expectedresult, result)
      implicit none
      integer*4 partno, numpassed
      character *(*) methodname, expectedresult, result
      character*(1024) buffer
      integer*8 tracker
      call synch_RegOut_getInstance_f(tracker)
      partno = partno + 1
      call synch_RegOut_startPart_f(tracker, partno)
      buffer = 'Method Inherit_' // methodname //
     $     ' should return ' // expectedresult
      call synch_RegOut_writeComment_f(tracker, buffer)
      buffer = 'Method Inherit_' // methodname //
     $     ' returned ' //  result
      call synch_RegOut_writeComment_f(tracker, buffer)
      if (result .eq. expectedresult) then
         call synch_RegOut_endPart_f(tracker, partno, 0)
      else
         call synch_RegOut_endPart_f(tracker, partno, 1)
      endif
      call synch_RegOut_deleteRef_f(tracker)
      end

      program inherittest
      implicit none
      integer*4 partno
      integer*8 object, altobject, interface, tracker
      character*32 strresult
      call synch_RegOut_getInstance_f(tracker)
      partno = 0

      call synch_RegOut_setExpectations_f(tracker, 59)

      call Inherit_C__create_f(object)

      call synch_RegOut_writeComment_f(tracker,
     $     'Class C:')

      call Inherit_C_c_f(object,strresult)
      call reporttest(partno, 'C_c', 'C.c', strresult)
      call Inherit_C_deleteRef_f(object)

      call Inherit_D__create_f(object)

      call synch_RegOut_writeComment_f(tracker,
     $     'Class D: inheritance of interface A')

      call Inherit_D_a_f(object,strresult)
      call reporttest(partno, 'D_a', 'D.a', strresult)

      call Inherit_D_d_f(object,strresult)
      call reporttest(partno, 'D_d', 'D.d', strresult)
      

      call synch_RegOut_writeComment_f(tracker,
     $     'Class D: via interface A')

      call Inherit_A__cast_f(object, interface)
      call castcheck(partno, 'Class D',
     $     'Interface A', interface)
      if (interface .ne. 0) then
         call Inherit_A_a_f(interface,strresult)
         call reporttest(partno, 'A_a', 'D.a', strresult)
         interface = 0
      endif
      call Inherit_D_deleteRef_f(object)

      call Inherit_E__create_f(object)

      call synch_RegOut_writeComment_f(tracker,
     $     'Class E: inheritance of class C')

      call Inherit_E_c_f(object,strresult)
      call reporttest(partno, 'E_c', 'C.c', strresult)

      call Inherit_E_e_f(object,strresult)
      call reporttest(partno, 'E_e', 'E.e', strresult)


      call synch_RegOut_writeComment_f(tracker,
     $     'Class E: via class C (C.c not overridden)')

      call Inherit_C__cast_f(object, altobject)
      call castcheck(partno, 'Class E',
     $     'Class C', altobject)
      if (altobject .ne. 0) then
         call Inherit_C_c_f(altobject,strresult)
         call reporttest(partno, 'C_c', 'C.c', strresult)
         altobject = 0
      endif
      call Inherit_E_deleteRef_f(object)

      call Inherit_E2__create_f(object)

      call synch_RegOut_writeComment_f(tracker,
     $     'Class E2: inheritance of class C')

      call Inherit_E2_c_f(object,strresult)
      call reporttest(partno, 'E2_c', 'E2.c', strresult)

      call Inherit_E2_e_f(object,strresult)
      call reporttest(partno, 'E2_e', 'E2.e', strresult)

      call synch_RegOut_writeComment_f(tracker,
     $     'Class E2: via class C (C.c overridden)')
      call Inherit_C__cast_f(object, altobject)
      call castcheck(partno, 'Class E2',
     $     'Class C', altobject)
      if (altobject .ne. 0) then
         call Inherit_C_c_f(altobject,strresult)
         call reporttest(partno, 'C_c', 'E2.c', strresult)
         altobject = 0
      endif
      call Inherit_E2_deleteRef_f(object)

      call Inherit_F__create_f(object)

      call synch_RegOut_writeComment_f(tracker,
     $     'Class F: Multiple inheritance (no overriding)')

      call Inherit_F_a_f(object,strresult)
      call reporttest(partno, 'F_a', 'F.a', strresult)

      call Inherit_F_b_f(object,strresult)
      call reporttest(partno, 'F_b', 'F.b', strresult)

      call Inherit_F_c_f(object,strresult)
      call reporttest(partno, 'F_c', 'C.c', strresult)

      call Inherit_F_f_f(object,strresult)
      call reporttest(partno, 'F_f', 'F.f', strresult)

      call synch_RegOut_writeComment_f(tracker,
     $     'Class F: via interface A')

      call Inherit_A__cast_f(object, interface)
      call castcheck(partno, 'Class F',
     $     'Interface A', interface)
      if (interface .ne. 0) then
         call Inherit_A_a_f(interface,strresult)
         call reporttest(partno, 'A_a', 'F.a', strresult)
         interface = 0
      endif


      call synch_RegOut_writeComment_f(tracker,
     $     'Class F: via interface B')

      call Inherit_B__cast_f(object, interface)
      call castcheck(partno, 'Class F',
     $     'Interface B', interface)
      if (interface .ne. 0) then
         call Inherit_B_b_f(interface,strresult)
         call reporttest(partno, 'B_b', 'F.b', strresult)
         interface = 0
      endif


      call synch_RegOut_writeComment_f(tracker,
     $     'Class F: via class C (no overloading of C.c)')

      call Inherit_C__cast_f(object, altobject)
      call castcheck(partno, 'Class F',
     $     'Class C', altobject)
      if (altobject .ne. 0) then
         call Inherit_C_c_f(altobject,strresult)
         call reporttest(partno, 'C_c', 'C.c', strresult)
         altobject = 0
      endif


      call Inherit_F_deleteRef_f(object)

      call Inherit_F2__create_f(object)

      call synch_RegOut_writeComment_f(tracker,
     $     'Class F2: Multiple inheritance (overrides C.c)')

      call Inherit_F2_a_f(object,strresult)
      call reporttest(partno, 'F2_a', 'F2.a', strresult)

      call Inherit_F2_b_f(object,strresult)
      call reporttest(partno, 'F2_b', 'F2.b', strresult)

      call Inherit_F2_c_f(object,strresult)
      call reporttest(partno, 'F2_c', 'F2.c', strresult)

      call Inherit_F2_f_f(object,strresult)
      call reporttest(partno, 'F2_f', 'F2.f', strresult)

      

      call synch_RegOut_writeComment_f(tracker,
     $     'Class F2: via interface A')

      call Inherit_A__cast_f(object, interface)
      call castcheck(partno, 'Class F2',
     $     'Interface A', interface)
      if (interface .ne. 0) then
         call Inherit_A_a_f(interface,strresult)
         call reporttest(partno, 'A_a', 'F2.a', strresult)
         interface = 0
      endif


      call synch_RegOut_writeComment_f(tracker,
     $     'Class F2: via interface B')

      call Inherit_B__cast_f(object, interface)
      call castcheck(partno, 'Class F2',
     $     'Interface B', interface)
      if (interface .ne. 0) then
         call Inherit_B_b_f(interface,strresult)
         call reporttest(partno, 'B_b', 'F2.b', strresult)
         interface = 0
      endif


      call synch_RegOut_writeComment_f(tracker,
     $     'Class F2: via class C (overloads C.c)')

      call Inherit_C__cast_f(object, altobject)
      call castcheck(partno, 'Class F2',
     $     'Class C', altobject)
      if (altobject .ne. 0) then
         call Inherit_C_c_f(altobject,strresult)
         call reporttest(partno, 'C_c', 'F2.c', strresult)
         altobject = 0
      endif


      call Inherit_F2_deleteRef_f(object)


      call synch_RegOut_writeComment_f(tracker,
     $     'Class G: indirect multiple inheritance (no overloads)')

      call Inherit_G__create_f(object)
      call Inherit_G_a_f(object,strresult)
      call reporttest(partno, 'G_a', 'D.a', strresult)

      call Inherit_G_d_f(object,strresult)
      call reporttest(partno, 'G_d', 'D.d', strresult)

      call Inherit_G_g_f(object,strresult)
      call reporttest(partno, 'G_g', 'G.g', strresult)


      call synch_RegOut_writeComment_f(tracker,
     $     'Class G: via interface A')

      call Inherit_A__cast_f(object, interface)
      call castcheck(partno, 'Class G',
     $     'Interface A', interface)
      if (interface .ne. 0) then
         call Inherit_A_a_f(interface,strresult)
         call reporttest(partno, 'A_a', 'D.a', strresult)
         interface = 0
      endif

      call synch_RegOut_writeComment_f(tracker,
     $     'Class G: via class D')

      call Inherit_D__cast_f(object, altobject)
      call castcheck(partno, 'Class G',
     $     'Class D', altobject)
      if (altobject .ne. 0) then
         call Inherit_D_a_f(altobject,strresult)
         call reporttest(partno, 'D_a', 'D.a', strresult)


         call Inherit_D_d_f(altobject,strresult)
         call reporttest(partno, 'D_d', 'D.d', strresult)
         altobject = 0
      endif


      call Inherit_G_deleteRef_f(object)


      call synch_RegOut_writeComment_f(tracker,
     $     'Class G2: indirect multiple inheritance (overloads)')

      call Inherit_G2__create_f(object)
      call Inherit_G2_a_f(object,strresult)
      call reporttest(partno, 'G2_a', 'G2.a', strresult)

      call Inherit_G2_d_f(object,strresult)
      call reporttest(partno, 'G2_d', 'G2.d', strresult)

      call Inherit_G2_g_f(object,strresult)
      call reporttest(partno, 'G2_g', 'G2.g', strresult)


      call synch_RegOut_writeComment_f(tracker,
     $     'Class G2: via interface A')

      call Inherit_A__cast_f(object, interface)
      call castcheck(partno, 'Class G2',
     $     'Interface A', interface)
      if (interface .ne. 0) then
         call Inherit_A_a_f(interface,strresult)
         call reporttest(partno, 'A_a', 'G2.a', strresult)
         interface = 0
      endif


      call synch_RegOut_writeComment_f(tracker,
     $     'Class G2: via class D')

      call Inherit_D__cast_f(object, altobject)
      call castcheck(partno, 'Class G2',
     $     'Class D', altobject)
      if (altobject .ne. 0) then
         call Inherit_D_a_f(altobject,strresult)
         call reporttest(partno, 'D_a', 'G2.a', strresult)


         call Inherit_D_d_f(altobject,strresult)
         call reporttest(partno, 'D_d', 'G2.d', strresult)
         altobject = 0
      endif

      call Inherit_G2_deleteRef_f(object)

      call Inherit_I__create_f(object)

      call synch_RegOut_writeComment_f(tracker,
     $     'Class I:')

      call Inherit_I_a_f(object,strresult)
      call reporttest(partno, 'I_a', 'I.a', strresult)


      call Inherit_I_h_f(object,strresult)
      call reporttest(partno, 'I_h', 'I.h', strresult)


      call synch_RegOut_writeComment_f(tracker,
     $     'Class I: via class H')

      call Inherit_H__cast_f(object, altobject)
      call castcheck(partno, 'Class I',
     $     'Class H', altobject)
      if (altobject .ne. 0) then
         call Inherit_H_a_f(altobject,strresult)
         call reporttest(partno, 'H_a', 'I.a', strresult)


         call Inherit_H_h_f(altobject,strresult)
         call reporttest(partno, 'H_h', 'I.h', strresult)
         altobject = 0
      endif

      call Inherit_I_deleteRef_f(object)


      call Inherit_J__create_f(object)

      call synch_RegOut_writeComment_f(tracker,
     $     'Class J: inheritance of class E2, implements A and B')

      call Inherit_J_a_f(object,strresult)
      call reporttest(partno, 'J_a', 'J.a', strresult)

      call Inherit_J_b_f(object,strresult)
      call reporttest(partno, 'J_b', 'J.b', strresult)
      
      call Inherit_J_j_f(object,strresult)
      call reporttest(partno, 'J_j', 'J.j', strresult)

      call Inherit_J_c_f(object,strresult)
      call reporttest(partno, 'J_c', 'J.E2.c', strresult)

      call Inherit_J_e_f(object,strresult)
      call reporttest(partno, 'J_e', 'J.E2.e', strresult)
    
      call Inherit_J_deleteRef_f(object)

      call synch_RegOut_close_f(tracker)
      call synch_RegOut_deleteRef_f(tracker)
      end 
