/*
 * File:          QuickSort_Impl.java
 * Symbol:        sort.QuickSort-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for sort.QuickSort
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

package sort;

import sort.SortingAlgorithm;
import sidl.ClassInfo;
import sort.Comparator;
import sidl.BaseInterface;
import sort.Counter;
import sort.Container;
import sidl.BaseClass;

// DO-NOT-DELETE splicer.begin(sort.QuickSort._imports)
// Put additional imports here...
// DO-NOT-DELETE splicer.end(sort.QuickSort._imports)

/**
 * Symbol "sort.QuickSort" (version 0.1)
 * 
 * Quick sort
 */
public class QuickSort_Impl extends QuickSort
{

  // DO-NOT-DELETE splicer.begin(sort.QuickSort._data)
  int choosePivot(sort.Container  elems,
                sort.Comparator comp,
                sort.Counter    cmp,
                int         start,
                int         end)
  {
    int pivot = (start + end) >> 1;
    if ((end - start) > 4) {
      int mid = pivot;
      cmp.inc();
      if (elems.compare(start, mid, comp) <= 0) {
        cmp.inc();
        if (elems.compare(mid, end - 1, comp) > 0) {
          cmp.inc();
          if (elems.compare(start, end - 1, comp) < 0) {
            pivot = end - 1;
          }
          else {
            pivot = start;
          }
        }
      }
      else {
        cmp.inc();
        if (elems.compare(mid, end - 1, comp) < 0) {
          cmp.inc();
          if (elems.compare(start, end - 1, comp) > 0) {
            pivot = end - 1;
          }
          else {
            pivot = start;
          }
        }
      }
    }
    return pivot;
  }
  
  void quickSort(sort.Container  elems,
              sort.Comparator comp,
              sort.Counter    cmp,
              sort.Counter    swp,
              int         start,
              int         end)
  {
    if ((end - start) > 1) {
      int pivot = choosePivot(elems, comp, cmp, start, end);
      int i = start;
      int j = end;
      if (pivot != start) {
        swp.inc();
        elems.swap(start, pivot);
      }
      for(;;) {
        do {
          --j;
          cmp.inc();
        } while (elems.compare(start, j, comp) < 0);
        while (++i < j) {
          cmp.inc();
          if (elems.compare(start, i, comp) < 0) break;
        }
        if (i >= j) break;
        swp.inc();
        elems.swap(i, j);
      }
      if (j != start) {
        swp.inc();
        elems.swap(start, j);
      }
      quickSort(elems, comp, cmp, swp, start, j);
      quickSort(elems, comp, cmp, swp, j + 1, end);
    }
  }

  // Put additional private data here...
  // DO-NOT-DELETE splicer.end(sort.QuickSort._data)

  static { 
  // DO-NOT-DELETE splicer.begin(sort.QuickSort._load)
  // Put load function implementation here...
  // DO-NOT-DELETE splicer.end(sort.QuickSort._load)
  }

  /**
   * User defined constructor
   */
  public QuickSort_Impl(long IORpointer){
    super(IORpointer);
    // DO-NOT-DELETE splicer.begin(sort.QuickSort.QuickSort)
    // add construction details here
    // DO-NOT-DELETE splicer.end(sort.QuickSort.QuickSort)
  }

  /**
   * User defined destructing method
   */
  public void finalize() throws Throwable{
    super.finalize();
    // DO-NOT-DELETE splicer.begin(sort.QuickSort._dtor)
    // add destruction details here
    // DO-NOT-DELETE splicer.end(sort.QuickSort._dtor)
  }

  // user defined static methods: (none)

  // user defined non-static methods:
  /**
   * Sort elements using Quick Sort.
   */
  public void sort_Impl (
    /*in*/ sort.Container elems,
    /*in*/ sort.Comparator comp ) 
  {
    // DO-NOT-DELETE splicer.begin(sort.QuickSort.sort)
    // insert implementation here
    int num = elems.getLength();
    sort.Counter cmp = getCompareCounter();
    sort.Counter swp = getSwapCounter();
    quickSort(elems, comp, cmp, swp, 0, num);
    return ;
    // DO-NOT-DELETE splicer.end(sort.QuickSort.sort)
  }

  /**
   * Return quick sort.
   */
  public java.lang.String getName_Impl () 
  {
    // DO-NOT-DELETE splicer.begin(sort.QuickSort.getName)
    // insert implementation here
    return new java.lang.String("Quick sort");
    // DO-NOT-DELETE splicer.end(sort.QuickSort.getName)
  }


  // DO-NOT-DELETE splicer.begin(sort.QuickSort._misc)
  // Put miscellaneous code here
  // DO-NOT-DELETE splicer.end(sort.QuickSort._misc)

} // end class QuickSort

