// 
// File:          sort_HeapSort_Impl.cc
// Symbol:        sort.HeapSort-v0.1
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for sort.HeapSort
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "sort_HeapSort_Impl.hh"

// 
// Includes for all method dependencies.
// 
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif
#ifndef included_sort_Comparator_hh
#include "sort_Comparator.hh"
#endif
#ifndef included_sort_Container_hh
#include "sort_Container.hh"
#endif
#ifndef included_sort_Counter_hh
#include "sort_Counter.hh"
#endif
#line 32 "../../../../babel/regression/sort/libUCxx/sort_HeapSort_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.HeapSort._includes)
// Put additional includes or other arbitrary code here...
static void remakeHeap(ucxx::sort::Container &elem,
                       ucxx::sort::Comparator &comp,
                       ucxx::sort::Counter &cmp,
                       ucxx::sort::Counter &swp,
                       const int32_t last,
                       int32_t first)
{
  const int32_t half = (last >> 1) - 1;
  int32_t child;
  while (first <= half) {
    child = first + first + 1;
    if ((child+1) < last) {
      cmp.inc();
      if (elem.compare(child, child+1, comp) < 0) ++child;
    }
    cmp.inc();
    if (elem.compare(first, child, comp) >= 0) break;
    swp.inc();
    elem.swap(first, child);
    first = child;
  }
}
// DO-NOT-DELETE splicer.end(sort.HeapSort._includes)
#line 58 "sort_HeapSort_Impl.cc"

// user defined constructor
void sort::HeapSort_impl::_ctor() {
#line 60 "../../../../babel/regression/sort/libUCxx/sort_HeapSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.HeapSort._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(sort.HeapSort._ctor)
#line 66 "sort_HeapSort_Impl.cc"
}

// user defined destructor
void sort::HeapSort_impl::_dtor() {
#line 67 "../../../../babel/regression/sort/libUCxx/sort_HeapSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.HeapSort._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(sort.HeapSort._dtor)
#line 75 "sort_HeapSort_Impl.cc"
}

// static class initializer
void sort::HeapSort_impl::_load() {
#line 74 "../../../../babel/regression/sort/libUCxx/sort_HeapSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.HeapSort._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(sort.HeapSort._load)
#line 84 "sort_HeapSort_Impl.cc"
}

// user defined static methods: (none)

// user defined non-static methods:
/**
 * Sort elements using Heap Sort.
 */
void
sort::HeapSort_impl::sort_impl (
  /* in */::ucxx::sort::Container elems,
  /* in */::ucxx::sort::Comparator comp ) 
throw () 
{
#line 91 "../../../../babel/regression/sort/libUCxx/sort_HeapSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.HeapSort.sort)
  int32_t i;
  const int32_t num = elems.getLength();
  ucxx::sort::Counter cmp = getCompareCounter();
  ucxx::sort::Counter swp = getSwapCounter();
  /* make the heap */
  for(i = ((num/2) - 1); i >= 0; --i) {
    remakeHeap(elems, comp, cmp, swp, num, i);
  }
  /* put top of heap at back and remake the heap */
  i = num - 1;
  while (i > 0) {
    swp.inc();
    elems.swap(0, i);
    remakeHeap(elems, comp, cmp, swp, i--, 0);
  }
  // DO-NOT-DELETE splicer.end(sort.HeapSort.sort)
#line 117 "sort_HeapSort_Impl.cc"
}

/**
 * Return heap sort.
 */
::std::string
sort::HeapSort_impl::getName_impl () 
throw () 

{
#line 118 "../../../../babel/regression/sort/libUCxx/sort_HeapSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.HeapSort.getName)
  return "Heap sort";
  // DO-NOT-DELETE splicer.end(sort.HeapSort.getName)
#line 132 "sort_HeapSort_Impl.cc"
}


#line 124 "../../../../babel/regression/sort/libUCxx/sort_HeapSort_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.HeapSort._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.HeapSort._misc)
#line 140 "sort_HeapSort_Impl.cc"

