/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.util.List;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.edit.PDPageContentStream;
import org.pdfbox.pdmodel.font.PDType1Font;
import org.pdfbox.pdmodel.graphics.color.PDGamma;
import org.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationLine;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationSquareCircle;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationTextMarkup;
import org.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;

public class Annotation {
    private Annotation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            Annotation.usage();
        } else {
            PDDocument document = new PDDocument();
            try {
                float[] quads;
                PDPage page = new PDPage();
                document.addPage(page);
                List annotations = page.getAnnotations();
                float inch = 72.0f;
                PDGamma colourRed = new PDGamma();
                colourRed.setR(1.0f);
                PDGamma colourBlue = new PDGamma();
                colourBlue.setB(1.0f);
                PDGamma colourBlack = new PDGamma();
                PDBorderStyleDictionary borderThick = new PDBorderStyleDictionary();
                borderThick.setWidth(inch / 12.0f);
                PDBorderStyleDictionary borderThin = new PDBorderStyleDictionary();
                borderThin.setWidth(inch / 72.0f);
                PDBorderStyleDictionary borderULine = new PDBorderStyleDictionary();
                borderULine.setStyle("U");
                borderULine.setWidth(inch / 72.0f);
                float pw = page.getMediaBox().getUpperRightX();
                float ph = page.getMediaBox().getUpperRightY();
                PDType1Font font = PDType1Font.HELVETICA_BOLD;
                PDPageContentStream contentStream = new PDPageContentStream(document, page);
                contentStream.beginText();
                contentStream.setFont(font, 18.0f);
                contentStream.moveTextPositionByAmount(inch, ph - inch - 18.0f);
                contentStream.drawString("PDFBox");
                contentStream.moveTextPositionByAmount(0.0f, -(inch / 2.0f));
                contentStream.drawString("Click Here");
                contentStream.endText();
                contentStream.close();
                PDAnnotationTextMarkup txtMark = new PDAnnotationTextMarkup("Highlight");
                txtMark.setColour(colourBlue);
                txtMark.setConstantOpacity(0.2f);
                float textWidth = font.getStringWidth("PDFBox") / 1000.0f * 18.0f;
                PDRectangle position = new PDRectangle();
                position.setLowerLeftX(inch);
                position.setLowerLeftY(ph - inch - 18.0f);
                position.setUpperRightX(72.0f + textWidth);
                position.setUpperRightY(ph - inch);
                txtMark.setRectangle(position);
                quads = new float[]{position.getLowerLeftX(), position.getUpperRightY() - 2.0f, position.getUpperRightX(), quads[1], quads[0], position.getLowerLeftY() - 2.0f, quads[2], quads[5]};
                txtMark.setQuadPoints(quads);
                txtMark.setContents("Highlighted since it's important");
                annotations.add(txtMark);
                PDAnnotationLink txtLink = new PDAnnotationLink();
                txtLink.setBorderStyle(borderULine);
                textWidth = font.getStringWidth("Click Here") / 1000.0f * 18.0f;
                position = new PDRectangle();
                position.setLowerLeftX(inch);
                position.setLowerLeftY(ph - (float)(1.5 * (double)inch) - 20.0f);
                position.setUpperRightX(72.0f + textWidth);
                position.setUpperRightY(ph - (float)(1.5 * (double)inch));
                txtLink.setRectangle(position);
                PDActionURI action = new PDActionURI();
                action.setURI("http://www.pdfbox.org");
                txtLink.setAction(action);
                annotations.add(txtLink);
                PDAnnotationSquareCircle aCircle = new PDAnnotationSquareCircle("Circle");
                aCircle.setContents("Circle Annotation");
                aCircle.setInteriorColour(colourRed);
                aCircle.setColour(colourBlue);
                aCircle.setBorderStyle(borderThin);
                position = new PDRectangle();
                position.setLowerLeftX(inch);
                position.setLowerLeftY(ph - 3.0f * inch - inch);
                position.setUpperRightX(2.0f * inch);
                position.setUpperRightY(ph - 3.0f * inch);
                aCircle.setRectangle(position);
                annotations.add(aCircle);
                PDAnnotationSquareCircle aSquare = new PDAnnotationSquareCircle("Square");
                aSquare.setContents("Square Annotation");
                aSquare.setColour(colourRed);
                aSquare.setBorderStyle(borderThick);
                position = new PDRectangle();
                position.setLowerLeftX(pw - 2.0f * inch);
                position.setLowerLeftY(ph - (float)(3.5 * (double)inch) - inch);
                position.setUpperRightX(pw - inch);
                position.setUpperRightY(ph - (float)(3.5 * (double)inch));
                aSquare.setRectangle(position);
                annotations.add(aSquare);
                PDAnnotationLine aLine = new PDAnnotationLine();
                aLine.setEndPointEndingStyle("OpenArrow");
                aLine.setContents("Circle->Square");
                aLine.setCaption(true);
                position = new PDRectangle();
                position.setLowerLeftX(2.0f * inch);
                position.setLowerLeftY(ph - (float)(3.5 * (double)inch) - inch);
                position.setUpperRightX(pw - inch - inch);
                position.setUpperRightY(ph - 3.0f * inch);
                aLine.setRectangle(position);
                float[] linepos = new float[]{2.0f * inch, ph - (float)(3.5 * (double)inch), pw - 2.0f * inch, ph - 4.0f * inch};
                aLine.setLine(linepos);
                aLine.setBorderStyle(borderThick);
                aLine.setColour(colourBlack);
                annotations.add(aLine);
                document.save(args[0]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.examples.pdmodel.Annotation <output-pdf>");
    }
}

