/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHLHSPrimaryExpression;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterConstants;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHUnaryExpression
extends SimpleNode
implements InterpreterConstants {
    public int kind;
    public boolean postfix = false;

    BSHUnaryExpression(int n) {
        super(n);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        if (simpleNode instanceof BSHLHSPrimaryExpression) {
            return this.lhsUnaryOperation(((BSHLHSPrimaryExpression)simpleNode).toLHS(nameSpace, interpreter));
        }
        return this.unaryOperation(simpleNode.eval(nameSpace, interpreter), this.kind);
    }

    private Object lhsUnaryOperation(LHS lHS) throws EvalError {
        Interpreter.debug("lhsUnaryOperation");
        Object object = lHS.getValue();
        Object object2 = this.unaryOperation(object, this.kind);
        Object object3 = this.postfix ? object : object2;
        lHS.assign(object2);
        return object3;
    }

    private Object unaryOperation(Object object, int n) throws EvalError {
        if (object instanceof Boolean || object instanceof Character || object instanceof Number) {
            return this.primitiveWrapperUnaryOperation(object, n);
        }
        if (!(object instanceof Primitive)) {
            throw new EvalError("Unary operation " + InterpreterConstants.tokenImage[n] + " inappropriate for object", this);
        }
        return Primitive.unaryOperation((Primitive)object, n);
    }

    private Object primitiveWrapperUnaryOperation(Object object, int n) throws EvalError {
        Class<?> clazz = object.getClass();
        Object object2 = Primitive.promotePrimitive(object);
        if (object2 instanceof Boolean) {
            return new Boolean(Primitive.booleanUnaryOperation((Boolean)object2, n));
        }
        if (object2 instanceof Integer) {
            int n2 = Primitive.intUnaryOperation((Integer)object2, n);
            if (n == 89 || n == 90) {
                if (clazz == Byte.TYPE) {
                    return new Byte((byte)n2);
                }
                if (clazz == Short.TYPE) {
                    return new Short((short)n2);
                }
                if (clazz == Character.TYPE) {
                    return new Character((char)n2);
                }
            }
            return new Integer(n2);
        }
        if (object2 instanceof Long) {
            return new Long(Primitive.longUnaryOperation((Long)object2, n));
        }
        if (object2 instanceof Float) {
            return new Float(Primitive.floatUnaryOperation((Float)object2, n));
        }
        if (object2 instanceof Double) {
            return new Double(Primitive.doubleUnaryOperation((Double)object2, n));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }
}

