/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Application;
import jde.debugger.ApplicationCommands;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.LispForm;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;
import jde.debugger.Rep;

public class ThreadCommands
extends ApplicationCommands {
    public void doSuspend(Integer n, List list) throws JDEException {
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Long l = Etc.safeGetLong(iterator.next(), "thread(group)");
                ObjectReference objectReference = this.store.get(l);
                if (objectReference == null) {
                    throw new JDEException("Invalid ThreadID, or the thread/threadgroup is dead");
                }
                if (objectReference instanceof ThreadReference) {
                    ((ThreadReference)objectReference).suspend();
                    continue;
                }
                if (objectReference instanceof ThreadGroupReference) {
                    ((ThreadGroupReference)objectReference).suspend();
                    continue;
                }
                throw new JDEException("The object is not a thread or a threadgroup");
            }
            this.app.signalCommandResult(n);
        } else {
            try {
                this.app.getVM().suspend();
                this.app.signalCommandResult(n);
            }
            catch (Exception exception) {
                throw new JDEException("Unable to suspend the application");
            }
        }
    }

    public void doResume(Integer n, List list) throws JDEException {
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Long l = Etc.safeGetLong(iterator.next(), "thread(group)");
                ObjectReference objectReference = this.store.get(l);
                if (objectReference == null) {
                    throw new JDEException("Invalid ThreadID, or the thread/threadgroup is dead");
                }
                if (objectReference instanceof ThreadReference) {
                    ((ThreadReference)objectReference).resume();
                    continue;
                }
                if (objectReference instanceof ThreadGroupReference) {
                    ((ThreadGroupReference)objectReference).resume();
                    continue;
                }
                throw new JDEException("The object is not a thread or a threadgroup");
            }
            this.app.signalCommandResult(n);
        } else {
            try {
                this.app.getVM().resume();
                this.app.signalCommandResult(n);
            }
            catch (Exception exception) {
                throw new JDEException("Unable to resume the application");
            }
        }
    }

    public void doInterrupt(Integer n, List list) throws JDEException {
        if (list.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Long l = Etc.safeGetLong(iterator.next(), "thread ID");
            ObjectReference objectReference = this.store.get(l);
            if (objectReference == null) {
                throw new JDEException("Invalid ThreadID, or the thread is dead");
            }
            if (objectReference instanceof ThreadReference) {
                ((ThreadReference)objectReference).interrupt();
                continue;
            }
            throw new JDEException("The object is not a thread");
        }
        this.app.signalCommandResult(n);
    }

    public void doKillThread(Integer n, List list) throws JDEException {
        if (list.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        Long l = Etc.safeGetLong(list.remove(0), "thread ID");
        ObjectReference objectReference = this.store.get(l);
        if (objectReference == null) {
            throw new JDEException("No such thread exists");
        }
        if (!(objectReference instanceof ThreadReference)) {
            throw new JDEException("The ID doesn't correspond to a thread");
        }
        ThreadReference threadReference = (ThreadReference)objectReference;
        l = Etc.safeGetLong(list.remove(0), "thread ID");
        objectReference = this.store.get(l);
        if (objectReference == null) {
            throw new JDEException("No such thread exists");
        }
        try {
            threadReference.stop(objectReference);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new JDEException("Object ID doesn't correspond to a Throwable object");
        }
        this.app.signalCommandResult(n);
    }

    public void doGetThreads(Integer n, List list) throws JDEException {
        this.app.signalCommandResult(n, ThreadCommands.getAllThreadsInformation(this.app.getVM(), this.store));
    }

    static LispForm getAllThreadsInformation(VirtualMachine virtualMachine, ObjectStore objectStore) {
        List<ThreadGroupReference> list = virtualMachine.topLevelThreadGroups();
        String string = "(list ";
        Iterator<ThreadGroupReference> iterator = list.iterator();
        while (iterator.hasNext()) {
            string = string + Protocol.BR + Rep.getThreadGroupRep(iterator.next(), objectStore);
        }
        string = string + ")";
        return new LispForm(string);
    }

    static ThreadReference getThread(VirtualMachine virtualMachine, String string) {
        List<ThreadReference> list = virtualMachine.allThreads();
        Iterator<ThreadReference> iterator = list.iterator();
        while (iterator.hasNext()) {
            ThreadReference threadReference = iterator.next();
            if (!threadReference.name().equals(string)) continue;
            return threadReference;
        }
        return null;
    }

    public void doGetThread(Integer n, List list) throws JDEException {
        if (list.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long l = Etc.safeGetLong(list.remove(0), "thread ID");
        ObjectReference objectReference = this.store.get(l);
        if (objectReference == null) {
            throw new JDEException("No such thread exists");
        }
        if (!(objectReference instanceof ThreadReference)) {
            throw new JDEException("No such thread exists (anymore?)");
        }
        this.app.signalCommandResult(n, Rep.getThreadRep((ThreadReference)objectReference, this.store, true));
    }

    public void doGetObjectMonitors(Integer n, List list) throws JDEException {
        if (list.size() != 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long l = Etc.safeGetLong(list.remove(0), "object ID");
        ObjectReference objectReference = this.store.get(l);
        if (objectReference == null) {
            throw new JDEException("No such object exists");
        }
        this.app.signalCommandResult(n, Rep.getObjectMonitorsRep(objectReference, this.store));
    }

    public void doTraceThreads(Integer n, List list) throws JDEException {
        if (list.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String string = list.remove(0).toString().toLowerCase();
        if (!string.equals("start") && !string.equals("death")) {
            throw new JDEException("Invalid type");
        }
        List list2 = Etc.getClassFiltersFromArgs(list);
        List list3 = Etc.getClassExFiltersFromArgs(list);
        EventRequestManager eventRequestManager = this.app.getVM().eventRequestManager();
        Long l = null;
        if (string.equals("start")) {
            ThreadStartRequest threadStartRequest = eventRequestManager.createThreadStartRequest();
            threadStartRequest.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(list));
            if (list.size() > 0) {
                Long l2 = Etc.safeGetLong(list.remove(0), "thread ID");
                ObjectReference objectReference = this.store.get(l2);
                if (objectReference == null) {
                    throw new JDEException("No such thread exists");
                }
                if (!(objectReference instanceof ThreadReference)) {
                    throw new JDEException("No such thread exists (anymore?)");
                }
                threadStartRequest.addThreadFilter((ThreadReference)objectReference);
            }
            l = this.addIdentifiableRequest(threadStartRequest);
        } else if (string.equals("death")) {
            ThreadDeathRequest threadDeathRequest = eventRequestManager.createThreadDeathRequest();
            threadDeathRequest.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(list));
            if (list.size() > 0) {
                Long l3 = Etc.safeGetLong(list.remove(0), "thread ID");
                ObjectReference objectReference = this.store.get(l3);
                if (objectReference == null) {
                    throw new JDEException("No such thread exists");
                }
                if (!(objectReference instanceof ThreadReference)) {
                    throw new JDEException("No such thread exists (anymore?)");
                }
                threadDeathRequest.addThreadFilter((ThreadReference)objectReference);
            }
            l = this.addIdentifiableRequest(threadDeathRequest);
        }
        this.app.signalCommandResult(n, l);
    }

    public void doCancelTraceThreads(Integer n, List list) throws JDEException {
        if (list.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        this.deleteIdentifiableRequest(Etc.safeGetLong(list.remove(0), "request ID"));
        this.app.signalCommandResult(n);
    }

    public ThreadCommands(Application application, ObjectStore objectStore) {
        super(application, objectStore);
    }
}

