/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Application;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.command.DebugApplicationCommand;

public class Step
extends DebugApplicationCommand {
    public void doCommand() throws JDEException {
        int depth;
        if (this.args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String arg = this.args.remove(0).toString().toLowerCase();
        boolean into_all = false;
        if (arg.equals("over")) {
            depth = 2;
        } else if (arg.equals("out")) {
            depth = 3;
        } else if (arg.equals("into")) {
            depth = 1;
        } else if (arg.equals("into-all")) {
            depth = 1;
            into_all = true;
        } else {
            throw new JDEException("Syntax error: use step over/out/into");
        }
        Long uniqueID = Etc.safeGetLong(this.args.remove(0), "thread ID");
        ThreadReference tRef = (ThreadReference)this.app.getStore().get(uniqueID);
        if (tRef == null) {
            throw new JDEException("Invalid thread ID or the thread is dead");
        }
        if (tRef.suspendCount() == 0) {
            throw new JDEException("The specified thread is not suspended");
        }
        this.clearPreviousStep(tRef);
        EventRequestManager erm = this.app.getVM().eventRequestManager();
        StepRequest request = erm.createStepRequest(tRef, -2, depth);
        request.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.args));
        if (depth == 1 && !into_all) {
            request.addClassExclusionFilter("java.*");
            request.addClassExclusionFilter("javax.*");
            request.addClassExclusionFilter("sun.*");
        }
        request.addCountFilter(1);
        request.enable();
        this.app.getVM().resume();
        this.app.signalCommandResult(this.cmdID);
    }

    private void clearPreviousStep(ThreadReference thread) {
        Application application = this.app;
        synchronized (application) {
            EventRequestManager mgr = this.app.getVM().eventRequestManager();
            List<StepRequest> requests = mgr.stepRequests();
            Iterator<StepRequest> iter = requests.iterator();
            while (iter.hasNext()) {
                StepRequest request = iter.next();
                ThreadReference requestThread = request.thread();
                if (!request.thread().equals(thread)) continue;
                mgr.deleteEventRequest(request);
                break;
            }
        }
    }

    public Object clone() {
        return new Step();
    }
}

