//
// Generated by JTB 1.2.1
//

package jde.debugger.interpret.visitor;
import jde.debugger.interpret.syntaxtree.*;
import java.util.*;

/**
 * Provides default methods which visit each node in the tree in depth-first
 * order.  Your visitors may extend this class.
 */
public class DepthFirstVisitor implements Visitor {
   //
   // Auto class visitors--probably don't need to be overridden.
   //
   public void visit(NodeList n) {
      for ( Enumeration e = n.elements(); e.hasMoreElements(); )
         ((Node)e.nextElement()).accept(this);
   }

   public void visit(NodeListOptional n) {
      if ( n.present() )
         for ( Enumeration e = n.elements(); e.hasMoreElements(); )
            ((Node)e.nextElement()).accept(this);
   }

   public void visit(NodeOptional n) {
      if ( n.present() )
         n.node.accept(this);
   }

   public void visit(NodeSequence n) {
      for ( Enumeration e = n.elements(); e.hasMoreElements(); )
         ((Node)e.nextElement()).accept(this);
   }

   public void visit(NodeToken n) { }

   //
   // User-generated visitor methods below
   //

   /**
    * <PRE>
    * nodeChoice -> ( PrimitiveType() | Name() )
    * nodeListOptional -> ( "[" "]" )*
    * </PRE>
    */
   public void visit(Type n) {
      n.nodeChoice.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> "boolean"
    *       | "char"
    *       | "byte"
    *       | "short"
    *       | "int"
    *       | "long"
    *       | "float"
    *       | "double"
    * </PRE>
    */
   public void visit(PrimitiveType n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> "void"
    *       | Type()
    * </PRE>
    */
   public void visit(ResultType n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * nodeToken -> &lt;IDENTIFIER&gt;
    * nodeListOptional -> ( "." &lt;IDENTIFIER&gt; )*
    * </PRE>
    */
   public void visit(Name n) {
      n.nodeToken.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * name -> Name()
    * nodeListOptional -> ( "," Name() )*
    * </PRE>
    */
   public void visit(NameList n) {
      n.name.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * conditionalExpression -> ConditionalExpression()
    * nodeOptional -> [ AssignmentOperator() Expression() ]
    * </PRE>
    */
   public void visit(Expression n) {
      n.conditionalExpression.accept(this);
      n.nodeOptional.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> "="
    *       | "*="
    *       | "/="
    *       | "%="
    *       | "+="
    *       | "-="
    *       | "&lt;&lt;="
    *       | "&gt;&gt;="
    *       | "&gt;&gt;&gt;="
    *       | "&="
    *       | "^="
    *       | "|="
    * </PRE>
    */
   public void visit(AssignmentOperator n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * conditionalOrExpression -> ConditionalOrExpression()
    * nodeOptional -> [ "?" Expression() ":" ConditionalExpression() ]
    * </PRE>
    */
   public void visit(ConditionalExpression n) {
      n.conditionalOrExpression.accept(this);
      n.nodeOptional.accept(this);
   }

   /**
    * <PRE>
    * conditionalAndExpression -> ConditionalAndExpression()
    * nodeListOptional -> ( "||" ConditionalAndExpression() )*
    * </PRE>
    */
   public void visit(ConditionalOrExpression n) {
      n.conditionalAndExpression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * inclusiveOrExpression -> InclusiveOrExpression()
    * nodeListOptional -> ( "&&" InclusiveOrExpression() )*
    * </PRE>
    */
   public void visit(ConditionalAndExpression n) {
      n.inclusiveOrExpression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * exclusiveOrExpression -> ExclusiveOrExpression()
    * nodeListOptional -> ( "|" ExclusiveOrExpression() )*
    * </PRE>
    */
   public void visit(InclusiveOrExpression n) {
      n.exclusiveOrExpression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * andExpression -> AndExpression()
    * nodeListOptional -> ( "^" AndExpression() )*
    * </PRE>
    */
   public void visit(ExclusiveOrExpression n) {
      n.andExpression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * equalityExpression -> EqualityExpression()
    * nodeListOptional -> ( "&" EqualityExpression() )*
    * </PRE>
    */
   public void visit(AndExpression n) {
      n.equalityExpression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * instanceOfExpression -> InstanceOfExpression()
    * nodeListOptional -> ( ( "==" | "!=" ) InstanceOfExpression() )*
    * </PRE>
    */
   public void visit(EqualityExpression n) {
      n.instanceOfExpression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * relationalExpression -> RelationalExpression()
    * nodeOptional -> [ "instanceof" Type() ]
    * </PRE>
    */
   public void visit(InstanceOfExpression n) {
      n.relationalExpression.accept(this);
      n.nodeOptional.accept(this);
   }

   /**
    * <PRE>
    * shiftExpression -> ShiftExpression()
    * nodeListOptional -> ( ( "&lt;" | "&gt;" | "&lt;=" | "&gt;=" ) ShiftExpression() )*
    * </PRE>
    */
   public void visit(RelationalExpression n) {
      n.shiftExpression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * additiveExpression -> AdditiveExpression()
    * nodeListOptional -> ( ( "&lt;&lt;" | "&gt;&gt;" | "&gt;&gt;&gt;" ) AdditiveExpression() )*
    * </PRE>
    */
   public void visit(ShiftExpression n) {
      n.additiveExpression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * multiplicativeExpression -> MultiplicativeExpression()
    * nodeListOptional -> ( ( "+" | "-" ) MultiplicativeExpression() )*
    * </PRE>
    */
   public void visit(AdditiveExpression n) {
      n.multiplicativeExpression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * unaryExpression -> UnaryExpression()
    * nodeListOptional -> ( ( "*" | "/" | "%" ) UnaryExpression() )*
    * </PRE>
    */
   public void visit(MultiplicativeExpression n) {
      n.unaryExpression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> ( "+" | "-" ) UnaryExpression()
    *       | PreIncrementExpression()
    *       | PreDecrementExpression()
    *       | UnaryExpressionNotPlusMinus()
    * </PRE>
    */
   public void visit(UnaryExpression n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * nodeToken -> "++"
    * primaryExpression -> PrimaryExpression()
    * </PRE>
    */
   public void visit(PreIncrementExpression n) {
      n.nodeToken.accept(this);
      n.primaryExpression.accept(this);
   }

   /**
    * <PRE>
    * nodeToken -> "--"
    * primaryExpression -> PrimaryExpression()
    * </PRE>
    */
   public void visit(PreDecrementExpression n) {
      n.nodeToken.accept(this);
      n.primaryExpression.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> ( "~" | "!" ) UnaryExpression()
    *       | CastExpression()
    *       | PostfixExpression()
    * </PRE>
    */
   public void visit(UnaryExpressionNotPlusMinus n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> "(" PrimitiveType()
    *       | "(" Name() "[" "]"
    *       | "(" Name() ")" ( "~" | "!" | "(" | &lt;IDENTIFIER&gt; | "this" | "super" | "new" | Literal() )
    * </PRE>
    */
   public void visit(CastLookahead n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * primaryExpression -> PrimaryExpression()
    * nodeOptional -> [ "++" | "--" ]
    * </PRE>
    */
   public void visit(PostfixExpression n) {
      n.primaryExpression.accept(this);
      n.nodeOptional.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> "(" Type() ")" UnaryExpression()
    *       | "(" Type() ")" UnaryExpressionNotPlusMinus()
    * </PRE>
    */
   public void visit(CastExpression n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * primaryPrefix -> PrimaryPrefix()
    * nodeListOptional -> ( PrimarySuffix() )*
    * </PRE>
    */
   public void visit(PrimaryExpression n) {
      n.primaryPrefix.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> Literal()
    *       | "this"
    *       | "super" "." &lt;IDENTIFIER&gt;
    *       | "(" Expression() ")"
    *       | AllocationExpression()
    *       | ResultType() "." "class"
    *       | Name()
    * </PRE>
    */
   public void visit(PrimaryPrefix n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> "." "this"
    *       | "." AllocationExpression()
    *       | "[" Expression() "]"
    *       | "." &lt;IDENTIFIER&gt;
    *       | Arguments()
    * </PRE>
    */
   public void visit(PrimarySuffix n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> &lt;INTEGER_LITERAL&gt;
    *       | &lt;FLOATING_POINT_LITERAL&gt;
    *       | &lt;CHARACTER_LITERAL&gt;
    *       | &lt;STRING_LITERAL&gt;
    *       | BooleanLiteral()
    *       | NullLiteral()
    * </PRE>
    */
   public void visit(Literal n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> "true"
    *       | "false"
    * </PRE>
    */
   public void visit(BooleanLiteral n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * nodeToken -> "null"
    * </PRE>
    */
   public void visit(NullLiteral n) {
      n.nodeToken.accept(this);
   }

   /**
    * <PRE>
    * nodeToken -> "("
    * nodeOptional -> [ ArgumentList() ]
    * nodeToken1 -> ")"
    * </PRE>
    */
   public void visit(Arguments n) {
      n.nodeToken.accept(this);
      n.nodeOptional.accept(this);
      n.nodeToken1.accept(this);
   }

   /**
    * <PRE>
    * expression -> Expression()
    * nodeListOptional -> ( "," Expression() )*
    * </PRE>
    */
   public void visit(ArgumentList n) {
      n.expression.accept(this);
      n.nodeListOptional.accept(this);
   }

   /**
    * <PRE>
    * nodeChoice -> "new" PrimitiveType() ArrayDimsAndInits()
    *       | "new" Name() ( ArrayDimsAndInits() | Arguments() )
    * </PRE>
    */
   public void visit(AllocationExpression n) {
      n.nodeChoice.accept(this);
   }

   /**
    * <PRE>
    * nodeList -> ( "[" Expression() "]" )+
    * nodeListOptional -> ( "[" "]" )*
    * </PRE>
    */
   public void visit(ArrayDimsAndInits n) {
      n.nodeList.accept(this);
      n.nodeListOptional.accept(this);
   }

}
